/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.signup.dto;

import com.baijia.tianxiao.dal.constant.ChargeType;
import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.sal.organization.finance.dto.SignupRefundResponse;
import com.baijia.tianxiao.util.NumberUtil;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Lists;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;

import lombok.Data;

/**
 * @author cxm
 * @version 1.0
 * @title SignupCourseInfoDto
 * @desc TODO
 * @date 2015年9月8日
 */
@Data
public class SignupCourseInfoDto implements Serializable {

    private static final long serialVersionUID = 6811476720391997504L;

    public static final int NORMAT_SHOW_STATUS = 0;
    public static final int HAS_TRANS_COURSE_RECORD = 1;

    private Long orgId;

    private Long userId;
    /**
     * 课程id
     */
    private Long orgCourseId;

    /**
     * 班级id
     */
    private Long classId;

    /**
     * 课程编号
     */
    private Long orgCourseNumber;

    /**
     * 课程名
     */
    private String orgCourseName;

    /**
     * 如果多个老师
     */
    private Collection<String> teacherNames = Lists.newArrayList();

    private String teacherNameStr;// 字符窜形式老师,默认待定,多个逗号分开

    /**
     * 课程原价
     */
    private Double coursePrice;
    /**
     * 报名价
     */
    private Double originPrice;
    /**
     * 价格带单位字符串
     */
    private String originPriceStr;

    public void setOriginPrice(Double originPrice) {
        this.originPrice = originPrice;
        this.updateOriginPriceStr();
    }

    public void setFreq(int freq) {
        this.freq = freq;
        this.updateOriginPriceStr();
    }

    public void setChargeType(Integer chargeType) {
        this.chargeType = chargeType;
        this.updateOriginPriceStr();
    }

    public void setChargeUnit(Integer chargeUnit) {
        this.chargeUnit = chargeUnit;
        this.updateOriginPriceStr();
    }

    private void updateOriginPriceStr() {
        if (null == this.originPrice || null == this.chargeType || null == this.chargeUnit) {
            return;
        } else {
            if (this.chargeType == ChargeType.BY_PERIODS.getCode()) {
                if (0 == this.freq) {
                    return;
                } else {
                    this.originPriceStr =
                            String.format("￥%s/期（%s次）", NumberUtil.get2FromDouble(this.originPrice), this.freq);
                }
            } else if (this.chargeType == ChargeType.BY_CLASSHOUR.getCode()) {
                if (ChargeUnit.isByTime(this.chargeUnit)) {
                    this.originPriceStr = String.format("￥%s/小时", NumberUtil.get2FromDouble(this.originPrice));
                } else {
                    this.originPriceStr = String.format("￥%s/次", NumberUtil.get2FromDouble(this.originPrice));
                }
            } else if (this.chargeType == ChargeType.BY_OTHER.getCode()) {
                this.originPriceStr = "￥" + NumberUtil.get2FromDouble(this.originPrice);
            }
        }
    }

    /**
     * 支付价格
     */
    private Double payPrice = 0d;

    /**
     * db实际存储的payPrice值
     */
    @JsonIgnore
    private Double realPayPrice = 0d;

    /**
     * 折扣百分数
     */
    private int discount = 100;//历史原因这个目前默认都是100


    private Integer realDiscount = -1;//真实的折扣信息，前端传递保存，-1代表没有折扣

    /**
     * 优惠金额
     */
    private double preferential;

    private Double roundUpMoney = 0d;

    private int freq;// 课程原课节数

    /**
     * 购买课程数量
     */
    private int count;

    private int courseType;

    private double poundage;
    // 退款日期和金额
    private List<SignupRefundResponse> signupRefundDto;
    // 累计退款金额
    private double totalRefundMoney;
    // 实收净额
    private double profit;
    // 合计=单价＊数量
    private double totalPrice;

    // 课程封面id
    private Integer coverId;
    // 课程封面Url
    private String coverUrl;
    // 合同课次
    private Integer lessonCount;
    // 收费类型
    private Integer chargeType;
    //计费模式
    private Integer chargeMode;
    // 计费单位
    private Integer chargeUnit;
    // 取消状态
    private Integer status;
    // 储值账户支付金额
    private Double studentPayPrice = 0d;

    private String amount; // 实退款/收金额-->详情(转班新加)
    private String realAmount;// 列表实收款

    private String transferClassDeduction = "/";// 转班抵扣金额（转班新增）
    private String refundAmount;// 实退金额（转班新增）
    private int showTransferStatus = NORMAT_SHOW_STATUS;// 0:无 1:转班记录（转班新增）
    private int transferClass;
}
