package com.baijia.tianxiao.sal.signup.constants;

import java.util.Collection;
import java.util.List;

import com.baijia.tianxiao.constants.signup.PayType;
import com.google.common.collect.Lists;

/**
 * @author shizuwei
 * @version 1.0
 * @title AppPayType
 * @desc 用于在接口和数据库之间转换paytype编码
 * @date 2015年12月8日
 */
public enum AppPayType {
    UNKOWN(-1), ALL(0), ALIPAY(1), WEIXIN(2), POS(3), YINLIAN(4);
    private Integer code;

    private AppPayType(Integer code) {
        this.code = code;
    }

    public Integer getCode() {
        return this.code;
    }

    public static AppPayType getByCode(Integer code) {
        if (code == ALL.getCode()) {
            return ALL;
        } else if (code == ALIPAY.getCode()) {
            return ALIPAY;
        } else if (code == WEIXIN.getCode()) {
            return WEIXIN;
        } else if (code == POS.getCode()) {
            return POS;
        } else if (code == YINLIAN.getCode()) {
            return YINLIAN;
        }
        return UNKOWN;
    }

    // ALIPAY_POS PAY_POS_YINLIAN_CARD PAY_POS_KUAIQIAN_CARD WX_POS CASH
    private static final List<Integer> PAY_TYPE_CODE_ALL = Lists.newArrayList(new Integer[]{
            PayType.ALIPAY_POS.getCode(), PayType.PAY_POS_YINLIAN_CARD.getCode(), PayType.CASH.getCode(),
            PayType.WX_POS.getCode(), PayType.PAY_POS_KUAIQIAN_CARD.getCode(), PayType.ONLINE_PAYMENT.getCode(),
            PayType.PAY_POS_CARD.getCode()});
    private static final List<Integer> PAY_TYPE_CODE_ALIPAY = Lists.newArrayList(new Integer[]{PayType.ALIPAY_POS
            .getCode()});
    private static final List<Integer> PAY_TYPE_CODE_WEIXIN = Lists.newArrayList(new Integer[]{PayType.WX_POS
            .getCode()});
    private static final List<Integer> PAY_TYPE_CODE_POS = Lists
            .newArrayList(new Integer[]{PayType.PAY_POS_KUAIQIAN_CARD.getCode(), PayType.PAY_POS_YINLIAN_CARD.getCode(),
                    PayType.PAY_POS_CARD.getCode()});
    private static final List<Integer> PAY_TYPE_CODE_YINLIAN = Lists
            .newArrayList(new Integer[]{PayType.PAY_POS_YINLIAN_CARD.getCode()});

    public Collection<Integer> getPayTypeCodes() {
        if (this.code == ALIPAY.getCode()) {
            return PAY_TYPE_CODE_ALIPAY;
        } else if (this.code == WEIXIN.getCode()) {
            return PAY_TYPE_CODE_WEIXIN;
        } else if (this.code == POS.getCode()) {
            return PAY_TYPE_CODE_POS;
        } else if (this.code == YINLIAN.getCode()) {
            return PAY_TYPE_CODE_YINLIAN;
        }

        return PayType.getAllCode();
    }

    public static Integer toAppPayTypeCode(Integer payType) {
        if (PAY_TYPE_CODE_ALIPAY.contains(payType)) {
            return ALIPAY.getCode();
        } else if (PAY_TYPE_CODE_WEIXIN.contains(payType)) {
            return WEIXIN.getCode();
        }
        if (PAY_TYPE_CODE_POS.contains(payType)) {
            return POS.getCode();
        }
        if (PAY_TYPE_CODE_YINLIAN.contains(payType)) {
            return YINLIAN.getCode();
        }

        return ALL.getCode();
    }

}