/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.signup.service.Impl;

import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupStorageDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupStorage;
import com.baijia.tianxiao.sal.signup.dto.OrgSignupStorageDto;
import com.baijia.tianxiao.sal.signup.dto.response.OrgSignupStorageResponseDto;
import com.baijia.tianxiao.sal.signup.service.OrgSignupStorageService;
import com.baijia.tianxiao.util.storage.StorageUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class OrgSignupStorageServiceImpl
implements OrgSignupStorageService {
    private static final Logger log = LoggerFactory.getLogger(OrgSignupStorageServiceImpl.class);
    @Autowired
    private OrgSignupStorageDao orgSignupStorageDao;
    @Autowired
    private OrgStorageDao storageDao;

    @Override
    public void addOrEditOrgSignupStorage(@NonNull Long orgId, @NonNull Collection<OrgSignupStorageDto> dtos) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        if (dtos == null) {
            throw new NullPointerException("dtos");
        }
        if (CollectionUtils.isEmpty(dtos)) {
            log.warn("dtos = {}", dtos);
            return;
        }
        ArrayList orgSignupStorages = Lists.newArrayList();
        for (OrgSignupStorageDto dto : dtos) {
            if (dto.getSignupPurchaseId() != null && dto.getStorageId() != null) {
                OrgSignupStorage orgSignupStorage = new OrgSignupStorage();
                orgSignupStorage.setSignupPurchaseId(dto.getSignupPurchaseId());
                orgSignupStorage.setStorageId(dto.getStorageId());
                orgSignupStorage.setRemark(dto.getRemark() == null ? "" : dto.getRemark());
                orgSignupStorages.add(orgSignupStorage);
                continue;
            }
            log.warn("param error:sigupid={},storageid={}", (Object)dto.getSignupPurchaseId(), (Object)dto.getStorageId());
        }
        this.orgSignupStorageDao.addOrEditOrgSignupStorage(orgId, (Collection)orgSignupStorages);
    }

    @Override
    public void delOrgSignupStorage(@NonNull Long orgId, @NonNull Collection<OrgSignupStorageDto> dtos) throws Exception {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        if (dtos == null) {
            throw new NullPointerException("dtos");
        }
        if (CollectionUtils.isEmpty(dtos)) {
            log.warn("dtos = {}", dtos);
            return;
        }
        ArrayList orgSignupStorages = Lists.newArrayList();
        for (OrgSignupStorageDto dto : dtos) {
            if (dto.getSignupPurchaseId() != null && dto.getStorageId() != null) {
                OrgSignupStorage orgSignupStorage = new OrgSignupStorage();
                orgSignupStorage.setOrgId(orgId);
                orgSignupStorage.setSignupPurchaseId(dto.getSignupPurchaseId());
                orgSignupStorage.setStorageId(dto.getStorageId());
                orgSignupStorage.setRemark(dto.getRemark() == null ? "" : dto.getRemark());
                orgSignupStorages.add(orgSignupStorage);
                continue;
            }
            log.warn("param error:sigupid={},storageid={}", (Object)dto.getSignupPurchaseId(), (Object)dto.getStorageId());
        }
        this.orgSignupStorageDao.delOrgSignupStorage((Collection)orgSignupStorages);
    }

    @Override
    public OrgSignupStorageResponseDto getOrgSignupStorageBySignupPurchaseId(@NonNull Long orgId, @NonNull Long signupPurchaseId) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        if (signupPurchaseId == null) {
            throw new NullPointerException("signupPurchaseId");
        }
        List orgSignupStorages = this.orgSignupStorageDao.getOrgSignupStorageBySignupPurchaseId(orgId, signupPurchaseId);
        ArrayList storageIds = Lists.newArrayList();
        for (OrgSignupStorage signupStorage : orgSignupStorages) {
            storageIds.add(signupStorage.getStorageId());
        }
        log.debug("all storage ids:{}", (Object)storageIds);
        Map<Long, String> urlMap = this.getStorageUrlMap(storageIds);
        ArrayList orgSignupStorageDtos = Lists.newArrayList();
        for (OrgSignupStorage signupStorage : orgSignupStorages) {
            OrgSignupStorageDto dto = new OrgSignupStorageDto();
            if (signupStorage.getStorageId() == null || signupStorage.getStorageId() == 0L) continue;
            dto.setId(signupStorage.getId());
            dto.setOrgId(signupStorage.getOrgId());
            dto.setRemark(signupStorage.getRemark());
            dto.setSignupPurchaseId(signupStorage.getSignupPurchaseId());
            dto.setUrl(urlMap.get(signupStorage.getStorageId()));
            dto.setStorageId(signupStorage.getStorageId());
            orgSignupStorageDtos.add(dto);
        }
        OrgSignupStorageResponseDto orgSignupStorageResponseDto = new OrgSignupStorageResponseDto();
        if (!CollectionUtils.isEmpty((Collection)orgSignupStorages)) {
            orgSignupStorageResponseDto.setRemark(((OrgSignupStorage)orgSignupStorages.get(0)).getRemark());
        }
        orgSignupStorageResponseDto.setList(orgSignupStorageDtos);
        return orgSignupStorageResponseDto;
    }

    private Map<Long, String> getStorageUrlMap(Collection<Long> storageIds) {
        List storages = this.storageDao.getByIds(storageIds, new String[0]);
        HashMap urlMap = Maps.newHashMap();
        for (OrgStorage storage : storages) {
            urlMap.put(storage.getId().longValue(), StorageUtil.constructUrl((String)storage.getFid(), (String)storage.getSn(), (Integer)storage.getMimeType()));
        }
        return urlMap;
    }

    @Override
    public void deleteById(long id) {
        this.orgSignupStorageDao.delById((Serializable)Long.valueOf(id));
    }
}

