package com.baijia.tianxiao.sal.signup.service.Impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.Resource;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baijia.commons.lang.utils.date.DateUtils;
import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constant.StudentFiannceOpType;
import com.baijia.tianxiao.constants.PayStatus;
import com.baijia.tianxiao.constants.org.BizConf;
import com.baijia.tianxiao.constants.signup.PayResult;
import com.baijia.tianxiao.constants.signup.PayType;
import com.baijia.tianxiao.constants.signup.SplitCourseResult;
import com.baijia.tianxiao.constants.sms.SmsMessageType;
import com.baijia.tianxiao.constants.sms.SmsSendResult;
import com.baijia.tianxiao.dal.constant.ChargeType;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.finance.dao.TxStudentFinanceAccountDao;
import com.baijia.tianxiao.dal.finance.po.TxStudentFinanceAccount;
import com.baijia.tianxiao.dal.org.constant.CampusAccountType;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.constant.StudentType;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseTeacherDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgSinupPurchaseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.dao.TtsSmsDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgCourseTeacher;
import com.baijia.tianxiao.dal.org.po.OrgSinupPurchase;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.org.po.TtsSms;
import com.baijia.tianxiao.dal.signup.constant.SignupCourseStatus;
import com.baijia.tianxiao.dal.signup.constant.SignupStatus;
import com.baijia.tianxiao.dal.signup.constant.SignupType;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupFeeDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupOnlinePayDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupFee;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.dal.signup.po.OrgSignupOnlinePay;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dto.signup.CreatePurchaseResponseDto;
import com.baijia.tianxiao.dto.signup.PayResultDto;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.RedisKeyEnums;
import com.baijia.tianxiao.enums.SignupErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.organization.constant.OrgSinupPurchaseStatus;
import com.baijia.tianxiao.sal.organization.org.service.TXAccountService;
import com.baijia.tianxiao.sal.organization.org.service.TxCascadeCredentialService;
import com.baijia.tianxiao.sal.signup.constants.SignupSourceType;
import com.baijia.tianxiao.sal.signup.dto.PaymentResultDto;
import com.baijia.tianxiao.sal.signup.dto.SignupCourseInfoDto;
import com.baijia.tianxiao.sal.signup.dto.SignupFeeItemDto;
import com.baijia.tianxiao.sal.signup.dto.request.FillCourseInfoRequestDto;
import com.baijia.tianxiao.sal.signup.dto.request.SingupListRequestDto;
import com.baijia.tianxiao.sal.signup.dto.response.OrgSignupListDto;
import com.baijia.tianxiao.sal.signup.dto.response.OrgSingupInfoDto;
import com.baijia.tianxiao.sal.signup.service.SignupService;
import com.baijia.tianxiao.sal.student.api.OrgStudentService;
import com.baijia.tianxiao.sal.student.api.OrgStudentTagService;
import com.baijia.tianxiao.sal.student.dto.CommentInfoDto;
import com.baijia.tianxiao.sal.student.dto.StudentInfoDto;
import com.baijia.tianxiao.sal.student.dto.TagInfoDto;
import com.baijia.tianxiao.sal.student.dto.response.OrgStudentAddresponseDto;
import com.baijia.tianxiao.sal.student.dto.response.OrgTagListResopnseDto;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.BaseUtils;
import com.baijia.tianxiao.util.DigitUppercaseUtils;
import com.baijia.tianxiao.util.NumberUtil;
import com.baijia.tianxiao.util.SerializeUtil;
import com.baijia.tianxiao.util.ShortUrlUtil;
import com.baijia.tianxiao.util.SmsContentHelper;
import com.baijia.tianxiao.util.SmsSendUtil;
import com.baijia.tianxiao.util.encrypt.MD5Utils;
import com.baijia.tianxiao.util.mobile.MaskUtil;
import com.baijia.tianxiao.util.properties.UrlProperties;
import com.baijia.tianxiao.util.rest.RestUtils;
import com.baijia.tianxiao.validation.ParamValidateUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;

import lombok.NonNull;
import lombok.extern.slf4j.Slf4j;

@Slf4j
@Service
public class SignupServiceImpl implements SignupService {

    public static final BigDecimal HUNDRED = new BigDecimal(100);

    private static final int SIGNUP_PAY_SMS_CONTENT = 0;
    private static final int SIGNUP_COMPLETE_SMS_CONTENT = 1;

    // public static final String TIANXIAO_SIGNUP_REDIS_PRE = "TIANXIAO_SIGNUP_INFO_";

    @Resource
    private OrgCourseDao orgCourseDao;

    @Resource
    private OrgCourseTeacherDao orgCourseTeacherDao;

    @Resource
    private OrgSignupCourseDao orgSignupCourseDao;

    @Resource
    private OrgSignupInfoDao orgSignupInfoDao;

    @Resource
    private OrgInfoDao orgInfoDao;

    @Resource
    private OrgSinupPurchaseDao orgSinupPurchaseDao;

    @Resource
    private OrgSignupFeeDao orgSignupFeeDao;

    @Resource
    private OrgSignupOnlinePayDao orgSignupOninePayDao;

    @Resource
    private TtsSmsDao ttsSmsDao;

    @Resource
    private OrgStudentDao orgStudentDao;

    @Autowired(required = true)
    private OrgStudentService orgStudentService;

    @Resource
    private OrgAccountDao orgAccountDao;

    @Resource
    private TeacherDao teacherDao;

    @Resource
    private TXAccountService txAccountService;

    @Resource
    private TXCascadeAccountDao txCascadeAccountDao;

    @Resource
    private TxCascadeCredentialService txCascadeCredentialService;

    @Autowired(required = false)
    private StringRedisTemplate redisTemplate;

    @Resource
    private OrgStudentTagService orgStudentTagService;

    @Resource
    private TxStudentFinanceAccountDao txStudentFinanceAccountDao;

    @Resource
    private OrgStudentCourseDao studentCourseDao;

    private Long getOrgNumber(Long orgId) {
        OrgAccount account = this.orgAccountDao.getAccountById(orgId.intValue(), "number");
        if (account == null) {
            return null;
        }
        Integer number = account.getNumber();
        return number != null ? number.longValue() : null;
    }

    @Override
    public OrgSignupListDto pcSignupList(SingupListRequestDto requestDto) {
        Integer cascadeId = requestDto.getCascadeId();
        if (cascadeId != null) {
            TXCascadeAccount txCascadeAccount = txCascadeAccountDao.getById(cascadeId);
            if (txCascadeAccount != null && txCascadeAccount.getAccountType() != CampusAccountType.STAFF.getCode()) {
                cascadeId = null;
                requestDto.setCascadeId(null);
            }
        }

        OrgSignupListDto orgSignupListDto = new OrgSignupListDto();
        orgSignupListDto.setList(getSignupList(requestDto));

        requestDto.setSignupStatus(SignupStatus.NOT_PAY.getCode());
        orgSignupListDto.setNotPayNum(orgSignupInfoDao.countByPurchaseStatus(requestDto.getOrgId(),
            requestDto.getPurchaseStatusCodes(), requestDto.getSplitCodes(), cascadeId));

        orgSignupListDto.setNotPayPrice(orgSignupInfoDao.sumByPurchaseStatus(requestDto.getOrgId(),
            requestDto.getPurchaseStatusCodes(), requestDto.getSplitCodes(), cascadeId, false).doubleValue() / 100);

        requestDto.setSignupStatus(SignupStatus.NOT_SIGN.getCode());
        orgSignupListDto.setNotSignNum(orgSignupInfoDao.countByPurchaseStatus(requestDto.getOrgId(),
            requestDto.getPurchaseStatusCodes(), requestDto.getSplitCodes(), cascadeId));
        orgSignupListDto.setNotSignPrice(orgSignupInfoDao.sumByPurchaseStatus(requestDto.getOrgId(),
            requestDto.getPurchaseStatusCodes(), requestDto.getSplitCodes(), cascadeId, false).doubleValue() / 100);
        return orgSignupListDto;
    }

    @Override
    public List<OrgSingupInfoDto> getSignupList(SingupListRequestDto requestDto) {

        Preconditions.checkNotNull(requestDto.getOrgId(), "orgId may not be null");
        requestDto.setOrgNumber(getOrgNumber(requestDto.getOrgId()));
        Preconditions.checkNotNull(requestDto.getOrgNumber(), "orgNumber may not be null");

        String key = requestDto.getSearchKey();
        List<Long> purchaseIds = Lists.newArrayList();

        if (StringUtils.isNotBlank(key)) {
            /**
             * 查出机构课程名like key的所有课程Ids
             */
            List<Long> courseIds = orgCourseDao.getCourseIdsByOrgNumberAndCourseName(requestDto.getOrgNumber(), key,
                null, CourseTypeEnum.IS_COURSE_TRUE.getCode(), null, null);
            if (CollectionUtils.isNotEmpty(courseIds)) {
                /**
                 * 查出课程对应的purchaseIds
                 */
                purchaseIds.addAll(orgSignupCourseDao.searchPurchaseIdByCourseId(courseIds, requestDto.getStartTime(),
                    requestDto.getEndTime()));
            }
        }
        /**
         * 根据条件查出所需的OrgSignupInfos
         */
        List<OrgSignupInfo> result = orgSignupInfoDao.getOrgSignupInfo(requestDto.getMethod(), requestDto.getSource(),
            requestDto.getOrgId(), purchaseIds, requestDto.getPurchaseStatusCodes(), requestDto.getSplitCodes(),
            requestDto.getPayTypeCodes(), key, requestDto.getStartTime(), requestDto.getEndTime(),
            requestDto.getCascadeId(), requestDto.getCancelStatus(), requestDto);
        if (CollectionUtils.isEmpty(result)) {
            return Collections.emptyList();
        }
        /**
         * 添加订单和课程id对应信息
         */
        loadSignupCourseInfo(result);

        /**
         * 添加订单和费用对应信息
         */
        loadSignupFeeItem(result);

        boolean isShowMobile =
            txCascadeCredentialService.isShowMobile(requestDto.getOrgId(), requestDto.getCascadeId());

        return buildOrgSingupInfoDtos(result, orgInfoDao.getOrgShortNameByOrgId(requestDto.getOrgId().intValue()),
            isShowMobile);
    }

    private List<OrgSingupInfoDto> buildOrgSingupInfoDtos(Collection<OrgSignupInfo> orgSignupInfos, String orgName,
        boolean isShowMobile) {
        /**
         * 获取老师名和课程名
         */
        List<OrgSingupInfoDto> orgSingupInfoDtos = Lists.newArrayList();
        Set<Long> courseIds = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty(orgSignupInfos)) {

            /**
             * 所有课程的id
             */
            Long orgId = 0l;
            for (OrgSignupInfo orgSignupInfo : orgSignupInfos) {
                orgId = orgSignupInfo.getOrgId();
                if (CollectionUtils.isNotEmpty(orgSignupInfo.getOrgSignupCourses())) {
                    for (OrgSignupCourse orgSignupCourse : orgSignupInfo.getOrgSignupCourses()) {
                        courseIds.add(orgSignupCourse.getOrgCourseId());
                    }
                }
            }
            /**
             * 课程id和课程映射
             */
            Map<Long, OrgCourse> courseMap = this.orgCourseDao.getOrgCourseMap(courseIds);
            /**
             * 课程和老师名称映射
             */
            Map<Long, List<String>> courseTeacherNameMap = getCourseIdTeacherNamesMap(courseIds);

            Map<Long, String> cascadeMap = txCascadeCredentialService.getByTxCasCadeIdWithDelete(orgId);

            for (OrgSignupInfo orgSignupInfo : orgSignupInfos) {
                OrgSingupInfoDto dto = buildOrgSignupInfoDto(orgSignupInfo, orgName, courseMap, courseTeacherNameMap,
                    cascadeMap, isShowMobile);
                orgSingupInfoDtos.add(dto);
            }
        }
        return orgSingupInfoDtos;
    }

    private OrgSingupInfoDto buildOrgSignupInfoDto(OrgSignupInfo orgSignupInfo, String orgName,
        Map<Long, OrgCourse> courseMap, Map<Long, List<String>> courseTeacherNameMap, Map<Long, String> cascadeMap,
        boolean isShowMobile) {
        OrgSingupInfoDto dto = new OrgSingupInfoDto();
        if (orgSignupInfo != null) {
            dto.setTotalPrice(orgSignupInfo.getTotalPrices().doubleValue() / 100);
            int payType = PayType.getCodeByPayType(orgSignupInfo.getPayType());
            if (payType == PayType.CASH.getCode()) {
                dto.setCashPayPrice(dto.getTotalPrice());
            } else if (payType == PayType.PAY_POS_CARD.getCode()) {
                dto.setPosPayPrice(dto.getTotalPrice());
            } else {
                dto.setOnlinePayPrice(dto.getTotalPrice());
            }
            dto.setStudentPayPrice(orgSignupInfo.getStudentPayPrice().doubleValue() / 100);// 学生账户付款金额
            dto.setChinesePrice(DigitUppercaseUtils.digitUppercase(dto.getTotalPrice() + dto.getStudentPayPrice()));
            dto.setSourceType(orgSignupInfo.getSourceType().intValue() == SignupSourceType.TX_SIANGUP.getCode()
                ? SignupSourceType.SIGNUP.getCode() : orgSignupInfo.getSourceType());
            dto.setPayResultEnum(PayResult.getPayResultByCode(orgSignupInfo.getPurchaseStatus().intValue()));
            dto.setPayTypeEnum(PayType.getPayTypeByCode(orgSignupInfo.getPayType().intValue()));
            dto.setSignupTypeEnum(SignupType.getTypeByCode(orgSignupInfo.getSignupType().intValue()));
            dto.setOrgId(orgSignupInfo.getOrgId());
            dto.setOrgName(orgName);
            if (dto.getSignupType().intValue() == SignupType.FRONTED.getCode()) {
                dto.setSignUpTime(orgSignupInfo.getCreateTime());
            } else {
                dto.setSignUpTime(orgSignupInfo.getUpdateTime());
            }
            if (orgSignupInfo.getPurchaseStatus().intValue() == 1) {
                dto.setPayTime(orgSignupInfo.getPayTime());
                // 设置经办人
                String cascadeIdStr =
                    cascadeMap.get(orgSignupInfo.getCascadeId() == null ? 0 : orgSignupInfo.getCascadeId().longValue());
                dto.setCascadeIdStr(cascadeIdStr == null ? "" : cascadeIdStr);
            } else {
                dto.setCascadeIdStr("--");
            }
            if (orgSignupInfo.getStudentPayPrice().longValue() > 0) {
                if (orgSignupInfo.getTotalPrices().longValue() > 0) {
                    dto.setPayTypeStr("学员余额￥" + NumberUtil.get2FromDouble(dto.getStudentPayPrice()) + "+"
                        + dto.getPayTypeStr() + "￥" + NumberUtil.get2FromDouble(dto.getTotalPrice()));
                } else {
                    dto.setPayTypeStr("学生余额支付");
                }
            }
            dto.setSignupPurchaseId(orgSignupInfo.getSignupPurchaseId());
            dto.setPayPurchaseId(orgSignupInfo.getPayPurchaseId() == 0 ? orgSignupInfo.getSignupPurchaseId()
                : orgSignupInfo.getPayPurchaseId());
            dto.setCreateTime(orgSignupInfo.getCreateTime());
            dto.setUpdateTime(orgSignupInfo.getUpdateTime());
            dto.setCourseInfos(Lists.<SignupCourseInfoDto> newArrayList());
            dto.setId(orgSignupInfo.getId());
            if (orgSignupInfo.getStatus() == 1) {// 取消状态
                dto.setStatus(SignupStatus.CANCEL.getCode());
            } else {
                dto.setStatus(orgSignupInfo.getPurchaseStatus().intValue(), orgSignupInfo.getSplitResult().intValue());
            }
            String remark = "无";
            if (StringUtils.isNotBlank(orgSignupInfo.getRemark())) {
                remark = orgSignupInfo.getRemark();
            }
            if (orgSignupInfo.getTradeNo() != null && orgSignupInfo.getTradeNo().longValue() != 0l) {
                dto.setTradeNo(orgSignupInfo.getTradeNo().toString());
            } else {
                dto.setTradeNo(orgSignupInfo.getSignupPurchaseId().toString());
            }
            if (CollectionUtils.isNotEmpty(orgSignupInfo.getHeaders())
                && orgSignupInfo.getTotalPrices().doubleValue() > 0) {
                String payUrlWinxin =
                    RestUtils.getWeiXinPurchaseUrl(orgSignupInfo.getSignupPurchaseId(), orgSignupInfo.getOrgId(),
                        orgSignupInfo.getTotalPrices().doubleValue() / 100, orgSignupInfo.getHeaders());
                dto.setPayUrlWinxin(payUrlWinxin);
            }
            dto.setRemark(remark);
            dto.setStudentId(orgSignupInfo.getUserId());
            dto.setUserId(orgSignupInfo.getUserId());
            dto.setStudentMobile(orgSignupInfo.getMobile());
            if (!isShowMobile) {
                dto.setStudentMobile(MaskUtil.maskMobile(dto.getStudentMobile()));
            }
            if (orgSignupInfo.getUserId() != null && orgSignupInfo.getUserId().longValue() > 0) {
                OrgStudent orgStudent = orgStudentDao.getStudent(orgSignupInfo.getOrgId(), orgSignupInfo.getUserId(),
                    DataStatus.NORMAL.getValue());
                if (orgStudent != null) {
                    TxStudentFinanceAccount txStudentFinanceAccount =
                        txStudentFinanceAccountDao.getFinanceAccount(orgSignupInfo.getOrgId(), orgStudent.getId());
                    if (txStudentFinanceAccount != null) {
                        dto.setStudentAccountBalance(txStudentFinanceAccount.getBalance().doubleValue() / 100);
                    }
                }
            }
            dto.setStudentName(orgSignupInfo.getStudentName());
            dto.setOperator(orgSignupInfo.getOperator());
            if (CollectionUtils.isNotEmpty(orgSignupInfo.getOrgSignupCourses())) {
                for (OrgSignupCourse orgSignupCourse : orgSignupInfo.getOrgSignupCourses()) {
                    Long courseId = orgSignupCourse.getOrgCourseId();
                    SignupCourseInfoDto courseInfoDto = buildOrgSignupCourseDto(orgSignupCourse,
                        courseMap.get(courseId), courseTeacherNameMap.get(courseId));
                    dto.setPreferentialPrice(dto.getPreferentialPrice() + courseInfoDto.getPreferential());
                    if (orgSignupCourse.getStatus().intValue() == SignupCourseStatus.QUIT_PURCHASE.getCode()
                        || orgSignupCourse.getStatus().intValue() == SignupCourseStatus.QUIT_CLASS.getCode()) {
                        dto.setQuitClass(1);// 有退班
                    }
                    if (dto.getPayResult() == PayStatus.SUCESS.getCode()
                        && courseInfoDto.getStatus() == SignupCourseStatus.NOT_PAY.getCode()) {
                        courseInfoDto.setStatus(SignupCourseStatus.HAS_PAY.getCode());
                    }
                    dto.getCourseInfos().add(courseInfoDto);
                }
            }
            if (CollectionUtils.isNotEmpty(orgSignupInfo.getOrgSignupFees())) {
                for (OrgSignupFee orgSignupFee : orgSignupInfo.getOrgSignupFees()) {
                    dto.getFeeItemDtos().add(buildOrgSignupFeeItemDto(orgSignupFee));
                }
            }
        }
        return dto;
    }

    private SignupCourseInfoDto buildOrgSignupCourseDto(OrgSignupCourse orgSignupCourse, OrgCourse orgCourse,
        List<String> teacherNames) {
        SignupCourseInfoDto dto = new SignupCourseInfoDto();
        dto.setCount(orgSignupCourse.getCount());
        dto.setDiscount(orgSignupCourse.getCourseDiscount());
        dto.setOrgCourseId(orgSignupCourse.getOrgCourseId());
        dto.setOriginPrice(orgSignupCourse.getOriginPrice().doubleValue() / 100);
        // 优惠金额＝(原优惠金额＋原价*count＊(1-折扣百分数))/100
        double preferential = ((100d - orgSignupCourse.getCourseDiscount().doubleValue()) / 100
            * orgSignupCourse.getOriginPrice() * orgSignupCourse.getCount() + orgSignupCourse.getPreferential()) / 100;
        dto.setPreferential(preferential);
        dto.setPayPrice(orgSignupCourse.getPayPrice().doubleValue() / 100);
        dto.setOrgCourseName(orgCourse == null ? "" : orgCourse.getName());
        dto.setOrgCourseNumber(orgCourse == null ? 0l : orgCourse.getNumber());
        dto.setFreq(orgCourse == null || orgCourse.getFreq() == null ? 0 : orgCourse.getFreq());
        dto.setTeacherNames(teacherNames);
        dto.setTeacherNameStr(
            (teacherNames == null || teacherNames.size() == 0) ? "待定" : BaseUtils.listToStr(teacherNames, ","));
        dto.setTotalPrice(dto.getOriginPrice() * dto.getCount());

        if (orgCourse != null) {
            dto.setCourseType(orgCourse.getCourseType());
            dto.setChargeType(orgCourse.getChargeType());
        }
        dto.setChargeUnit(orgSignupCourse.getChargeUnit());
        dto.setStudentPayPrice(orgSignupCourse.getStudentPayPrice().doubleValue() / 100);
        dto.setLessonCount(orgSignupCourse.getLessonCount() == null ? 0 : orgSignupCourse.getLessonCount());
        dto.setStatus(orgSignupCourse.getStatus());
        if (dto.getChargeType() != null && dto.getLessonCount() != null
            && dto.getChargeType().intValue() == ChargeType.BY_PERIODS.getCode()) {
            dto.setTotalPrice((dto.getOriginPrice() / dto.getFreq()) * dto.getLessonCount());
        }

        return dto;
    }

    private SignupFeeItemDto buildOrgSignupFeeItemDto(OrgSignupFee orgSignupFee) {
        SignupFeeItemDto dto = new SignupFeeItemDto();
        dto.setCount(orgSignupFee.getCount());
        dto.setDiscount(orgSignupFee.getFeeItemDiscount());
        dto.setFeeItemId(orgSignupFee.getFeeItemId());
        dto.setFeeItemName(orgSignupFee.getFeeItemName());
        dto.setOriginPrice(orgSignupFee.getOriginPrice().doubleValue() / 100);
        // 优惠金额＝(原优惠金额＋原价*count＊(1-折扣百分数))/100
        double preferential = ((100d - orgSignupFee.getFeeItemDiscount().doubleValue()) / 100
            * orgSignupFee.getOriginPrice() * orgSignupFee.getCount() + orgSignupFee.getPreferential()) / 100;
        dto.setPreferential(preferential);
        dto.setPayPrice(orgSignupFee.getPayPrice().doubleValue() / 100);
        return dto;
    }

    private void loadSignupCourseInfo(Collection<OrgSignupInfo> orgSignupInfos) {
        List<Long> purchaseIds = Lists.newArrayList();
        for (OrgSignupInfo info : orgSignupInfos) {
            purchaseIds.add(info.getSignupPurchaseId());
        }

        /**
         * 获取所有订单和课程对应关系
         */
        List<OrgSignupCourse> signupCourses = orgSignupCourseDao.loadByPurchaseIds(purchaseIds);
        Map<Long, List<OrgSignupCourse>> signupCourseMaping = Maps.newHashMap();

        /**
         * 按照purchaseId相同的进行分组
         */
        for (OrgSignupCourse orgSignupCourse : signupCourses) {
            Long purchaseId = orgSignupCourse.getSignupPurchaseId();
            if (!signupCourseMaping.containsKey(purchaseId)) {
                signupCourseMaping.put(purchaseId, new ArrayList<OrgSignupCourse>());
            }
            signupCourseMaping.get(purchaseId).add(orgSignupCourse);
        }

        /**
         * 添加到对应的signup course对应列表
         */
        for (OrgSignupInfo orgSignupInfo : orgSignupInfos) {
            Long purchaseId = orgSignupInfo.getSignupPurchaseId();
            if (signupCourseMaping.containsKey(purchaseId)) {
                orgSignupInfo.setOrgSignupCourses(signupCourseMaping.get(purchaseId));
            }
        }
    }

    private void loadSignupFeeItem(Collection<OrgSignupInfo> orgSignupInfos) {
        List<Long> purchaseIds = Lists.newArrayList();
        for (OrgSignupInfo info : orgSignupInfos) {
            purchaseIds.add(info.getSignupPurchaseId());
        }

        /**
         * 获取所有订单和费用对应关系
         */
        List<OrgSignupFee> signupFeeItems = orgSignupFeeDao.loadByPurchaseIds(purchaseIds);
        Map<Long, List<OrgSignupFee>> signupFeeItemMaping = Maps.newHashMap();

        /**
         * 按照purchaseId相同的进行分组
         */
        for (OrgSignupFee orgSignupFee : signupFeeItems) {
            Long purchaseId = orgSignupFee.getSignupPurchaseId();
            if (!signupFeeItemMaping.containsKey(purchaseId)) {
                signupFeeItemMaping.put(purchaseId, new ArrayList<OrgSignupFee>());
            }
            signupFeeItemMaping.get(purchaseId).add(orgSignupFee);
        }

        /**
         * 添加到对应的signup feeItem对应列表
         */
        for (OrgSignupInfo orgSignupInfo : orgSignupInfos) {
            Long purchaseId = orgSignupInfo.getSignupPurchaseId();
            if (signupFeeItemMaping.containsKey(purchaseId)) {
                orgSignupInfo.setOrgSignupFees(signupFeeItemMaping.get(purchaseId));
            }
        }
    }

    private OrgSingupInfoDto buildOrgSignupInfoDto(OrgSignupInfo orgSignupInfo, boolean isShowMobile) {
        Set<Long> courseIds = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty(orgSignupInfo.getOrgSignupCourses())) {
            for (OrgSignupCourse orgSignupCourse : orgSignupInfo.getOrgSignupCourses()) {
                courseIds.add(orgSignupCourse.getOrgCourseId());
            }
        }

        Map<Long, OrgCourse> courseMap = this.orgCourseDao.getOrgCourseMap(courseIds);
        Map<Long, List<String>> courseTeacherNameMap = getCourseIdTeacherNamesMap(courseIds);

        Map<Long, String> cascadeMap = txCascadeCredentialService.getByTxCasCadeIds(orgSignupInfo.getOrgId());

        return buildOrgSignupInfoDto(orgSignupInfo,
            orgInfoDao
                .getOrgShortNameByOrgId(orgSignupInfo.getOrgId() != null ? orgSignupInfo.getOrgId().intValue() : null),
            courseMap, courseTeacherNameMap, cascadeMap, isShowMobile);
    }

    @Override
    public OrgSingupInfoDto generarateTradeNo(Collection<Header> headers, double totalPrice, Long orgId)
        throws BussinessException {

        OrgSingupInfoDto dto = new OrgSingupInfoDto();
        if (totalPrice < 0.0) {
            log.error("totalPrice = {} < 0.", totalPrice);
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "totalPrice < 0");
        }
        CreatePurchaseResponseDto purchaseResponseDto = RestUtils.createPurchaseResponseDto(orgId, totalPrice, headers);
        Long purchaseId = purchaseResponseDto.getData().getPurchaseId();
        dto.setSignupPurchaseId(purchaseId);

        String tradeNo = RestUtils.getTradeNo(orgId, purchaseId, totalPrice, headers);
        dto.setTradeNo(tradeNo);

        String payUrlWinxin = RestUtils.getWeiXinPurchaseUrl(purchaseId, orgId, totalPrice, headers);
        log.info("payUrlWinxin=={}", payUrlWinxin);
        dto.setPayUrlWinxin(payUrlWinxin);

        dto.setOrgId(orgId);
        dto.setTotalPrice(totalPrice);
        return dto;
    }

    @Override
    public OrgSingupInfoDto signUp(FillCourseInfoRequestDto fillCourseInfoRequestDto) throws BussinessException {
        Preconditions.checkNotNull(fillCourseInfoRequestDto.getOrgId(), "orgId may not be null");
        fillCourseInfoRequestDto.setOrgNumber(getOrgNumber(fillCourseInfoRequestDto.getOrgId()));
        Preconditions.checkNotNull(fillCourseInfoRequestDto.getOrgNumber(), "orgNumber may not be null");
        Long orgId = fillCourseInfoRequestDto.getOrgId();
        Long orgNumber = fillCourseInfoRequestDto.getOrgNumber();
        log.info("signUp--> orgId {}, signupPurchaseId {}", orgId, fillCourseInfoRequestDto.getSignupPurchaseId());
        if (fillCourseInfoRequestDto.getOrgNumber() == null) {
            fillCourseInfoRequestDto.setOrgNumber(getOrgNumber(fillCourseInfoRequestDto.getOrgId()));
        }
        OrgSingupInfoDto dto = null;
        if (fillCourseInfoRequestDto.getSignupType() == SignupType.POS_CARD.getCode()) {// 刷卡报名
            if (!isPurchaseSucce(fillCourseInfoRequestDto.getSignupPurchaseId(), orgId,
                fillCourseInfoRequestDto.getCascadeId())) {
                throw new BussinessException(SignupErrorCode.PURCHASE_NOT_SUCCEED);
            }
            dto = signupAfterPay(fillCourseInfoRequestDto, orgId, orgNumber);
            // sendSignUpSms(dto.getSignupPurchaseId(), orgId,
            // dto.getStudentMobile());
            saveContent(
                RedisKeyEnums.CW.TIANXIAO_SIGNUP_REDIS_PRE.getRedisKey() + dto.getSignupPurchaseId().longValue(),
                SerializeUtil.serialize(dto));
            return dto;
        } else if (fillCourseInfoRequestDto.getSignupType() == SignupType.FRONTED.getCode()) {// 前端报名
            dto = signupBeforePay(fillCourseInfoRequestDto, orgId, orgNumber);
            // sendSignUpSms(dto.getSignupPurchaseId(), orgId,
            // dto.getStudentMobile());
            saveContent(
                RedisKeyEnums.CW.TIANXIAO_SIGNUP_REDIS_PRE.getRedisKey() + dto.getSignupPurchaseId().longValue(),
                SerializeUtil.serialize(dto));
            return dto;
        } else if (fillCourseInfoRequestDto.getSignupType() == SignupType.ONLINE.getCode()) {// 在线支付
            return signupPayOnline(fillCourseInfoRequestDto, orgId, orgNumber);
        } else {
            throw new BussinessException(SignupErrorCode.UNKNOWN_PURCHASE_STATUS);
        }
    }

    private OrgSingupInfoDto signupPayOnline(FillCourseInfoRequestDto fillCourseInfoRequestDto, Long orgId,
        Long orgNumber) {
        throw new UnsupportedOperationException("not implement....");
    }

    private OrgSingupInfoDto signupBeforePay(FillCourseInfoRequestDto fillCourseInfoRequestDto, Long orgId,
        Long orgNumber) throws BussinessException {
        if (CollectionUtils.isNotEmpty(fillCourseInfoRequestDto.getCourseInfos())) {// 新提交的课程
            double totalPrice = 0;
            for (SignupCourseInfoDto signupCourseInfoDto : fillCourseInfoRequestDto.getCourseInfos()) {
                totalPrice += caculatePayPrice(signupCourseInfoDto);
            }
            if (fillCourseInfoRequestDto.getFeeItemDtos() != null) {
                for (SignupFeeItemDto signupFeeItemDto : fillCourseInfoRequestDto.getFeeItemDtos()) {
                    totalPrice += caculateFeePrice(signupFeeItemDto);
                }
            }
            if (totalPrice > 1000000 || totalPrice < 0) {
                throw new BussinessException(SignupErrorCode.TOTALPRICE_ERROR,
                    SignupErrorCode.TOTALPRICE_ERROR.getMessage());
            }
            long begin = System.currentTimeMillis();
            Long purchaseId = RestUtils.getPurchaseId(orgId, totalPrice, fillCourseInfoRequestDto.getHeaders());
            String tradeNo = RestUtils.getTradeNo(orgId, purchaseId, totalPrice, fillCourseInfoRequestDto.getHeaders());
            long end = System.currentTimeMillis();
            log.debug("signupBeforePay-->    RestUtils.getPurchaseId cost{}", end - begin);
            log.info("getPurchaseId--> {}", purchaseId);
            Date now = new Date();
            OrgSignupInfo orgSignupInfo = new OrgSignupInfo();
            orgSignupInfo.setStudentPayPrice(0l);
            orgSignupInfo.setStatus(DataStatus.NORMAL.getValue());
            orgSignupInfo.setCreateTime(new Date());
            orgSignupInfo.setSplitResult(SplitCourseResult.PENDING.getCode());
            fillOrgSignupInfo(fillCourseInfoRequestDto, orgSignupInfo, orgId, orgNumber);
            orgSignupInfo.setSignupPurchaseId(purchaseId);
            orgSignupInfo.setPayPurchaseId(purchaseId);
            orgSignupInfo.setTradeNo(Long.parseLong(tradeNo));
            fillCourseInfoRequestDto.setSignupPurchaseId(purchaseId);
            orgSignupInfo.setSignupType(1);
            orgSignupInfo.setTotalPrices(NumberUtil.multiply(totalPrice, HUNDRED, 0).longValue());

            // 课程
            List<OrgSignupCourse> orgSignupCourses = Lists.newArrayList();
            for (SignupCourseInfoDto signupCourseInfoDto : fillCourseInfoRequestDto.getCourseInfos()) {
                signupCourseInfoDto.setPayPrice(caculatePayPrice(signupCourseInfoDto));
                orgSignupCourses.add(fillOrgSignupCourse(fillCourseInfoRequestDto, signupCourseInfoDto,
                    orgSignupInfo.getUserId(), now, orgId));
            }
            orgSignupInfo.setOrgSignupCourses(orgSignupCourses);

            // 费用
            List<OrgSignupFee> orgSignupFees = Lists.newArrayList();
            if (fillCourseInfoRequestDto.getFeeItemDtos() != null) {
                for (SignupFeeItemDto signupFeeItemDto : fillCourseInfoRequestDto.getFeeItemDtos()) {
                    signupFeeItemDto.setPayPrice(caculateFeePrice(signupFeeItemDto));
                    orgSignupFees.add(fillOrgSignupFee(fillCourseInfoRequestDto, signupFeeItemDto,
                        orgSignupInfo.getUserId(), now, orgId));
                }
            }
            orgSignupInfo.setOrgSignupFees(orgSignupFees);
            orgSignupInfo.setHeaders(fillCourseInfoRequestDto.getHeaders());
            orgSignupInfo.setSourceType(fillCourseInfoRequestDto.getSourceType());

            this.saveOrUpdateSignupInfo(orgSignupInfo, true);

            saveContent(RedisKeyEnums.CW.TIANXIAO_SIGNUP_REDIS_PRE.getRedisKey()
                + orgSignupInfo.getSignupPurchaseId().longValue(), SerializeUtil.serialize(orgSignupInfo));

            boolean isShowMobile =
                txCascadeCredentialService.isShowMobile(orgId, fillCourseInfoRequestDto.getCascadeId());

            return buildOrgSignupInfoDto(orgSignupInfo, isShowMobile);
        } else {
            throw new BussinessException(SignupErrorCode.SIGNUPCOURSE_NULL);
        }
    }

    public boolean signupCourseInfoEqual(OrgSignupCourse orgSignupCourse, SignupCourseInfoDto signupCourseInfoDto) {
        if (orgSignupCourse == null) {
            return true;
        }
        if (orgSignupCourse.getCount() != signupCourseInfoDto.getCount()) {
            return false;
        }
        if (orgSignupCourse.getCourseDiscount().intValue() != signupCourseInfoDto.getDiscount()) {
            return false;
        }
        if (orgSignupCourse.getOriginPrice().intValue() != signupCourseInfoDto.getOriginPrice().intValue()) {
            return false;
        }
        if (orgSignupCourse.getPreferential().intValue() != NumberUtil
            .multiply(signupCourseInfoDto.getPreferential(), HUNDRED, 0).intValue()) {
            return false;
        }
        return true;
    }

    private OrgSingupInfoDto signupAfterPay(FillCourseInfoRequestDto fillCourseInfoRequestDto, Long orgId,
        Long orgNumber) throws BussinessException {
        OrgSignupInfo orgSignupInfo = null;
        /**
         * 获取报名信息，包括课程
         */
        if (fillCourseInfoRequestDto.getSignupPurchaseId() != null) {
            orgSignupInfo = orgSignupInfoDao.searchByPurchaseId(fillCourseInfoRequestDto.getSignupPurchaseId(), true);
            orgSignupInfo.setOrgSignupCourses(
                orgSignupCourseDao.loadByPurchaseId(fillCourseInfoRequestDto.getSignupPurchaseId()));
            orgSignupInfo
                .setOrgSignupFees(orgSignupFeeDao.loadByPurchaseId(fillCourseInfoRequestDto.getSignupPurchaseId()));
        }

        if (orgSignupInfo == null || orgSignupInfo.getSignupType().intValue() != 0) {
            throw new BussinessException(SignupErrorCode.PURCHASEID_ERROR);
        }
        // 添加如果订单已经拆分完成,那么直接出提示
        if (orgSignupInfo != null && orgSignupInfo.getSplitResult().intValue() == SplitCourseResult.SUCCESS.getCode()) {
            throw new BussinessException(SignupErrorCode.COURCE_CHANGE);
        }

        // 如果已经报名成功，返回错误
        if (orgSignupInfo.getSplitResult().intValue() >= SplitCourseResult.PENDING.getCode()) {
            throw new BussinessException(SignupErrorCode.REPEAT_SUBMIT);
        }

        fillOrgSignupInfo(fillCourseInfoRequestDto, orgSignupInfo, orgId, orgNumber);
        orgSignupInfo.setSplitResult(SplitCourseResult.PENDING.getCode());
        long totalNow = 0l;
        long totalNew = 0l;
        Date now = new Date();
        Map<Long, OrgSignupCourse> orgSignupCourseMap = new HashMap<>();
        List<OrgSignupCourse> orgSignupCoursesNew = Lists.newArrayList();
        List<OrgSignupCourse> orgSignupCoursesNow = Lists.newArrayList();

        orgSignupCoursesNow.addAll(orgSignupInfo.getOrgSignupCourses());
        if (CollectionUtils.isNotEmpty(orgSignupInfo.getOrgSignupCourses())) {
            for (OrgSignupCourse orgSignupCourse : orgSignupInfo.getOrgSignupCourses()) {
                totalNow += orgSignupCourse.getPayPrice();
                orgSignupCourseMap.put(orgSignupCourse.getOrgCourseId(), orgSignupCourse);
            }
        }
        if (orgSignupInfo.getTotalPrices().longValue() <= totalNow) {
            log.warn(" signupAfterPay get error:{}", SignupErrorCode.REPEAT_SUBMIT.getMessage());
            throw new BussinessException(SignupErrorCode.REPEAT_SUBMIT);
        }

        if (CollectionUtils.isNotEmpty(fillCourseInfoRequestDto.getCourseInfos())) {// 新提交的课程
            for (SignupCourseInfoDto signupCourseInfoDto : fillCourseInfoRequestDto.getCourseInfos()) {
                if (orgSignupCourseMap.containsKey(signupCourseInfoDto.getOrgCourseId())) {
                    if (!signupCourseInfoEqual(orgSignupCourseMap.get(signupCourseInfoDto.getOrgCourseId()),
                        signupCourseInfoDto)) {
                        log.warn(" fillCourseInfo get error:{}", SignupErrorCode.COURCE_CHANGE.getMessage());
                        throw new BussinessException(SignupErrorCode.COURCE_CHANGE);
                    }
                } else {
                    signupCourseInfoDto.setPayPrice(caculatePayPrice(signupCourseInfoDto));
                    totalNew += NumberUtil.multiply(signupCourseInfoDto.getPayPrice(), HUNDRED, 0).longValue();
                    orgSignupCoursesNew.add(fillOrgSignupCourse(fillCourseInfoRequestDto, signupCourseInfoDto,
                        orgSignupInfo.getUserId(), now, orgId));
                }
            }
        }
        long total = totalNew + totalNow;
        if (total < 0) {
            throw new BussinessException(SignupErrorCode.TOTALPRICE_ERROR,
                SignupErrorCode.TOTALPRICE_ERROR.getMessage());
        } else if (total != orgSignupInfo.getTotalPrices().doubleValue()) {
            throw new BussinessException(SignupErrorCode.TOTALPRICE_NOTMATCH,
                SignupErrorCode.TOTALPRICE_NOTMATCH.getMessage());
        } else {
            if (orgSignupInfo.getPayType().intValue() == PayType.CASH.getCode()) {
                orgSignupInfo.setSplitResult(SplitCourseResult.SUCCESS.getCode());
            } else {
                orgSignupInfo.setSplitResult(SplitCourseResult.PENDING.getCode());
            }
        }

        if (CollectionUtils.isNotEmpty(orgSignupCoursesNew)) {
            orgSignupInfo.setOrgSignupCourses(orgSignupCoursesNew);
        }
        orgSignupInfo.setSourceType(fillCourseInfoRequestDto.getSourceType());
        this.saveOrUpdateSignupInfo(orgSignupInfo, true);
        orgSignupInfo.getOrgSignupCourses().addAll(orgSignupCoursesNow);
        orgSignupInfo.setPurchaseStatus(PayResult.SUCCESS.getCode());

        saveContent(
            RedisKeyEnums.CW.TIANXIAO_SIGNUP_REDIS_PRE.getRedisKey() + orgSignupInfo.getSignupPurchaseId().longValue(),
            SerializeUtil.serialize(orgSignupInfo));

        boolean isShowMobile = txCascadeCredentialService.isShowMobile(orgId, fillCourseInfoRequestDto.getCascadeId());

        return buildOrgSignupInfoDto(orgSignupInfo, isShowMobile);
    }

    private double caculatePayPrice(SignupCourseInfoDto signupCourseInfoDto) {
        if (signupCourseInfoDto.getChargeType() != null
            && signupCourseInfoDto.getChargeType().intValue() == ChargeType.BY_PERIODS.getCode()) {
            return signupCourseInfoDto.getPayPrice();// 按期的金额=原价/原单价*lessonCount ，按前端计算
        } else {
            BigDecimal result = new BigDecimal(signupCourseInfoDto.getOriginPrice())
                .multiply(new BigDecimal(signupCourseInfoDto.getDiscount())).divide(HUNDRED)
                .multiply(new BigDecimal(signupCourseInfoDto.getCount()))
                .subtract(new BigDecimal(signupCourseInfoDto.getPreferential())).setScale(2, RoundingMode.HALF_UP);
            return result.doubleValue();
        }
    }

    private double caculateFeePrice(SignupFeeItemDto signupFeeItemDto) {
        BigDecimal result =
            new BigDecimal(signupFeeItemDto.getOriginPrice()).multiply(new BigDecimal(signupFeeItemDto.getDiscount()))
                .divide(HUNDRED).multiply(new BigDecimal(signupFeeItemDto.getCount()))
                .subtract(new BigDecimal(signupFeeItemDto.getPreferential())).setScale(2, RoundingMode.HALF_UP);
        return result.doubleValue();
    }

    private OrgSignupCourse fillOrgSignupCourse(FillCourseInfoRequestDto fillCourseInfoRequestDto,
        SignupCourseInfoDto signupCourseInfoDto, Long studentId, Date now, Long orgId) {
        OrgCourse orgCourse = orgCourseDao.getByCourseId(signupCourseInfoDto.getOrgCourseId());
        OrgSignupCourse orgSignupCourse = new OrgSignupCourse();
        orgSignupCourse.setCount(signupCourseInfoDto.getCount());
        if (orgCourse != null && orgCourse.getChargeType() == ChargeType.BY_OTHER.getCode()) {
            orgSignupCourse.setLessonCount(0);
        } else {
            orgSignupCourse.setLessonCount(
                signupCourseInfoDto.getLessonCount() == null ? 0 : signupCourseInfoDto.getLessonCount());
        }
        orgSignupCourse.setCourseDiscount(signupCourseInfoDto.getDiscount());
        orgSignupCourse.setCreateTime(now);
        orgSignupCourse.setUpdateTime(now);
        orgSignupCourse.setOrgCourseId(signupCourseInfoDto.getOrgCourseId());
        orgSignupCourse.setOrgId(orgId);
        orgSignupCourse
            .setOriginPrice(NumberUtil.multiply(signupCourseInfoDto.getOriginPrice(), HUNDRED, 0).intValue());
        orgSignupCourse
            .setPreferential(NumberUtil.multiply(signupCourseInfoDto.getPreferential(), HUNDRED, 0).intValue());
        orgSignupCourse.setSignupPurchaseId(fillCourseInfoRequestDto.getSignupPurchaseId());
        orgSignupCourse.setOrgCourseNumber(signupCourseInfoDto.getOrgCourseNumber());
        orgSignupCourse.setUserId(studentId);
        orgSignupCourse.setPayPrice(NumberUtil.multiply(caculatePayPrice(signupCourseInfoDto), HUNDRED, 0).longValue());
        orgSignupCourse.setStudentPayPrice(0l);
        orgSignupCourse.setChargeUnit(signupCourseInfoDto.getChargeUnit());

        orgSignupCourse.setIsDel(DataStatus.NORMAL.getValue());
        orgSignupCourse.setStatus(SignupCourseStatus.NOT_PAY.getCode());

        return orgSignupCourse;

    }

    private OrgSignupFee fillOrgSignupFee(FillCourseInfoRequestDto fillCourseInfoRequestDto,
        SignupFeeItemDto signupFeeItemDto, Long studentId, Date now, Long orgId) {
        OrgSignupFee orgSignupFee = new OrgSignupFee();
        orgSignupFee.setCount(signupFeeItemDto.getCount());
        orgSignupFee.setFeeItemDiscount(signupFeeItemDto.getDiscount());
        orgSignupFee.setCreateTime(now);
        orgSignupFee.setFeeItemId(signupFeeItemDto.getFeeItemId());
        orgSignupFee.setOrgId(orgId);
        orgSignupFee.setOriginPrice(NumberUtil.multiply(signupFeeItemDto.getOriginPrice(), HUNDRED, 0).intValue());
        orgSignupFee.setPreferential(NumberUtil.multiply(signupFeeItemDto.getPreferential(), HUNDRED, 0).intValue());
        orgSignupFee.setSignupPurchaseId(fillCourseInfoRequestDto.getSignupPurchaseId());
        orgSignupFee.setFeeItemName(signupFeeItemDto.getFeeItemName());
        orgSignupFee.setUserId(studentId);
        orgSignupFee.setPayPrice(NumberUtil.multiply(caculateFeePrice(signupFeeItemDto), HUNDRED, 0).longValue());
        return orgSignupFee;

    }

    private Long getStudent(FillCourseInfoRequestDto fillCourseInfoRequestDto) throws BussinessException {
        Long usrId = null;
        Long studentId = null;
        Long orgId = fillCourseInfoRequestDto.getOrgId();
        String mobile = fillCourseInfoRequestDto.getStudentMobile();
        String studentName = fillCourseInfoRequestDto.getStudentName();

        List<OrgStudent> students = Lists.newArrayList();
        if (fillCourseInfoRequestDto.getStudentId() != null) {
            List studentIds = Lists.newArrayList();
            studentIds.add(fillCourseInfoRequestDto.getStudentId());
            students = orgStudentDao.getStudentByIds(fillCourseInfoRequestDto.getOrgId(), studentIds);
        } else {
            students = orgStudentDao.getStudentId(orgId, mobile, DeleteStatus.NORMAL.getValue(), studentName, "userId",
                "id", "mobile", "showMobile");
        }

        StudentInfoDto studentInfoDto = new StudentInfoDto();
        if (!students.isEmpty()) {
            OrgStudent stu = students.get(0);
            usrId = stu.getUserId();
            studentId = stu.getId();
            studentInfoDto = fillStudentInfoByStu(studentInfoDto, stu);
        }
        log.debug("studentInfoDto = {}", studentInfoDto);
        studentInfoDto = fillStudentInfo(studentInfoDto, fillCourseInfoRequestDto);
        List<CommentInfoDto> commentInfoDtos = fillCommentInfoList(fillCourseInfoRequestDto);
        List<TagInfoDto> tagInfoDtos = fillTagInfoList(studentId, fillCourseInfoRequestDto);

        log.debug("studentInfoDto = {},tagInfoDto={}", studentInfoDto, tagInfoDtos);
        // 报名的同时添加或修改档案信息
        studentInfoDto.setConfirm(BizConf.TRUE);
        if (studentId == null) {
            OrgStudentAddresponseDto dto =
                this.orgStudentService.addStudent(studentInfoDto, commentInfoDtos, tagInfoDtos, orgId);
            usrId = dto.getUserId();
        } else {
            this.orgStudentService.modStudent(studentInfoDto, commentInfoDtos, tagInfoDtos, orgId);
            // if (CollectionUtils.isNotEmpty(tagInfoDtos)) {
            // this.tagService.batchHandleTags(StudentType.ORG_STUDENTS.getCode(), orgId,
            // studentInfoDto.getStudentId(), tagInfoDtos);
            // }
        }
        return usrId;
    }

    private StudentInfoDto fillStudentInfoByStu(StudentInfoDto studentInfoDto, OrgStudent stu) {
        studentInfoDto.setStudentId(stu.getId());
        studentInfoDto.setMobile(stu.getStudentMobile());
        studentInfoDto.setQq(stu.getQq());
        studentInfoDto.setWeixin(stu.getWeixin());
        studentInfoDto.setName(stu.getName());
        studentInfoDto.setBirthday(stu.getBirthday() != null ? stu.getBirthday().getTime() : null);
        studentInfoDto.setRemark(stu.getRemark());
        studentInfoDto.setMail(stu.getMail());
        studentInfoDto.setParentName(stu.getParentName());
        studentInfoDto.setParentMobile(stu.getParentMobile());
        studentInfoDto.setGender(stu.getGender());
        studentInfoDto.setNextRemindTimeDate(stu.getNextRemindTime());
        studentInfoDto.setAddress(stu.getAddress());
        studentInfoDto.setDegreeClass(stu.getDegreeClass());
        studentInfoDto.setFatherOccupation(stu.getFatherOccupation());
        studentInfoDto.setMatherOccupation(stu.getMatherOccupation());
        studentInfoDto.setSource(stu.getSource());
        studentInfoDto.setSchool(stu.getSchool());
        studentInfoDto.setBranchId(stu.getBranchId());
        studentInfoDto.setRelationship(stu.getRelationship());
        studentInfoDto.setLatitude(stu.getLatitude() != null ? stu.getLatitude() : 0.00000);
        studentInfoDto.setLongitude(stu.getLongitude() != null ? stu.getLongitude() : 0.00000);
        studentInfoDto.setAreaId(stu.getAreaId());
        studentInfoDto.setStorageId(stu.getAvatar());
        studentInfoDto.setNextRemindTime(stu.getNextRemindTime() != null ? stu.getNextRemindTime().getTime() : null);
        return studentInfoDto;
    }

    private StudentInfoDto fillStudentInfo(StudentInfoDto studentInfoDto,
        FillCourseInfoRequestDto fillCourseInfoRequestDto) {
        if (fillCourseInfoRequestDto.getStudentId() != null)
            studentInfoDto.setStudentId(fillCourseInfoRequestDto.getStudentId());

        if (fillCourseInfoRequestDto.getStudentMobile() != null
            && !fillCourseInfoRequestDto.getStudentMobile().contains("*"))
            studentInfoDto.setMobile(fillCourseInfoRequestDto.getStudentMobile());

        if (fillCourseInfoRequestDto.getStudentQQ() != null)
            studentInfoDto.setQq(fillCourseInfoRequestDto.getStudentQQ());

        if (fillCourseInfoRequestDto.getStudentWx() != null)
            studentInfoDto.setWeixin(fillCourseInfoRequestDto.getStudentWx());

        if (fillCourseInfoRequestDto.getStudentName() != null)
            studentInfoDto.setName(fillCourseInfoRequestDto.getStudentName());

        if (fillCourseInfoRequestDto.getBirthday() != null)
            studentInfoDto.setBirthday(fillCourseInfoRequestDto.getBirthday().getTime());

        if (fillCourseInfoRequestDto.getStudentRemark() != null)
            studentInfoDto.setRemark(fillCourseInfoRequestDto.getStudentRemark());

        if (fillCourseInfoRequestDto.getEmail() != null)
            studentInfoDto.setMail(fillCourseInfoRequestDto.getEmail());

        if (fillCourseInfoRequestDto.getParentName() != null)
            studentInfoDto.setParentName(fillCourseInfoRequestDto.getParentName());

        if (fillCourseInfoRequestDto.getParentMobile() != null
            && !fillCourseInfoRequestDto.getParentMobile().contains("*"))
            studentInfoDto.setParentMobile(fillCourseInfoRequestDto.getParentMobile());

        if (fillCourseInfoRequestDto.getGender() != null) {
            studentInfoDto.setGender(fillCourseInfoRequestDto.getGender());
        }

        if (fillCourseInfoRequestDto.getTags() != null) {
            studentInfoDto.setTags(fillCourseInfoRequestDto.getTags());
        }

        return studentInfoDto;
    }

    private List<CommentInfoDto> fillCommentInfoList(FillCourseInfoRequestDto fillCourseInfoRequestDto) {
        return Collections.EMPTY_LIST;
    }

    private List<TagInfoDto> fillTagInfoList(Long studentId, FillCourseInfoRequestDto fillCourseInfoRequestDto) {
        log.debug("fillTagInfoList={}", fillCourseInfoRequestDto);
        List<TagInfoDto> tagInfoDtos = Lists.newArrayList();
        if (studentId == null) {
            return tagInfoDtos;
        }
        if (StringUtils.isEmpty(fillCourseInfoRequestDto.getTags())) {
            OrgTagListResopnseDto tagsResponse = this.orgStudentTagService.getTags(StudentType.ORG_STUDENTS.getCode(),
                studentId, fillCourseInfoRequestDto.getOrgId());
            return tagsResponse.getTags();
        }

        String[] tags = fillCourseInfoRequestDto.getTags().split(" ");
        for (String tag : tags) {
            TagInfoDto tagInfoDto = new TagInfoDto();
            tagInfoDto.setContent(tag);
            tagInfoDtos.add(tagInfoDto);
        }
        log.debug("fillTagInfoList={},{}", tagInfoDtos, tags);
        return tagInfoDtos;
    }

    private void fillOrgSignupInfo(FillCourseInfoRequestDto fillCourseInfoRequestDto, OrgSignupInfo orgSignupInfo,
        Long orgId, Long orgNumber) throws BussinessException {
        long begin = System.currentTimeMillis();
        Long stuUserId = getStudent(fillCourseInfoRequestDto);
        long end = System.currentTimeMillis();
        log.debug("-->    getStudent cost{}", end - begin);
        orgSignupInfo.setUserId(stuUserId);
        orgSignupInfo.setOrgId(orgId);
        orgSignupInfo.setOrgNumber(orgNumber);
        orgSignupInfo.setMobile(fillCourseInfoRequestDto.getStudentMobile());
        orgSignupInfo.setStudentName(fillCourseInfoRequestDto.getStudentName());
        if (orgSignupInfo.getPayType() == null) {
            orgSignupInfo.setPayType(PayType.PAY_POS_CARD.getCode());
        }
        orgSignupInfo.setRemark(StringUtils.isEmpty(fillCourseInfoRequestDto.getRemark()) ? orgSignupInfo.getRemark()
            : fillCourseInfoRequestDto.getRemark());
        orgSignupInfo.setRemark(orgSignupInfo.getRemark() == null ? "" : orgSignupInfo.getRemark());
        orgSignupInfo.setOperator("");
        orgSignupInfo.setUpdateTime(new Date());
        orgSignupInfo.setSignupType(fillCourseInfoRequestDto.getSignupType());
        if (orgSignupInfo.getCascadeId() == null || orgSignupInfo.getCascadeId().intValue() == 0) {
            orgSignupInfo.setCascadeId(
                fillCourseInfoRequestDto.getCascadeId() == null ? 0 : fillCourseInfoRequestDto.getCascadeId());
        }
        // orgSignupInfo.setSplitResult(SplitCourseResult.PENDING.getCode());
    }

    @Override
    @Transactional
    public OrgSingupInfoDto payByCash(Long signupPurchaseId, Long orgId, Integer cascadeId) throws BussinessException {

        OrgSignupInfo orgSignupInfo = orgSignupInfoDao.searchByPurchaseId(signupPurchaseId);
        boolean isNew = false;
        if (orgSignupInfo == null) {
            OrgSinupPurchase purchase = orgSinupPurchaseDao.getByPurchaseId(signupPurchaseId);
            log.debug("get purchase:{} by purchaseId:{}", purchase, signupPurchaseId);
            if (purchase != null) {
                isNew = true;
                orgSignupInfo = insertSuccSignupInfo(signupPurchaseId, purchase, purchase.getPurchaseId(), cascadeId);
            }
        }
        if (orgSignupInfo == null) {
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "signup purchase error");
        }

        List<OrgSignupCourse> orgCourseList = orgSignupCourseDao.loadByPurchaseId(signupPurchaseId);

        OrgSignupInfo saveObj = new OrgSignupInfo();
        saveObj.setId(orgSignupInfo.getId());
        saveObj.setPayType(PayType.CASH.getCode());
        saveObj.setPurchaseStatus(1);
        saveObj.setPayTime(new Date());
        if (isNew) {
            saveObj.setSplitResult(SplitCourseResult.NOT_COMMIT.getCode());
        } else {
            saveObj.setSplitResult(SplitCourseResult.SUCCESS.getCode());
            orgSignupCourseDao.updateStatusByPurchaseId(signupPurchaseId, SignupCourseStatus.HAS_PAY.getCode());
            for (OrgSignupCourse signupCourse : orgCourseList) {
                signupCourse.setStatus(SignupCourseStatus.HAS_PAY.getCode());
            }
        }
        orgSignupInfoDao.update(saveObj, false, "payType", "purchaseStatus", "splitResult", "payTime");

        orgSignupInfo.setOrgSignupCourses(orgCourseList);
        orgSignupInfo.setStudentPayPrice(orgSignupInfo.getStudentPayPrice());
        orgSignupInfo.setStatus(DataStatus.NORMAL.getValue());
        orgSignupInfo.setPayType(PayType.CASH.getCode());
        orgSignupInfo.setPurchaseStatus(1);
        orgSignupInfo.setCascadeId(cascadeId);

        saveContent(
            RedisKeyEnums.CW.TIANXIAO_SIGNUP_REDIS_PRE.getRedisKey() + orgSignupInfo.getSignupPurchaseId().longValue(),
            SerializeUtil.serialize(orgSignupInfo));

        boolean isShowMobile = txCascadeCredentialService.isShowMobile(orgId, cascadeId);

        return buildOrgSignupInfoDto(orgSignupInfo, isShowMobile);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void delSignupInfo(Long signupPurchaseId, Long orgId) throws BussinessException {
        OrgSignupInfo orgSignupInfo = orgSignupInfoDao.searchByPurchaseId(signupPurchaseId, "id");
        if (orgSignupInfo == null) {
            throw new BussinessException(SignupErrorCode.PURCHASEID_ERROR);
        }
        orgSignupInfo.setIsDel(DataStatus.DELETE.getValue());
        orgSignupInfo.setUpdateTime(new Date());
        orgSignupInfoDao.update(orgSignupInfo, false, "isDel", "updateTime");

        orgSignupCourseDao.delSignupCourseByPurchaseId(signupPurchaseId);
    }

    @Override
    public OrgSignupInfo getByPurchaseId(Long orgId, Long signupPurchaseId) throws BussinessException {
        return orgSignupInfoDao.getByPurchaseId(orgId, signupPurchaseId);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean isPurchaseSucce(Long payPurchaseId, Long orgId, Integer cascadeId) throws BussinessException {
        Preconditions.checkNotNull(payPurchaseId);
        Preconditions.checkArgument(payPurchaseId > 0, "purchase id can not be 0");
        /*
         * 从org_sinup_purchase获取支付数据，更新org_signup_info表
         */
        OrgSignupInfo orgSignupInfo = orgSignupInfoDao.searchByPayPurchaseId(payPurchaseId, false);

        if (orgSignupInfo == null) {
            orgSignupInfo = orgSignupInfoDao.searchByPurchaseId(payPurchaseId, false);
        }

        OrgSinupPurchase purchase = orgSinupPurchaseDao.getByPurchaseId(payPurchaseId);

        if (orgSignupInfo != null && orgSignupInfo.getPayType() != null
            && orgSignupInfo.getPayType().intValue() == PayType.CASH.getCode()) {

            byte[] signupBytes = getContent(RedisKeyEnums.CW.TIANXIAO_SIGNUP_REDIS_PRE.getRedisKey()
                + orgSignupInfo.getSignupPurchaseId().longValue());
            if (signupBytes == null) {
                return true;
            }
            OrgSignupInfo orgSignupInfoRedis = (OrgSignupInfo) SerializeUtil.unserialize(signupBytes);

            if (orgSignupInfoRedis != null) {
                orgSignupInfoRedis.setPurchaseStatus(PayResult.SUCCESS.getCode());
                saveContent(
                    RedisKeyEnums.CW.TIANXIAO_SIGNUP_REDIS_PRE.getRedisKey()
                        + orgSignupInfoRedis.getSignupPurchaseId().longValue(),
                    SerializeUtil.serialize(orgSignupInfoRedis));
            }
            return true;
        }
        if (purchase.getStatus() != null && purchase.getStatus().intValue() == PayResult.SUCCESS.getCode()) {
            Map<Long, Long> tradeNoMap = RestUtils.getTradeNoMap(Lists.newArrayList(payPurchaseId));
            if (orgSignupInfo == null) {
                orgSignupInfo = insertSuccSignupInfo(payPurchaseId, purchase, tradeNoMap.get(payPurchaseId), cascadeId);
                saveContent(
                    RedisKeyEnums.CW.TIANXIAO_SIGNUP_REDIS_PRE.getRedisKey() + orgSignupInfo.getSignupPurchaseId(),
                    SerializeUtil.serialize(orgSignupInfo));
                return true;
            } else {
                if (orgSignupInfo.getPurchaseStatus().intValue() != PayResult.SUCCESS.getCode()) {
                    if (tradeNoMap.isEmpty() || !tradeNoMap.containsKey(payPurchaseId)) {
                        throw new BussinessException(SignupErrorCode.PURCHASE_NOT_SUCCEED);
                    }
                    orgSignupInfo.setPurchaseStatus(PayResult.SUCCESS.getCode());

                    int payType = PayType.getPayTypeByTypeStr(purchase.getPayType()).getCode();
                    orgSignupInfo.setTradeNo(tradeNoMap.get(payPurchaseId));
                    orgSignupInfo.setPayType(payType);
                    orgSignupInfo.setPayTime(new Date());
                    orgSignupInfoDao.update(orgSignupInfo, "purchaseStatus", "tradeNo", "payType", "payTime");

                    saveContent(
                        RedisKeyEnums.CW.TIANXIAO_SIGNUP_REDIS_PRE.getRedisKey() + orgSignupInfo.getSignupPurchaseId(),
                        SerializeUtil.serialize(orgSignupInfo));
                    return true;
                }
            }

            byte[] signupBytes = getContent(RedisKeyEnums.CW.TIANXIAO_SIGNUP_REDIS_PRE.getRedisKey()
                + (orgSignupInfo == null ? payPurchaseId : orgSignupInfo.getSignupPurchaseId()));
            if (signupBytes != null) {
                OrgSignupInfo orgSignupInfoRedis = (OrgSignupInfo) SerializeUtil.unserialize(signupBytes);
                if (orgSignupInfoRedis != null) {
                    orgSignupInfoRedis.setPurchaseStatus(PayResult.SUCCESS.getCode());
                    saveContent(
                        RedisKeyEnums.CW.TIANXIAO_SIGNUP_REDIS_PRE.getRedisKey()
                            + orgSignupInfoRedis.getSignupPurchaseId().longValue(),
                        SerializeUtil.serialize(orgSignupInfoRedis));
                }
            }
            return true;
        }
        return false;
    }

    private OrgSignupInfo insertSuccSignupInfo(Long signupPurchaseId, OrgSinupPurchase sinupPurchase, Long tradeNo,
        Integer cascadeId) {
        log.info("create signup info from purchase:{}", sinupPurchase);
        OrgSignupInfo info = new OrgSignupInfo();
        info.setCreateTime(sinupPurchase.getPayTime());
        info.setPayTime(sinupPurchase.getPayTime());
        info.setStatus(DeleteStatus.NORMAL.getValue());
        info.setIsDel(DeleteStatus.NORMAL.getValue());
        info.setMobile("");
        info.setOperator("");
        info.setOrgId(sinupPurchase.getOrgId());
        info.setOrgNumber(sinupPurchase.getOrgNumber());
        info.setPayType(PayType.getPayTypeByTypeStr(sinupPurchase.getPayType()).getCode());
        info.setPurchaseStatus(sinupPurchase.getStatus());
        info.setRemark("");
        info.setSignupPurchaseId(signupPurchaseId);
        info.setPayPurchaseId(sinupPurchase.getPurchaseId());
        info.setSignupType(SignupType.POS_CARD.getCode());
        info.setSplitResult(SplitCourseResult.NOT_COMMIT.getCode());
        info.setStudentName("");
        info.setTotalPrices(NumberUtil.multiply(sinupPurchase.getTotalPrices(), HUNDRED, 0).longValue());
        info.setStudentPayPrice(0l);
        info.setUpdateTime(new Date());
        info.setUserId(0l);
        info.setTradeNo(tradeNo);
        info.setCascadeId(cascadeId);
        this.saveOrUpdateSignupInfo(info, false);
        return info;
    }

    private void saveOrUpdateSignupInfo(@NonNull OrgSignupInfo signupInfo, boolean saveCourses) {
        // 设置默认天校报名
        if (signupInfo.getSourceType() == null || signupInfo.getSourceType().intValue() == 0) {
            signupInfo.setSourceType(SignupSourceType.TX_SIANGUP.getCode());
        }

        if (signupInfo.getPurchaseStatus().intValue() != PayStatus.SUCESS.getCode()
            && signupInfo.getStudentPayPrice() == 0 && signupInfo.getTotalPrices() == 0) {
            signupInfo.setPayType(PayType.CASH.getCode());
            signupInfo.setPayTime(new Date());
            signupInfo.setPurchaseStatus(PayResult.SUCCESS.getCode());
            signupInfo.setSplitResult(SplitCourseResult.SUCCESS.getCode());
        }

        if (signupInfo.getId() != null && signupInfo.getId() > 0) {
            this.orgSignupInfoDao.update(signupInfo);
        } else {
            this.orgSignupInfoDao.save(signupInfo);
        }
        if (saveCourses && CollectionUtils.isNotEmpty(signupInfo.getOrgSignupCourses())) {
            try {
                orgSignupCourseDao.saveSignupCourses(signupInfo.getOrgSignupCourses());
            } catch (org.springframework.dao.DuplicateKeyException e) {
                log.warn("数据重复。e = {}", e);
            }
        }

        if (saveCourses && CollectionUtils.isNotEmpty(signupInfo.getOrgSignupFees())) {
            try {
                orgSignupFeeDao.saveSignupFees(signupInfo.getOrgSignupFees());
            } catch (Exception e) {
                log.warn("数据error。e = {}", e);
            }
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean sendOnlinePaySms(@NonNull Long signupPurchaseId, @NonNull Long orgId, @NonNull String mobile)
        throws BussinessException {
        OrgSignupInfo purchase = orgSignupInfoDao.searchByPurchaseId(signupPurchaseId);
        if (!ParamValidateUtils.validateMobile(mobile)) {
            throw new BussinessException(SignupErrorCode.MOBILE_FORMATE_ERROR);
        }
        if (purchase == null || !purchase.getOrgId().equals(orgId)) {
            throw new BussinessException(SignupErrorCode.PURCHASE_ID_INVALIDATE);
        }
        if (purchase.getPurchaseStatus().intValue() == PayResult.SUCCESS.getCode()) {
            throw new BussinessException(SignupErrorCode.PURCHASE_ID_ALREADY_PAY_SUCC);
        }
        if (purchase.getSplitResult().intValue() == SplitCourseResult.NOT_COMMIT.getCode()) {
            throw new BussinessException(SignupErrorCode.SIGNUP_HAS_NOT_COURSE_INFO);
        }
        int count = orgSignupOninePayDao.countByMobileAndPurchaseId(signupPurchaseId, mobile, DateUtils.getToday());
        String maxCountStr = UrlProperties.getProperty("max.signup.count");
        int maxCount = 3;
        if (StringUtils.isNumeric(maxCountStr)) {
            maxCount = Integer.parseInt(maxCountStr);
        }
        if (count >= maxCount) {
            throw new BussinessException(SignupErrorCode.SEND_SMS_COUNT_TOO_SOON);
        }
        Long payPurchaseId = purchase.getPayPurchaseId() == 0 ? signupPurchaseId : purchase.getPayPurchaseId();
        OrgSignupOnlinePay onlinePay = new OrgSignupOnlinePay();
        onlinePay.setCreateTime(new Date());
        onlinePay.setPurchaseId(payPurchaseId);
        onlinePay.setOrgId(orgId);
        onlinePay.setToMobile(mobile);
        String smsKey =
            MD5Utils.MD5(OrgSignupOnlinePayDao.ENC_KEY + payPurchaseId + mobile + System.currentTimeMillis());
        onlinePay.setSmsKey(smsKey);
        orgSignupOninePayDao.save(onlinePay);

        purchase.setPayType(PayType.ONLINE_PAYMENT.getCode());
        orgSignupInfoDao.update(purchase, "payType");

        return createAndSaveTtsSms(orgId, onlinePay.getId(), mobile, buildSmsContent(
            OrgSignupOnlinePayDao.SIGNUP_PAY_SMS_CONTENT_TEMPLATE, purchase, smsKey, SIGNUP_PAY_SMS_CONTENT));
    }

    private String buildSmsContent(String smsTemplate, OrgSignupInfo purchase, String smsKey, int smsCodeType) {
        log.debug("buildSmsContent  purchaseId = {}", purchase.getSignupPurchaseId());
        List<OrgSignupCourse> courses = orgSignupCourseDao.loadByPurchaseId(purchase.getSignupPurchaseId(),
            "orgCourseId", "originPrice", "payPrice");
        Set<Long> courseIds = Sets.newHashSet();
        CollectionUtils.collect(courses, new Transformer<OrgSignupCourse, Long>() {
            @Override
            public Long transform(OrgSignupCourse input) {
                return input.getOrgCourseId();
            }
        }, courseIds);

        Map<Long, String> courseName = orgCourseDao.getCourseNameMap(courseIds);
        log.debug("courseIds = {} courseName={}", courseIds, courseName);
        String orgName = orgInfoDao.getOrgShortNameByOrgId(purchase.getOrgId().intValue());
        String cName = null;
        String showCourseName = null;
        for (OrgSignupCourse course : courses) {
            if (cName == null) {
                cName = "『" + courseName.get(course.getOrgCourseId()) + "』";
                showCourseName = courseName.get(course.getOrgCourseId());
            }
        }
        String h5Url =
            ShortUrlUtil.getShortUrl(UrlProperties.getProperty("signup.online.pay.url") + "?smsKey=" + smsKey);
        if (smsCodeType == SIGNUP_PAY_SMS_CONTENT) {
            return SmsContentHelper.createSignupPaySmsMsg(showCourseName, orgName, h5Url, courseName.size());
        } else {
            if (courseName.size() > 1) {
                cName += "等课程";
            }
            return String.format(smsTemplate, orgName, cName, purchase.getTotalPrices().doubleValue() / 100, h5Url);
        }
    }

    @Override
    public boolean sendSignUpSms(@NonNull Long signupPurchaseId, @NonNull Long orgId, @NonNull String mobile)
        throws BussinessException {
        log.info("sendSignUpSms signupPurchaseId={},orgId={},mobile={}", signupPurchaseId, orgId, mobile);
        OrgSignupInfo purchase = orgSignupInfoDao.searchByPurchaseId(signupPurchaseId);
        if (!ParamValidateUtils.validateMobile(mobile)) {
            throw new BussinessException(SignupErrorCode.MOBILE_FORMATE_ERROR);
        }
        if (purchase == null || !purchase.getOrgId().equals(orgId)) {
            throw new BussinessException(SignupErrorCode.PURCHASE_ID_INVALIDATE);
        }

        int count = orgSignupOninePayDao.countByMobileAndPurchaseId(signupPurchaseId, mobile, DateUtils.getToday());
        log.debug("count={}", count);
        String maxCountStr = UrlProperties.getProperty("max.signup.count");
        int maxCount = 3;
        if (StringUtils.isNumeric(maxCountStr)) {
            maxCount = Integer.parseInt(maxCountStr);
        }
        if (count >= maxCount) {
            throw new BussinessException(SignupErrorCode.SEND_SMS_COUNT_TOO_SOON);
        }
        OrgSignupOnlinePay onlinePay = new OrgSignupOnlinePay();
        onlinePay.setCreateTime(new Date());
        onlinePay.setPurchaseId(signupPurchaseId);
        onlinePay.setOrgId(orgId);
        onlinePay.setToMobile(mobile);
        String smsKey =
            MD5Utils.MD5(OrgSignupOnlinePayDao.ENC_KEY + signupPurchaseId + mobile + System.currentTimeMillis());
        onlinePay.setSmsKey(smsKey);
        orgSignupOninePayDao.save(onlinePay);

        /* purchase.setPayType(PayType.ONLINE_PAYMENT.getCode()); */
        /* orgSignupInfoDao.update(purchase, "payType"); */

        return createAndSaveTtsSms(orgId, onlinePay.getId(), mobile, buildSmsContent(
            OrgSignupOnlinePayDao.SIGNUP_COMPLETE_SMS_CONTENT_TEMPLATE, purchase, smsKey, SIGNUP_COMPLETE_SMS_CONTENT));
    }

    private boolean createAndSaveTtsSms(Long orgId, Long onlinePayId, String mobile, String content) {
        TtsSms sms = new TtsSms();
        sms.setContent(content);
        sms.setMessageType(SmsMessageType.NOTIFY.getCode());
        sms.setMobile(mobile);

        boolean sendResult =
            SmsSendUtil.sendSms(mobile, content, SmsMessageType.TIANXIAO_NOTIFY.getCode(), orgId.intValue(),
                UserRole.ORGANIZATION.getRole(), true, txAccountService.getTxAccountSmsGate(orgId.intValue()));
        sms.setSendResult(sendResult ? SmsSendResult.SUCCESS.getValue() : SmsSendResult.FAILED.getValue());
        sms.setSendSmsKey(onlinePayId);

        try {
            ttsSmsDao.save(sms);
        } catch (Exception e) {
            log.warn("save sms record catch error:{}", e);
        }
        log.info("send sms to :{},onlinePayId:{} is succ:{}", mobile, onlinePayId, sendResult);
        return sendResult;
    }

    private Map<Long, List<String>> getCourseIdTeacherNamesMap(Collection<Long> courseIds) {
        List<OrgCourseTeacher> orgCourseTeachers = orgCourseTeacherDao.getOrgCourseTeacher(courseIds, null);

        if (CollectionUtils.isNotEmpty(orgCourseTeachers)) {
            Map<Long, List<String>> result = Maps.newHashMap();
            Set<Long> teacherIds = Sets.newHashSet();
            for (OrgCourseTeacher orgCourseTeacher : orgCourseTeachers) {
                teacherIds.add(orgCourseTeacher.getUserId());
            }

            Map<Long, String> teacherNames = teacherDao.getTeacherRealNameMap(teacherIds);
            for (OrgCourseTeacher orgCourseTeacher : orgCourseTeachers) {
                Long courseId = orgCourseTeacher.getOrgCourseId();
                if (!result.containsKey(courseId)) {
                    result.put(courseId, Lists.<String> newArrayList());
                }
                String name = teacherNames.get(orgCourseTeacher.getUserId());
                if (name != null) {
                    result.get(courseId).add(name);
                }
            }
            return result;
        }

        return Collections.emptyMap();

    }

    @Override
    public OrgSingupInfoDto getCourseInfo(Collection<Header> headers, Long signupPurchaseId, Long orgId,
        Integer cascadeId) {
        OrgSignupInfo orgSignupInfo = orgSignupInfoDao.searchByPurchaseId(signupPurchaseId);

        if (orgSignupInfo == null) {
            orgSignupInfo = (OrgSignupInfo) SerializeUtil.unserialize(
                getContent(RedisKeyEnums.CW.TIANXIAO_SIGNUP_REDIS_PRE.getRedisKey() + signupPurchaseId.longValue()));

        } else {
            orgSignupInfo.setOrgSignupCourses(orgSignupCourseDao.loadByPurchaseId(signupPurchaseId));
            orgSignupInfo.setOrgSignupFees(orgSignupFeeDao.loadByPurchaseId(signupPurchaseId));
        }

        boolean isShowMobile = txCascadeCredentialService.isShowMobile(orgId, cascadeId);
        if (orgSignupInfo == null) {
            log.error("orgSignupInfo is null signupPurchaseId:{}", signupPurchaseId);
        }
        OrgSingupInfoDto dto = buildOrgSignupInfoDto(orgSignupInfo, isShowMobile);

        if (orgSignupInfo.getPurchaseStatus().intValue() != PayResult.SUCCESS.getCode()
            && orgSignupInfo.getTotalPrices().doubleValue() > 0) {
            log.info("get new TradeNo while pay status is not success");
            String tradeNo = RestUtils.getTradeNo(orgSignupInfo.getOrgId(), orgSignupInfo.getSignupPurchaseId(),
                orgSignupInfo.getTotalPrices().doubleValue() / 100, headers);
            dto.setTradeNo(tradeNo);

            String payUrlWinxin = RestUtils.getWeiXinPurchaseUrl(signupPurchaseId, orgSignupInfo.getOrgId(),
                orgSignupInfo.getTotalPrices().doubleValue() / 100, headers);
            dto.setPayUrlWinxin(payUrlWinxin);
        }

        OrgSignupOnlinePay onlinePayRecord =
            orgSignupOninePayDao.getLastRecordByPurchaseId(signupPurchaseId, "createTime");
        if (onlinePayRecord != null) {
            dto.setLastSendTime(onlinePayRecord.getCreateTime());
        }

        return dto;
    }

    @Override
    public PaymentResultDto getPaymentResultDto(Long signupPurchaseId) throws BussinessException, Exception {
        PayResultDto payResultDto = RestUtils.getSignupPayResultDto(signupPurchaseId);

        PaymentResultDto dto = new PaymentResultDto();
        dto.setCourseName(payResultDto.getCourseName());
        dto.setPaymentMethod(payResultDto.getPayTypeStr());
        dto.setPaymentTime(payResultDto.getPayTime());
        dto.setTotalPrice(payResultDto.getTotalPrice());
        dto.setStatus(payResultDto.getStatus());
        dto.setCount(payResultDto.getCount());

        OrgSignupInfo orgSignupInfo = orgSignupInfoDao.searchByPurchaseId(signupPurchaseId);
        dto.setStudentMobile(orgSignupInfo.getMobile());
        dto.setStudentName(orgSignupInfo.getStudentName());
        return dto;
    }

    @Override
    public void updateSignupRemark(Long signupPurchaseId, String remark) {
        OrgSignupInfo orgSignupInfo = orgSignupInfoDao.searchByPurchaseId(signupPurchaseId);
        if (orgSignupInfo != null) {
            orgSignupInfo.setRemark(remark);
            orgSignupInfo.setUpdateTime(orgSignupInfo.getUpdateTime());
            orgSignupInfoDao.saveOrUpdateSignupInfo(orgSignupInfo);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void cancelSignupInfo(Long signupPurchaseId, Long orgId) throws BussinessException {
        OrgSignupInfo orgSignupInfo = orgSignupInfoDao.searchByPurchaseId(signupPurchaseId, "id");
        if (orgSignupInfo == null) {
            throw new BussinessException(SignupErrorCode.PURCHASEID_ERROR);
        }
        orgSignupInfo.setStatus(DeleteStatus.DELETED.getValue());// 取消
        orgSignupInfo.setUpdateTime(new Date());
        orgSignupInfoDao.update(orgSignupInfo, false, "status", "updateTime");

        List<OrgSignupCourse> signupCourses = orgSignupCourseDao.loadByPurchaseId(signupPurchaseId);
        for (OrgSignupCourse orgSignupCourse : signupCourses) {
            orgSignupCourse.setStatus(DataStatus.DELETE.getValue());// 取消
            orgSignupCourseDao.update(orgSignupCourse, "status");
        }
    }

    @Override
    public OrgSignupInfo changeSignupStudentPrice(Long orgId, Long signupPurchaseId, Integer opType,
        Long studentPayMoney) throws BussinessException {
        Preconditions.checkNotNull(
            opType == StudentFiannceOpType.SIGNUP_PAY.getCode() || opType == StudentFiannceOpType.PAY_CANCEL.getCode(),
            "orgId may not be null");
        OrgSignupInfo orgSignupInfo = orgSignupInfoDao.getByPurchaseId(orgId, signupPurchaseId);
        if (orgSignupInfo == null) {
            throw new BussinessException(SignupErrorCode.PURCHASEID_ERROR);
        }
        log.info("changeSignupStudentPrice=={},studentPayMoney={}", orgSignupInfo, studentPayMoney);
        if (opType == StudentFiannceOpType.SIGNUP_PAY.getCode() && (orgSignupInfo.getStudentPayPrice().intValue() > 0
            || orgSignupInfo.getTotalPrices().intValue() < studentPayMoney)) {
            throw new BussinessException(SignupErrorCode.STUDENT_PAY_ERROR);
        }
        if (opType == StudentFiannceOpType.PAY_CANCEL.getCode() && (orgSignupInfo.getStudentPayPrice().intValue() == 0
            || orgSignupInfo.getStudentPayPrice().longValue() != studentPayMoney.longValue())) {
            throw new BussinessException(SignupErrorCode.STUDENT_PAY_ERROR);
        }

        List<OrgSignupCourse> signupCourses = orgSignupCourseDao.loadByPurchaseId(signupPurchaseId);
        if (CollectionUtils.isEmpty(signupCourses)) {
            throw new BussinessException(SignupErrorCode.SIGNUP_HAS_NOT_COURSE_INFO);
        }
        if (opType == StudentFiannceOpType.SIGNUP_PAY.getCode()) {
            orgSignupInfo.setStudentPayPrice(studentPayMoney);
            orgSignupInfo.setTotalPrices(orgSignupInfo.getTotalPrices() - studentPayMoney);
            if (orgSignupInfo.getTotalPrices().doubleValue() == 0d) {
                orgSignupInfo.setPurchaseStatus(OrgSinupPurchaseStatus.DEAL_DONE.getCode());
                orgSignupInfo.setSplitResult(SplitCourseResult.SUCCESS.getCode());
                orgSignupInfo.setPayType(PayType.TX_STUDENT_PAY.getCode());
                orgSignupInfo.setPayTime(new Date());
            }
        } else if (opType == StudentFiannceOpType.PAY_CANCEL.getCode()) {
            orgSignupInfo.setStudentPayPrice(0l);
            orgSignupInfo.setTotalPrices(orgSignupInfo.getTotalPrices() + studentPayMoney);
        } else {
            throw new BussinessException(SignupErrorCode.STUDENT_PAY_ERROR);
        }

        if (orgSignupInfo.getTotalPrices().longValue() > 0) {
            Long newPurchaseId =
                RestUtils.getPurchaseId(orgId, orgSignupInfo.getTotalPrices().doubleValue() / 100, null);
            Long newTradeNo = Long.valueOf(
                RestUtils.getTradeNo(orgId, newPurchaseId, orgSignupInfo.getTotalPrices().doubleValue() / 100, null));
            orgSignupInfo.setPayPurchaseId(newPurchaseId);
            orgSignupInfo.setTradeNo(newTradeNo);
            String payUrlWinxin = RestUtils.getWeiXinPurchaseUrl(signupPurchaseId, orgSignupInfo.getOrgId(),
                orgSignupInfo.getTotalPrices().doubleValue() / 100, buildHeaders());
            orgSignupInfo.setPayUrlWinxin(payUrlWinxin);

        }

        orgSignupInfo.setUpdateTime(new Date());

        log.info("WSignup service changeSignupStudentPrice=signupinfo=={}", orgSignupInfo);
        orgSignupInfoDao.update(orgSignupInfo);// 更新报名信息

        Long surplusStudentMoney = studentPayMoney;
        List<OrgSignupCourse> signupCourseList = Lists.newArrayList();
        for (OrgSignupCourse orgSignupCourse : signupCourses) {
            if (surplusStudentMoney.longValue() > 0) {
                if (surplusStudentMoney - orgSignupCourse.getPayPrice() >= 0) {
                    surplusStudentMoney = surplusStudentMoney - orgSignupCourse.getPayPrice();
                    orgSignupCourse.setStudentPayPrice(orgSignupCourse.getPayPrice());
                    orgSignupCourse.setPayPrice(0l);
                } else {
                    orgSignupCourse.setStudentPayPrice(surplusStudentMoney);
                    orgSignupCourse.setPayPrice(orgSignupCourse.getPayPrice() - surplusStudentMoney);
                    surplusStudentMoney = 0l;
                }
            }

            log.info("WSignup service changeSignupStudentPrice=orgSignupCourse=={},{}", orgSignupCourse,
                surplusStudentMoney);
            orgSignupCourseDao.update(orgSignupCourse, "signupPurchaseId", "studentPayPrice", "payPrice", "updateTime");

            signupCourseList.add(orgSignupCourse);
        }

        /**
         * 更新缓存
         */
        orgSignupInfo.setOrgSignupCourses(signupCourseList);
        saveContent(RedisKeyEnums.CW.TIANXIAO_SIGNUP_REDIS_PRE.getRedisKey() + signupPurchaseId,
            SerializeUtil.serialize(orgSignupInfo));

        return orgSignupInfo;
    }

    @Override
    public void syncClassId(PageDto pageDto) {
        List<OrgSignupCourse> courseList = orgSignupCourseDao.getByPage(pageDto);
        for (OrgSignupCourse course : courseList) {
            course.getOrgCourseId();
        }
    }

    private static Collection<Header> buildHeaders() {
        List<Header> headers = Lists.newArrayList();
        Header header = new BasicHeader(HEADER_X_FORWARDED_FOR, "");
        headers.add(header);
        return headers;
    }

    private boolean saveContent(final String MKEY, final byte[] contents) {
        boolean result = redisTemplate.execute(new RedisCallback<Boolean>() {

            @Override
            public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                boolean result = connection.setNX(MKEY.getBytes(), contents);
                connection.expire(MKEY.getBytes(), 60 * 10);
                return result;
            }

        });
        return result;
    }

    private byte[] getContent(final String MKEY) {
        byte[] result = redisTemplate.execute(new RedisCallback<byte[]>() {

            @Override
            public byte[] doInRedis(RedisConnection connection) throws DataAccessException {
                return connection.get(MKEY.getBytes());
            }

        });
        return result;
    }

    private void delContent(final String MKEY) {
        redisTemplate.execute(new RedisCallback<Long>() {

            @Override
            public Long doInRedis(RedisConnection connection) throws DataAccessException {
                return connection.del(MKEY.getBytes());
            }

        });
    }
}
