/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.signup.dto;

import com.baijia.tianxiao.constant.StudentFiannceOpType;
import com.baijia.tianxiao.dal.finance.po.TxStudentFinanceRecord;
import com.baijia.tianxiao.excel.ExcelColumn;
import com.baijia.tianxiao.excel.ExcelExporterDto;
import com.baijia.tianxiao.excel.ExcelType;
import com.baijia.tianxiao.excel.InitAble;
import com.baijia.tianxiao.sal.signup.dto.SignupRefundStorageDto;
import com.baijia.tianxiao.util.GenericsUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;

@ExcelExporterDto
public class BalanceChangeRecord
implements InitAble {
    private Long recordId;
    @ExcelColumn(value="\u65e5\u671f", excelType=ExcelType.DATE, dataFormat="yyyy-MM-dd")
    private long opTime;
    @ExcelColumn(value="\u6458\u8981")
    private String abstractDesc;
    @ExcelColumn(value="\u7c7b\u578b")
    private String opTypeDesc;
    @ExcelColumn(value="\u91d1\u989d")
    private String opMoneyDesc;
    @ExcelColumn(value="\u4f59\u989d")
    private String banlanceDesc;
    @ExcelColumn(value="\u64cd\u4f5c\u5458")
    private String operator;
    @ExcelColumn(value="\u5907\u6ce8")
    private String comment;
    private int opTo;
    private double balance;
    private double opMoney;
    private Integer opType;
    private List<SignupRefundStorageDto> remarkImages;
    @JsonIgnore
    private Integer operatorId;
    private String opInfo;

    public static BalanceChangeRecord newInstance(TxStudentFinanceRecord record) {
        BalanceChangeRecord bcr = new BalanceChangeRecord();
        bcr.setAbstractDesc(record.getOpInfo());
        bcr.setBalance((double)record.getCurrBalance().longValue() / 100.0);
        bcr.setComment(GenericsUtils.isNullOrEmpty((Object)record.getRemark()) ? "" : record.getRemark());
        bcr.setOpMoney((double)record.getOpMoney().longValue() / 100.0);
        bcr.setOpTime(record.getUpdateTime().getTime());
        bcr.setOpType(record.getOpType());
        bcr.setRecordId(record.getId().longValue());
        bcr.setOperatorId(record.getCascadeId());
        bcr.setOpInfo(record.getOpInfo());
        bcr.setOpTo(record.getOpTo());
        return bcr;
    }

    public void initProperties() {
        this.opTypeDesc = StudentFiannceOpType.getByCode((Integer)this.opType).getName();
        String desc = String.valueOf(this.opMoney);
        this.opMoneyDesc = this.opTo == 1 ? "+ " + desc : "- " + desc;
        this.banlanceDesc = String.valueOf(this.balance);
    }

    public Long getRecordId() {
        return this.recordId;
    }

    public long getOpTime() {
        return this.opTime;
    }

    public String getAbstractDesc() {
        return this.abstractDesc;
    }

    public String getOpTypeDesc() {
        return this.opTypeDesc;
    }

    public String getOpMoneyDesc() {
        return this.opMoneyDesc;
    }

    public String getBanlanceDesc() {
        return this.banlanceDesc;
    }

    public String getOperator() {
        return this.operator;
    }

    public String getComment() {
        return this.comment;
    }

    public int getOpTo() {
        return this.opTo;
    }

    public double getBalance() {
        return this.balance;
    }

    public double getOpMoney() {
        return this.opMoney;
    }

    public Integer getOpType() {
        return this.opType;
    }

    public List<SignupRefundStorageDto> getRemarkImages() {
        return this.remarkImages;
    }

    public Integer getOperatorId() {
        return this.operatorId;
    }

    public String getOpInfo() {
        return this.opInfo;
    }

    public void setRecordId(Long recordId) {
        this.recordId = recordId;
    }

    public void setOpTime(long opTime) {
        this.opTime = opTime;
    }

    public void setAbstractDesc(String abstractDesc) {
        this.abstractDesc = abstractDesc;
    }

    public void setOpTypeDesc(String opTypeDesc) {
        this.opTypeDesc = opTypeDesc;
    }

    public void setOpMoneyDesc(String opMoneyDesc) {
        this.opMoneyDesc = opMoneyDesc;
    }

    public void setBanlanceDesc(String banlanceDesc) {
        this.banlanceDesc = banlanceDesc;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setOpTo(int opTo) {
        this.opTo = opTo;
    }

    public void setBalance(double balance) {
        this.balance = balance;
    }

    public void setOpMoney(double opMoney) {
        this.opMoney = opMoney;
    }

    public void setOpType(Integer opType) {
        this.opType = opType;
    }

    public void setRemarkImages(List<SignupRefundStorageDto> remarkImages) {
        this.remarkImages = remarkImages;
    }

    public void setOperatorId(Integer operatorId) {
        this.operatorId = operatorId;
    }

    public void setOpInfo(String opInfo) {
        this.opInfo = opInfo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BalanceChangeRecord)) {
            return false;
        }
        BalanceChangeRecord other = (BalanceChangeRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$recordId = this.getRecordId();
        Long other$recordId = other.getRecordId();
        if (this$recordId == null ? other$recordId != null : !((Object)this$recordId).equals(other$recordId)) {
            return false;
        }
        if (this.getOpTime() != other.getOpTime()) {
            return false;
        }
        String this$abstractDesc = this.getAbstractDesc();
        String other$abstractDesc = other.getAbstractDesc();
        if (this$abstractDesc == null ? other$abstractDesc != null : !this$abstractDesc.equals(other$abstractDesc)) {
            return false;
        }
        String this$opTypeDesc = this.getOpTypeDesc();
        String other$opTypeDesc = other.getOpTypeDesc();
        if (this$opTypeDesc == null ? other$opTypeDesc != null : !this$opTypeDesc.equals(other$opTypeDesc)) {
            return false;
        }
        String this$opMoneyDesc = this.getOpMoneyDesc();
        String other$opMoneyDesc = other.getOpMoneyDesc();
        if (this$opMoneyDesc == null ? other$opMoneyDesc != null : !this$opMoneyDesc.equals(other$opMoneyDesc)) {
            return false;
        }
        String this$banlanceDesc = this.getBanlanceDesc();
        String other$banlanceDesc = other.getBanlanceDesc();
        if (this$banlanceDesc == null ? other$banlanceDesc != null : !this$banlanceDesc.equals(other$banlanceDesc)) {
            return false;
        }
        String this$operator = this.getOperator();
        String other$operator = other.getOperator();
        if (this$operator == null ? other$operator != null : !this$operator.equals(other$operator)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        if (this.getOpTo() != other.getOpTo()) {
            return false;
        }
        if (Double.compare(this.getBalance(), other.getBalance()) != 0) {
            return false;
        }
        if (Double.compare(this.getOpMoney(), other.getOpMoney()) != 0) {
            return false;
        }
        Integer this$opType = this.getOpType();
        Integer other$opType = other.getOpType();
        if (this$opType == null ? other$opType != null : !((Object)this$opType).equals(other$opType)) {
            return false;
        }
        List<SignupRefundStorageDto> this$remarkImages = this.getRemarkImages();
        List<SignupRefundStorageDto> other$remarkImages = other.getRemarkImages();
        if (this$remarkImages == null ? other$remarkImages != null : !((Object)this$remarkImages).equals(other$remarkImages)) {
            return false;
        }
        Integer this$operatorId = this.getOperatorId();
        Integer other$operatorId = other.getOperatorId();
        if (this$operatorId == null ? other$operatorId != null : !((Object)this$operatorId).equals(other$operatorId)) {
            return false;
        }
        String this$opInfo = this.getOpInfo();
        String other$opInfo = other.getOpInfo();
        return !(this$opInfo == null ? other$opInfo != null : !this$opInfo.equals(other$opInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BalanceChangeRecord;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $recordId = this.getRecordId();
        result = result * 59 + ($recordId == null ? 43 : ((Object)$recordId).hashCode());
        long $opTime = this.getOpTime();
        result = result * 59 + (int)($opTime >>> 32 ^ $opTime);
        String $abstractDesc = this.getAbstractDesc();
        result = result * 59 + ($abstractDesc == null ? 43 : $abstractDesc.hashCode());
        String $opTypeDesc = this.getOpTypeDesc();
        result = result * 59 + ($opTypeDesc == null ? 43 : $opTypeDesc.hashCode());
        String $opMoneyDesc = this.getOpMoneyDesc();
        result = result * 59 + ($opMoneyDesc == null ? 43 : $opMoneyDesc.hashCode());
        String $banlanceDesc = this.getBanlanceDesc();
        result = result * 59 + ($banlanceDesc == null ? 43 : $banlanceDesc.hashCode());
        String $operator = this.getOperator();
        result = result * 59 + ($operator == null ? 43 : $operator.hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        result = result * 59 + this.getOpTo();
        long $balance = Double.doubleToLongBits(this.getBalance());
        result = result * 59 + (int)($balance >>> 32 ^ $balance);
        long $opMoney = Double.doubleToLongBits(this.getOpMoney());
        result = result * 59 + (int)($opMoney >>> 32 ^ $opMoney);
        Integer $opType = this.getOpType();
        result = result * 59 + ($opType == null ? 43 : ((Object)$opType).hashCode());
        List<SignupRefundStorageDto> $remarkImages = this.getRemarkImages();
        result = result * 59 + ($remarkImages == null ? 43 : ((Object)$remarkImages).hashCode());
        Integer $operatorId = this.getOperatorId();
        result = result * 59 + ($operatorId == null ? 43 : ((Object)$operatorId).hashCode());
        String $opInfo = this.getOpInfo();
        result = result * 59 + ($opInfo == null ? 43 : $opInfo.hashCode());
        return result;
    }

    public String toString() {
        return "BalanceChangeRecord(recordId=" + this.getRecordId() + ", opTime=" + this.getOpTime() + ", abstractDesc=" + this.getAbstractDesc() + ", opTypeDesc=" + this.getOpTypeDesc() + ", opMoneyDesc=" + this.getOpMoneyDesc() + ", banlanceDesc=" + this.getBanlanceDesc() + ", operator=" + this.getOperator() + ", comment=" + this.getComment() + ", opTo=" + this.getOpTo() + ", balance=" + this.getBalance() + ", opMoney=" + this.getOpMoney() + ", opType=" + this.getOpType() + ", remarkImages=" + this.getRemarkImages() + ", operatorId=" + this.getOperatorId() + ", opInfo=" + this.getOpInfo() + ")";
    }
}

