/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.signup.service.Impl;

import com.baijia.tianxiao.constant.StudentFiannceOpType;
import com.baijia.tianxiao.dal.finance.dao.TxStudentFinanceAccountDao;
import com.baijia.tianxiao.dal.finance.dao.TxStudentFinanceRecordDao;
import com.baijia.tianxiao.dal.finance.po.TxStudentFinanceAccount;
import com.baijia.tianxiao.dal.finance.po.TxStudentFinanceAccountDto;
import com.baijia.tianxiao.dal.finance.po.TxStudentFinanceRecord;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.organization.finance.constant.FinanceOpTo;
import com.baijia.tianxiao.sal.organization.org.service.TxCascadeCredentialService;
import com.baijia.tianxiao.sal.signup.dto.BalanceChangeRecord;
import com.baijia.tianxiao.sal.signup.dto.SignupRefundStorageDto;
import com.baijia.tianxiao.sal.signup.dto.request.StudentBalanceRequestDto;
import com.baijia.tianxiao.sal.signup.dto.response.StudentBalanceResponseDto;
import com.baijia.tianxiao.sal.signup.service.SignupRefundStorageService;
import com.baijia.tianxiao.sal.signup.service.TxStudentFinanceAccountService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.StringUtils;
import com.baijia.tianxiao.util.mobile.MaskUtil;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TxStudentFinanceAccountServiceImpl
implements TxStudentFinanceAccountService {
    private static final Logger log = LoggerFactory.getLogger(TxStudentFinanceAccountServiceImpl.class);
    @Resource
    private TxStudentFinanceAccountDao txStudentFinanceAccountDao;
    @Resource
    private TxStudentFinanceRecordDao txStudentFinanceRecordDao;
    @Autowired
    private TXCascadeCredentialDao txCascadeCredentialDao;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private TxCascadeCredentialService txCascadeCredentialService;
    @Resource
    private SignupRefundStorageService signupRefundStorageService;

    @Override
    public void changeStudentFiannceAccount(Long orgId, Integer cascadeId, Long studentId, StudentFiannceOpType opType, Long money, String opInfo, String remark) {
        log.info("ChangeStudentFiannceAccount params={},{},{} {},{},{}", new Object[]{orgId, cascadeId, studentId, opType, money, opInfo});
        OrgStudent orgStudent = (OrgStudent)this.orgStudentDao.getById((Serializable)studentId, new String[0]);
        if (orgStudent == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b66\u5458\u4e0d\u5b58\u5728");
        }
        TxStudentFinanceAccount txStudentFinanceAccount = this.txStudentFinanceAccountDao.getFinanceAccount(orgId, studentId);
        if (txStudentFinanceAccount == null) {
            txStudentFinanceAccount = new TxStudentFinanceAccount();
            txStudentFinanceAccount.setOrgId(orgId);
            txStudentFinanceAccount.setStudentId(studentId);
            txStudentFinanceAccount.setCreateTime(new Date());
        }
        TxStudentFinanceRecord txStudentFinanceRecord = new TxStudentFinanceRecord();
        txStudentFinanceRecord.setOrgId(orgId);
        txStudentFinanceRecord.setStudentId(studentId);
        txStudentFinanceRecord.setCreateTime(new Date());
        txStudentFinanceRecord.setUpdateTime(new Date());
        txStudentFinanceRecord.setOpMoney(money);
        txStudentFinanceRecord.setOpType(opType.getCode());
        txStudentFinanceRecord.setCascadeId(cascadeId);
        txStudentFinanceRecord.setRemark(remark);
        if (opType == StudentFiannceOpType.QUIT_CLASS) {
            txStudentFinanceRecord.setPreBalance(txStudentFinanceAccount.getBalance());
            txStudentFinanceAccount.setBalance(Long.valueOf(txStudentFinanceAccount.getBalance() + money));
            txStudentFinanceRecord.setCurrBalance(txStudentFinanceAccount.getBalance());
            txStudentFinanceRecord.setPreFreezeMoney(txStudentFinanceAccount.getFreezeMoney());
            txStudentFinanceAccount.setFreezeMoney(txStudentFinanceAccount.getFreezeMoney());
            txStudentFinanceRecord.setCurrfreezeMoney(txStudentFinanceAccount.getFreezeMoney());
            txStudentFinanceRecord.setOpTo(FinanceOpTo.INCOME.getCode());
            txStudentFinanceRecord.setOpInfo(opInfo);
        } else if (opType == StudentFiannceOpType.RECHARGE) {
            txStudentFinanceRecord.setPreBalance(txStudentFinanceAccount.getBalance());
            txStudentFinanceAccount.setBalance(Long.valueOf(txStudentFinanceAccount.getBalance() + money));
            txStudentFinanceRecord.setCurrBalance(txStudentFinanceAccount.getBalance());
            txStudentFinanceRecord.setPreFreezeMoney(txStudentFinanceAccount.getFreezeMoney());
            txStudentFinanceAccount.setFreezeMoney(txStudentFinanceAccount.getFreezeMoney());
            txStudentFinanceRecord.setCurrfreezeMoney(txStudentFinanceAccount.getFreezeMoney());
            txStudentFinanceRecord.setOpTo(FinanceOpTo.INCOME.getCode());
            txStudentFinanceRecord.setOpInfo("\u5b66\u5458" + orgStudent.getName() + "\u5145\u503c");
        } else if (opType == StudentFiannceOpType.REFUND_CASH) {
            if (txStudentFinanceAccount.getId() == null || txStudentFinanceAccount.getBalance() < money) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.SIGN_INVALIDATE, "\u5b66\u751f\u8d26\u53f7\u53d8\u52a8\u91d1\u989d\u5f02\u5e38\u6216\u6709\u51bb\u7ed3\u91d1\u989d");
            }
            txStudentFinanceRecord.setPreBalance(txStudentFinanceAccount.getBalance());
            txStudentFinanceAccount.setBalance(Long.valueOf(txStudentFinanceAccount.getBalance() - money));
            txStudentFinanceRecord.setCurrBalance(txStudentFinanceAccount.getBalance());
            txStudentFinanceRecord.setPreFreezeMoney(txStudentFinanceAccount.getFreezeMoney());
            txStudentFinanceAccount.setFreezeMoney(txStudentFinanceAccount.getFreezeMoney());
            txStudentFinanceRecord.setCurrfreezeMoney(txStudentFinanceAccount.getFreezeMoney());
            txStudentFinanceRecord.setOpTo(FinanceOpTo.EXPEND.getCode());
            txStudentFinanceRecord.setOpInfo("\u5b66\u5458" + orgStudent.getName() + "\u4ece\u8d26\u6237\u9000\u6b3e");
        } else if (opType == StudentFiannceOpType.PAY_SUCCESS) {
            if (txStudentFinanceAccount.getId() == null || txStudentFinanceAccount.getFreezeMoney() < money) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.SIGN_INVALIDATE, "\u5b66\u751f\u8d26\u53f7\u53d8\u52a8\u91d1\u989d\u5f02\u5e38");
            }
            txStudentFinanceRecord.setPreBalance(txStudentFinanceAccount.getBalance());
            txStudentFinanceAccount.setBalance(txStudentFinanceAccount.getBalance());
            txStudentFinanceRecord.setCurrBalance(txStudentFinanceAccount.getBalance());
            txStudentFinanceRecord.setPreFreezeMoney(txStudentFinanceAccount.getFreezeMoney());
            txStudentFinanceAccount.setFreezeMoney(Long.valueOf(txStudentFinanceAccount.getFreezeMoney() - money));
            txStudentFinanceRecord.setCurrfreezeMoney(txStudentFinanceAccount.getFreezeMoney());
            txStudentFinanceRecord.setOpTo(FinanceOpTo.EXPEND.getCode());
            txStudentFinanceRecord.setIsShow(Integer.valueOf(1));
            txStudentFinanceRecord.setOpInfo("\u7cfb\u7edf\u652f\u4ed8\u6210\u529f");
        } else if (opType == StudentFiannceOpType.PAY_CANCEL) {
            if (txStudentFinanceAccount.getId() == null || txStudentFinanceAccount.getFreezeMoney() < money) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.SIGN_INVALIDATE, "\u5b66\u751f\u8d26\u53f7\u53d8\u52a8\u91d1\u989d\u5f02\u5e38");
            }
            txStudentFinanceRecord.setPreBalance(txStudentFinanceAccount.getBalance());
            txStudentFinanceAccount.setBalance(Long.valueOf(txStudentFinanceAccount.getBalance() + money));
            txStudentFinanceRecord.setCurrBalance(txStudentFinanceAccount.getBalance());
            txStudentFinanceRecord.setPreFreezeMoney(txStudentFinanceAccount.getFreezeMoney());
            txStudentFinanceAccount.setFreezeMoney(Long.valueOf(txStudentFinanceAccount.getFreezeMoney() - money));
            txStudentFinanceRecord.setCurrfreezeMoney(txStudentFinanceAccount.getFreezeMoney());
            txStudentFinanceRecord.setOpTo(FinanceOpTo.INCOME.getCode());
            txStudentFinanceRecord.setOpInfo(opInfo);
        } else if (opType == StudentFiannceOpType.SIGNUP_PAY) {
            if (txStudentFinanceAccount.getId() == null || txStudentFinanceAccount.getBalance() < money) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.SIGN_INVALIDATE, "\u5b66\u751f\u8d26\u53f7\u53d8\u52a8\u91d1\u989d\u5f02\u5e38");
            }
            txStudentFinanceRecord.setPreBalance(txStudentFinanceAccount.getBalance());
            txStudentFinanceAccount.setBalance(Long.valueOf(txStudentFinanceAccount.getBalance() - money));
            txStudentFinanceRecord.setCurrBalance(txStudentFinanceAccount.getBalance());
            txStudentFinanceRecord.setPreFreezeMoney(txStudentFinanceAccount.getFreezeMoney());
            txStudentFinanceAccount.setFreezeMoney(Long.valueOf(txStudentFinanceAccount.getFreezeMoney() + money));
            txStudentFinanceRecord.setCurrfreezeMoney(txStudentFinanceAccount.getFreezeMoney());
            txStudentFinanceRecord.setOpTo(FinanceOpTo.EXPEND.getCode());
            txStudentFinanceRecord.setOpInfo(opInfo);
        }
        txStudentFinanceAccount.setUpdateTime(new Date());
        log.info("ChangeStudentFiannceAccount result1={}", (Object)txStudentFinanceAccount);
        this.txStudentFinanceAccountDao.saveOrUpdate((Object)txStudentFinanceAccount, new String[0]);
        log.info("ChangeStudentFiannceAccount result2={}", (Object)txStudentFinanceRecord);
        this.txStudentFinanceRecordDao.save((Object)txStudentFinanceRecord, new String[0]);
    }

    @Override
    public List<TxStudentFinanceRecord> findStudentFiannceAccountRecord(Long orgId, Long studentId, PageDto pageDto) {
        return this.txStudentFinanceRecordDao.findTxStudentFinanceRecords(orgId, studentId, pageDto);
    }

    @Override
    public List<TxStudentFinanceAccountDto> findStudentFiannceAccount(Long orgId, Integer cascadeId, String key, PageDto pageDto) {
        pageDto.setCount(this.txStudentFinanceAccountDao.countByStudentAccount(orgId, key));
        List list = this.txStudentFinanceAccountDao.searchByStudentAccount(orgId, key, pageDto);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.EMPTY_LIST;
        }
        boolean isShowMobile = this.txCascadeCredentialService.isShowMobile(orgId, cascadeId);
        for (TxStudentFinanceAccountDto dto : list) {
            if (!isShowMobile) {
                dto.setStudentMobile(MaskUtil.maskMobile((String)dto.getStudentMobile()));
                continue;
            }
            dto.setStudentMobile(dto.getStudentMobile());
        }
        return list;
    }

    @Override
    public StudentBalanceResponseDto findStudentBalanceResponseDto(StudentBalanceRequestDto request) {
        Long orgId = request.getOrgId();
        Long studentId = request.getStudentId();
        TxStudentFinanceAccount financeAccount = this.txStudentFinanceAccountDao.getFinanceAccount(orgId, studentId);
        log.info("financeAccount is :{} ", (Object)financeAccount);
        ArrayList records = Lists.newArrayList();
        StudentBalanceResponseDto studentBalanceResponseDto = StudentBalanceResponseDto.newInstance(financeAccount, records);
        if (request.isNeedBanlacneChangeRecords()) {
            List<TxStudentFinanceRecord> findStudentFiannceAccountRecord = this.findStudentFiannceAccountRecord(orgId, studentId, request.getPageDto());
            log.info("findStudentFiannceAccountRecord are :{} ", findStudentFiannceAccountRecord);
            records.addAll(this.createBalanceChangeRecords(findStudentFiannceAccountRecord));
            List cascadeIds = GenericsUtils.toFieldList((Collection)records, (String)"operatorId");
            Map txCascadCredentialListByCascdeIds = this.txCascadeCredentialDao.getTxCascadCredentialListByCascdeIds((Collection)cascadeIds);
            if (cascadeIds.contains(0)) {
                OrgInfo orginfo = this.orgInfoDao.getOrgInfo(Integer.valueOf(orgId.intValue()), new String[0]);
                txCascadCredentialListByCascdeIds.put(0L, orginfo.getContacts());
            }
            for (BalanceChangeRecord bcr : records) {
                Long operatorId = bcr.getOperatorId().longValue();
                String operator = (String)txCascadCredentialListByCascdeIds.get(operatorId);
                if (GenericsUtils.isNullOrEmpty((Object)operator)) {
                    operator = "[\u7cfb\u7edf]";
                }
                bcr.setOperator(operator);
                if (bcr.getOpType().intValue() != StudentFiannceOpType.QUIT_CLASS.getCode().intValue() || StringUtils.isEmpty((String)bcr.getComment())) continue;
                this.changeQuitClassRemark(bcr, orgId);
            }
            log.info("records are :{} ", (Object)records);
        }
        return studentBalanceResponseDto;
    }

    private void changeQuitClassRemark(BalanceChangeRecord recordDto, Long orgId) {
        try {
            String[] params = recordDto.getComment().split("_");
            List<SignupRefundStorageDto> result = this.signupRefundStorageService.getSignupRefundStorages(orgId, Long.parseLong(params[0]), Long.parseLong(params[2]), Long.parseLong(params[1]));
            recordDto.setRemarkImages(result);
            if (!result.isEmpty()) {
                recordDto.setComment(result.get(0).getRemark());
                if (result.get(0).getStorageId() == 0L) {
                    recordDto.setRemarkImages(Lists.newArrayList());
                }
            } else {
                recordDto.setComment("");
            }
        }
        catch (Exception e) {
            recordDto.setComment("");
        }
    }

    private List<BalanceChangeRecord> createBalanceChangeRecords(List<TxStudentFinanceRecord> findStudentFiannceAccountRecord) {
        if (GenericsUtils.isNullOrEmpty(findStudentFiannceAccountRecord)) {
            return GenericsUtils.emptyList();
        }
        ArrayList retRecords = Lists.newArrayList();
        for (TxStudentFinanceRecord record : findStudentFiannceAccountRecord) {
            BalanceChangeRecord bcr = BalanceChangeRecord.newInstance(record);
            retRecords.add(bcr);
        }
        return retRecords;
    }
}

