/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.signup.service.Impl;

import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.SignupRefundStorageDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.TxSignupRefundStorage;
import com.baijia.tianxiao.sal.organization.finance.dto.SignupRefundRequest;
import com.baijia.tianxiao.sal.signup.dto.SignupRefundStorageDto;
import com.baijia.tianxiao.sal.signup.service.SignupRefundStorageService;
import com.baijia.tianxiao.util.BaseUtils;
import com.baijia.tianxiao.util.mobile.EmojiUtils;
import com.baijia.tianxiao.util.storage.StorageUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SignupRefundStorageServiceImpl
implements SignupRefundStorageService {
    private static final Logger log = LoggerFactory.getLogger(SignupRefundStorageServiceImpl.class);
    @Autowired
    private OrgStorageDao storageDao;
    @Autowired
    private SignupRefundStorageDao signupRefundStorageDao;
    @Autowired
    private OrgSignupCourseDao orgSignupCourseDao;
    @Autowired
    private OrgCourseDao orgCourseDao;

    @Override
    public void addOrEditOrgSignupStorage(Long orgId, Collection<TxSignupRefundStorage> dtos) {
        log.info("signup refund remark params=={},{}", (Object)orgId, dtos);
        if (CollectionUtils.isEmpty(dtos)) {
            return;
        }
        for (TxSignupRefundStorage signup : dtos) {
            List temp = this.signupRefundStorageDao.getTxSignupRefundStorage(orgId, signup.getSignupPurchaseId(), signup.getCourseId(), signup.getUserId(), signup.getStorageId());
            if (CollectionUtils.isEmpty((Collection)temp)) {
                this.signupRefundStorageDao.save((Object)signup, new String[0]);
                continue;
            }
            TxSignupRefundStorage old = (TxSignupRefundStorage)temp.get(0);
            old.setRemark(signup.getRemark());
            old.setStorageId(signup.getStorageId());
            this.signupRefundStorageDao.update((Object)old, new String[0]);
        }
    }

    @Override
    public List<SignupRefundStorageDto> getSignupRefundStorages(Long orgId, Long signupPurchaseId, Long courseId, Long userId) {
        log.info("SignupRefundStorageServiceImpl->getSignupRefundStorages->params={},{},{},{}", new Object[]{orgId, signupPurchaseId, courseId, userId});
        OrgCourse orgCourse = this.orgCourseDao.getByCourseId(courseId, new String[0]);
        if (orgCourse != null && orgCourse.getParentId().intValue() > 0) {
            courseId = orgCourse.getParentId();
        }
        List list = this.signupRefundStorageDao.getTxSignupRefundStorage(orgId, signupPurchaseId, courseId, userId, null);
        ArrayList storageIds = Lists.newArrayList();
        for (TxSignupRefundStorage storage : list) {
            if (storage.getStorageId() == null || storage.getStorageId().intValue() == 0) continue;
            storageIds.add(storage.getStorageId());
        }
        Map<Long, String> urlMap = this.getStorageUrlMap(storageIds);
        ArrayList result = Lists.newArrayList();
        log.debug("SignupRefundStorageServiceImpl->getSignupRefundStorages->result={},{}", urlMap, (Object)list);
        for (TxSignupRefundStorage s : list) {
            SignupRefundStorageDto dto = new SignupRefundStorageDto();
            dto.setStorageId(s.getStorageId());
            dto.setCourseId(s.getCourseId());
            dto.setId(s.getId());
            dto.setUserId(s.getUserId() != null ? s.getUserId() : 0L);
            dto.setSignupPurchaseId(s.getSignupPurchaseId() != null ? s.getSignupPurchaseId() : 0L);
            dto.setOrgId(s.getOrgId());
            dto.setUrl(urlMap.get((long)s.getStorageId()));
            dto.setRemark(s.getRemark());
            result.add(dto);
        }
        log.debug("SignupRefundStorageServiceImpl->getSignupRefundStorages->result={},{}", (Object)result);
        return result;
    }

    @Override
    public void deleteById(long id) {
        this.signupRefundStorageDao.delById((Serializable)Long.valueOf(id));
    }

    @Override
    public void deleteByIds(List<String> ids) {
        ArrayList longids = Lists.newArrayList();
        for (String id : ids) {
            longids.add(Long.valueOf(id));
        }
        this.signupRefundStorageDao.delByIds((Collection)longids);
    }

    @Override
    public void saveOrUpdateRemark(Long orgId, SignupRefundRequest refundRequest) {
        OrgCourse orgCourse;
        log.info("signup refund remark params=={}", (Object)refundRequest);
        if (StringUtils.isNotEmpty((CharSequence)refundRequest.getDelIds())) {
            List ids = BaseUtils.strToList((String)refundRequest.getDelIds(), (String)",");
            this.deleteByIds(ids);
        }
        if ((orgCourse = this.orgCourseDao.getByCourseId(refundRequest.getCourseId(), new String[0])) != null && orgCourse.getParentId().intValue() > 0) {
            refundRequest.setCourseId(orgCourse.getParentId());
        }
        ArrayList params = Lists.newArrayList();
        List<Long> signupPurchaseIdList = this.buildSignupPurchaseId(orgId, refundRequest);
        if (CollectionUtils.isEmpty(signupPurchaseIdList)) {
            signupPurchaseIdList.add(0L);
        }
        log.info("signup refund remark params=={}", signupPurchaseIdList);
        for (Long purchaseId : signupPurchaseIdList) {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{refundRequest.getStorageIds()})) {
                String[] arr = refundRequest.getStorageIds().split(",");
                for (int i = 0; i < arr.length; ++i) {
                    TxSignupRefundStorage s = new TxSignupRefundStorage();
                    s.setSignupPurchaseId(purchaseId);
                    s.setStorageId(Long.valueOf(arr[i]));
                    s.setOrgId(Long.valueOf(orgId));
                    s.setUserId(refundRequest.getUserId());
                    s.setRemark(refundRequest.getRemark() == null ? "" : EmojiUtils.filterEmoji((String)refundRequest.getRemark()));
                    s.setCourseId(refundRequest.getCourseId());
                    params.add(s);
                }
                continue;
            }
            TxSignupRefundStorage s = new TxSignupRefundStorage();
            s.setSignupPurchaseId(purchaseId);
            s.setStorageId(Long.valueOf(0L));
            s.setOrgId(Long.valueOf(orgId));
            s.setUserId(refundRequest.getUserId());
            s.setRemark(refundRequest.getRemark() == null ? "" : EmojiUtils.filterEmoji((String)refundRequest.getRemark()));
            s.setCourseId(refundRequest.getCourseId());
            params.add(s);
        }
        this.addOrEditOrgSignupStorage((long)orgId, params);
    }

    private Map<Long, String> getStorageUrlMap(Collection<Long> storageIds) {
        List storages = this.storageDao.getByIds(storageIds, new String[0]);
        HashMap urlMap = Maps.newHashMap();
        for (OrgStorage storage : storages) {
            urlMap.put(storage.getId().longValue(), StorageUtil.constructUrl((String)storage.getFid(), (String)storage.getSn(), (Integer)storage.getMimeType()));
        }
        return urlMap;
    }

    private List<Long> buildSignupPurchaseId(Long orgId, SignupRefundRequest refundRequest) {
        ArrayList purchaseIds = Lists.newArrayList();
        if (refundRequest.getSignupPurchaseId() != null && refundRequest.getSignupPurchaseId().intValue() > 0) {
            purchaseIds.add(refundRequest.getSignupPurchaseId());
        } else {
            List signupCourseList = this.orgSignupCourseDao.listSignupCourseByCourse(orgId, null, refundRequest.getCourseId(), refundRequest.getUserId(), new String[0]);
            for (OrgSignupCourse orgSignupCourse : signupCourseList) {
                purchaseIds.add(orgSignupCourse.getSignupPurchaseId());
            }
        }
        return purchaseIds;
    }
}

