package com.baijia.tianxiao.sal.signup.service.Impl;

import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupStorageDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.dal.signup.po.OrgSignupStorage;
import com.baijia.tianxiao.sal.signup.dto.OrgSignupStorageDto;
import com.baijia.tianxiao.sal.signup.dto.response.OrgSignupStorageResponseDto;
import com.baijia.tianxiao.sal.signup.service.OrgSignupStorageService;
import com.baijia.tianxiao.util.storage.StorageUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.NonNull;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.Collection;
import java.util.List;
import java.util.Map;

@Slf4j
@Service
public class OrgSignupStorageServiceImpl implements OrgSignupStorageService {

    @Autowired
    private OrgSignupStorageDao orgSignupStorageDao;
    @Autowired
    private OrgStorageDao storageDao;
    @Autowired
    private OrgSignupInfoDao orgSignupInfoDao;


    @Override
    public void addOrEditOrgSignupStorage(@NonNull Long orgId, @NonNull Collection<OrgSignupStorageDto> dtos) {

        if (CollectionUtils.isEmpty(dtos)) {
            log.warn("dtos = {}", dtos);
            return;
        }
        List<OrgSignupStorage> orgSignupStorages = Lists.newArrayList();
        for (OrgSignupStorageDto dto : dtos) {
            if (dto.getSignupPurchaseId() != null && dto.getStorageId() != null) {
                OrgSignupStorage orgSignupStorage = new OrgSignupStorage();
                orgSignupStorage.setSignupPurchaseId(dto.getSignupPurchaseId());
                orgSignupStorage.setStorageId(dto.getStorageId());
                orgSignupStorage.setRemark(dto.getRemark() == null ? "" : dto.getRemark());
                orgSignupStorages.add(orgSignupStorage);
            } else {
                log.warn("param error:sigupid={},storageid={}", dto.getSignupPurchaseId(), dto.getStorageId());
            }
        }
        this.orgSignupStorageDao.addOrEditOrgSignupStorage(orgId, orgSignupStorages);
    }

    @Override
    public void delOrgSignupStorage(@NonNull Long orgId, @NonNull Collection<OrgSignupStorageDto> dtos)
        throws Exception {

        if (CollectionUtils.isEmpty(dtos)) {
            log.warn("dtos = {}", dtos);
            return;
        }
        List<OrgSignupStorage> orgSignupStorages = Lists.newArrayList();
        for (OrgSignupStorageDto dto : dtos) {
            if (dto.getSignupPurchaseId() != null && dto.getStorageId() != null) {
                OrgSignupStorage orgSignupStorage = new OrgSignupStorage();
                orgSignupStorage.setOrgId(orgId);
                orgSignupStorage.setSignupPurchaseId(dto.getSignupPurchaseId());
                orgSignupStorage.setStorageId(dto.getStorageId());
                orgSignupStorage.setRemark(dto.getRemark() == null ? "" : dto.getRemark());
                orgSignupStorages.add(orgSignupStorage);
            } else {
                log.warn("param error:sigupid={},storageid={}", dto.getSignupPurchaseId(), dto.getStorageId());
            }
        }
        this.orgSignupStorageDao.delOrgSignupStorage(orgSignupStorages);
    }

    @Override
    public OrgSignupStorageResponseDto getOrgSignupStorageBySignupPurchaseId(@NonNull Long orgId,
        @NonNull Long signupPurchaseId) {
        List<OrgSignupStorage> orgSignupStorages =
            this.orgSignupStorageDao.getOrgSignupStorageBySignupPurchaseId(orgId, signupPurchaseId);
        List<Long> storageIds = Lists.newArrayList();
        for (OrgSignupStorage signupStorage : orgSignupStorages) {
            storageIds.add(signupStorage.getStorageId());
        }
        log.debug("all storage ids:{}", storageIds);
        Map<Long, String> urlMap = getStorageUrlMap(storageIds);
        List<OrgSignupStorageDto> orgSignupStorageDtos = Lists.newArrayList();
        for (OrgSignupStorage signupStorage : orgSignupStorages) {
            OrgSignupStorageDto dto = new OrgSignupStorageDto();
            if (signupStorage.getStorageId() != null && signupStorage.getStorageId() != 0) {
                dto.setId(signupStorage.getId());
                dto.setOrgId(signupStorage.getOrgId());
                dto.setRemark(signupStorage.getRemark());
                dto.setSignupPurchaseId(signupStorage.getSignupPurchaseId());
                dto.setUrl(urlMap.get(signupStorage.getStorageId()));
                dto.setStorageId(signupStorage.getStorageId());
                orgSignupStorageDtos.add(dto);
            }
        }

        OrgSignupStorageResponseDto orgSignupStorageResponseDto = new OrgSignupStorageResponseDto();

        OrgSignupInfo orgSignupInfo = orgSignupInfoDao.getByPurchaseId(orgId,signupPurchaseId);
        if (orgSignupInfo!=null){
            orgSignupStorageResponseDto.setRemark(orgSignupInfo.getRemark());
        }

        orgSignupStorageResponseDto.setList(orgSignupStorageDtos);
        return orgSignupStorageResponseDto;
    }

    private Map<Long, String> getStorageUrlMap(Collection<Long> storageIds) {

        List<OrgStorage> storages = storageDao.getByIds(storageIds);
        Map<Long, String> urlMap = Maps.newHashMap();
        for (OrgStorage storage : storages) {
            urlMap.put(storage.getId().longValue(),
                StorageUtil.constructUrl(storage.getFid(), storage.getSn(), storage.getMimeType()));
        }
        return urlMap;
    }

    @Override
    public void deleteById(long id) {
        orgSignupStorageDao.delById(id);
    }

    @Override
    public void deleteByIds(List<String> ids) {
        List<Long> longids = Lists.newArrayList();
        for (String id : ids) {
            longids.add(Long.valueOf(id));
        }
        orgSignupStorageDao.delByIds(longids);
    }
}
