/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.signup.service.Impl;

import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentKexiaoRecordDao;
import com.baijia.tianxiao.dal.org.dto.StudentCourseKexiaoDocument;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.signup.constant.SignupCourseStatus;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupRefundDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupRefund;
import com.baijia.tianxiao.sal.signup.service.OrgSignupRefundService;
import com.baijia.tianxiao.util.NumberUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OrgSignupRefundServiceImpl
implements OrgSignupRefundService {
    private static final Logger log = LoggerFactory.getLogger(OrgSignupRefundServiceImpl.class);
    @Resource
    private OrgSignupRefundDao orgSignupRefundDao;
    @Resource
    private OrgSignupCourseDao orgSignupCourseDao;
    @Resource
    private OrgStudentCourseDao studentCourseDao;
    @Resource
    private OrgStudentKexiaoRecordDao orgStudentKexiaoRecordDao;

    @Override
    public List<OrgSignupRefund> saveRefund(List<OrgSignupCourse> signupCourses, Long orgId, Long signupPurchaseId, Long courseId, Long userId, Long refundPrice, Integer refundType, Integer cascadeId) {
        log.debug("OrgSignupRefundServiceImpl params={},{},{},{},{},{},{},{}", new Object[]{signupCourses, orgId, signupPurchaseId, courseId, userId, refundPrice, refundType, cascadeId});
        List<Object> signupCourseList = Lists.newArrayList();
        if (signupPurchaseId != null && signupPurchaseId > 0L) {
            OrgSignupCourse orgSignupCourse = this.orgSignupCourseDao.getByCourseId(orgId, signupPurchaseId, courseId);
            signupCourseList.add(orgSignupCourse);
        } else {
            signupCourseList = signupCourses;
        }
        OrgStudentCourse studentCourse = this.studentCourseDao.getStudentCourseByRealCourseId(orgId, courseId, userId);
        if (studentCourse == null) {
            return Collections.EMPTY_LIST;
        }
        return this.saveAll(signupCourseList, studentCourse, courseId, refundPrice, refundType, cascadeId);
    }

    @Override
    public List<OrgSignupRefund> listSignupRefund(Long orgId, Long signupPurchaseId, Long userId, Long courseId) {
        return this.orgSignupRefundDao.getOrgSignupRefundByStudent(orgId, signupPurchaseId, userId, courseId);
    }

    private List<OrgSignupRefund> saveAll(List<OrgSignupCourse> signupCourseList, OrgStudentCourse studentCourse, Long courseId, Long refundPrice, Integer refundType, Integer cascadeId) {
        log.debug("OrgSignupRefundServiceImpl params={},{},{},{},{}", new Object[]{signupCourseList, studentCourse, refundPrice, refundType, cascadeId});
        ArrayList saveAll = Lists.newArrayList();
        Long allRemainMoney = refundPrice;
        if (CollectionUtils.isEmpty(signupCourseList)) {
            OrgSignupRefund savePo = new OrgSignupRefund();
            if (studentCourse != null) {
                savePo.setClassId(studentCourse.getCourseId());
            }
            savePo.setOrgId(studentCourse.getOrgId());
            savePo.setSignupPurchaseId(NumberUtil.randomSignupPurchaseId4Excel((Date)new Date()));
            savePo.setCourseId(courseId);
            savePo.setUserId(studentCourse.getUserId());
            savePo.setRefundPrice(refundPrice);
            savePo.setRefundFee(Long.valueOf(0L));
            savePo.setRefundType(refundType);
            savePo.setCascadeId(cascadeId);
            savePo.setRemark("");
            savePo.setCreateTime(new Date());
            savePo.setKexiaoCount(Long.valueOf(0L));
            savePo.setKexiaoMoney(Long.valueOf(0L));
            saveAll.add(savePo);
        } else {
            for (OrgSignupCourse signupCourse : signupCourseList) {
                StudentCourseKexiaoDocument financed = this.orgStudentKexiaoRecordDao.finishCountMoney(signupCourse.getOrgId(), signupCourse.getOrgCourseId(), signupCourse.getUserId(), signupCourse.getId(), SignupCourseStatus.inStudentCourseStatus);
                Long canRefundPrice = signupCourse.getPayPrice() + signupCourse.getStudentPayPrice() - financed.getFinishMoney();
                Long realRefundPrice = allRemainMoney - canRefundPrice <= 0L ? allRemainMoney : canRefundPrice;
                realRefundPrice = realRefundPrice < 0L ? 0L : realRefundPrice;
                Long canRefundFee = canRefundPrice - realRefundPrice;
                Long realRefundFee = canRefundFee <= 0L ? 0L : canRefundFee;
                allRemainMoney = allRemainMoney - realRefundPrice < 0L ? 0L : allRemainMoney - realRefundPrice;
                OrgSignupRefund savePo = new OrgSignupRefund();
                log.info("[Refund] studentCourse={},courseId={},userId={}", new Object[]{studentCourse, signupCourse.getOrgCourseId(), signupCourse.getUserId()});
                if (studentCourse != null) {
                    savePo.setClassId(studentCourse.getCourseId());
                }
                savePo.setOrgId(signupCourse.getOrgId());
                savePo.setSignupPurchaseId(signupCourse.getSignupPurchaseId());
                savePo.setCourseId(signupCourse.getOrgCourseId());
                savePo.setUserId(signupCourse.getUserId());
                savePo.setRefundPrice(realRefundPrice);
                savePo.setRefundFee(realRefundFee);
                savePo.setRefundType(refundType);
                savePo.setCascadeId(cascadeId);
                savePo.setRemark("");
                savePo.setCreateTime(new Date());
                if (financed != null) {
                    if (studentCourse != null && (studentCourse.getChargeUnit().intValue() == ChargeUnit.BY_HOUR.getCode() || studentCourse.getChargeUnit().intValue() == ChargeUnit.BY_HALF_HOUR.getCode())) {
                        savePo.setKexiaoCount(financed.getFinishTime());
                    } else {
                        savePo.setKexiaoCount(financed.getFinishCount());
                    }
                    savePo.setKexiaoMoney(financed.getFinishMoney());
                }
                saveAll.add(savePo);
            }
        }
        log.info("OrgSignupRefundServiceImpl=={}", (Object)saveAll);
        this.orgSignupRefundDao.saveAll((List)saveAll, new String[0]);
        return saveAll;
    }

    public OrgSignupRefundDao getOrgSignupRefundDao() {
        return this.orgSignupRefundDao;
    }

    public OrgSignupCourseDao getOrgSignupCourseDao() {
        return this.orgSignupCourseDao;
    }

    public OrgStudentCourseDao getStudentCourseDao() {
        return this.studentCourseDao;
    }

    public OrgStudentKexiaoRecordDao getOrgStudentKexiaoRecordDao() {
        return this.orgStudentKexiaoRecordDao;
    }

    public void setOrgSignupRefundDao(OrgSignupRefundDao orgSignupRefundDao) {
        this.orgSignupRefundDao = orgSignupRefundDao;
    }

    public void setOrgSignupCourseDao(OrgSignupCourseDao orgSignupCourseDao) {
        this.orgSignupCourseDao = orgSignupCourseDao;
    }

    public void setStudentCourseDao(OrgStudentCourseDao studentCourseDao) {
        this.studentCourseDao = studentCourseDao;
    }

    public void setOrgStudentKexiaoRecordDao(OrgStudentKexiaoRecordDao orgStudentKexiaoRecordDao) {
        this.orgStudentKexiaoRecordDao = orgStudentKexiaoRecordDao;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrgSignupRefundServiceImpl)) {
            return false;
        }
        OrgSignupRefundServiceImpl other = (OrgSignupRefundServiceImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        OrgSignupRefundDao this$orgSignupRefundDao = this.getOrgSignupRefundDao();
        OrgSignupRefundDao other$orgSignupRefundDao = other.getOrgSignupRefundDao();
        if (this$orgSignupRefundDao == null ? other$orgSignupRefundDao != null : !this$orgSignupRefundDao.equals(other$orgSignupRefundDao)) {
            return false;
        }
        OrgSignupCourseDao this$orgSignupCourseDao = this.getOrgSignupCourseDao();
        OrgSignupCourseDao other$orgSignupCourseDao = other.getOrgSignupCourseDao();
        if (this$orgSignupCourseDao == null ? other$orgSignupCourseDao != null : !this$orgSignupCourseDao.equals(other$orgSignupCourseDao)) {
            return false;
        }
        OrgStudentCourseDao this$studentCourseDao = this.getStudentCourseDao();
        OrgStudentCourseDao other$studentCourseDao = other.getStudentCourseDao();
        if (this$studentCourseDao == null ? other$studentCourseDao != null : !this$studentCourseDao.equals(other$studentCourseDao)) {
            return false;
        }
        OrgStudentKexiaoRecordDao this$orgStudentKexiaoRecordDao = this.getOrgStudentKexiaoRecordDao();
        OrgStudentKexiaoRecordDao other$orgStudentKexiaoRecordDao = other.getOrgStudentKexiaoRecordDao();
        return !(this$orgStudentKexiaoRecordDao == null ? other$orgStudentKexiaoRecordDao != null : !this$orgStudentKexiaoRecordDao.equals(other$orgStudentKexiaoRecordDao));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OrgSignupRefundServiceImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        OrgSignupRefundDao $orgSignupRefundDao = this.getOrgSignupRefundDao();
        result = result * 59 + ($orgSignupRefundDao == null ? 43 : $orgSignupRefundDao.hashCode());
        OrgSignupCourseDao $orgSignupCourseDao = this.getOrgSignupCourseDao();
        result = result * 59 + ($orgSignupCourseDao == null ? 43 : $orgSignupCourseDao.hashCode());
        OrgStudentCourseDao $studentCourseDao = this.getStudentCourseDao();
        result = result * 59 + ($studentCourseDao == null ? 43 : $studentCourseDao.hashCode());
        OrgStudentKexiaoRecordDao $orgStudentKexiaoRecordDao = this.getOrgStudentKexiaoRecordDao();
        result = result * 59 + ($orgStudentKexiaoRecordDao == null ? 43 : $orgStudentKexiaoRecordDao.hashCode());
        return result;
    }

    public String toString() {
        return "OrgSignupRefundServiceImpl(orgSignupRefundDao=" + this.getOrgSignupRefundDao() + ", orgSignupCourseDao=" + this.getOrgSignupCourseDao() + ", studentCourseDao=" + this.getStudentCourseDao() + ", orgStudentKexiaoRecordDao=" + this.getOrgStudentKexiaoRecordDao() + ")";
    }
}

