package com.baijia.tianxiao.sal.signup.service.Impl;

import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.SignupRefundStorageDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.TxSignupRefundStorage;
import com.baijia.tianxiao.sal.organization.finance.dto.SignupRefundRequest;
import com.baijia.tianxiao.sal.signup.dto.SignupRefundStorageDto;
import com.baijia.tianxiao.sal.signup.service.SignupRefundStorageService;
import com.baijia.tianxiao.util.BaseUtils;
import com.baijia.tianxiao.util.mobile.EmojiUtils;
import com.baijia.tianxiao.util.storage.StorageUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * Author: hanlaijin Date: 16/12/5 下午5:00
 */
@Service
@Slf4j
public class SignupRefundStorageServiceImpl implements SignupRefundStorageService {

    @Autowired
    private OrgStorageDao storageDao;
    @Autowired
    private SignupRefundStorageDao signupRefundStorageDao;
    @Autowired
    private OrgSignupCourseDao orgSignupCourseDao;
    @Autowired
    private OrgCourseDao orgCourseDao;

    @Override
    public void addOrEditOrgSignupStorage(Long orgId, Collection<TxSignupRefundStorage> dtos) {
        log.info("signup refund remark params=={},{}", orgId, dtos);
        if (CollectionUtils.isEmpty(dtos)) {
            return;
        }
        for (TxSignupRefundStorage signup : dtos) {
            List<TxSignupRefundStorage> temp = signupRefundStorageDao.getTxSignupRefundStorage(orgId,
                    signup.getSignupPurchaseId(), signup.getCourseId(), signup.getUserId(), signup.getStorageId());
            if (CollectionUtils.isEmpty(temp)) {
                signupRefundStorageDao.save(signup);
            } else {
                TxSignupRefundStorage old = temp.get(0);
                old.setRemark(signup.getRemark());
                old.setStorageId(signup.getStorageId());
                signupRefundStorageDao.update(old);
            }
        }
    }

    @Override
    public List<SignupRefundStorageDto> getSignupRefundStorages(Long orgId, Long signupPurchaseId, Long courseId,
                                                                Long userId) {
        log.info("SignupRefundStorageServiceImpl->getSignupRefundStorages->params={},{},{},{}", orgId, signupPurchaseId, courseId, userId);
        OrgCourse orgCourse = orgCourseDao.getByCourseId(courseId);
        if (orgCourse != null && orgCourse.getParentId().intValue() > 0) {
            courseId = orgCourse.getParentId();
        }
        List<TxSignupRefundStorage> list =
                signupRefundStorageDao.getTxSignupRefundStorage(orgId, signupPurchaseId, courseId, userId, null);
        List<Long> storageIds = Lists.newArrayList();
        for (TxSignupRefundStorage storage : list) {
            if (storage.getStorageId() != null && storage.getStorageId().intValue() != 0) {
                storageIds.add(storage.getStorageId());
            }
        }
        Map<Long, String> urlMap = getStorageUrlMap(storageIds);
        List<SignupRefundStorageDto> result = Lists.newArrayList();
        log.debug("SignupRefundStorageServiceImpl->getSignupRefundStorages->result={},{}", urlMap, list);

        for (TxSignupRefundStorage s : list) {
            SignupRefundStorageDto dto = new SignupRefundStorageDto();
            dto.setStorageId(s.getStorageId());
            dto.setCourseId(s.getCourseId());
            dto.setId(s.getId());
            dto.setUserId(s.getUserId() != null ? s.getUserId() : 0);
            dto.setSignupPurchaseId(s.getSignupPurchaseId() != null ? s.getSignupPurchaseId() : 0);
            dto.setOrgId(s.getOrgId());
            dto.setUrl(urlMap.get(s.getStorageId().longValue()));
            dto.setRemark(s.getRemark());
            result.add(dto);
        }
        log.debug("SignupRefundStorageServiceImpl->getSignupRefundStorages->result={},{}", result);

        return result;
    }

    @Override
    public void deleteById(long id) {
        signupRefundStorageDao.delById(id);
    }

    @Override
    public void deleteByIds(List<String> ids) {
        List<Long> longids = Lists.newArrayList();
        for (String id : ids) {
            longids.add(Long.valueOf(id));
        }
        signupRefundStorageDao.delByIds(longids);
    }

    @Override
    public void saveOrUpdateRemark(Long orgId, SignupRefundRequest refundRequest) {
        log.info("signup refund remark params=={}", refundRequest);
        if (StringUtils.isNotEmpty(refundRequest.getDelIds())) {
            List<String> ids = BaseUtils.strToList(refundRequest.getDelIds(), ",");
            deleteByIds(ids);
        }
        OrgCourse orgCourse = orgCourseDao.getByCourseId(refundRequest.getCourseId());
        if (orgCourse != null && orgCourse.getParentId().intValue() > 0) {
            refundRequest.setCourseId(orgCourse.getParentId());
        }
        List<TxSignupRefundStorage> params = Lists.newArrayList();
        List<Long> signupPurchaseIdList = buildSignupPurchaseId(orgId, refundRequest);

        if (CollectionUtils.isEmpty(signupPurchaseIdList)){
            signupPurchaseIdList.add(0l);
        }
        log.info("signup refund remark params=={}", signupPurchaseIdList);
        for (Long purchaseId : signupPurchaseIdList) {
            if (StringUtils.isNoneBlank(refundRequest.getStorageIds())) {
                String[] arr = refundRequest.getStorageIds().split(",");
                for (int i = 0; i < arr.length; i++) {
                    TxSignupRefundStorage s = new TxSignupRefundStorage();
                    s.setSignupPurchaseId(purchaseId);
                    s.setStorageId(Long.valueOf(arr[i]));
                    s.setOrgId(orgId.longValue());
                    s.setUserId(refundRequest.getUserId());
                    s.setRemark(refundRequest.getRemark() == null ? "" : EmojiUtils.filterEmoji(refundRequest.getRemark()));
                    s.setCourseId(refundRequest.getCourseId());
                    params.add(s);
                }
            } else {
                TxSignupRefundStorage s = new TxSignupRefundStorage();
                s.setSignupPurchaseId(purchaseId);
                s.setStorageId(0l);
                s.setOrgId(orgId.longValue());
                s.setUserId(refundRequest.getUserId());
                s.setRemark(refundRequest.getRemark() == null ? "" : EmojiUtils.filterEmoji(refundRequest.getRemark()));
                s.setCourseId(refundRequest.getCourseId());
                params.add(s);
            }
        }
        addOrEditOrgSignupStorage(orgId.longValue(), params);
    }

    private Map<Long, String> getStorageUrlMap(Collection<Long> storageIds) {
        List<OrgStorage> storages = storageDao.getByIds(storageIds);
        Map<Long, String> urlMap = Maps.newHashMap();
        for (OrgStorage storage : storages) {
            urlMap.put(storage.getId().longValue(),
                    StorageUtil.constructUrl(storage.getFid(), storage.getSn(), storage.getMimeType()));
        }
        return urlMap;
    }

    private List<Long> buildSignupPurchaseId(Long orgId, SignupRefundRequest refundRequest) {
        List<Long> purchaseIds = Lists.newArrayList();
        if (refundRequest.getSignupPurchaseId() != null && refundRequest.getSignupPurchaseId().intValue() > 0) {
            purchaseIds.add(refundRequest.getSignupPurchaseId());
        } else {
            List<OrgSignupCourse> signupCourseList = orgSignupCourseDao.listSignupCourseByCourse(orgId, null, refundRequest.getCourseId(), refundRequest.getUserId());
            for (OrgSignupCourse orgSignupCourse : signupCourseList) {
                purchaseIds.add(orgSignupCourse.getSignupPurchaseId());
            }
        }
        return purchaseIds;
    }
}
