
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.signup.dto.response;

import java.util.List;

import com.baijia.tianxiao.dal.finance.po.TxStudentFinanceAccount;
import com.baijia.tianxiao.sal.signup.dto.BalanceChangeRecord;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time Dec 13, 2016
 * @Desc this guy is too lazy, nothing left.
 */
@Data
@Slf4j
public class StudentBalanceResponseDto {

    private Long studentId;
    private String studentName;
    private String mobile;
    private double balance;
    private List<BalanceChangeRecord> records;

    private String showInfo = "可在电脑端【资金管理】为学员进行退款";// app需要的提示文案

    /**
     * @param financeAccount
     * @param orgStudent
     * @param records2
     * @return
     */
    public static StudentBalanceResponseDto newInstance(TxStudentFinanceAccount financeAccount,
        List<BalanceChangeRecord> records) {
        log.info("financeAccount is :{}", financeAccount);
        StudentBalanceResponseDto sbrd = new StudentBalanceResponseDto();
        if (financeAccount != null) {
            sbrd.balance = financeAccount.getBalance() / 100D;
            sbrd.studentId = financeAccount.getStudentId();
        }
        sbrd.setRecords(records);
        return sbrd;
    }

}
