package com.baijia.tianxiao.sal.signup.service.Impl;

import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.signup.dao.SignupRefundStorageDao;
import com.baijia.tianxiao.dal.signup.po.TxSignupRefundStorage;
import com.baijia.tianxiao.sal.organization.finance.dto.SignupRefundRequest;
import com.baijia.tianxiao.sal.signup.dto.SignupRefundStorageDto;
import com.baijia.tianxiao.sal.signup.service.SignupRefundStorageService;
import com.baijia.tianxiao.util.BaseUtils;
import com.baijia.tianxiao.util.storage.StorageUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * Author: hanlaijin Date: 16/12/5 下午5:00
 */
@Service
@Slf4j
public class SignupRefundStorageServiceImpl implements SignupRefundStorageService {

    @Autowired
    private OrgStorageDao storageDao;
    @Autowired
    private SignupRefundStorageDao signupRefundStorageDao;
    @Autowired
    private OrgStudentDao orgStudentDao;

    @Override
    public void addOrEditOrgSignupStorage(Long orgId, Collection<TxSignupRefundStorage> dtos) {
        if (CollectionUtils.isEmpty(dtos)) {
            return;
        }
        for (TxSignupRefundStorage signup : dtos) {
            List<TxSignupRefundStorage> temp = signupRefundStorageDao.getTxSignupRefundStorage(orgId,
                    signup.getSignupPurchaseId(), signup.getCourseId(), signup.getUserId(), signup.getStorageId());
            if (CollectionUtils.isEmpty(temp)) {
                signupRefundStorageDao.save(signup);
            } else {
                TxSignupRefundStorage old = temp.get(0);
                old.setRemark(signup.getRemark());
                old.setStorageId(signup.getStorageId());
                signupRefundStorageDao.update(old);
            }
        }
    }

    @Override
    public List<SignupRefundStorageDto> getSignupRefundStorages(Long orgId, Long signupPurchaseId, Long courseId,
                                                                Long userId) {
        List<TxSignupRefundStorage> list =
                signupRefundStorageDao.getTxSignupRefundStorage(orgId, signupPurchaseId, courseId, userId, null);
        List<Long> storageIds = Lists.newArrayList();
        for (TxSignupRefundStorage storage : list) {
            storageIds.add(storage.getStorageId());
        }
        Map<Long, String> urlMap = getStorageUrlMap(storageIds);
        List<SignupRefundStorageDto> result = Lists.newArrayList();
        for (TxSignupRefundStorage s : list) {
            SignupRefundStorageDto dto = new SignupRefundStorageDto();
            dto.setStorageId(s.getStorageId());
            dto.setCourseId(s.getCourseId());
            dto.setId(s.getId());
            dto.setUserId(s.getUserId() != null ? s.getUserId() : 0);
            dto.setSignupPurchaseId(s.getSignupPurchaseId() != null ? s.getSignupPurchaseId() : 0);
            dto.setOrgId(s.getOrgId());
            dto.setUrl(urlMap.get(s.getStorageId()));
            dto.setRemark(s.getRemark());
            result.add(dto);
        }
        return result;
    }

    @Override
    public void deleteById(long id) {
        signupRefundStorageDao.delById(id);
    }

    @Override
    public void deleteByIds(List<String> ids) {
        List<Long> longids = Lists.newArrayList();
        for (String id : ids) {
            longids.add(Long.valueOf(id));
        }
        signupRefundStorageDao.delByIds(longids);
    }

    @Override
    public void saveOrUpdateRemark(Long orgId, SignupRefundRequest refundRequest) {
        if (StringUtils.isNotEmpty(refundRequest.getDelIds())) {
            List<String> ids = BaseUtils.strToList(refundRequest.getDelIds(), ",");
            deleteByIds(ids);
        }
        if (StringUtils.isNoneBlank(refundRequest.getStorageIds())) {
            List<TxSignupRefundStorage> params = Lists.newArrayList();
            String[] arr = refundRequest.getStorageIds().split(",");
            for (int i = 0; i < arr.length; i++) {
                TxSignupRefundStorage s = new TxSignupRefundStorage();
                s.setSignupPurchaseId(refundRequest.getSignupPurchaseId() != null ? Long.valueOf(refundRequest.getSignupPurchaseId()) : null);
                s.setStorageId(Long.valueOf(arr[i]));
                s.setOrgId(orgId.longValue());
                s.setUserId(refundRequest.getUserId());
                s.setRemark(refundRequest.getRemark() == null ? "" : refundRequest.getRemark());
                s.setCourseId(refundRequest.getCourseId());
                params.add(s);
            }
            addOrEditOrgSignupStorage(orgId.longValue(), params);
        }
    }

    private Map<Long, String> getStorageUrlMap(Collection<Long> storageIds) {
        List<OrgStorage> storages = storageDao.getByIds(storageIds);
        Map<Long, String> urlMap = Maps.newHashMap();
        for (OrgStorage storage : storages) {
            urlMap.put(storage.getId().longValue(),
                    StorageUtil.constructUrl(storage.getFid(), storage.getSn(), storage.getMimeType()));
        }
        return urlMap;
    }
}
