package com.baijia.tianxiao.sal.signup.service.Impl;


import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentKexiaoRecordDao;
import com.baijia.tianxiao.dal.org.dto.StudentCourseKexiaoDocument;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.signup.constant.SignupCourseStatus;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupRefundDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupRefund;
import com.baijia.tianxiao.sal.signup.service.OrgSignupRefundService;
import com.baijia.tianxiao.util.NumberUtil;
import com.google.common.collect.Lists;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/**
 * 报名 退款
 */
@Service
@Data
@Slf4j
public class OrgSignupRefundServiceImpl implements OrgSignupRefundService {

    @Resource
    private OrgSignupRefundDao orgSignupRefundDao;

    @Resource
    private OrgSignupCourseDao orgSignupCourseDao;

    @Resource
    private OrgStudentCourseDao studentCourseDao;

    @Resource
    private OrgStudentKexiaoRecordDao orgStudentKexiaoRecordDao;

    @Override
    public List<OrgSignupRefund> saveRefund(List<OrgSignupCourse> signupCourses, Long orgId, Long signupPurchaseId, Long courseId, Long userId, Long refundPrice, Integer refundType, Integer cascadeId) {

        log.debug("OrgSignupRefundServiceImpl params={},{},{},{},{},{},{},{}", signupCourses, orgId, signupPurchaseId, courseId, userId, refundPrice, refundType, cascadeId);
        List<OrgSignupCourse> signupCourseList = Lists.newArrayList();
        if (signupPurchaseId != null && signupPurchaseId > 0) {
            OrgSignupCourse orgSignupCourse = orgSignupCourseDao.getByCourseId(orgId, signupPurchaseId, courseId);
            signupCourseList.add(orgSignupCourse);
        } else {
            signupCourseList = signupCourses;
        }

        OrgStudentCourse studentCourse = studentCourseDao.getStudentCourseByRealCourseId(orgId, courseId, userId);
        if (studentCourse == null) {
            return Collections.EMPTY_LIST;
        }

        return saveAll(signupCourseList, studentCourse, courseId, refundPrice, refundType, cascadeId);
    }

    @Override
    public List<OrgSignupRefund> listSignupRefund(Long orgId, Long signupPurchaseId, Long userId, Long courseId) {
        return orgSignupRefundDao.getOrgSignupRefundByStudent(orgId, signupPurchaseId, userId, courseId);
    }

    private List<OrgSignupRefund> saveAll(List<OrgSignupCourse> signupCourseList, OrgStudentCourse studentCourse, Long courseId, Long refundPrice, Integer refundType, Integer cascadeId) {
        log.debug("OrgSignupRefundServiceImpl params={},{},{},{},{}", signupCourseList, studentCourse, refundPrice, refundType, cascadeId);

        List<OrgSignupRefund> saveAll = Lists.newArrayList();

        Long allRemainMoney = refundPrice;

        if (CollectionUtils.isEmpty(signupCourseList)) {
            OrgSignupRefund savePo = new OrgSignupRefund();
            if (studentCourse != null) {
                savePo.setClassId(studentCourse.getCourseId());
            }
            savePo.setOrgId(studentCourse.getOrgId());
            savePo.setSignupPurchaseId(NumberUtil.randomSignupPurchaseId4Excel(new Date()));
            savePo.setCourseId(courseId);
            savePo.setUserId(studentCourse.getUserId());
            savePo.setRefundPrice(refundPrice);
            savePo.setRefundFee(0l);
            savePo.setRefundType(refundType);
            savePo.setCascadeId(cascadeId);
            savePo.setRemark("");
            savePo.setCreateTime(new Date());
            savePo.setKexiaoCount(0l);
            savePo.setKexiaoMoney(0l);

            saveAll.add(savePo);
        } else {
            for (OrgSignupCourse signupCourse : signupCourseList) {
                StudentCourseKexiaoDocument financed = orgStudentKexiaoRecordDao.finishCountMoney(signupCourse.getOrgId(), signupCourse.getOrgCourseId(), signupCourse.getUserId(), signupCourse.getId(), SignupCourseStatus.inStudentCourseStatus);

                Long canRefundPrice = signupCourse.getPayPrice() + signupCourse.getStudentPayPrice() - financed.getFinishMoney();//可退金额
                Long realRefundPrice = (allRemainMoney - canRefundPrice) <= 0 ? allRemainMoney : canRefundPrice;//实际金额
                realRefundPrice = (realRefundPrice.longValue() < 0) ? 0 : realRefundPrice;

                Long canRefundFee = canRefundPrice - realRefundPrice;//可退费用
                Long realRefundFee = canRefundFee.longValue() <= 0 ? 0 : canRefundFee;//实际费用

                allRemainMoney = (allRemainMoney - realRefundPrice) < 0 ? 0 : (allRemainMoney - realRefundPrice);

                OrgSignupRefund savePo = new OrgSignupRefund();
                log.info("[Refund] studentCourse={},courseId={},userId={}", studentCourse, signupCourse.getOrgCourseId(), signupCourse.getUserId());
                if (studentCourse != null) {
                    savePo.setClassId(studentCourse.getCourseId());
                }
                savePo.setOrgId(signupCourse.getOrgId());
                savePo.setSignupPurchaseId(signupCourse.getSignupPurchaseId());
                savePo.setCourseId(signupCourse.getOrgCourseId());
                savePo.setUserId(signupCourse.getUserId());
                savePo.setRefundPrice(realRefundPrice);
                savePo.setRefundFee(realRefundFee);
                savePo.setRefundType(refundType);
                savePo.setCascadeId(cascadeId);
                savePo.setRemark("");
                savePo.setCreateTime(new Date());
                if (financed != null) {
                    if (studentCourse != null && (studentCourse.getChargeUnit() == ChargeUnit.BY_HOUR.getCode()
                            || studentCourse.getChargeUnit() == ChargeUnit.BY_HALF_HOUR.getCode())) {
                        savePo.setKexiaoCount(financed.getFinishTime());
                    } else {
                        savePo.setKexiaoCount(financed.getFinishCount());
                    }
                    savePo.setKexiaoMoney(financed.getFinishMoney());
                }
                saveAll.add(savePo);
            }
        }
        log.info("OrgSignupRefundServiceImpl=={}", saveAll);
        orgSignupRefundDao.saveAll(saveAll);
        return saveAll;
    }
}
