
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.signup.dto;

import com.baijia.tianxiao.constant.StudentFiannceOpType;
import com.baijia.tianxiao.dal.finance.po.TxStudentFinanceRecord;
import com.baijia.tianxiao.excel.ExcelColumn;
import com.baijia.tianxiao.excel.ExcelExporterDto;
import com.baijia.tianxiao.excel.ExcelType;
import com.baijia.tianxiao.excel.InitAble;
import com.baijia.tianxiao.util.GenericsUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;

import lombok.Data;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time Dec 13, 2016
 * @Desc this guy is too lazy, nothing left.
 */
@Data
@ExcelExporterDto
public class BalanceChangeRecord implements InitAble {

    private Long recordId;
    @ExcelColumn(value = "日期", excelType = ExcelType.DATE, dataFormat = "yyyy-MM-dd")
    private long opTime;
    @ExcelColumn("摘要")
    private String abstractDesc;
    @ExcelColumn("类型")
    private String opTypeDesc;
    @ExcelColumn("金额")
    private String opMoneyDesc;
    @ExcelColumn("余额")
    private String banlanceDesc;
    @ExcelColumn("操作员")
    private String operator;
    @ExcelColumn("备注")
    private String comment;

    private int opTo;
    private double balance;
    private double opMoney;
    private Integer opType;

    @JsonIgnore
    private Integer operatorId; // cascadeId
    private String opInfo;

    /**
     * @param record
     * @return
     */

    public static BalanceChangeRecord newInstance(TxStudentFinanceRecord record) {
        BalanceChangeRecord bcr = new BalanceChangeRecord();
        bcr.setAbstractDesc(record.getOpInfo());
        bcr.setBalance(record.getCurrBalance() / 100D);
        bcr.setComment(GenericsUtils.isNullOrEmpty(record.getRemark()) ? "[暂无]" : record.getRemark());
        bcr.setOpMoney(record.getOpMoney() / 100D);
        bcr.setOpTime(record.getUpdateTime().getTime());
        bcr.setOpType(record.getOpType());
        bcr.setRecordId(record.getId().longValue());
        bcr.setOperatorId(record.getCascadeId());
        bcr.setOpInfo(record.getOpInfo());
        bcr.setOpTo(record.getOpTo());
        return bcr;
    }

    public void initProperties() {
        this.opTypeDesc = StudentFiannceOpType.getByCode(this.opType).getName();
        String desc = String.valueOf(this.opMoney);
        this.opMoneyDesc = this.opTo == 1 ? "+ " + desc : "- " + desc;
        this.banlanceDesc = String.valueOf(this.balance);
    }

}
