/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.signup.constants;

import com.baijia.tianxiao.constants.signup.PayType;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;

public enum AppPayType {
    UNKOWN(-1),
    ALL(0),
    ALIPAY(1),
    WEIXIN(2),
    POS(3),
    YINLIAN(4);

    private Integer code;
    private static final List<Integer> PAY_TYPE_CODE_ALL;
    private static final List<Integer> PAY_TYPE_CODE_ALIPAY;
    private static final List<Integer> PAY_TYPE_CODE_WEIXIN;
    private static final List<Integer> PAY_TYPE_CODE_POS;
    private static final List<Integer> PAY_TYPE_CODE_YINLIAN;

    private AppPayType(Integer code) {
        this.code = code;
    }

    public Integer getCode() {
        return this.code;
    }

    public static AppPayType getByCode(Integer code) {
        if (code == ALL.getCode()) {
            return ALL;
        }
        if (code == ALIPAY.getCode()) {
            return ALIPAY;
        }
        if (code == WEIXIN.getCode()) {
            return WEIXIN;
        }
        if (code == POS.getCode()) {
            return POS;
        }
        if (code == YINLIAN.getCode()) {
            return YINLIAN;
        }
        return UNKOWN;
    }

    public Collection<Integer> getPayTypeCodes() {
        if (this.code == ALIPAY.getCode()) {
            return PAY_TYPE_CODE_ALIPAY;
        }
        if (this.code == WEIXIN.getCode()) {
            return PAY_TYPE_CODE_WEIXIN;
        }
        if (this.code == POS.getCode()) {
            return PAY_TYPE_CODE_POS;
        }
        if (this.code == YINLIAN.getCode()) {
            return PAY_TYPE_CODE_YINLIAN;
        }
        return PAY_TYPE_CODE_ALL;
    }

    public static Integer toAppPayTypeCode(Integer payType) {
        if (PAY_TYPE_CODE_ALIPAY.contains(payType)) {
            return ALIPAY.getCode();
        }
        if (PAY_TYPE_CODE_WEIXIN.contains(payType)) {
            return WEIXIN.getCode();
        }
        if (PAY_TYPE_CODE_POS.contains(payType)) {
            return POS.getCode();
        }
        if (PAY_TYPE_CODE_YINLIAN.contains(payType)) {
            return YINLIAN.getCode();
        }
        return ALL.getCode();
    }

    static {
        PAY_TYPE_CODE_ALL = Lists.newArrayList((Object[])new Integer[]{PayType.ALIPAY_POS.getCode(), PayType.PAY_POS_YINLIAN_CARD.getCode(), PayType.CASH.getCode(), PayType.WX_POS.getCode(), PayType.PAY_POS_KUAIQIAN_CARD.getCode(), PayType.ONLINE_PAYMENT.getCode(), PayType.PAY_POS_CARD.getCode()});
        PAY_TYPE_CODE_ALIPAY = Lists.newArrayList((Object[])new Integer[]{PayType.ALIPAY_POS.getCode()});
        PAY_TYPE_CODE_WEIXIN = Lists.newArrayList((Object[])new Integer[]{PayType.WX_POS.getCode()});
        PAY_TYPE_CODE_POS = Lists.newArrayList((Object[])new Integer[]{PayType.PAY_POS_KUAIQIAN_CARD.getCode(), PayType.PAY_POS_YINLIAN_CARD.getCode(), PayType.PAY_POS_CARD.getCode()});
        PAY_TYPE_CODE_YINLIAN = Lists.newArrayList((Object[])new Integer[]{PayType.PAY_POS_YINLIAN_CARD.getCode()});
    }
}

