/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.signup.service.Impl;

import com.baijia.commons.lang.utils.date.DateUtils;
import com.baijia.tianxiao.constants.signup.PayResult;
import com.baijia.tianxiao.constants.signup.PayType;
import com.baijia.tianxiao.constants.signup.SplitCourseResult;
import com.baijia.tianxiao.constants.sms.SmsMessageType;
import com.baijia.tianxiao.constants.sms.SmsSendResult;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.CoursePurchaseDao;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseTeacherDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgSinupPurchaseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.TtsSmsDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgCourseTeacher;
import com.baijia.tianxiao.dal.org.po.OrgSinupPurchase;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.org.po.TtsSms;
import com.baijia.tianxiao.dal.signup.constant.SignupType;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupOnlinePayDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.dal.signup.po.OrgSignupOnlinePay;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dal.user.dao.UserDao;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.SignupErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.signup.dto.OrgSingupInfoDto;
import com.baijia.tianxiao.sal.signup.dto.SignupCourseInfoDto;
import com.baijia.tianxiao.sal.signup.dto.request.FillCourseInfoRequestDto;
import com.baijia.tianxiao.sal.signup.dto.request.SingupListRequestDto;
import com.baijia.tianxiao.sal.signup.service.SignupService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.DigitUppercaseUtils;
import com.baijia.tianxiao.util.NumberUtil;
import com.baijia.tianxiao.util.ShortUrlUtil;
import com.baijia.tianxiao.util.SmsSendUtil;
import com.baijia.tianxiao.util.encrypt.MD5Utils;
import com.baijia.tianxiao.util.properties.UrlProperties;
import com.baijia.tianxiao.util.rest.RestUtils;
import com.baijia.tianxiao.validation.ParamValidateUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SignupServiceImpl
implements SignupService {
    private static final Logger log = LoggerFactory.getLogger(SignupServiceImpl.class);
    public static final BigDecimal HUNDRED = new BigDecimal(100);
    @Resource
    private OrgCourseDao orgCourseDao;
    @Resource
    private OrgCourseTeacherDao orgCourseTeacherDao;
    @Resource
    private OrgSignupCourseDao orgSignupCourseDao;
    @Resource
    private OrgSignupInfoDao orgSignupInfoDao;
    @Resource
    private OrgInfoDao orgInfoDao;
    @Resource
    private UserDao userDao;
    @Resource
    private OrgSinupPurchaseDao orgSinupPurchaseDao;
    @Resource
    private OrgStudentCourseDao orgStudentCourseDao;
    @Resource
    private OrgSignupOnlinePayDao orgSignupOninePayDao;
    @Resource
    private CoursePurchaseDao coursePurchaseDao;
    @Resource
    private TtsSmsDao ttsSmsDao;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private OrgAccountDao orgAccountDao;
    @Resource
    private TeacherDao teacherDao;

    private Long getOrgNumber(Long orgId) {
        OrgAccount account = this.orgAccountDao.getAccountById(orgId.intValue(), new String[]{"number"});
        if (account == null) {
            return null;
        }
        Integer number = account.getNumber();
        return number != null ? Long.valueOf(number.longValue()) : null;
    }

    @Override
    public List<OrgSingupInfoDto> getSignupList(SingupListRequestDto requestDto) {
        List result;
        List courseIds;
        Preconditions.checkNotNull((Object)requestDto.getOrgId(), (Object)"orgId may not be null");
        requestDto.setOrgNumber(this.getOrgNumber(requestDto.getOrgId()));
        Preconditions.checkNotNull((Object)requestDto.getOrgNumber(), (Object)"orgNumber may not be null");
        String key = requestDto.getSearchKey();
        ArrayList purchaseIds = Lists.newArrayList();
        if (StringUtils.isNotBlank((String)key) && CollectionUtils.isNotEmpty((Collection)(courseIds = this.orgCourseDao.getCourseIdsByOrgNumberAndCourseName(requestDto.getOrgNumber(), key, Integer.valueOf(0))))) {
            purchaseIds.addAll(this.orgSignupCourseDao.searchPurchaseIdByCourseId((Collection)courseIds, requestDto.getStartTime(), requestDto.getEndTime()));
        }
        if (CollectionUtils.isEmpty((Collection)(result = this.orgSignupInfoDao.getOrgSignupInfo(requestDto.getOrgId(), (Collection)purchaseIds, requestDto.getPurchaseStatusCodes(), requestDto.getSplitCodes(), requestDto.getPayTypeCodes(), key, requestDto.getStartTime(), requestDto.getEndTime(), (PageDto)requestDto, new String[0])))) {
            return Collections.emptyList();
        }
        this.loadSignupCourseInfo(result);
        return this.buildOrgSingupInfoDtos(result, this.orgInfoDao.getOrgShortNameByOrgId(Integer.valueOf(requestDto.getOrgId().intValue())));
    }

    private List<OrgSingupInfoDto> buildOrgSingupInfoDtos(Collection<OrgSignupInfo> orgSignupInfos, String orgName) {
        ArrayList orgSingupInfoDtos = Lists.newArrayList();
        HashSet courseIds = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty(orgSignupInfos)) {
            for (OrgSignupInfo orgSignupInfo : orgSignupInfos) {
                if (!CollectionUtils.isNotEmpty((Collection)orgSignupInfo.getOrgSignupCourses())) continue;
                for (OrgSignupCourse orgSignupCourse : orgSignupInfo.getOrgSignupCourses()) {
                    courseIds.add(orgSignupCourse.getOrgCourseId());
                }
            }
            Map courseMap = this.orgCourseDao.getOrgCourseMap((Collection)courseIds);
            Map<Long, List<String>> courseTeacherNameMap = this.getCourseIdTeacherNamesMap(courseIds);
            for (OrgSignupInfo orgSignupInfo : orgSignupInfos) {
                orgSingupInfoDtos.add(this.buildOrgSignupInfoDto(orgSignupInfo, orgName, courseMap, courseTeacherNameMap));
            }
        }
        return orgSingupInfoDtos;
    }

    private OrgSingupInfoDto buildOrgSignupInfoDto(OrgSignupInfo orgSignupInfo, String orgName, Map<Long, OrgCourse> courseMap, Map<Long, List<String>> courseTeacherNameMap) {
        OrgSingupInfoDto dto = new OrgSingupInfoDto();
        if (orgSignupInfo != null) {
            dto.setTotalPrice(orgSignupInfo.getTotalPrices().doubleValue() / 100.0);
            dto.setChinesePrice(DigitUppercaseUtils.digitUppercase((double)dto.getTotalPrice()));
            dto.setPayResultEnum(PayResult.getPayResultByCode((Integer)orgSignupInfo.getPurchaseStatus().intValue()));
            dto.setPayTypeEnum(PayType.getPayTypeByCode((Integer)orgSignupInfo.getPayType()));
            dto.setSignupTypeEnum(SignupType.getTypeByCode((Integer)orgSignupInfo.getSignupType()));
            dto.setOrgId(orgSignupInfo.getOrgId());
            dto.setOrgName(orgName);
            dto.setSignUpTime(orgSignupInfo.getCreateTime());
            dto.setSignupPurchaseId(orgSignupInfo.getSignupPurchaseId());
            dto.setCreateTime(orgSignupInfo.getCreateTime());
            dto.setUpdateTime(orgSignupInfo.getUpdateTime());
            dto.setCourseInfos(Lists.newArrayList());
            dto.setId(orgSignupInfo.getId());
            dto.setStatus(orgSignupInfo.getPurchaseStatus().intValue(), (int)orgSignupInfo.getSplitResult());
            String remark = "\u65e0";
            if (StringUtils.isNotBlank((String)orgSignupInfo.getRemark())) {
                remark = orgSignupInfo.getRemark();
            }
            if (orgSignupInfo.getTradeNo() != null && orgSignupInfo.getTradeNo().longValue() != 0L) {
                dto.setTradeNo(orgSignupInfo.getTradeNo().longValue());
            } else {
                dto.setTradeNo(orgSignupInfo.getSignupPurchaseId());
            }
            dto.setRemark(remark);
            dto.setStudentId(orgSignupInfo.getUserId());
            dto.setStudentMobile(orgSignupInfo.getMobile());
            dto.setStudentName(orgSignupInfo.getStudentName());
            dto.setOperator(orgSignupInfo.getOperator());
            if (CollectionUtils.isNotEmpty((Collection)orgSignupInfo.getOrgSignupCourses())) {
                for (OrgSignupCourse orgSignupCourse : orgSignupInfo.getOrgSignupCourses()) {
                    Long courseId = orgSignupCourse.getOrgCourseId();
                    dto.getCourseInfos().add(this.buildOrgSignupCourseDto(orgSignupCourse, courseMap.get(courseId), courseTeacherNameMap.get(courseId)));
                }
            }
        }
        return dto;
    }

    private SignupCourseInfoDto buildOrgSignupCourseDto(OrgSignupCourse orgSignupCourse, OrgCourse orgCourse, List<String> teacherNames) {
        SignupCourseInfoDto dto = new SignupCourseInfoDto();
        dto.setCount(orgSignupCourse.getCount());
        dto.setDiscount(orgSignupCourse.getCourseDiscount());
        dto.setOrgCourseId(orgSignupCourse.getOrgCourseId());
        dto.setOriginPrice(orgSignupCourse.getOriginPrice().doubleValue() / 100.0);
        dto.setPreferential(orgSignupCourse.getPreferential().doubleValue() / 100.0);
        dto.setPayPrice(orgSignupCourse.getPayPrice().doubleValue() / 100.0);
        dto.setCourseName(orgCourse.getName());
        dto.setOrgCourseNumber(orgCourse.getNumber());
        dto.setTeacherNames(teacherNames);
        return dto;
    }

    private void loadSignupCourseInfo(Collection<OrgSignupInfo> orgSignupInfos) {
        Long purchaseId;
        ArrayList purchaseIds = Lists.newArrayList();
        for (OrgSignupInfo info : orgSignupInfos) {
            purchaseIds.add(info.getSignupPurchaseId());
        }
        List signupCourses = this.orgSignupCourseDao.loadByPurchaseIds((Collection)purchaseIds, new String[0]);
        HashMap signupCourseMaping = Maps.newHashMap();
        for (OrgSignupCourse orgSignupCourse : signupCourses) {
            purchaseId = orgSignupCourse.getSignupPurchaseId();
            if (!signupCourseMaping.containsKey(purchaseId)) {
                signupCourseMaping.put(purchaseId, new ArrayList());
            }
            ((List)signupCourseMaping.get(purchaseId)).add(orgSignupCourse);
        }
        for (OrgSignupInfo orgSignupInfo : orgSignupInfos) {
            purchaseId = orgSignupInfo.getSignupPurchaseId();
            if (!signupCourseMaping.containsKey(purchaseId)) continue;
            orgSignupInfo.setOrgSignupCourses((List)signupCourseMaping.get(purchaseId));
        }
    }

    private OrgSingupInfoDto buildOrgSignupInfoDto(OrgSignupInfo orgSignupInfo) {
        HashSet courseIds = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty((Collection)orgSignupInfo.getOrgSignupCourses())) {
            for (OrgSignupCourse orgSignupCourse : orgSignupInfo.getOrgSignupCourses()) {
                courseIds.add(orgSignupCourse.getOrgCourseId());
            }
        }
        Map courseMap = this.orgCourseDao.getOrgCourseMap((Collection)courseIds);
        Map<Long, List<String>> courseTeacherNameMap = this.getCourseIdTeacherNamesMap(courseIds);
        return this.buildOrgSignupInfoDto(orgSignupInfo, this.orgInfoDao.getOrgShortNameByOrgId(orgSignupInfo.getOrgId() != null ? Integer.valueOf(orgSignupInfo.getOrgId().intValue()) : null), courseMap, courseTeacherNameMap);
    }

    @Override
    public OrgSingupInfoDto getSignupCourseInfo(Collection<Header> headers, Long signupPurchaseId, Long orgId) throws Exception {
        OrgSignupOnlinePay onlinePayRecord;
        OrgSignupInfo orgSignupInfo = this.orgSignupInfoDao.searchByPurchaseId(signupPurchaseId, new String[0]);
        orgSignupInfo.setOrgSignupCourses(this.orgSignupCourseDao.loadByPurchaseId(signupPurchaseId, new String[0]));
        OrgSingupInfoDto dto = this.buildOrgSignupInfoDto(orgSignupInfo);
        if (orgSignupInfo.getPurchaseStatus().intValue() != PayResult.SUCCESS.getCode()) {
            log.info("get new TradeNo while pay status is not success");
            Long tradeNo = 0L;
            RestUtils.getTradeNo((Long)orgSignupInfo.getOrgId(), (Long)orgSignupInfo.getSignupPurchaseId(), (Double)(orgSignupInfo.getTotalPrices().doubleValue() / 100.0), headers);
            dto.setTradeNo(tradeNo);
            String payUrlWinxin = "";
            RestUtils.getWeiXinPurchaseUrl((Long)signupPurchaseId, (Long)orgSignupInfo.getOrgId(), (Double)(orgSignupInfo.getTotalPrices().doubleValue() / 100.0), headers);
            dto.setPayUrlWinxin(payUrlWinxin);
        }
        if ((onlinePayRecord = this.orgSignupOninePayDao.getLastRecordByPurchaseId(signupPurchaseId, new String[]{"createTime"})) != null) {
            dto.setLastSendTime(onlinePayRecord.getCreateTime());
        }
        return dto;
    }

    @Override
    public OrgSingupInfoDto generarateTradeNo(Collection<Header> headers, double totalPrice, Long orgId) throws BussinessException {
        OrgSingupInfoDto dto = new OrgSingupInfoDto();
        if (totalPrice < 0.0) {
            log.error("totalPrice = {} < 0.", (Object)totalPrice);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "totalPrice < 0");
        }
        String payUrlWinxin = RestUtils.getWeiXinPurchaseUrl((Long)orgId, (Double)totalPrice, headers);
        dto.setPayUrlWinxin(payUrlWinxin);
        Long purchaseId = RestUtils.getPurchaseId((Long)orgId, (Double)totalPrice, headers);
        Long tradeNo = RestUtils.getTradeNo((Long)orgId, (Long)purchaseId, (Double)totalPrice, headers);
        dto.setTradeNo(tradeNo);
        dto.setOrgId(orgId);
        dto.setTotalPrice(totalPrice);
        dto.setSignupPurchaseId(purchaseId);
        return dto;
    }

    @Override
    public OrgSingupInfoDto signUp(FillCourseInfoRequestDto fillCourseInfoRequestDto) throws BussinessException {
        Preconditions.checkNotNull((Object)fillCourseInfoRequestDto.getOrgId(), (Object)"orgId may not be null");
        fillCourseInfoRequestDto.setOrgNumber(this.getOrgNumber(fillCourseInfoRequestDto.getOrgId()));
        Preconditions.checkNotNull((Object)fillCourseInfoRequestDto.getOrgNumber(), (Object)"orgNumber may not be null");
        Long orgId = fillCourseInfoRequestDto.getOrgId();
        Long orgNumber = fillCourseInfoRequestDto.getOrgNumber();
        log.info("signUp--> orgId {}, signupPurchaseId {}", (Object)orgId, (Object)fillCourseInfoRequestDto.getSignupPurchaseId());
        if (fillCourseInfoRequestDto.getOrgNumber() == null) {
            fillCourseInfoRequestDto.setOrgNumber(this.getOrgNumber(fillCourseInfoRequestDto.getOrgId()));
        }
        OrgSingupInfoDto dto = null;
        if (fillCourseInfoRequestDto.getSignupType() == SignupType.POS_CARD.getCode()) {
            if (!this.isPurchaseSucce(fillCourseInfoRequestDto.getSignupPurchaseId(), orgId)) {
                throw new BussinessException((UniverseErrorCode)SignupErrorCode.PURCHASE_NOT_SUCCEED);
            }
            dto = this.signupAfterPay(fillCourseInfoRequestDto, orgId, orgNumber);
            return dto;
        }
        if (fillCourseInfoRequestDto.getSignupType() == SignupType.FRONTED.getCode()) {
            dto = this.signupBeforePay(fillCourseInfoRequestDto, orgId, orgNumber);
            return dto;
        }
        if (fillCourseInfoRequestDto.getSignupType() == SignupType.ONLINE.getCode()) {
            return this.signupPayOnline(fillCourseInfoRequestDto, orgId, orgNumber);
        }
        throw new BussinessException((UniverseErrorCode)SignupErrorCode.UNKNOWN_PURCHASE_STATUS);
    }

    private OrgSingupInfoDto signupPayOnline(FillCourseInfoRequestDto fillCourseInfoRequestDto, Long orgId, Long orgNumber) {
        throw new UnsupportedOperationException("not implement....");
    }

    private OrgSingupInfoDto signupBeforePay(FillCourseInfoRequestDto fillCourseInfoRequestDto, Long orgId, Long orgNumber) throws BussinessException {
        if (CollectionUtils.isNotEmpty(fillCourseInfoRequestDto.getCourseInfos())) {
            double totalPrice = 0.0;
            for (SignupCourseInfoDto signupCourseInfoDto : fillCourseInfoRequestDto.getCourseInfos()) {
                totalPrice += this.caculatePayPrice(signupCourseInfoDto);
            }
            if (totalPrice < 0.0) {
                throw new BussinessException((UniverseErrorCode)SignupErrorCode.TOTALPRICE_ERROR);
            }
            long begin = System.currentTimeMillis();
            Long purchaseId = RestUtils.getPurchaseId((Long)orgId, (Double)totalPrice, fillCourseInfoRequestDto.getHeaders());
            Long tradeNo = RestUtils.getTradeNo((Long)orgId, (Long)purchaseId, (Double)totalPrice, fillCourseInfoRequestDto.getHeaders());
            long end = System.currentTimeMillis();
            log.debug("signupBeforePay-->    RestUtils.getPurchaseId cost{}", (Object)(end - begin));
            log.info("getPurchaseId--> {}", (Object)purchaseId);
            Date now = new Date();
            OrgSignupInfo orgSignupInfo = new OrgSignupInfo();
            orgSignupInfo.setCreateTime(new Date());
            orgSignupInfo.setSplitResult(Integer.valueOf(SplitCourseResult.PENDING.getCode()));
            this.fillOrgSignupInfo(fillCourseInfoRequestDto, orgSignupInfo, orgId, orgNumber);
            orgSignupInfo.setSignupPurchaseId(purchaseId);
            orgSignupInfo.setTradeNo((Number)tradeNo);
            fillCourseInfoRequestDto.setSignupPurchaseId(purchaseId);
            orgSignupInfo.setSignupType(Integer.valueOf(1));
            orgSignupInfo.setTotalPrices(Long.valueOf(NumberUtil.multiply((Number)totalPrice, (BigDecimal)HUNDRED, (int)0).longValue()));
            ArrayList orgSignupCourses = Lists.newArrayList();
            for (SignupCourseInfoDto signupCourseInfoDto : fillCourseInfoRequestDto.getCourseInfos()) {
                signupCourseInfoDto.setPayPrice(this.caculatePayPrice(signupCourseInfoDto));
                orgSignupCourses.add(this.fillOrgSignupCourse(fillCourseInfoRequestDto, signupCourseInfoDto, orgSignupInfo.getUserId(), now, orgId));
            }
            orgSignupInfo.setOrgSignupCourses((List)orgSignupCourses);
            this.saveOrUpdateSignupInfo(orgSignupInfo, true);
            return this.buildOrgSignupInfoDto(orgSignupInfo);
        }
        throw new BussinessException((UniverseErrorCode)SignupErrorCode.SIGNUPCOURSE_NULL);
    }

    public boolean signupCourseInfoEqual(OrgSignupCourse orgSignupCourse, SignupCourseInfoDto signupCourseInfoDto) {
        if (orgSignupCourse == null) {
            return true;
        }
        if (orgSignupCourse.getCount().intValue() != signupCourseInfoDto.getCount()) {
            return false;
        }
        if (orgSignupCourse.getCourseDiscount().intValue() != signupCourseInfoDto.getDiscount()) {
            return false;
        }
        if (orgSignupCourse.getOriginPrice().intValue() != signupCourseInfoDto.getOriginPrice().intValue()) {
            return false;
        }
        return orgSignupCourse.getPreferential().intValue() == NumberUtil.multiply((Number)signupCourseInfoDto.getPreferential(), (BigDecimal)HUNDRED, (int)0).intValue();
    }

    private OrgSingupInfoDto signupAfterPay(FillCourseInfoRequestDto fillCourseInfoRequestDto, Long orgId, Long orgNumber) throws BussinessException {
        long total;
        OrgSignupInfo orgSignupInfo = null;
        if (fillCourseInfoRequestDto.getSignupPurchaseId() != null) {
            orgSignupInfo = this.orgSignupInfoDao.searchByPurchaseId(fillCourseInfoRequestDto.getSignupPurchaseId(), true, new String[0]);
            orgSignupInfo.setOrgSignupCourses(this.orgSignupCourseDao.loadByPurchaseId(fillCourseInfoRequestDto.getSignupPurchaseId(), new String[0]));
        }
        if (orgSignupInfo == null || orgSignupInfo.getSignupType() != 0) {
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.PURCHASEID_ERROR);
        }
        if (orgSignupInfo != null && orgSignupInfo.getSplitResult().intValue() == SplitCourseResult.SUCCESS.getCode()) {
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.COURCE_CHANGE);
        }
        if (orgSignupInfo.getSplitResult() >= SplitCourseResult.PENDING.getCode()) {
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.REPEAT_SUBMIT);
        }
        this.fillOrgSignupInfo(fillCourseInfoRequestDto, orgSignupInfo, orgId, orgNumber);
        orgSignupInfo.setSplitResult(Integer.valueOf(SplitCourseResult.PENDING.getCode()));
        long totalNow = 0L;
        long totalNew = 0L;
        Date now = new Date();
        HashMap<Long, OrgSignupCourse> orgSignupCourseMap = new HashMap<Long, OrgSignupCourse>();
        ArrayList orgSignupCoursesNew = Lists.newArrayList();
        ArrayList orgSignupCoursesNow = Lists.newArrayList();
        orgSignupCoursesNow.addAll(orgSignupInfo.getOrgSignupCourses());
        if (CollectionUtils.isNotEmpty((Collection)orgSignupInfo.getOrgSignupCourses())) {
            for (OrgSignupCourse orgSignupCourse : orgSignupInfo.getOrgSignupCourses()) {
                totalNow += orgSignupCourse.getPayPrice().longValue();
                orgSignupCourseMap.put(orgSignupCourse.getOrgCourseId(), orgSignupCourse);
            }
        }
        if (orgSignupInfo.getTotalPrices() <= totalNow) {
            log.warn(" signupAfterPay get error:{}", (Object)SignupErrorCode.REPEAT_SUBMIT.getMessage());
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.REPEAT_SUBMIT);
        }
        if (CollectionUtils.isNotEmpty(fillCourseInfoRequestDto.getCourseInfos())) {
            for (SignupCourseInfoDto signupCourseInfoDto : fillCourseInfoRequestDto.getCourseInfos()) {
                if (orgSignupCourseMap.containsKey(signupCourseInfoDto.getOrgCourseId())) {
                    if (this.signupCourseInfoEqual((OrgSignupCourse)orgSignupCourseMap.get(signupCourseInfoDto.getOrgCourseId()), signupCourseInfoDto)) continue;
                    log.warn(" fillCourseInfo get error:{}", (Object)SignupErrorCode.COURCE_CHANGE.getMessage());
                    throw new BussinessException((UniverseErrorCode)SignupErrorCode.COURCE_CHANGE);
                }
                signupCourseInfoDto.setPayPrice(this.caculatePayPrice(signupCourseInfoDto));
                totalNew += NumberUtil.multiply((Number)signupCourseInfoDto.getPayPrice(), (BigDecimal)HUNDRED, (int)0).longValue();
                orgSignupCoursesNew.add(this.fillOrgSignupCourse(fillCourseInfoRequestDto, signupCourseInfoDto, orgSignupInfo.getUserId(), now, orgId));
            }
        }
        if ((total = totalNew + totalNow) < 0L) {
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.TOTALPRICE_ERROR, SignupErrorCode.TOTALPRICE_ERROR.getMessage());
        }
        if ((double)total > orgSignupInfo.getTotalPrices().doubleValue()) {
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.TOTALPRICE_NOTMATCH, SignupErrorCode.TOTALPRICE_NOTMATCH.getMessage());
        }
        if ((double)total < orgSignupInfo.getTotalPrices().doubleValue()) {
            log.warn("\u4ef7\u683c\u4e0d\u6b63\u786e \uff1atotal = {},getTotalPrices = {}", (Object)total, (Object)orgSignupInfo.getTotalPrices());
            orgSignupInfo.setSplitResult(Integer.valueOf(SplitCourseResult.NOT_COMMIT.getCode()));
        } else {
            orgSignupInfo.setSplitResult(Integer.valueOf(SplitCourseResult.PENDING.getCode()));
        }
        if (CollectionUtils.isNotEmpty((Collection)orgSignupCoursesNew)) {
            orgSignupInfo.setOrgSignupCourses((List)orgSignupCoursesNew);
        }
        this.saveOrUpdateSignupInfo(orgSignupInfo, true);
        orgSignupInfo.getOrgSignupCourses().addAll(orgSignupCoursesNow);
        orgSignupInfo.setPurchaseStatus((Number)PayResult.SUCCESS.getCode());
        return this.buildOrgSignupInfoDto(orgSignupInfo);
    }

    private double caculatePayPrice(SignupCourseInfoDto signupCourseInfoDto) {
        BigDecimal result = new BigDecimal(signupCourseInfoDto.getOriginPrice()).multiply(new BigDecimal(signupCourseInfoDto.getDiscount())).divide(HUNDRED).multiply(new BigDecimal(signupCourseInfoDto.getCount())).subtract(new BigDecimal(signupCourseInfoDto.getPreferential())).setScale(2, RoundingMode.HALF_UP);
        return result.doubleValue();
    }

    private OrgSignupCourse fillOrgSignupCourse(FillCourseInfoRequestDto fillCourseInfoRequestDto, SignupCourseInfoDto signupCourseInfoDto, Long studentId, Date now, Long orgId) {
        OrgSignupCourse orgSignupCourse = new OrgSignupCourse();
        orgSignupCourse.setCount(Integer.valueOf(signupCourseInfoDto.getCount()));
        orgSignupCourse.setCourseDiscount(Integer.valueOf(signupCourseInfoDto.getDiscount()));
        orgSignupCourse.setCreateTime(now);
        orgSignupCourse.setOrgCourseId(signupCourseInfoDto.getOrgCourseId());
        orgSignupCourse.setOrgId(orgId);
        orgSignupCourse.setOriginPrice(Integer.valueOf(NumberUtil.multiply((Number)signupCourseInfoDto.getOriginPrice(), (BigDecimal)HUNDRED, (int)0).intValue()));
        orgSignupCourse.setPreferential(Integer.valueOf(NumberUtil.multiply((Number)signupCourseInfoDto.getPreferential(), (BigDecimal)HUNDRED, (int)0).intValue()));
        orgSignupCourse.setSignupPurchaseId(fillCourseInfoRequestDto.getSignupPurchaseId());
        orgSignupCourse.setOrgCourseNumber(signupCourseInfoDto.getOrgCourseNumber());
        orgSignupCourse.setUserId(studentId);
        orgSignupCourse.setPayPrice(Long.valueOf(NumberUtil.multiply((Number)this.caculatePayPrice(signupCourseInfoDto), (BigDecimal)HUNDRED, (int)0).longValue()));
        return orgSignupCourse;
    }

    private Long getStudent(FillCourseInfoRequestDto fillCourseInfoRequestDto) throws BussinessException {
        Long usrId = null;
        Long orgId = fillCourseInfoRequestDto.getOrgId();
        String mobile = fillCourseInfoRequestDto.getStudentMobile();
        String studentName = fillCourseInfoRequestDto.getStudentName();
        List students = this.orgStudentDao.getStudentId(orgId, mobile, Integer.valueOf(DeleteStatus.NORMAL.getValue()), studentName, new String[]{"userId", "id", "mobile", "showMobile"});
        for (OrgStudent stu : students) {
            if (!fillCourseInfoRequestDto.getStudentMobile().equals(stu.getShowMobile()) && (!StringUtils.isBlank((String)stu.getShowMobile()) && !StringUtils.contains((String)stu.getShowMobile(), (String)"****") || !fillCourseInfoRequestDto.getStudentMobile().equals(stu.getMobile()))) continue;
            usrId = stu.getUserId();
            break;
        }
        if (usrId == null) {
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.STUDENT_NOT_REGISTERD);
        }
        return usrId;
    }

    private void fillOrgSignupInfo(FillCourseInfoRequestDto fillCourseInfoRequestDto, OrgSignupInfo orgSignupInfo, Long orgId, Long orgNumber) throws BussinessException {
        long begin = System.currentTimeMillis();
        Long stuUserId = this.getStudent(fillCourseInfoRequestDto);
        long end = System.currentTimeMillis();
        log.debug("-->    getStudent cost{}", (Object)(end - begin));
        orgSignupInfo.setUserId(stuUserId);
        orgSignupInfo.setOrgId(orgId);
        orgSignupInfo.setOrgNumber(orgNumber);
        orgSignupInfo.setMobile(fillCourseInfoRequestDto.getStudentMobile());
        orgSignupInfo.setStudentName(fillCourseInfoRequestDto.getStudentName());
        if (orgSignupInfo.getPayType() == null) {
            orgSignupInfo.setPayType(Integer.valueOf(PayType.PAY_POS_CARD.getCode()));
        }
        orgSignupInfo.setRemark(fillCourseInfoRequestDto.getRemark());
        orgSignupInfo.setOperator("");
        orgSignupInfo.setUpdateTime(new Date());
        orgSignupInfo.setSignupType(Integer.valueOf(fillCourseInfoRequestDto.getSignupType()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public OrgSingupInfoDto payByCash(Long signupPurchaseId, Long orgId) throws BussinessException {
        OrgSignupInfo orgSignupInfo = this.orgSignupInfoDao.searchByPurchaseId(signupPurchaseId, new String[0]);
        orgSignupInfo.setOrgSignupCourses(this.orgSignupCourseDao.loadByPurchaseId(signupPurchaseId, new String[0]));
        if (orgSignupInfo == null || orgSignupInfo.getSignupType().intValue() != SignupType.FRONTED.getCode()) {
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.PURCHASEID_ERROR);
        }
        this.saveStudentCourse(orgSignupInfo);
        OrgSignupInfo saveObj = new OrgSignupInfo();
        saveObj.setId(orgSignupInfo.getId());
        saveObj.setPayType(Integer.valueOf(PayType.CASH.getCode()));
        saveObj.setSplitResult(Integer.valueOf(SplitCourseResult.SUCCESS.getCode()));
        saveObj.setPurchaseStatus((Number)1);
        this.orgSignupInfoDao.update((Object)saveObj, Boolean.valueOf(false), new String[]{"payType", "purchaseStatus", "splitResult"});
        orgSignupInfo.setPayType(Integer.valueOf(PayType.CASH.getCode()));
        orgSignupInfo.setPurchaseStatus((Number)1);
        return this.buildOrgSignupInfoDto(orgSignupInfo);
    }

    private void saveStudentCourse(@NonNull OrgSignupInfo orgSignupInfo) {
        if (orgSignupInfo == null) {
            throw new NullPointerException("orgSignupInfo");
        }
        for (OrgSignupCourse course : orgSignupInfo.getOrgSignupCourses()) {
            OrgStudentCourse studentCourse = new OrgStudentCourse();
            studentCourse.setCourseId(course.getOrgCourseId());
            studentCourse.setCreateTime(new Date());
            studentCourse.setDelStatus(Integer.valueOf(DeleteStatus.NORMAL.getValue()));
            studentCourse.setOrgId(orgSignupInfo.getOrgId());
            studentCourse.setUserId(orgSignupInfo.getUserId());
            studentCourse.setStudentMobile(orgSignupInfo.getMobile());
            studentCourse.setStudentName(orgSignupInfo.getStudentName());
            try {
                this.orgStudentCourseDao.save((Object)studentCourse, new String[0]);
            }
            catch (Exception e) {
                log.warn("can not save student :{} into student course by error :{}", (Object)studentCourse, (Object)e);
                e.printStackTrace();
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delSignupInfo(Long signupPurchaseId, Long orgId) throws BussinessException {
        OrgSignupInfo orgSignupInfo = this.orgSignupInfoDao.searchByPurchaseId(signupPurchaseId, new String[]{"id"});
        if (orgSignupInfo == null) {
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.PURCHASEID_ERROR);
        }
        OrgSignupInfo saveObj = new OrgSignupInfo();
        saveObj.setId(orgSignupInfo.getId());
        saveObj.setIsDel((Number)1);
        this.orgSignupInfoDao.update((Object)saveObj, Boolean.valueOf(false), new String[]{"isDel"});
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean isPurchaseSucce(Long signupPurchaseId, Long orgId) throws BussinessException {
        Preconditions.checkNotNull((Object)signupPurchaseId);
        Preconditions.checkArgument((signupPurchaseId > 0L ? 1 : 0) != 0, (Object)"purchase id can not be 0");
        OrgSinupPurchase purchase = this.orgSinupPurchaseDao.getByPurchaseId(signupPurchaseId, new String[0]);
        if (purchase.getStatus() != null && purchase.getStatus().intValue() == PayResult.SUCCESS.getCode()) {
            OrgSignupInfo orgSignupInfo = this.orgSignupInfoDao.searchByPurchaseId(signupPurchaseId, new String[]{"id", "purchaseStatus"});
            Map tradeNoMap = RestUtils.getTradeNoMap((Collection)Lists.newArrayList((Object[])new Long[]{signupPurchaseId}));
            if (orgSignupInfo == null) {
                this.insertSuccSignupInfo(purchase, (Long)tradeNoMap.get(signupPurchaseId));
            } else if (orgSignupInfo.getPurchaseStatus().intValue() != PayResult.SUCCESS.getCode()) {
                if (tradeNoMap.isEmpty() || !tradeNoMap.containsKey(signupPurchaseId)) {
                    throw new BussinessException((UniverseErrorCode)SignupErrorCode.PURCHASE_NOT_SUCCEED);
                }
                orgSignupInfo.setPurchaseStatus((Number)PayResult.SUCCESS.getCode());
                int payType = PayType.getPayTypeByTypeStr((String)purchase.getPayType()).getCode();
                orgSignupInfo.setTradeNo((Number)tradeNoMap.get(signupPurchaseId));
                orgSignupInfo.setPayType(Integer.valueOf(payType));
                this.orgSignupInfoDao.update((Object)orgSignupInfo, new String[]{"purchaseStatus", "tradeNo", "payType"});
            }
            return true;
        }
        return false;
    }

    private OrgSignupInfo insertSuccSignupInfo(OrgSinupPurchase sinupPurchase, Long tradeNo) {
        log.info("create signup info from purchase:{}", (Object)sinupPurchase);
        OrgSignupInfo info = new OrgSignupInfo();
        info.setCreateTime(sinupPurchase.getPayTime());
        info.setIsDel((Number)DeleteStatus.NORMAL.getValue());
        info.setMobile("");
        info.setOperator("");
        info.setOrgId(sinupPurchase.getOrgId());
        info.setOrgNumber(sinupPurchase.getOrgNumber());
        info.setPayType(Integer.valueOf(PayType.getPayTypeByTypeStr((String)sinupPurchase.getPayType()).getCode()));
        info.setPurchaseStatus(sinupPurchase.getStatus());
        info.setRemark("");
        info.setSignupPurchaseId(sinupPurchase.getPurchaseId());
        info.setSignupType(Integer.valueOf(SignupType.POS_CARD.getCode()));
        info.setSplitResult(Integer.valueOf(SplitCourseResult.NOT_COMMIT.getCode()));
        info.setStudentName("");
        info.setTotalPrices(Long.valueOf(NumberUtil.multiply((Number)sinupPurchase.getTotalPrices(), (BigDecimal)HUNDRED, (int)0).longValue()));
        info.setUpdateTime(new Date());
        info.setUserId(Long.valueOf(0L));
        info.setTradeNo((Number)tradeNo);
        this.saveOrUpdateSignupInfo(info, false);
        return info;
    }

    private void saveOrUpdateSignupInfo(@NonNull OrgSignupInfo signupInfo, boolean saveCourses) {
        if (signupInfo == null) {
            throw new NullPointerException("signupInfo");
        }
        if (signupInfo.getId() != null && signupInfo.getId() > 0L) {
            this.orgSignupInfoDao.update((Object)signupInfo, new String[0]);
        } else {
            this.orgSignupInfoDao.save((Object)signupInfo, new String[0]);
        }
        if (saveCourses && CollectionUtils.isNotEmpty((Collection)signupInfo.getOrgSignupCourses())) {
            try {
                this.orgSignupCourseDao.saveSignupCourses(signupInfo.getOrgSignupCourses());
            }
            catch (DuplicateKeyException e) {
                log.warn("\u6570\u636e\u91cd\u590d\u3002e = {}", (Throwable)e);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean sendOnlinePaySms(@NonNull Long signupPurchaseId, @NonNull Long orgId, @NonNull String mobile) throws BussinessException {
        if (signupPurchaseId == null) {
            throw new NullPointerException("signupPurchaseId");
        }
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        if (mobile == null) {
            throw new NullPointerException("mobile");
        }
        OrgSignupInfo purchase = this.orgSignupInfoDao.searchByPurchaseId(signupPurchaseId, new String[0]);
        if (!ParamValidateUtils.validateMobile((String)mobile)) {
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.MOBILE_FORMATE_ERROR);
        }
        if (purchase == null || !purchase.getOrgId().equals(orgId)) {
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.PURCHASE_ID_INVALIDATE);
        }
        if (purchase.getPurchaseStatus().intValue() == PayResult.SUCCESS.getCode()) {
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.PURCHASE_ID_ALREADY_PAY_SUCC);
        }
        if (purchase.getSplitResult().intValue() == SplitCourseResult.NOT_COMMIT.getCode()) {
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.SIGNUP_HAS_NOT_COURSE_INFO);
        }
        int count = this.orgSignupOninePayDao.countByMobileAndPurchaseId(signupPurchaseId, mobile, DateUtils.getToday());
        String maxCountStr = UrlProperties.getProperty((String)"max.signup.count");
        int maxCount = 3;
        if (StringUtils.isNumeric((String)maxCountStr)) {
            maxCount = Integer.parseInt(maxCountStr);
        }
        if (count >= maxCount) {
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.SEND_SMS_COUNT_TOO_SOON);
        }
        OrgSignupOnlinePay onlinePay = new OrgSignupOnlinePay();
        onlinePay.setCreateTime(new Date());
        onlinePay.setPurchaseId(signupPurchaseId);
        onlinePay.setOrgId(orgId);
        onlinePay.setToMobile(mobile);
        String smsKey = MD5Utils.MD5((String)("TTS_SIGNUP_KEY" + signupPurchaseId + mobile + System.currentTimeMillis()));
        onlinePay.setSmsKey(smsKey);
        this.orgSignupOninePayDao.save((Object)onlinePay, new String[0]);
        purchase.setPayType(Integer.valueOf(PayType.ONLINE_PAYMENT.getCode()));
        this.orgSignupInfoDao.update((Object)purchase, new String[]{"payType"});
        return this.createAndSaveTtsSms(onlinePay.getId(), mobile, this.buildSmsContent("\u60a8\u6b63\u5728\u62a5\u540d\u300e%s\u300f\u7684%s\u3002\u8d39\u7528%s\u5143\u3002\u70b9\u51fb\u94fe\u63a5\u5b8c\u6210\u7f34\u8d39\uff1a%s", purchase, smsKey));
    }

    private String buildSmsContent(String smsTemplate, OrgSignupInfo purchase, String smsKey) {
        log.debug("buildSmsContent  purchaseId = {}", (Object)purchase.getSignupPurchaseId());
        List courses = this.orgSignupCourseDao.loadByPurchaseId(purchase.getSignupPurchaseId(), new String[]{"orgCourseId", "originPrice", "payPrice"});
        HashSet courseIds = Sets.newHashSet();
        CollectionUtils.collect((Iterable)courses, (Transformer)new Transformer<OrgSignupCourse, Long>(){

            public Long transform(OrgSignupCourse input) {
                return input.getOrgCourseId();
            }
        }, (Collection)courseIds);
        Map courseName = this.orgCourseDao.getCourseNameMap((Collection)courseIds);
        log.debug("courseIds = {} courseName={}", (Object)courseIds, (Object)courseName);
        String orgName = this.orgInfoDao.getOrgShortNameByOrgId(Integer.valueOf(purchase.getOrgId().intValue()));
        String cName = null;
        for (OrgSignupCourse course : courses) {
            if (cName != null) continue;
            cName = "\u300e" + (String)courseName.get(course.getOrgCourseId()) + "\u300f";
        }
        String h5Url = ShortUrlUtil.getShortUrl((String)(UrlProperties.getProperty((String)"signup.online.pay.url") + "?smsKey=" + smsKey));
        if (courseName.size() > 1) {
            cName = cName + "\u7b49\u8bfe\u7a0b";
        }
        return String.format(smsTemplate, orgName, cName, purchase.getTotalPrices().doubleValue() / 100.0, h5Url);
    }

    @Override
    public boolean sendSignUpSms(@NonNull Long signupPurchaseId, @NonNull Long orgId, @NonNull String mobile) throws BussinessException {
        if (signupPurchaseId == null) {
            throw new NullPointerException("signupPurchaseId");
        }
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        if (mobile == null) {
            throw new NullPointerException("mobile");
        }
        log.info("sendSignUpSms signupPurchaseId={},orgId={},mobile={}", new Object[]{signupPurchaseId, orgId, mobile});
        OrgSignupInfo purchase = this.orgSignupInfoDao.searchByPurchaseId(signupPurchaseId, new String[0]);
        if (!ParamValidateUtils.validateMobile((String)mobile)) {
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.MOBILE_FORMATE_ERROR);
        }
        if (purchase == null || !purchase.getOrgId().equals(orgId)) {
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.PURCHASE_ID_INVALIDATE);
        }
        int count = this.orgSignupOninePayDao.countByMobileAndPurchaseId(signupPurchaseId, mobile, DateUtils.getToday());
        log.debug("count={}", (Object)count);
        String maxCountStr = UrlProperties.getProperty((String)"max.signup.count");
        int maxCount = 3;
        if (StringUtils.isNumeric((String)maxCountStr)) {
            maxCount = Integer.parseInt(maxCountStr);
        }
        if (count >= maxCount) {
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.SEND_SMS_COUNT_TOO_SOON);
        }
        OrgSignupOnlinePay onlinePay = new OrgSignupOnlinePay();
        onlinePay.setCreateTime(new Date());
        onlinePay.setPurchaseId(signupPurchaseId);
        onlinePay.setOrgId(orgId);
        onlinePay.setToMobile(mobile);
        String smsKey = MD5Utils.MD5((String)("TTS_SIGNUP_KEY" + signupPurchaseId + mobile + System.currentTimeMillis()));
        onlinePay.setSmsKey(smsKey);
        this.orgSignupOninePayDao.save((Object)onlinePay, new String[0]);
        return this.createAndSaveTtsSms(onlinePay.getId(), mobile, this.buildSmsContent("\u606d\u559c\u60a8\u6210\u529f\u62a5\u540d\u300e%s\u300f\u7684%s\u3002\u8d39\u7528%s\u5143\u3002\u70b9\u51fb\u94fe\u63a5\u67e5\u770b\u62a5\u540d\u51ed\u8bc1\uff1a%s", purchase, smsKey));
    }

    private boolean createAndSaveTtsSms(Long onlinePayId, String mobile, String content) {
        TtsSms sms = new TtsSms();
        sms.setContent(content);
        sms.setMessageType((Number)SmsMessageType.NOTIFY.getCode());
        sms.setMobile(mobile);
        boolean sendResult = SmsSendUtil.sendSms((String)mobile, (String)content, (Integer)SmsMessageType.NOTIFY.getCode(), null, null, (boolean)true);
        sms.setSendResult((Number)(sendResult ? SmsSendResult.SUCCESS.getValue() : SmsSendResult.FAILED.getValue()));
        sms.setSendSmsKey(onlinePayId);
        try {
            this.ttsSmsDao.save((Object)sms, new String[0]);
        }
        catch (Exception e) {
            log.warn("save sms record catch error:{}", (Throwable)e);
        }
        log.info("send sms to :{},onlinePayId:{} is succ:{}", new Object[]{mobile, onlinePayId, sendResult});
        return sendResult;
    }

    private Map<Long, List<String>> getCourseIdTeacherNamesMap(Collection<Long> courseIds) {
        List orgCourseTeachers = this.orgCourseTeacherDao.getOrgCourseTeacher(courseIds, null);
        if (CollectionUtils.isNotEmpty((Collection)orgCourseTeachers)) {
            HashMap result = Maps.newHashMap();
            HashSet teacherIds = Sets.newHashSet();
            for (OrgCourseTeacher orgCourseTeacher : orgCourseTeachers) {
                teacherIds.add(orgCourseTeacher.getUserId());
            }
            Map teacherNames = this.teacherDao.getTeacherRealNameMap((Collection)teacherIds);
            for (OrgCourseTeacher orgCourseTeacher : orgCourseTeachers) {
                Long courseId = orgCourseTeacher.getOrgCourseId();
                if (!result.containsKey(courseId)) {
                    result.put(courseId, Lists.newArrayList());
                }
                ((List)result.get(courseId)).add(teacherNames.get(orgCourseTeacher.getUserId()));
            }
            return result;
        }
        return Collections.emptyMap();
    }
}

