/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.room.service.impl;

import com.baijia.tianxiao.constant.InClassStatus;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassRoomDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseRoomDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonConflictDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherLessonDao;
import com.baijia.tianxiao.dal.org.po.OrgClassRoom;
import com.baijia.tianxiao.dal.org.po.OrgCourseRoom;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.room.dto.AppClassRoomDto;
import com.baijia.tianxiao.sal.room.dto.ClassRoomDto;
import com.baijia.tianxiao.sal.room.dto.RoomCountDto;
import com.baijia.tianxiao.sal.room.dto.RoomDto;
import com.baijia.tianxiao.sal.room.service.ClassRoomService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.BaseUtils;
import com.baijia.tianxiao.util.HanZiPinYinUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ClassRoomServiceImpl
implements ClassRoomService {
    private static final Logger log = LoggerFactory.getLogger(ClassRoomServiceImpl.class);
    @Resource
    private OrgClassRoomDao orgClassRoomDao;
    @Resource
    private OrgCourseRoomDao orgCourseRoomDao;
    @Resource
    private OrgClassLessonDao orgClassLessonDao;
    @Resource
    private OrgTeacherLessonDao orgTeacherLessonDao;
    @Resource
    private OrgLessonConflictDao orgLessonConflictDao;

    @Override
    public ClassRoomDto saveOrUpdateClassRoom(Long orgId, ClassRoomDto params) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        params.setOrgId(orgId);
        params.validate();
        OrgClassRoom classRoom = ClassRoomDto.converPo(params);
        if (params.getRoomId() != null && params.getRoomId() > 0L) {
            this.orgClassRoomDao.update((Object)classRoom, new String[0]);
        } else {
            if (classRoom.getBranchId() == null) {
                classRoom.setBranchId(Long.valueOf(0L));
            }
            this.orgClassRoomDao.save((Object)classRoom, new String[0]);
            params.setRoomId(classRoom.getId());
        }
        OrgClassRoom temp = (OrgClassRoom)this.orgClassRoomDao.getById((Serializable)params.getRoomId(), new String[0]);
        params.setRecycleStatus(temp.getRecycleStatus());
        params.setBranchId(temp.getBranchId());
        params.setCreateTime(temp.getCreateTime());
        params.setUpdateTime(temp.getUpdateTime());
        List lessons = this.orgClassLessonDao.getStartLessons(orgId, params.getRoomId(), new Date());
        params.setClassRecord(lessons.size() > 0 ? 1 : 0);
        return params;
    }

    @Override
    public void delClassRoom(Long orgId, Long roomId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((roomId != null && roomId > 0L ? 1 : 0) != 0, (Object)"roomId is illegal");
        List lessons = this.orgClassLessonDao.getStartLessons(orgId, roomId, new Date());
        if (CollectionUtils.isNotEmpty((Collection)lessons)) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6709\u4e0a\u8bfe\u8bb0\u5f55\u7684\u6559\u5ba4\u65e0\u6cd5\u6e05\u9664");
        }
        this.orgCourseRoomDao.delCourseRoom(orgId, null, (Collection)Lists.newArrayList((Object[])new Long[]{roomId}));
        this.orgClassRoomDao.delLogicallyById(roomId.longValue());
    }

    @Override
    public List<ClassRoomDto> listOrgClassRooms(Long orgId, Long branchId, Long courseId, PageDto page) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        List classRooms = this.orgClassRoomDao.getClassRoom(orgId, null, branchId, Boolean.valueOf(false), Integer.valueOf(DeleteStatus.NORMAL.getValue()), page, new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)classRooms)) {
            ArrayList result = Lists.newArrayList();
            HashSet courseRoomIds = Sets.newHashSet();
            if (courseId != null && courseId > 0L) {
                courseRoomIds.addAll(this.orgCourseRoomDao.getCourseRoomIds(orgId, courseId));
            }
            for (OrgClassRoom classRoom : classRooms) {
                if (courseRoomIds.contains(classRoom.getId())) continue;
                result.add(ClassRoomDto.covert2Dto(classRoom));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public List<AppClassRoomDto> listOrgClassRoomsWithCourse(String key, Long orgId, Long courseId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        List classRooms = this.orgClassRoomDao.getClassRoom(orgId, key, null, Boolean.valueOf(false), Integer.valueOf(DeleteStatus.NORMAL.getValue()), null, new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)classRooms)) {
            ArrayList result = Lists.newArrayList();
            HashSet courseRoomIds = Sets.newHashSet();
            if (courseId != null && courseId > 0L) {
                courseRoomIds.addAll(this.orgCourseRoomDao.getCourseRoomIds(orgId, courseId));
            }
            for (OrgClassRoom classRoom : classRooms) {
                AppClassRoomDto dto = new AppClassRoomDto();
                if (courseRoomIds.contains(classRoom.getId())) {
                    dto.setChosen(InClassStatus.YES.isCode());
                }
                dto.setInitial(HanZiPinYinUtils.getInitialStr((String)classRoom.getRoomName()));
                dto.setRoomId(classRoom.getId());
                dto.setRoomName(classRoom.getRoomName());
                dto.setRoomSize(classRoom.getRoomSize());
                result.add(dto);
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public void addClassRoomCourse(Long orgId, Long courseId, Collection<Long> roomIds) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((courseId != null && courseId > 0L ? 1 : 0) != 0, (Object)"courseId is illegal");
        if (CollectionUtils.isEmpty(roomIds)) {
            log.warn("room ids is empty.");
            return;
        }
        log.info("add roomids:{} into course :{},orgId:{}", new Object[]{roomIds, courseId, orgId});
        List courseRooms = this.orgCourseRoomDao.getCourseRoomList(orgId, courseId, new String[0]);
        boolean hasDefault = false;
        if (CollectionUtils.isNotEmpty((Collection)courseRooms)) {
            for (OrgCourseRoom courseRoom : courseRooms) {
                roomIds.remove(courseRoom.getRoomId());
                hasDefault |= courseRoom.isDefault();
            }
        }
        boolean bl = hasDefault = !hasDefault;
        if (CollectionUtils.isNotEmpty(roomIds)) {
            ArrayList saveCourseRooms = Lists.newArrayList();
            List classRooms = this.orgClassRoomDao.getByIds(roomIds, new String[]{"orgId", "id", "delStatus"});
            OrgCourseRoom courseRoom = null;
            for (OrgClassRoom room : classRooms) {
                if (!orgId.equals(room.getOrgId()) || room.isDelStatus()) {
                    log.warn("room id :{} is not in current orgId:{}", (Object)room.getId(), (Object)room.getOrgId());
                    continue;
                }
                courseRoom = new OrgCourseRoom();
                courseRoom.setCourseId(courseId);
                courseRoom.setIsDefault(hasDefault);
                courseRoom.setOrgId(orgId);
                courseRoom.setRoomId(room.getId());
                hasDefault = false;
                saveCourseRooms.add(courseRoom);
            }
            log.debug("save course room :{}", (Object)saveCourseRooms);
            this.orgCourseRoomDao.saveAll((List)saveCourseRooms, new String[]{"courseId", "isDefault", "orgId", "roomId"});
        }
    }

    @Override
    public void delClassRoomFromCourse(Long orgId, Long courseId, Collection<Long> roomIds) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((courseId != null && courseId > 0L ? 1 : 0) != 0, (Object)"courseId is illegal");
        if (CollectionUtils.isEmpty(roomIds)) {
            log.warn("room ids is empty.");
            return;
        }
        this.orgCourseRoomDao.delCourseRoom(orgId, courseId, roomIds);
        List lessonIds = this.orgClassLessonDao.getLeftLessonIds(orgId, courseId);
        if (CollectionUtils.isNotEmpty((Collection)lessonIds)) {
            int result = this.orgClassLessonDao.updateLessonClassRoom(orgId, (Collection)lessonIds, null);
            log.info("delete class room from lessonIds:{},result:{}", (Object)lessonIds, (Object)result);
        }
    }

    @Override
    public List<ClassRoomDto> listOrgCourseRooms(Long orgId, Long courseId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((courseId != null && courseId > 0L ? 1 : 0) != 0, (Object)"courseId is illegal");
        List courseRooms = this.orgCourseRoomDao.getCourseRoomList(orgId, courseId, new String[0]);
        if (CollectionUtils.isEmpty((Collection)courseRooms)) {
            return Collections.emptyList();
        }
        HashSet roomIds = Sets.newHashSet();
        Long defaultRoomId = null;
        for (OrgCourseRoom courseRoom : courseRooms) {
            roomIds.add(courseRoom.getRoomId());
            if (!courseRoom.isDefault()) continue;
            defaultRoomId = courseRoom.getRoomId();
        }
        List classRooms = this.orgClassRoomDao.getByIds((Collection)roomIds, new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)classRooms)) {
            ArrayList result = Lists.newArrayList();
            for (OrgClassRoom classRoom : classRooms) {
                ClassRoomDto dto = ClassRoomDto.covert2Dto(classRoom);
                if (classRoom.getId().equals(defaultRoomId)) {
                    dto.setIsDefault(1);
                }
                if (classRoom.getRecycleStatus().intValue() != DeleteStatus.NORMAL.getValue()) continue;
                result.add(dto);
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public void courseRoomSeting(Long orgId, Long courseId, Long roomId, boolean enable) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((courseId != null && courseId > 0L ? 1 : 0) != 0, (Object)"courseId is illegal");
        Preconditions.checkArgument((roomId != null && roomId > 0L ? 1 : 0) != 0, (Object)"roomId is illegal");
        log.info("set orgId:{} course:{} default room:{} : {}", new Object[]{orgId, courseId, roomId, enable});
        this.orgCourseRoomDao.courseDefaultRoomSet(orgId, courseId, roomId, enable);
    }

    @Override
    public ClassRoomDto info(Long orgId, Long roomId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((roomId != null && roomId > 0L ? 1 : 0) != 0, (Object)"roomId is illegal");
        OrgClassRoom classRoom = (OrgClassRoom)this.orgClassRoomDao.getById((Serializable)roomId, new String[0]);
        Preconditions.checkArgument((classRoom != null && classRoom.getOrgId().equals(orgId) ? 1 : 0) != 0, (Object)"\u6559\u5ba4ID\u4e0d\u6b63\u786e");
        ClassRoomDto dto = ClassRoomDto.covert2Dto(classRoom);
        List lessons = this.orgClassLessonDao.getStartLessons(orgId, dto.getRoomId(), new Date());
        log.debug("[class record size ]={}", (Object)lessons.size());
        dto.setClassRecord(lessons.size() > 0 ? 1 : 0);
        return dto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveCourseRooms(Long orgId, Long courseId, Collection<Long> roomIds) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((courseId != null && courseId > 0L ? 1 : 0) != 0, (Object)"courseId is illegal");
        if (roomIds == null) {
            roomIds = Lists.newArrayList();
        }
        List existRooms = this.orgCourseRoomDao.getCourseRoomIds(orgId, courseId);
        ArrayList tempRooms = Lists.newArrayList((Iterable)existRooms);
        ArrayList toDelRooms = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)roomIds)) {
            tempRooms.removeAll(roomIds);
        }
        toDelRooms.addAll(tempRooms);
        Map mapClassLesson = this.orgClassLessonDao.getClassLessonMap(orgId, courseId, Integer.valueOf(0), new String[]{"roomId"});
        Set usedRooms = BaseUtils.getPropertiesList((List)Lists.newArrayList(mapClassLesson.values()), (String)"roomId");
        for (Long roomId : toDelRooms) {
            if (!usedRooms.contains(roomId)) continue;
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5df2\u7ecf\u6392\u8bfe\u7684\u6559\u5ba4\u65e0\u6cd5\u5220\u9664");
        }
        if (CollectionUtils.isNotEmpty((Collection)toDelRooms)) {
            this.orgCourseRoomDao.delCourseRoom(orgId, courseId, (Collection)toDelRooms);
        }
        roomIds.removeAll(existRooms);
        if (CollectionUtils.isNotEmpty((Collection)roomIds)) {
            this.addClassRoomCourse(orgId, courseId, roomIds);
        }
    }

    @Override
    public List<OrgClassRoom> fuzzyQuery(Long orgId, String roomName) {
        List rooms = this.orgClassRoomDao.getOrgClassRoomByNameAndIds(orgId, null, roomName);
        return rooms;
    }

    @Override
    public List<RoomDto> listPcOrgClassRooms(Long orgId, String key, Long courseId, PageDto pageDto) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"\u673a\u6784id\u975e\u6cd5");
        Set orgCourseRoomIds = Sets.newHashSet();
        if (courseId != null && courseId > 0L) {
            List orgCourseRooms = this.orgCourseRoomDao.getCourseRoomList(orgId, courseId, new String[0]);
            orgCourseRoomIds = BaseUtils.getPropertiesList((List)orgCourseRooms, (String)"roomId");
        }
        List orgClassRooms = this.orgClassRoomDao.queryListByParam(orgId, key, (Collection)orgCourseRoomIds, pageDto);
        ArrayList roomDtos = Lists.newArrayList();
        for (OrgClassRoom orgClassRoom : orgClassRooms) {
            RoomDto roomDto = RoomDto.convertToDto(orgClassRoom);
            roomDtos.add(roomDto);
        }
        Collections.sort(roomDtos, new Comparator(){

            public int compare(Object object1, Object object2) {
                RoomDto info1 = (RoomDto)object1;
                RoomDto info2 = (RoomDto)object2;
                return Collator.getInstance(Locale.CHINESE).compare(info1.getName(), info2.getName());
            }
        });
        return roomDtos;
    }

    @Override
    public List<RoomDto> selectClassRoom(Long orgId, List<Long> teacherIds, List<Long> courseIds, Integer type) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"\u673a\u6784id\u975e\u6cd5");
        ArrayList teacherLessonIds = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(teacherIds)) {
            List orgTeacherLessons = this.orgTeacherLessonDao.queryTeacherLessons(orgId, teacherIds, new String[0]);
            Set lessonIds = BaseUtils.getPropertiesList((List)orgTeacherLessons, (String)"lessonId");
            teacherLessonIds.addAll(lessonIds);
        }
        ArrayList confictLessonIds = Lists.newArrayList();
        if (type == 1) {
            List confictLessons = this.orgLessonConflictDao.queryConfilctByTeacherIds(orgId, teacherIds);
            Set conflictSet = BaseUtils.getPropertiesList((List)confictLessons, (String)"lessonId");
            confictLessonIds.addAll(conflictSet);
        }
        List orgClassLesson = this.orgClassLessonDao.queryByParams(orgId, (List)teacherLessonIds, (List)confictLessonIds, courseIds);
        Set roomIds = BaseUtils.getPropertiesList((List)orgClassLesson, (String)"roomId");
        Map names = this.orgClassRoomDao.getRoomName(orgId, (Collection)roomIds);
        return RoomDto.convertToDto(names);
    }

    @Override
    public void deleteClassRoom(Long orgId, Long roomId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((roomId != null && roomId > 0L ? 1 : 0) != 0, (Object)"roomId is illegal");
        this.orgClassRoomDao.moveToRecycleBin(roomId.longValue());
    }

    @Override
    public void reuseClassRoom(Long orgId, Long roomId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((roomId != null && roomId > 0L ? 1 : 0) != 0, (Object)"roomId is illegal");
        this.orgClassRoomDao.removeFromRecycleBin(roomId.longValue());
    }

    @Override
    public RoomCountDto getClassRecordCount(Long orgId, Long branchId) {
        List classRooms = this.orgClassRoomDao.getOrgClassRoomsList(orgId, branchId, Integer.valueOf(DeleteStatus.DELETED.getValue()), null, null, null);
        log.debug("[org_id]={},[classroom size]={}", (Object)orgId, (Object)classRooms.size());
        List<Long> roomIds = this.getAllRoomId(classRooms);
        if (roomIds.size() == 0) {
            RoomCountDto dto = new RoomCountDto();
            dto.setAllDeletedCount(0);
            dto.setClassRecordCount(0);
            return dto;
        }
        Map map = this.orgClassLessonDao.getRoomClassRecordCount(orgId, roomIds);
        int count = 0;
        for (Integer i : map.values()) {
            if (i <= 0) continue;
            ++count;
        }
        RoomCountDto dto = new RoomCountDto();
        dto.setAllDeletedCount(classRooms.size());
        dto.setClassRecordCount(count);
        return dto;
    }

    private List<Long> getAllRoomId(List<OrgClassRoom> classRooms) {
        ArrayList roomIds = Lists.newArrayList();
        if (CollectionUtils.isEmpty(classRooms)) {
            return roomIds;
        }
        for (OrgClassRoom room : classRooms) {
            roomIds.add(room.getId());
        }
        return roomIds;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void clearAllClassRoom(Long orgId, Long branchId) {
        List classRooms = this.orgClassRoomDao.getOrgClassRoomsList(orgId, branchId, Integer.valueOf(DeleteStatus.DELETED.getValue()), null, null, null);
        if (CollectionUtils.isEmpty((Collection)classRooms)) {
            return;
        }
        List<Long> roomIds = this.getAllRoomId(classRooms);
        Map map = this.orgClassLessonDao.getRoomClassRecordCount(orgId, roomIds);
        Iterator<Long> it = roomIds.iterator();
        while (it.hasNext()) {
            Long roomId = it.next();
            Integer lessonNum = (Integer)map.get(roomId);
            if (lessonNum == null || lessonNum <= 0) continue;
            it.remove();
        }
        this.orgCourseRoomDao.delCourseRoom(orgId, null, (Collection)Lists.newArrayList(roomIds));
        for (Long roomId : roomIds) {
            this.orgClassRoomDao.delLogicallyById(roomId.longValue());
        }
    }

    @Override
    public List<Long> getRecycleRoomIdsByCourseId(Long orgId, Long courseId) {
        List courseRooms = this.orgCourseRoomDao.getCourseRoomList(orgId, courseId, new String[0]);
        if (CollectionUtils.isEmpty((Collection)courseRooms)) {
            return Collections.EMPTY_LIST;
        }
        HashSet roomIds = Sets.newHashSet();
        for (OrgCourseRoom courseRoom : courseRooms) {
            roomIds.add(courseRoom.getRoomId());
        }
        List recycleClassRoomIds = this.orgClassRoomDao.getRecycleRoomId(orgId, (Collection)roomIds);
        if (CollectionUtils.isEmpty((Collection)recycleClassRoomIds)) {
            return Collections.EMPTY_LIST;
        }
        return recycleClassRoomIds;
    }
}

