/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.room.dto;

import com.baijia.tianxiao.dal.org.po.OrgClassRoom;
import com.google.common.base.Preconditions;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class ClassRoomDto {
    private Long roomId;
    private Long orgId;
    private Long branchId;
    private String roomNumber;
    private String roomName;
    private String initial;
    private boolean isChosen = false;
    private Integer roomSize;
    private boolean delStatus;
    private Date createTime;
    private int isDefault;
    private Date updateTime;
    private Integer recycleStatus;
    private Date recycleTime;
    private Integer arrangedMinutes;
    private Integer arrangedCount;
    private Integer classRecord;

    public static OrgClassRoom converPo(ClassRoomDto dto) {
        Preconditions.checkNotNull((Object)dto);
        OrgClassRoom po = new OrgClassRoom();
        po.setBranchId(dto.getBranchId());
        po.setCreateTime(dto.getCreateTime());
        po.setDelStatus(dto.isDelStatus());
        po.setOrgId(dto.getOrgId());
        po.setId(dto.getRoomId());
        po.setRoomName(dto.getRoomName());
        po.setRoomNumber(dto.getRoomNumber());
        po.setRoomSize(dto.getRoomSize());
        return po;
    }

    public static ClassRoomDto covert2Dto(OrgClassRoom po) {
        Preconditions.checkNotNull((Object)po);
        ClassRoomDto dto = new ClassRoomDto();
        dto.setBranchId(po.getBranchId());
        dto.setCreateTime(po.getCreateTime());
        dto.setDelStatus(po.isDelStatus());
        dto.setOrgId(po.getOrgId());
        dto.setRoomId(po.getId());
        dto.setRoomName(po.getRoomName());
        dto.setRoomNumber(po.getRoomNumber());
        dto.setRoomSize(po.getRoomSize());
        dto.setUpdateTime(po.getUpdateTime());
        dto.setRecycleStatus(po.getRecycleStatus());
        dto.setRecycleTime(po.getRecycleTime());
        return dto;
    }

    public void validate() {
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.roomName}), (Object)"\u6559\u5ba4\u540d\u5b57\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((this.roomSize != null && this.roomSize > 0 && this.roomSize <= 999 ? 1 : 0) != 0, (Object)"\u6559\u5ba4\u5bb9\u91cf\u5fc5\u987b\u57281-999\u4e4b\u95f4");
    }

    public int compare(ClassRoomDto o2) {
        if (this.getArrangedMinutes() > o2.getArrangedMinutes()) {
            return 1;
        }
        if (this.getArrangedMinutes() < o2.getArrangedMinutes()) {
            return -1;
        }
        return 0;
    }

    public Long getRoomId() {
        return this.roomId;
    }

    public Long getOrgId() {
        return this.orgId;
    }

    public Long getBranchId() {
        return this.branchId;
    }

    public String getRoomNumber() {
        return this.roomNumber;
    }

    public String getRoomName() {
        return this.roomName;
    }

    public String getInitial() {
        return this.initial;
    }

    public boolean isChosen() {
        return this.isChosen;
    }

    public Integer getRoomSize() {
        return this.roomSize;
    }

    public boolean isDelStatus() {
        return this.delStatus;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public int getIsDefault() {
        return this.isDefault;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public Integer getRecycleStatus() {
        return this.recycleStatus;
    }

    public Date getRecycleTime() {
        return this.recycleTime;
    }

    public Integer getArrangedMinutes() {
        return this.arrangedMinutes;
    }

    public Integer getArrangedCount() {
        return this.arrangedCount;
    }

    public Integer getClassRecord() {
        return this.classRecord;
    }

    public void setRoomId(Long roomId) {
        this.roomId = roomId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public void setBranchId(Long branchId) {
        this.branchId = branchId;
    }

    public void setRoomNumber(String roomNumber) {
        this.roomNumber = roomNumber;
    }

    public void setRoomName(String roomName) {
        this.roomName = roomName;
    }

    public void setInitial(String initial) {
        this.initial = initial;
    }

    public void setChosen(boolean isChosen) {
        this.isChosen = isChosen;
    }

    public void setRoomSize(Integer roomSize) {
        this.roomSize = roomSize;
    }

    public void setDelStatus(boolean delStatus) {
        this.delStatus = delStatus;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setIsDefault(int isDefault) {
        this.isDefault = isDefault;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public void setRecycleStatus(Integer recycleStatus) {
        this.recycleStatus = recycleStatus;
    }

    public void setRecycleTime(Date recycleTime) {
        this.recycleTime = recycleTime;
    }

    public void setArrangedMinutes(Integer arrangedMinutes) {
        this.arrangedMinutes = arrangedMinutes;
    }

    public void setArrangedCount(Integer arrangedCount) {
        this.arrangedCount = arrangedCount;
    }

    public void setClassRecord(Integer classRecord) {
        this.classRecord = classRecord;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClassRoomDto)) {
            return false;
        }
        ClassRoomDto other = (ClassRoomDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$roomId = this.getRoomId();
        Long other$roomId = other.getRoomId();
        if (this$roomId == null ? other$roomId != null : !((Object)this$roomId).equals(other$roomId)) {
            return false;
        }
        Long this$orgId = this.getOrgId();
        Long other$orgId = other.getOrgId();
        if (this$orgId == null ? other$orgId != null : !((Object)this$orgId).equals(other$orgId)) {
            return false;
        }
        Long this$branchId = this.getBranchId();
        Long other$branchId = other.getBranchId();
        if (this$branchId == null ? other$branchId != null : !((Object)this$branchId).equals(other$branchId)) {
            return false;
        }
        String this$roomNumber = this.getRoomNumber();
        String other$roomNumber = other.getRoomNumber();
        if (this$roomNumber == null ? other$roomNumber != null : !this$roomNumber.equals(other$roomNumber)) {
            return false;
        }
        String this$roomName = this.getRoomName();
        String other$roomName = other.getRoomName();
        if (this$roomName == null ? other$roomName != null : !this$roomName.equals(other$roomName)) {
            return false;
        }
        String this$initial = this.getInitial();
        String other$initial = other.getInitial();
        if (this$initial == null ? other$initial != null : !this$initial.equals(other$initial)) {
            return false;
        }
        if (this.isChosen() != other.isChosen()) {
            return false;
        }
        Integer this$roomSize = this.getRoomSize();
        Integer other$roomSize = other.getRoomSize();
        if (this$roomSize == null ? other$roomSize != null : !((Object)this$roomSize).equals(other$roomSize)) {
            return false;
        }
        if (this.isDelStatus() != other.isDelStatus()) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        if (this.getIsDefault() != other.getIsDefault()) {
            return false;
        }
        Date this$updateTime = this.getUpdateTime();
        Date other$updateTime = other.getUpdateTime();
        if (this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime)) {
            return false;
        }
        Integer this$recycleStatus = this.getRecycleStatus();
        Integer other$recycleStatus = other.getRecycleStatus();
        if (this$recycleStatus == null ? other$recycleStatus != null : !((Object)this$recycleStatus).equals(other$recycleStatus)) {
            return false;
        }
        Date this$recycleTime = this.getRecycleTime();
        Date other$recycleTime = other.getRecycleTime();
        if (this$recycleTime == null ? other$recycleTime != null : !((Object)this$recycleTime).equals(other$recycleTime)) {
            return false;
        }
        Integer this$arrangedMinutes = this.getArrangedMinutes();
        Integer other$arrangedMinutes = other.getArrangedMinutes();
        if (this$arrangedMinutes == null ? other$arrangedMinutes != null : !((Object)this$arrangedMinutes).equals(other$arrangedMinutes)) {
            return false;
        }
        Integer this$arrangedCount = this.getArrangedCount();
        Integer other$arrangedCount = other.getArrangedCount();
        if (this$arrangedCount == null ? other$arrangedCount != null : !((Object)this$arrangedCount).equals(other$arrangedCount)) {
            return false;
        }
        Integer this$classRecord = this.getClassRecord();
        Integer other$classRecord = other.getClassRecord();
        return !(this$classRecord == null ? other$classRecord != null : !((Object)this$classRecord).equals(other$classRecord));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClassRoomDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $roomId = this.getRoomId();
        result = result * 59 + ($roomId == null ? 43 : ((Object)$roomId).hashCode());
        Long $orgId = this.getOrgId();
        result = result * 59 + ($orgId == null ? 43 : ((Object)$orgId).hashCode());
        Long $branchId = this.getBranchId();
        result = result * 59 + ($branchId == null ? 43 : ((Object)$branchId).hashCode());
        String $roomNumber = this.getRoomNumber();
        result = result * 59 + ($roomNumber == null ? 43 : $roomNumber.hashCode());
        String $roomName = this.getRoomName();
        result = result * 59 + ($roomName == null ? 43 : $roomName.hashCode());
        String $initial = this.getInitial();
        result = result * 59 + ($initial == null ? 43 : $initial.hashCode());
        result = result * 59 + (this.isChosen() ? 79 : 97);
        Integer $roomSize = this.getRoomSize();
        result = result * 59 + ($roomSize == null ? 43 : ((Object)$roomSize).hashCode());
        result = result * 59 + (this.isDelStatus() ? 79 : 97);
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        result = result * 59 + this.getIsDefault();
        Date $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        Integer $recycleStatus = this.getRecycleStatus();
        result = result * 59 + ($recycleStatus == null ? 43 : ((Object)$recycleStatus).hashCode());
        Date $recycleTime = this.getRecycleTime();
        result = result * 59 + ($recycleTime == null ? 43 : ((Object)$recycleTime).hashCode());
        Integer $arrangedMinutes = this.getArrangedMinutes();
        result = result * 59 + ($arrangedMinutes == null ? 43 : ((Object)$arrangedMinutes).hashCode());
        Integer $arrangedCount = this.getArrangedCount();
        result = result * 59 + ($arrangedCount == null ? 43 : ((Object)$arrangedCount).hashCode());
        Integer $classRecord = this.getClassRecord();
        result = result * 59 + ($classRecord == null ? 43 : ((Object)$classRecord).hashCode());
        return result;
    }

    public String toString() {
        return "ClassRoomDto(roomId=" + this.getRoomId() + ", orgId=" + this.getOrgId() + ", branchId=" + this.getBranchId() + ", roomNumber=" + this.getRoomNumber() + ", roomName=" + this.getRoomName() + ", initial=" + this.getInitial() + ", isChosen=" + this.isChosen() + ", roomSize=" + this.getRoomSize() + ", delStatus=" + this.isDelStatus() + ", createTime=" + this.getCreateTime() + ", isDefault=" + this.getIsDefault() + ", updateTime=" + this.getUpdateTime() + ", recycleStatus=" + this.getRecycleStatus() + ", recycleTime=" + this.getRecycleTime() + ", arrangedMinutes=" + this.getArrangedMinutes() + ", arrangedCount=" + this.getArrangedCount() + ", classRecord=" + this.getClassRecord() + ")";
    }
}

