
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.room.dto;

import com.baijia.tianxiao.dal.org.po.OrgClassRoom;
import com.google.common.base.Preconditions;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.util.Date;

/**
 * @author cxm
 * @version 1.0
 * @title ClassRoomDto
 * @desc TODO
 * @date 2015年12月24日
 */
@Data
public class ClassRoomDto {

    private Long roomId;

    private Long orgId;

    private Long branchId;

    private String roomNumber;

    private String roomName;

    private String initial;//名称首字母

    private boolean isChosen = false;// 是否被选择在班级里

    private Integer roomSize;

    private boolean delStatus;

    private Date createTime;

    private int isDefault;

    private Date updateTime;

    private Integer recycleStatus;

    private Date recycleTime;

    private Integer arrangedMinutes;

    private Integer arrangedCount;

    private Integer classRecord; //上课记录标签，0=没有，1=有

    public static OrgClassRoom converPo(ClassRoomDto dto) {
        Preconditions.checkNotNull(dto);
        OrgClassRoom po = new OrgClassRoom();
        po.setBranchId(dto.getBranchId());
        po.setCreateTime(dto.getCreateTime());
        po.setDelStatus(dto.isDelStatus());
        po.setOrgId(dto.getOrgId());
        po.setId(dto.getRoomId());
        po.setRoomName(dto.getRoomName());
        po.setRoomNumber(dto.getRoomNumber());
        po.setRoomSize(dto.getRoomSize());
        return po;
    }

    public static ClassRoomDto covert2Dto(OrgClassRoom po) {
        Preconditions.checkNotNull(po);
        ClassRoomDto dto = new ClassRoomDto();
        dto.setBranchId(po.getBranchId());
        dto.setCreateTime(po.getCreateTime());
        dto.setDelStatus(po.isDelStatus());
        dto.setOrgId(po.getOrgId());
        dto.setRoomId(po.getId());
        dto.setRoomName(po.getRoomName());
        dto.setRoomNumber(po.getRoomNumber());
        dto.setRoomSize(po.getRoomSize());
        dto.setUpdateTime(po.getUpdateTime());
        dto.setRecycleStatus(po.getRecycleStatus());
        dto.setRecycleTime(po.getRecycleTime());
        return dto;
    }

    public void validate() {
        Preconditions.checkArgument(StringUtils.isNoneBlank(roomName), "教室名字不能为空");
        Preconditions.checkArgument(roomSize != null && roomSize > 0 && roomSize <= 999, "教室容量必须在1-999之间");

    }

    public int compare(ClassRoomDto o2){
        if(this.getArrangedMinutes() > o2.getArrangedMinutes()){
            return 1;
        }else if(this.getArrangedMinutes() < o2.getArrangedMinutes()){
            return -1;
        }else{
            return 0;
        }
    }
}
