
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.room.service;

import java.util.Collection;
import java.util.List;

import com.baijia.tianxiao.dal.org.po.OrgClassRoom;
import com.baijia.tianxiao.sal.room.dto.AppClassRoomDto;
import com.baijia.tianxiao.sal.room.dto.ClassRoomDto;
import com.baijia.tianxiao.sal.room.dto.RoomDto;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;

/**
 * @title ClassRoomService
 * @desc TODO
 * @author cxm
 * @date 2015年12月24日
 * @version 1.0
 */
public interface ClassRoomService {

    /**
     * 查询机构的教室
     * 
     * @param orgId
     * @param branchId
     * @return
     */
    List<ClassRoomDto> listOrgClassRooms(Long orgId, Long branchId, Long courseId, PageDto page);

    /**
     * 教室列表带是否属于该班级标识
     * @param key
     * @param orgId
     * @param courseId
     * @return
     */
    List<AppClassRoomDto> listOrgClassRoomsWithCourse(String key, Long orgId, Long courseId);

    /**
     * 将教室添加到指定
     * 
     * @param orgId
     * @param courseId
     * @param roomIds
     */
    void addClassRoomCourse(Long orgId, Long courseId, Collection<Long> roomIds);

    /**
     * 从课程的教室列表中
     * 
     * @param orgId
     * @param courseId
     * @param roomIds
     */
    void delClassRoomFromCourse(Long orgId, Long courseId, Collection<Long> roomIds);

    /**
     * 查询机构指定课程对应的教室
     * 
     * @param orgId
     * @param courseId
     * @return
     */
    List<ClassRoomDto> listOrgCourseRooms(Long orgId, Long courseId);

    /**
     * 课程默认教室设置
     * 
     * @param orgId
     * @param courseId
     * @param roomId
     * @param enable
     */
    void courseRoomSeting(Long orgId, Long courseId, Long roomId, boolean enable);

    /**
     * 删除教室
     * 
     * @param orgId
     * @param roomId
     */
    void delClassRoom(Long orgId, Long roomId);

    /**
     * @param params
     * @return
     */
    ClassRoomDto saveOrUpdateClassRoom(Long orgId, ClassRoomDto params);

    /**
     * 查看教室详情
     * 
     * @param orgId
     * @param roomId
     * @return
     */
    ClassRoomDto info(Long orgId, Long roomId);
    
    /**
     * 新建/编辑班级时，保存班级教室
     * @param orgId
     * @param courseId
     * @param roomIds 教室id: 包括现存、待添加、待删除教室
     * @return
     */
    void saveCourseRooms(Long orgId, Long courseId, Collection<Long> roomIds);
    
    /**
    * 根据教室名称模糊查询教室列表
     * @param orgId
     * @param roomName
     * @return
     */
    List<OrgClassRoom> fuzzyQuery(Long orgId, String roomName);

    /**
     * 根据查询字符串模糊检索得到指定机构的教室信息
     * @param orgId：机构id
     * @param key：查询字符串
     * @param courseId：课程／班级id
     * @param pageDto：页码信息
     * @return
     */
	List<RoomDto> listPcOrgClassRooms(Long orgId, String key, Long courseId, PageDto pageDto);

	/**
	 * 根据筛选条件获取满足条件的教室列表
	 * @param teacherIds：教师id集合
	 * @param courseIds：课程id集合
	 * @param type：筛选类型
	 * @return
	 */
	List<RoomDto> selectClassRoom(Long orgId, List<Long> teacherIds, List<Long> courseIds, Integer type);
}
