/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.push.service.impl;

import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.pcAuthority.dao.TxAccountPermissionDao;
import com.baijia.tianxiao.dal.pcAuthority.po.TxAccountPermission;
import com.baijia.tianxiao.dal.push.constant.MsgSettingStatus;
import com.baijia.tianxiao.dal.push.constant.MsgUserRole;
import com.baijia.tianxiao.dal.push.dao.AccountMsgSettingDao;
import com.baijia.tianxiao.dal.push.po.AccountMsgSetting;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CrmErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.redis.AbstractBaseRedisDao;
import com.baijia.tianxiao.sal.push.dto.ConsultAvatarUrlAndNameDto;
import com.baijia.tianxiao.sal.push.service.ConsultAvatarUrlService;
import com.baijia.tianxiao.sal.push.service.PushRedisService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.stereotype.Service;

@Service
public class PushRedisServiceImpl
extends AbstractBaseRedisDao<String, Object>
implements PushRedisService {
    private static final Logger log = LoggerFactory.getLogger(PushRedisServiceImpl.class);
    private static final String LAST_PUSH_NO_HASH = "TX#LAST#PUSH#NO#HASH";
    private static final String CONSULT_USER_AVATAR_HASH = "TX#CONSULT#USER#AVATAR#HASH";
    private static final String ORG_ACCOUNT_TYPE = "TX#ORG#ACCOUNT#TYPE#HASH";
    @Autowired
    private TXCascadeAccountDao cascadeAccountDao;
    @Autowired
    private OrgSubAccountDao orgSubAccountDao;
    @Autowired
    private AccountMsgSettingDao accountMsgSettingDao;
    @Autowired
    private TxAccountPermissionDao permissionDao;
    @Autowired
    private ConsultAvatarUrlService avatarUrlService;

    @Override
    public Integer getConsultUserCount(final Long orgId) {
        return (Integer)this.redisTemplate.execute((RedisCallback)new RedisCallback<Integer>(){

            public Integer doInRedis(RedisConnection connection) throws DataAccessException {
                log.info("[Redis] Query start.");
                connection.select(6);
                RedisSerializer serializer = PushRedisServiceImpl.this.getRedisSerializer();
                byte[] key = serializer.serialize((Object)PushRedisServiceImpl.LAST_PUSH_NO_HASH);
                byte[] field = serializer.serialize((Object)orgId.toString());
                byte[] value = connection.hGet(key, field);
                log.info("[Redis] Query success===");
                if (value == null) {
                    return 0;
                }
                int result = Integer.parseInt((String)serializer.deserialize(value));
                log.info("[Redis] Query Result =" + result);
                return result;
            }
        });
    }

    @Override
    public void addConsultUserCount(final Long orgId) {
        this.redisTemplate.execute((RedisCallback)new RedisCallback<Object>(){

            public Object doInRedis(RedisConnection connection) throws DataAccessException {
                connection.select(6);
                RedisSerializer serializer = PushRedisServiceImpl.this.getRedisSerializer();
                byte[] key = serializer.serialize((Object)PushRedisServiceImpl.LAST_PUSH_NO_HASH);
                byte[] field = serializer.serialize((Object)orgId.toString());
                connection.hIncrBy(key, field, 1L);
                log.info("[Redis] Update success. orgId=" + orgId);
                return null;
            }
        });
    }

    @Override
    public List<Integer> getCascadeIds(Long orgId) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        List cascadeAccounts = this.cascadeAccountDao.getTXCascadeAccountListByOrgId(orgId);
        if (cascadeAccounts != null && cascadeAccounts.size() > 0) {
            for (Object account : cascadeAccounts) {
                ids.add(account.getId());
            }
            List permissions = this.permissionDao.selectPermission(ids, Long.valueOf(105L));
            log.info("[Switch] permissions cascadeIds=" + permissions);
            if (permissions != null) {
                for (TxAccountPermission tp : permissions) {
                    if (tp.getPType() != 1) continue;
                    log.info("[Switch] No permission,cascadeId=" + tp.getUId());
                    ids.remove(tp.getUId());
                }
            }
            ids.add(0, 0);
            List settings = this.accountMsgSettingDao.getAccountMsgSettingList(orgId, ids);
            ArrayList<Integer> closeIds = new ArrayList<Integer>();
            for (AccountMsgSetting setting : settings) {
                if (setting.getMsgSwitch() != MsgSettingStatus.CLOSE.getValue()) continue;
                closeIds.add(setting.getCascadeId());
            }
            log.info("[Switch] all cascadeIds=" + ids);
            log.info("[Switch] close cascadeIds=" + closeIds);
            ids.removeAll(closeIds);
            return ids;
        }
        return ids;
    }

    @Override
    public void setOrgAccountType(final Long orgId, final Integer cascadeId, final int type) {
        this.redisTemplate.execute((RedisCallback)new RedisCallback<Object>(){

            public Object doInRedis(RedisConnection connection) throws DataAccessException {
                connection.select(6);
                RedisSerializer serializer = PushRedisServiceImpl.this.getRedisSerializer();
                byte[] key = serializer.serialize((Object)PushRedisServiceImpl.ORG_ACCOUNT_TYPE);
                byte[] field = serializer.serialize((Object)PushRedisServiceImpl.this.getKey(orgId, cascadeId));
                connection.hIncrBy(key, field, (long)type);
                log.info("[Redis] Update success. orgId={},cascadeId={},type={}", new Object[]{orgId, cascadeId, type});
                return null;
            }
        });
    }

    @Override
    public int getOrgAccountType(final Long orgId, final Integer cascadeId) {
        Integer accountType = (Integer)this.redisTemplate.execute((RedisCallback)new RedisCallback<Integer>(){

            public Integer doInRedis(RedisConnection connection) throws DataAccessException {
                connection.select(6);
                RedisSerializer serializer = PushRedisServiceImpl.this.getRedisSerializer();
                byte[] key = serializer.serialize((Object)PushRedisServiceImpl.ORG_ACCOUNT_TYPE);
                byte[] field = serializer.serialize((Object)PushRedisServiceImpl.this.getKey(orgId, cascadeId));
                RedisSerializer redisSerializer = PushRedisServiceImpl.this.redisTemplate.getDefaultSerializer();
                byte[] value = connection.hGet(key, field);
                log.info("[Redis] Query success.");
                if (value != null) {
                    return null;
                }
                return (Integer)redisSerializer.deserialize(value);
            }
        });
        if (accountType == null) {
            accountType = this.getAccountTypeFromDb(orgId, cascadeId);
            this.setOrgAccountType(orgId, cascadeId, accountType);
        }
        return accountType;
    }

    private int getAccountTypeFromDb(Long orgId, Integer cascadeId) {
        if (cascadeId == null || cascadeId == 0) {
            OrgSubAccount subAccount = this.orgSubAccountDao.getMasterByOrgId(Integer.valueOf(orgId.intValue()));
            log.debug("OrgId=" + orgId + ";OrgSubAccount=" + subAccount);
            if (subAccount != null) {
                return MsgUserRole.HEADER.getValue();
            }
            return MsgUserRole.BRANCH_HEADER.getValue();
        }
        TXCascadeAccount cascadeAccount = (TXCascadeAccount)this.cascadeAccountDao.getById((Serializable)cascadeId, new String[0]);
        if (!MsgUserRole.isSubOrg((int)cascadeAccount.getAccountType())) {
            throw new BussinessException((UniverseErrorCode)CrmErrorCode.ORG_ACCOUNT_TYPE_ERROR);
        }
        return cascadeAccount.getAccountType();
    }

    private String getKey(Long orgId, Integer cascadeId) {
        if (cascadeId == null) {
            cascadeId = 0;
        }
        return orgId + "_" + cascadeId;
    }

    @Override
    public void setAvatar(final long consultUserId, final String url) {
        try {
            this.redisTemplate.execute((RedisCallback)new RedisCallback<Object>(){

                public Object doInRedis(RedisConnection connection) throws DataAccessException {
                    connection.select(6);
                    RedisSerializer serializer = PushRedisServiceImpl.this.getRedisSerializer();
                    byte[] key = serializer.serialize((Object)PushRedisServiceImpl.CONSULT_USER_AVATAR_HASH);
                    byte[] field = serializer.serialize((Object)String.valueOf(consultUserId));
                    byte[] value = serializer.serialize((Object)url);
                    connection.hSet(key, field, value);
                    return null;
                }
            });
        }
        catch (Exception e) {
            log.error("[Redis] Exception {}", (Throwable)e);
        }
    }

    @Override
    public void setAvatar(long consultUserId) {
        try {
            ConsultAvatarUrlAndNameDto dto = this.avatarUrlService.getConsultAvatarUrl(consultUserId);
            this.setAvatar(consultUserId, dto.getAvatarUrl());
        }
        catch (Exception e) {
            log.error("[Redis] Exception {}", (Throwable)e);
        }
    }

    @Override
    public String getAvatar(final long consultUserId) {
        String avatar = null;
        try {
            avatar = (String)this.redisTemplate.execute((RedisCallback)new RedisCallback<String>(){

                public String doInRedis(RedisConnection connection) throws DataAccessException {
                    connection.select(6);
                    RedisSerializer serializer = PushRedisServiceImpl.this.getRedisSerializer();
                    byte[] key = serializer.serialize((Object)PushRedisServiceImpl.ORG_ACCOUNT_TYPE);
                    byte[] field = serializer.serialize((Object)String.valueOf(consultUserId));
                    byte[] value = connection.hGet(key, field);
                    if (value != null) {
                        return (String)serializer.deserialize(value);
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            log.error("[Redis] Exception {}", (Throwable)e);
        }
        return avatar;
    }
}

