/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.push.service.impl;

import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.storage.dao.StorageDao;
import com.baijia.tianxiao.dal.storage.po.Storage;
import com.baijia.tianxiao.dal.user.dao.StudentDao;
import com.baijia.tianxiao.dal.user.po.Student;
import com.baijia.tianxiao.dal.wechat.dao.FansDao;
import com.baijia.tianxiao.dal.wechat.po.Fans;
import com.baijia.tianxiao.sal.push.dto.ConsultAvatarUrlAndNameDto;
import com.baijia.tianxiao.sal.push.service.ConsultAvatarUrlService;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.storage.StorageUtil;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConsultAvatarUrlServiceImpl
implements ConsultAvatarUrlService {
    private static final Logger log = LoggerFactory.getLogger(ConsultAvatarUrlServiceImpl.class);
    @Autowired
    private TxConsultUserDao txConsultUserDao;
    @Autowired
    private OrgStudentDao orgStudentDao;
    @Autowired
    private StudentDao studentDao;
    @Autowired
    private StorageDao storageDao;
    @Autowired
    private FansDao fansDao;
    @Autowired
    private OrgStorageDao orgStorageDao;

    @Override
    public ConsultAvatarUrlAndNameDto getConsultAvatarUrl(Long consultId) {
        String avatarUrl = null;
        String name = null;
        ConsultAvatarUrlAndNameDto consultAvatarUrlAndNameDto = new ConsultAvatarUrlAndNameDto();
        TxConsultUser txConsultUser = this.txConsultUserDao.getOrgConsultUser(consultId);
        log.info("consultId param:{}", (Object)consultId);
        if (GenericsUtils.isNullOrEmpty((Object)txConsultUser)) {
            log.info("\u8be5\u5b66\u5458\u4e0d\u5b58\u5728");
            return consultAvatarUrlAndNameDto;
        }
        Long orgId = txConsultUser.getOrgId();
        Long studentId = txConsultUser.getStudentId();
        OrgStudent orgStudent = null;
        if (studentId != null && studentId > 0L) {
            orgStudent = (OrgStudent)this.orgStudentDao.getById((Serializable)studentId, new String[0]);
            if (orgStudent != null) {
                Student student;
                OrgStorage orgStorage;
                name = orgStudent.getName();
                Long avatarId = orgStudent.getAvatar();
                String openId = orgStudent.getWeixin();
                log.info("orgAvatar param:{}", (Object)avatarId);
                if (avatarId != null && avatarId > 0L && (orgStorage = (OrgStorage)this.orgStorageDao.getById((Serializable)avatarId, new String[0])) != null) {
                    avatarUrl = StorageUtil.constructUrl((String)orgStorage.getFid(), (String)orgStorage.getSn(), (Integer)orgStorage.getMimeType());
                }
                if (StringUtils.isBlank((String)avatarUrl) && StringUtils.isNotBlank((String)openId)) {
                    Fans fans = this.fansDao.getByOpenId(openId);
                    log.info("fans param:{}", (Object)fans);
                    if (fans != null) {
                        avatarUrl = fans.getHeadImgUrl();
                        if (StringUtils.isBlank((String)name)) {
                            name = fans.getNick();
                        }
                    }
                }
                if (StringUtils.isBlank((String)avatarUrl) && (student = this.studentDao.getByUserId(orgStudent.getUserId(), new String[0])) != null) {
                    Storage storage;
                    Integer stuAvatarId = student.getAvatar();
                    log.info("avatar param:{}", (Object)avatarId);
                    if (stuAvatarId != null && stuAvatarId > 0 && (storage = this.storageDao.getStorageById(Long.valueOf(stuAvatarId.longValue()))) != null) {
                        avatarUrl = StorageUtil.constructUrl((Long)storage.getFid(), (String)storage.getMimetype(), (String)storage.getSn());
                    }
                }
            }
        } else {
            avatarUrl = txConsultUser.getPortrait();
            name = txConsultUser.getName();
            String openId = txConsultUser.getWeixinOpenId();
            if (GenericsUtils.isNullOrEmpty((Object)avatarUrl) && GenericsUtils.notNullAndEmpty((Object)openId)) {
                Fans fans = this.fansDao.getByOpenId(openId);
                log.info("fans param:{}", (Object)fans);
                if (GenericsUtils.notNullAndEmpty((Object)fans)) {
                    avatarUrl = fans.getHeadImgUrl();
                    if (GenericsUtils.isNullOrEmpty((Object)name)) {
                        name = fans.getNick();
                    }
                }
                log.info("avatarUrl param:{}", (Object)avatarUrl);
            }
        }
        if (GenericsUtils.isNullOrEmpty((Object)avatarUrl)) {
            avatarUrl = "http://img.gsxservice.com/11868865_wlpn1jd6.png";
        }
        consultAvatarUrlAndNameDto.setAvatarUrl(avatarUrl);
        consultAvatarUrlAndNameDto.setName(name);
        log.info("consultAvatarUrlAndNameDto param:{}", (Object)consultAvatarUrlAndNameDto);
        return consultAvatarUrlAndNameDto;
    }

    @Override
    public Map<Long, ConsultAvatarUrlAndNameDto> batchConsultAvatarUrlAndNameDtoMap(Collection<Long> consultIds, Long orgId) {
        Long studentId;
        log.info(" \u4f20\u6765\u7684\u53c2\u6570 consultIds params:{}, orgId param:{}", consultIds, (Object)orgId);
        HashMap<Long, ConsultAvatarUrlAndNameDto> dtoMap = new HashMap<Long, ConsultAvatarUrlAndNameDto>();
        if (consultIds == null || consultIds.size() < 1) {
            return dtoMap;
        }
        if (consultIds == null || consultIds.size() < 1) {
            return dtoMap;
        }
        List txConsultUsers = this.txConsultUserDao.batchTxConsultUserByIds(consultIds, null, null);
        log.info("txConsultUsers  parm:{}, size param:{}", (Object)txConsultUsers, (Object)txConsultUsers.size());
        this.setStudentId(txConsultUsers, orgId);
        ArrayList<String> openIds = new ArrayList<String>();
        ArrayList<Long> studentIds = new ArrayList<Long>();
        for (TxConsultUser txConsultUser : txConsultUsers) {
            String openId;
            Long studentId2 = txConsultUser.getStudentId();
            if (studentId2 != null && studentId2 > 0L) {
                studentIds.add(studentId2);
            }
            if ((openId = txConsultUser.getWeixinOpenId()).equals("") || openId.equals("0")) continue;
            openIds.add(openId);
        }
        log.info("\u83b7\u53d6\u5b66\u5458 studentIds param:{}", studentIds);
        Map fansMap = new HashMap();
        if (GenericsUtils.notNullAndEmpty(openIds)) {
            fansMap = this.fansDao.mapKeyOpenIdValueFans(openIds);
        }
        Map<Object, Object> userIdConsultAvartarMap = new HashMap();
        HashMap<Long, Long> studentIdUserIdMap = new HashMap<Long, Long>();
        if (GenericsUtils.notNullAndEmpty(studentIds)) {
            List orgStudents = this.orgStudentDao.getByIds(studentIds, new String[0]);
            for (OrgStudent orgStudent : orgStudents) {
                studentId = orgStudent.getId();
                Long userId = orgStudent.getUserId();
                studentIdUserIdMap.put(studentId, userId);
            }
            userIdConsultAvartarMap = this.batchStudentAvatarUrlAndNameDMap(studentIdUserIdMap.values(), orgId);
        }
        log.info("userIdConsultAvartarMap param:{}, size param:{}", userIdConsultAvartarMap, (Object)userIdConsultAvartarMap.size());
        for (TxConsultUser txConsultUser : txConsultUsers) {
            Long consultId = txConsultUser.getId();
            studentId = txConsultUser.getStudentId();
            ConsultAvatarUrlAndNameDto consultAvatarUrlAndNameDto = null;
            if (studentId != null && studentId > 0L) {
                Long userId = (Long)studentIdUserIdMap.get(studentId);
                consultAvatarUrlAndNameDto = (ConsultAvatarUrlAndNameDto)userIdConsultAvartarMap.get(userId);
                if (GenericsUtils.isNullOrEmpty((Object)consultAvatarUrlAndNameDto)) {
                    consultAvatarUrlAndNameDto = new ConsultAvatarUrlAndNameDto();
                    consultAvatarUrlAndNameDto.setAvatarUrl("http://img.gsxservice.com/11868865_wlpn1jd6.png");
                }
            } else {
                Fans fan;
                consultAvatarUrlAndNameDto = new ConsultAvatarUrlAndNameDto();
                String name = txConsultUser.getName();
                String avatarUrl = txConsultUser.getPortrait();
                String mobile = txConsultUser.getMobile();
                String openId = txConsultUser.getWeixinOpenId();
                if (GenericsUtils.isNullOrEmpty((Object)avatarUrl) && GenericsUtils.notNullAndEmpty((Object)openId) && GenericsUtils.notNullAndEmpty((Object)(fan = (Fans)fansMap.get(openId)))) {
                    avatarUrl = fan.getHeadImgUrl();
                    if (GenericsUtils.isNullOrEmpty((Object)name)) {
                        name = fan.getNick();
                    }
                }
                if (GenericsUtils.isNullOrEmpty((Object)avatarUrl)) {
                    avatarUrl = "http://img.gsxservice.com/11868865_wlpn1jd6.png";
                }
                consultAvatarUrlAndNameDto.setAvatarUrl(avatarUrl);
                consultAvatarUrlAndNameDto.setName(name == null ? "" : name);
                consultAvatarUrlAndNameDto.setMobile(mobile == null ? "" : mobile);
            }
            dtoMap.put(consultId, consultAvatarUrlAndNameDto);
        }
        log.info("dtoMap param:{}, size param:{}", dtoMap, (Object)dtoMap.size());
        return dtoMap;
    }

    @Override
    public Map<Long, ConsultAvatarUrlAndNameDto> batchStudentAvatarUrlAndNameDMap(Collection<Long> userIds, Long orgId) {
        if (userIds == null || userIds.size() < 1) {
            return Collections.EMPTY_MAP;
        }
        Map<Long, Integer> avatarIdMap = new HashMap();
        HashMap<Long, OrgStorage> orgStorageMap = new HashMap();
        HashMap<Long, Storage> storageMap = new HashMap();
        HashMap<String, Fans> fansMap = new HashMap();
        Map userIdOrgStudentMap = this.orgStudentDao.getStudentMap(userIds, orgId);
        HashSet<Long> orgAvatarIds = new HashSet<Long>();
        ArrayList<String> openIds = new ArrayList<String>();
        for (Object userId : userIdOrgStudentMap.keySet()) {
            Long avatarId;
            OrgStudent orgStudent = (OrgStudent)userIdOrgStudentMap.get(userId);
            String openId = orgStudent.getWeixin();
            if (!openId.equals("") && !openId.equals("0")) {
                openIds.add(openId);
            }
            if (!GenericsUtils.notNullAndEmpty((Object)(avatarId = orgStudent.getAvatar()))) continue;
            orgAvatarIds.add(avatarId);
        }
        if (GenericsUtils.notNullAndEmpty(orgAvatarIds)) {
            orgStorageMap = this.orgStorageDao.getOrgStorageMapByIds(orgAvatarIds);
        }
        avatarIdMap = this.studentDao.getAvatarsMap(userIds);
        HashSet avatarIds = Sets.newHashSet();
        if (GenericsUtils.notNullAndEmpty(avatarIdMap)) {
            for (Integer avatar : avatarIdMap.values()) {
                avatarIds.add(avatar.longValue());
            }
            if (GenericsUtils.notNullAndEmpty((Object)avatarIds)) {
                storageMap = this.storageDao.getStorageMapByIds((Collection)avatarIds);
            }
        }
        if (GenericsUtils.notNullAndEmpty(openIds)) {
            fansMap = this.fansDao.mapKeyOpenIdValueFans(openIds);
        }
        HashMap<Long, ConsultAvatarUrlAndNameDto> consultAvatarUrlAndNameDtoMap = new HashMap<Long, ConsultAvatarUrlAndNameDto>();
        for (Long userId : userIds) {
            OrgStudent orgStudent = (OrgStudent)userIdOrgStudentMap.get(userId);
            ConsultAvatarUrlAndNameDto dto = this.buildConsultAvatarUrlAndNameDto(orgStudent, orgStorageMap, fansMap, avatarIdMap, storageMap);
            consultAvatarUrlAndNameDtoMap.put(userId, dto);
        }
        return consultAvatarUrlAndNameDtoMap;
    }

    private ConsultAvatarUrlAndNameDto buildConsultAvatarUrlAndNameDto(OrgStudent orgStudent, Map<Long, OrgStorage> orgStorageMap, Map<String, Fans> fansMap, Map<Long, Integer> avatarIdMap, Map<Long, Storage> storageMap) {
        ConsultAvatarUrlAndNameDto dto = new ConsultAvatarUrlAndNameDto();
        String avatarUrl = null;
        String name = null;
        String mobile = null;
        if (GenericsUtils.notNullAndEmpty((Object)orgStudent)) {
            Storage storage;
            Integer aratarId;
            Fans fan;
            name = orgStudent.getName();
            mobile = orgStudent.getMobile();
            Long avatarId = orgStudent.getAvatar();
            OrgStorage orgStorage = orgStorageMap.get(avatarId);
            if (GenericsUtils.notNullAndEmpty((Object)orgStorage)) {
                avatarUrl = StorageUtil.constructUrl((String)orgStorage.getFid(), (String)orgStorage.getSn(), (Integer)orgStorage.getMimeType());
            }
            String openId = orgStudent.getWeixin();
            if (GenericsUtils.isNullOrEmpty((Object)avatarUrl) && GenericsUtils.notNullAndEmpty((Object)openId) && GenericsUtils.notNullAndEmpty((Object)(fan = fansMap.get(openId)))) {
                avatarUrl = fan.getHeadImgUrl();
            }
            if (GenericsUtils.isNullOrEmpty((Object)avatarUrl) && (aratarId = avatarIdMap.get(orgStudent.getUserId())) != null && (storage = storageMap.get(aratarId.longValue())) != null) {
                avatarUrl = StorageUtil.constructUrl((Long)storage.getFid(), (String)storage.getMimetype(), (String)storage.getSn());
            }
        }
        if (GenericsUtils.isNullOrEmpty(avatarUrl)) {
            avatarUrl = "http://img.gsxservice.com/11868865_wlpn1jd6.png";
        }
        dto.setAvatarUrl(avatarUrl);
        dto.setMobile(mobile);
        dto.setName(name);
        return dto;
    }

    private void setStudentId(List<TxConsultUser> users, Long orgId) {
        List orgStudents;
        HashMap<Long, TxConsultUser> map = new HashMap<Long, TxConsultUser>();
        for (TxConsultUser user : users) {
            if (user.getStudentId() != null && user.getStudentId() > 0L || user.getUserId() == null || user.getUserId() <= 0L) continue;
            map.put(user.getUserId(), user);
        }
        if (GenericsUtils.notNullAndEmpty(map.keySet()) && GenericsUtils.notNullAndEmpty((Object)(orgStudents = this.orgStudentDao.getStudentByUserIds(orgId, map.keySet(), new String[0])))) {
            for (OrgStudent stu : orgStudents) {
                TxConsultUser user = (TxConsultUser)map.get(stu.getUserId());
                if (user == null) continue;
                user.setStudentId(stu.getId());
            }
        }
    }
}

