package com.baijia.tianxiao.sal.push.dto;

import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.dal.push.constant.MsgUserType;
import com.baijia.tianxiao.dal.push.dto.content.NoticeMsgContent;
import com.baijia.tianxiao.dal.push.utils.ActionUtil;
import com.baijia.tianxiao.sal.push.utils.NativeUrlUtil;

import org.apache.commons.lang.builder.ToStringBuilder;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by liuxp on 16/1/6.
 */
public class PushConfig {

    private static String WECHAT_ACTION = "consult_wx";
    private static String APPOINTMENT_ACTION = "consult_reserve";
    private static String TELEPHONE_ACTION = "consult_call";

    private static String MSG_ACTION = "action_to_chat";
    private static String NOTICE_ACTION = "action_to_notification_list";


    public final static Map<Integer,String> tipMap = new HashMap<>();
    static {
        tipMap.put(MessageSource.WECHAT.getValue(),"您有一条微信商机，快去牢牢抓住");
        tipMap.put(MessageSource.APPOINTMENT.getValue(),"有个在线留单，赶紧去查看吧。");
        tipMap.put(MessageSource.TELEPHONE.getValue(),"收到一条来电咨询");
    }

    private String tip;//提示文案
    private String jumpUrl;//跳转URL

    public PushConfig() {

    }

    public String getTip() {
        return tip;
    }

    public void setTip(String tip) {
        this.tip = tip;
    }

    public String getJumpUrl() {
        return jumpUrl;
    }

    public void setJumpUrl(String jumpUrl) {
        this.jumpUrl = jumpUrl;
    }

    public static PushConfig getWechatConfig(long consultId){
        PushConfig config = new PushConfig();
        config.setTip(tipMap.get(MessageSource.WECHAT));
        String url = NativeUrlUtil.getUrl(WECHAT_ACTION);
        url = NativeUrlUtil.addParam(url,"id",consultId);
        config.setJumpUrl(url);
        return config;
    }

    public static PushConfig getNoticeConfig(NoticeMsgContent notice){
        PushConfig config = new PushConfig();
        config.setTip(notice.getText());
        String url = notice.getAction();
        config.setJumpUrl(url);
        return config;
    }

    public static PushConfig getMsgConfig(String text,Long userId,int userRole){
        PushConfig config = new PushConfig();
        config.setTip(text);
        Map<String,Object> map = new HashMap<>();
        map.put("userId",userId);
        map.put("userRole",userRole);
        map.put("userType", MsgUserType.getUserType(userRole).getValue());
        String url = ActionUtil.getAction(MSG_ACTION,map);
        config.setJumpUrl(url);
        return config;
    }

    public static PushConfig getAppointmentConfig(Long consultId,Long userId){
        PushConfig config = new PushConfig();
        config.setTip(tipMap.get(MessageSource.APPOINTMENT));

        String url = NativeUrlUtil.getUrl(APPOINTMENT_ACTION);
        if(userId!=null) {
            url = NativeUrlUtil.addParam(url,"sid",userId);
        }else {
            url = NativeUrlUtil.addParam(url,"cid",consultId);
        }
        config.setJumpUrl(url);
        return config;
    }

    public static PushConfig getTelConfig(long consultId,String mobile,long callId){
        PushConfig config = new PushConfig();
        config.setTip(tipMap.get(MessageSource.TELEPHONE));
        String url = NativeUrlUtil.getUrl(TELEPHONE_ACTION);
        url = NativeUrlUtil.addParam(url,"cid",consultId);
        url = NativeUrlUtil.addParam(url,"m",mobile);
        url = NativeUrlUtil.addParam(url,"id",callId);
        config.setJumpUrl(url);
        return config;
    }

    public static void main(String[] args) {
        System.out.println(ToStringBuilder.reflectionToString(getTelConfig(10L, "1111", 11L)));
    }
}
