package com.baijia.tianxiao.sal.push.dto;

import com.baijia.tianxiao.sal.push.constant.Config;
import lombok.Data;

/**
 * Created by liuxp on 16/5/11.
 */
@Data
public class PushBindChannel {
    /**
     * 绑定渠道的类型，见 ChannelTypeEnum，如 BAIDU,HUAWEI,XIAOMI
     */
    private String channelType;

    /**
     * 绑定渠道对应设备的Token，推送各个渠道的唯一标识
     */
    private String deviceToken;

    /**
     * 推送渠道对应申请的appId，
     */
    private String appId = Config.NEW_APP_ID;

    /**
     * 1是测试 2是线上
     */
    private Integer developStatus;

    /**
     * ios 特有的参数
     */
    private Integer deployStatus;
}
