/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.push.service.impl;

import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.sal.push.api.AppPushApi;
import com.baijia.tianxiao.sal.push.dto.PushConfig;
import com.baijia.tianxiao.sal.push.service.NeedRemindUserService;
import com.baijia.tianxiao.sal.push.utils.NativeUrlUtil;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NeedRemindUserServiceImpl
implements NeedRemindUserService {
    private static final Logger log = LoggerFactory.getLogger(NeedRemindUserServiceImpl.class);
    private static final String CONSULT_USER_ACTION = "add_consult";
    private static final String STUDENT_ACTION = "student_info";
    @Autowired
    private TxConsultUserDao consultUserDao;
    @Autowired
    private OrgStudentDao studentsDao;

    @Override
    public void pushConsultUser(Date startTime, Date endTime) {
        List consultUserList = this.consultUserDao.getConsultUserByRemindTime(startTime, endTime);
        log.info("pushConsultUser.startTime:{}, endTime:{}", (Object)startTime, (Object)endTime);
        if (consultUserList != null && consultUserList.size() > 0) {
            for (TxConsultUser consultUser : consultUserList) {
                OrgStudent stu;
                if (consultUser.getUserId() != null && (stu = this.studentsDao.getStudent(consultUser.getOrgId(), consultUser.getUserId(), null, new String[0])) != null) {
                    AppPushApi.pushMsg(this.getPushConfig(stu), stu.getOrgId());
                }
                AppPushApi.pushMsg(this.getPushConfig(consultUser), consultUser.getOrgId());
            }
        }
    }

    @Override
    public void pushOrgStudent(Date startTime, Date endTime) {
        List studentsList = this.studentsDao.getUserByRemindTime(startTime, endTime);
        log.info("pushOrgStudent.startTime:{}, endTime:{}", (Object)startTime, (Object)endTime);
        if (studentsList != null && studentsList.size() > 0) {
            for (OrgStudent stu : studentsList) {
                AppPushApi.pushMsg(this.getPushConfig(stu), stu.getOrgId());
            }
        }
    }

    private PushConfig getPushConfig(TxConsultUser consultUser) {
        PushConfig config = new PushConfig();
        String name = consultUser.getName();
        if (StringUtils.isBlank((String)name)) {
            name = consultUser.getMobile();
        }
        config.setTip(this.getConsultUserTip(name));
        String url = NativeUrlUtil.getUrl(CONSULT_USER_ACTION);
        url = NativeUrlUtil.addParam(url, "cid", consultUser.getId());
        config.setJumpUrl(url);
        return config;
    }

    private PushConfig getPushConfig(OrgStudent student) {
        PushConfig config = new PushConfig();
        String name = student.getName();
        if (StringUtils.isBlank((String)name)) {
            name = student.getMobile();
        }
        config.setTip(this.getStudentTip(name));
        String url = NativeUrlUtil.getUrl(STUDENT_ACTION);
        url = NativeUrlUtil.addParam(url, "sid", student.getId());
        config.setJumpUrl(url);
        return config;
    }

    private String getConsultUserTip(String name) {
        StringBuilder sb = new StringBuilder();
        sb.append("\uff3b\u8ddf\u8fdb\u63d0\u9192\uff3d\u60a8\u8be5\u8ddf\u8fdb\u5ba2\u6237");
        sb.append(name);
        sb.append("\u4e86\uff0c\u9632\u6b62\u5ba2\u6237\u6d41\u5931\u54e6\uff0c\u8d76\u5feb\u5904\u7406");
        return sb.toString();
    }

    private String getStudentTip(String name) {
        StringBuilder sb = new StringBuilder();
        sb.append("\uff3b\u56de\u8bbf\u63d0\u9192\uff3d\u5b66\u5458");
        sb.append(name);
        sb.append("\u8be5\u56de\u8bbf\u4e86");
        return sb.toString();
    }
}

