package com.baijia.tianxiao.sal.push.enums;

/**
 * Created by liuxp on 16/5/12.
 */
public enum PlatformType {
    ANDROID(1, "ANDROID"),
    IOS(2, "IOS");

    private int type;
    private String name;

    private PlatformType(int type, String name) {
        this.type = type;
        this.name = name;
    }

    public static String getName(int type) {
        for (PlatformType platformType : PlatformType.values()) {
            if (platformType.type == type) {
                return platformType.name;
            }
        }
        return "";
    }

    public static Integer getCode(String name) {
        for (PlatformType platformType : PlatformType.values()) {
            if (platformType.name.equals(name)) {
                return platformType.type;
            }
        }
        return -1;
    }

    public int getType() {
        return type;
    }

    public String getName() {
        return name;
    }
}
