package com.baijia.tianxiao.sal.push.dto.newpush;

import com.baijia.tianxiao.dal.org.po.TXCascadeCredential;
import com.baijia.tianxiao.dal.push.constant.MsgUserRole;
import com.baijia.tianxiao.dal.push.constant.MsgUserType;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.user.po.User;
import com.baijia.tianxiao.sal.push.dto.MsgUser;
import lombok.Data;

/**
 * Created by liuxp on 16/5/23.
 */
@Data
public class UserResponse {
    private long userId;
    private Long number;
    private String name;
    private String mobile;
    private int userType;
    private int userRole;
    private String  avatarUrl;

    public int getUserType() {
        return MsgUserType.getUserType(userRole).getValue();
    }

    public static UserResponse getInstance(MsgUser msgUser) {
        if (msgUser == null) {
            return null;
        }
        UserResponse response = new UserResponse();
        response.setUserId(msgUser.getUserId());
        response.setMobile(msgUser.getMobile());
        response.setName(msgUser.getName());
        response.setNumber(msgUser.getNumber());
        return response;
    }

    public static UserResponse getInstance(TxConsultUser user) {
        if (user == null) {
            return null;
        }
        UserResponse response = new UserResponse();
        response.setUserId(user.getId());
        response.setMobile(user.getMobile());
        response.setName(user.getName());
        response.setNumber(user.getUserNumber());
        return response;
    }


    public static UserResponse getInstance(User user,Long consultUserId) {
        if (user == null) {
            return null;
        }
        UserResponse response = new UserResponse();
        response.setUserId(consultUserId);
        response.setMobile(user.getMobile());
        response.setName(user.getName());
        response.setNumber(user.getNumber());
        response.setUserRole(MsgUserRole.STUDENT.getValue());
        return response;
    }

    public static UserResponse getInstance(TXCascadeCredential user) {
        if (user == null) {
            return null;
        }
        UserResponse response = new UserResponse();
        response.setMobile(user.getMobile());
        response.setName(user.getName());
        return response;
    }
}
