package com.baijia.tianxiao.sal.push.service.impl;

import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCommonRuleDao;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.org.po.TXCommonRule;
import com.baijia.tianxiao.dal.push.constant.MsgUserRole;
import com.baijia.tianxiao.sal.push.service.OrgService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * Created by liuxp on 16/6/16.
 */
@Service("pushOrgCommonSerive")
@Slf4j
public class OrgServiceImpl implements OrgService {

    @Autowired
    private OrgSubAccountDao orgSubAccountDao;
    @Autowired
    private TXCascadeAccountDao cascadeAccountDao;
    @Autowired
    private TXCommonRuleDao commonRuleDao;

    @Override
    public boolean isShowMobile(Long orgId, Integer cascadeId) {
        MsgUserRole userType = getOrgAccountType(orgId, cascadeId == null ? 0L : cascadeId.longValue());
        if (MsgUserRole.isHeader(userType.getValue())) {
            return true;
        } else {
            TXCommonRule commonRule = commonRuleDao.getByOrgId(orgId.intValue());
            if (commonRule != null) {
                return commonRule.getStudentMobileRule() == 0;
            }
        }
        return true;
    }

    @Override
    public MsgUserRole getOrgAccountType(long orgId, long cascadeId) {
        log.info("OrgId=" + orgId + ";cascadeId=" + cascadeId);
        if (cascadeId == 0) {
            OrgSubAccount subAccount = orgSubAccountDao.getMasterByOrgId((int) orgId);
            if (subAccount != null) {
                return MsgUserRole.HEADER;
            } else {
                return MsgUserRole.BRANCH_HEADER;
            }
        } else {
            TXCascadeAccount cascadeAccount = cascadeAccountDao.getById(cascadeId);
            if (cascadeAccount.getAccountType() == 3) {
                return MsgUserRole.MANAGER;
            } else {
                return MsgUserRole.STAFF;
            }
        }
    }

    public OrgSubAccount getOrgAccountInfo(int orgId){
        return orgSubAccountDao.getByOrgId(orgId);
    }
}
