package com.baijia.tianxiao.sal.push.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.pcAuthority.dao.TxAccountPermissionDao;
import com.baijia.tianxiao.dal.pcAuthority.po.TxAccountPermission;
import com.baijia.tianxiao.dal.push.constant.MsgSettingStatus;
import com.baijia.tianxiao.dal.push.dao.AccountMsgSettingDao;
import com.baijia.tianxiao.dal.push.po.AccountMsgSetting;
import com.baijia.tianxiao.enums.CrmErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.push.service.PushSettingService;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.ListUtil;

import lombok.extern.slf4j.Slf4j;

/**
 * Created by liuxp on 16/6/1.
 */
@Service
@Slf4j
public class PushSettingServiceImpl implements PushSettingService {

    @Autowired
    private AccountMsgSettingDao settingDao;

    @Autowired
    private OrgSubAccountDao orgSubAccountDao;

    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    @Autowired
    private TxAccountPermissionDao permissionDao;

    @Override
    public void setMsgSwitch(Long orgId, Integer cascadeId, int status) {
        if (status == MsgSettingStatus.CLOSE.getValue()) {
            if (cascadeId == null) {
                cascadeId = 0;
            }

            // 所有未停用子帐号
            List<TXCascadeAccount> txCascadeAccounts = this.txCascadeAccountDao.getTXCascadeAccountListByOrgId(orgId);
            List<Integer> cascadeIds = ListUtil.toKeyList(txCascadeAccounts, "id", TXCascadeAccount.class);

            // 所有没有权限的子账号
            List<Integer> noPermissionCascadeIds = new ArrayList<>();
            List<TxAccountPermission> permissions = permissionDao.selectPermission(cascadeIds, 105L);
            log.info("[TxAccountPermission] noPermissionCascadeIds=" + permissions);
            if (GenericsUtils.notNullAndEmpty(permissions)) {
                for (TxAccountPermission permission : permissions) {
                    if (permission.getPType() == 1) {
                        noPermissionCascadeIds.add(permission.getUId());
                    }
                }
            }

            // 主账号
            OrgSubAccount orgSubAccount = this.orgSubAccountDao.getByOrgId(orgId.intValue());
            if (orgSubAccount != null) {
                cascadeIds.add(0);
            }
            log.info("cascadeIds param:{}, cascadeId param:{}, orgId param:{},noPermissionCascadeIds={}", cascadeIds,
                cascadeId, orgId, noPermissionCascadeIds);

            // 所有关闭帐号
            List<AccountMsgSetting> offSettings =
                this.settingDao.selectSettingByOrgId(orgId, MsgSettingStatus.CLOSE.getValue());
            List<Integer> offCascadeIds = ListUtil.toKeyList(offSettings, "cascadeId", AccountMsgSetting.class);
            log.info("offCascadeIds param:{}, cascadeId param:{}, orgId param:{}", offCascadeIds, cascadeId, orgId);

            // 除去关闭帐号
            cascadeIds.removeAll(offCascadeIds);
            cascadeIds.removeAll(noPermissionCascadeIds);
            cascadeIds.remove(cascadeId);

            if (GenericsUtils.isNullOrEmpty(cascadeIds)) {
                log.warn("[Message] Not allow close.orgId=" + orgId + ";cascadeId=" + cascadeId);
                throw new BussinessException(CrmErrorCode.NOT_ALLOW_CLOSE);
            }
        }

        AccountMsgSetting setting = settingDao.selectAccountMsgSetting(orgId, cascadeId);
        if (setting == null) {
            setting = createNewSetting(orgId, cascadeId, status);
            settingDao.insertAccountMsgSetting(setting);
        } else {
            setting.setMsgSwitch(status);
            setting.setUpdateTime(new Date());
            settingDao.updateAccountMsgSetting(setting);
        }
    }

    private AccountMsgSetting createNewSetting(Long orgId, Integer cascadeId, int status) {
        AccountMsgSetting setting = new AccountMsgSetting();
        setting.setOrgId(orgId);
        setting.setCascadeId(cascadeId == null ? 0 : cascadeId);
        setting.setMsgSwitch(status);
        setting.setCreateTime(new Date());
        setting.setUpdateTime(new Date());
        return setting;
    }

    @Override
    public int getMsgSwitch(Long orgId, Integer cascadeId) {
        AccountMsgSetting setting = settingDao.selectAccountMsgSetting(orgId, cascadeId);
        if (setting == null) {
            setting = createNewSetting(orgId, cascadeId, MsgSettingStatus.OPEN.getValue());
            settingDao.insertAccountMsgSetting(setting);
            return MsgSettingStatus.OPEN.getValue();
        } else {
            return setting.getMsgSwitch();
        }
    }
}
