/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.push.dto;

import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.dal.push.constant.MsgUserType;
import com.baijia.tianxiao.dal.push.dto.content.NoticeMsgContent;
import com.baijia.tianxiao.dal.push.utils.ActionUtil;
import com.baijia.tianxiao.sal.push.utils.NativeUrlUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;

public class PushConfig {
    private static String WECHAT_ACTION = "consult_wx";
    private static String APPOINTMENT_ACTION = "consult_reserve";
    private static String TELEPHONE_ACTION = "consult_call";
    private static String MSG_ACTION = "action_to_chat";
    private static String NOTICE_ACTION = "action_to_notification_list";
    public static final Map<Integer, String> tipMap = new HashMap<Integer, String>();
    private String tip;
    private String jumpUrl;

    static {
        tipMap.put(MessageSource.WECHAT.getValue(), "\u60a8\u6709\u4e00\u6761\u5fae\u4fe1\u5546\u673a\uff0c\u5feb\u53bb\u7262\u7262\u6293\u4f4f");
        tipMap.put(MessageSource.APPOINTMENT.getValue(), "\u6709\u4e2a\u5728\u7ebf\u7559\u5355\uff0c\u8d76\u7d27\u53bb\u67e5\u770b\u5427\u3002");
        tipMap.put(MessageSource.TELEPHONE.getValue(), "\u6536\u5230\u4e00\u6761\u6765\u7535\u54a8\u8be2");
    }

    public String getTip() {
        return this.tip;
    }

    public void setTip(String tip) {
        this.tip = tip;
    }

    public String getJumpUrl() {
        return this.jumpUrl;
    }

    public void setJumpUrl(String jumpUrl) {
        this.jumpUrl = jumpUrl;
    }

    public static PushConfig getWechatConfig(long consultId) {
        PushConfig config = new PushConfig();
        config.setTip(tipMap.get(MessageSource.WECHAT));
        String url = NativeUrlUtil.getUrl(WECHAT_ACTION);
        url = NativeUrlUtil.addParam(url, "id", consultId);
        config.setJumpUrl(url);
        return config;
    }

    public static PushConfig getNoticeConfig(NoticeMsgContent notice) {
        PushConfig config = new PushConfig();
        config.setTip(notice.getText());
        String url = notice.getAction();
        config.setJumpUrl(url);
        return config;
    }

    public static PushConfig getMsgConfig(String text, Long userId, int userRole) {
        PushConfig config = new PushConfig();
        config.setTip(text);
        HashMap<String, Number> map = new HashMap<String, Number>();
        map.put("userId", userId);
        map.put("userRole", userRole);
        map.put("userType", MsgUserType.getUserType((int)userRole).getValue());
        String url = ActionUtil.getAction((String)MSG_ACTION, map);
        config.setJumpUrl(url);
        return config;
    }

    public static PushConfig getAppointmentConfig(Long consultId, Long userId) {
        PushConfig config = new PushConfig();
        config.setTip(tipMap.get(MessageSource.APPOINTMENT));
        String url = NativeUrlUtil.getUrl(APPOINTMENT_ACTION);
        url = userId != null ? NativeUrlUtil.addParam(url, "sid", userId) : NativeUrlUtil.addParam(url, "cid", consultId);
        config.setJumpUrl(url);
        return config;
    }

    public static PushConfig getTelConfig(long consultId, String mobile, long callId) {
        PushConfig config = new PushConfig();
        config.setTip(tipMap.get(MessageSource.TELEPHONE));
        String url = NativeUrlUtil.getUrl(TELEPHONE_ACTION);
        url = NativeUrlUtil.addParam(url, "cid", consultId);
        url = NativeUrlUtil.addParam(url, "m", mobile);
        url = NativeUrlUtil.addParam(url, "id", callId);
        config.setJumpUrl(url);
        return config;
    }

    public static void main(String[] args) {
        System.out.println(ToStringBuilder.reflectionToString((Object)PushConfig.getTelConfig(10L, "1111", 11L)));
    }
}

