/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.push.utils;

import com.baijia.tianxiao.constants.CommonConfig;
import com.baijia.tianxiao.util.rest.RestUtils;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParamUtil {
    private static final Logger logger = LoggerFactory.getLogger(ParamUtil.class);

    public static Map<String, String> constructBatchAppPushParams(Map<String, String> entry, String token) {
        Map<String, String> params = null;
        try {
            params = ParamUtil.getCommonParam(token);
            String appKey = CommonConfig.SERVICE_APP_KEY;
            params.put("message", entry.get("msg"));
            params.put("sendWay", "7");
            params.put("messageType", "\u5e7f\u64ad");
            params.put("bizMessageType", "5200");
            params.put("batchUserIds", entry.get("batchUserIds"));
            params.put("role", entry.get("role"));
            params.put("detail", entry.get("detail"));
            params.put("trace_code", "tianxiao_" + entry.get("code"));
            String signData = RestUtils.createSignData((String)"post", (String)"message", (String)"send", null, params);
            String sign = RestUtils.getSignature((byte[])signData.getBytes("UTF-8"), (byte[])appKey.getBytes("UTF-8"));
            params.put("sign", sign);
            logger.info("<params>=" + params);
        }
        catch (Exception e) {
            logger.error("[Param] Param parse exception.", (Throwable)e);
        }
        return params;
    }

    private static Map<String, String> getCommonParam(String token) {
        HashMap<String, String> params = new HashMap<String, String>();
        String appId = CommonConfig.SERVICE_APP_ID;
        params.put("app_id", appId);
        params.put("auth_token", token);
        params.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        params.put("fast", "1");
        return params;
    }

    public static String getUUID(Long orgId, Integer subAccountId) {
        StringBuilder builder = new StringBuilder();
        builder.append(orgId).append("_");
        if (subAccountId != null && subAccountId >= 0) {
            builder.append(subAccountId);
        }
        return builder.toString();
    }
}

