package com.baijia.tianxiao.sal.push.api;

import com.baijia.tianxiao.dal.push.po.ConsultMessage;
import com.baijia.tianxiao.dto.RestfulResult;
import static com.baijia.tianxiao.sal.push.constant.MsgConstant.*;
import com.baijia.tianxiao.sal.push.constant.Config;
import com.baijia.tianxiao.sal.push.dto.*;
import com.baijia.tianxiao.sal.push.utils.RestUtil;
import com.baijia.tianxiao.util.rest.RestUtils;
import com.google.gson.Gson;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;

/**
 * Created by liuxp on 15/12/3.
 */
public class AppPushApi {

    private static final int CMD_MSG_TYPE = 1;// 0 sdk 内部处理| 1 sdk 外部处理

    private static final int REPEAT_COUNT = 3;

    private static final Logger logger = LoggerFactory.getLogger(AppPushApi.class);

    //发送聊天消息
    public static void sendMsg(ConsultMessage message, MsgUser msgUser) {
        Map<String, String> parameterMap = new LinkedHashMap<String, String>();
        Gson gson = new Gson();
        Map<String, Object> payloadMap = new HashMap<>();
        payloadMap.put("action", "tianxiao-crm-msgs");
        List<PushDto> list = new ArrayList<>();
        PushDto pushDto = PushDto.getInstance(message);
        pushDto.setUser(UserDto.getInstance(msgUser));
        list.add(pushDto);
        payloadMap.put("list", list);

        Map<String, Object> messageMap = new HashMap<>();
        messageMap.put("payload", payloadMap);
        messageMap.put("type", CMD_MSG_TYPE);

        parameterMap.put("message", gson.toJson(messageMap));
        parameterMap.put("sendWay", SEND_WAY);
        parameterMap.put("from", TX_SYS_SENDER_ROLE);
        parameterMap.put("to", message.getReceiverId() + "_" + message.getReceiverRole());
        parameterMap.put("app_id", Config.APP_ID);
        parameterMap.put("pri", IM_PRIORITY);
        parameterMap.put("timestamp", String.valueOf(System.currentTimeMillis()));
        parameterMap.put("auth_token", getTokenFromCache());
        MsgDetail detail = MsgDetail.getDetail();
        parameterMap.put("detail", gson.toJson(detail));
        logger.info("[Param] = " + parameterMap);
        RestfulResult<String> result = null;
        try {
            result = RestUtil.getInstance().rest(RestUtils.RestMethod.POST, "message", "send", null, parameterMap, null);
        } catch (Exception e) {
            logger.info("[Push]parameterMap:{}", parameterMap);
            logger.error("[Push] Exception:", e);
        }
        logger.info("[Result]=" + ToStringBuilder.reflectionToString(result));
        int i = 1;

        while ((result == null || result.getCode() != 0) && i < REPEAT_COUNT) {
            try {
                result = RestUtil.getInstance().rest(RestUtils.RestMethod.POST, "message", "send", null, parameterMap, null);
                i++;
                logger.info("[Result]=" + ToStringBuilder.reflectionToString(result));
            } catch (Exception e) {
                logger.info("[Push]parameterMap:{}", parameterMap);
                logger.error("[Push] Exception:", e);
            }
        }
        if (result.getCode() != 0) {
            logger.error("[Push] :{}", parameterMap);
            throw new RuntimeException("外部接口访问失败");
        }
    }

    //发送推送消息
    public static void pushMsg(PushConfig config,Long orgId) {
        Map<String, String> parameterMap = new LinkedHashMap<String, String>();
        parameterMap.put("user_id", String.valueOf(orgId));
        parameterMap.put("user_role", USER_ROLE);
        parameterMap.put("app_type", APP_TYPE);
        parameterMap.put("msg", getJsonMsg(config));
        parameterMap.put("app_id", Config.APP_ID);
        parameterMap.put("timestamp", String.valueOf(System.currentTimeMillis()));
        parameterMap.put("auth_token", getTokenFromCache());
        parameterMap.put("msg_type", PUSH_MESSAGE_TYPE); // 见http://git.baijiahulian.com/zhouwei/wiki/wikis/Push
        logger.info("[Param] = " + parameterMap);
        try {
            RestfulResult<String> result =
                    RestUtil.getInstance().rest(RestUtils.RestMethod.POST, "push", "single", null, parameterMap, null);
            if (result.getCode() != 0) {
                logger.error("[Result] = " + ToStringBuilder.reflectionToString(result));
                throw new RuntimeException("返回结果有误");
            }
            logger.info("[Result] Push=" + ToStringBuilder.reflectionToString(result));
        } catch (Exception e) {
            logger.error("[Push]parameterMap:{}", parameterMap);
            logger.error("[Push] Exception:", e);
            throw new RuntimeException("外部接口访问失败");
        }
    }

    private static String getJsonMsg(PushConfig config) {
        Map<String, String> map = new HashMap<>();
        map.put("description",config.getTip());
        map.put("s", config.getJumpUrl());
        Gson gson = new Gson();
        return gson.toJson(map);
    }

    public static void bind(AppPushBindInfo info) {
        Map<String, String> parameterMap = new LinkedHashMap<String, String>();
        parameterMap.put("user_id", String.valueOf(info.getUserId()));
        parameterMap.put("user_role", USER_ROLE);
        parameterMap.put("app_type", String.valueOf(info.getAppType()));
        parameterMap.put("tid", info.getTid());
        parameterMap.put("develop_status", String.valueOf(info.getDevelopStatus()));
        parameterMap.put("deploy_status", String.valueOf(info.getDeployStatus()));
        parameterMap.put("baidu_uid", info.getBaiduUid());
        parameterMap.put("baidu_cid", info.getBaiduCid());
        parameterMap.put("app_id", Config.APP_ID);
        parameterMap.put("timestamp", String.valueOf(System.currentTimeMillis()));
        parameterMap.put("auth_token", getTokenFromCache());
        try {
            RestfulResult<String> result =
                    RestUtil.getInstance().rest(RestUtils.RestMethod.POST, "push", "bind", null, parameterMap, null);
            if (result.getCode() != 0) {
                throw new RuntimeException();
            }
        } catch (Exception e) {
            logger.error("[Push] Bind parameterMap:{}", parameterMap);
            logger.error("[Push] Exception:", e);
            throw new RuntimeException();
        }

    }

    public static void unBind(AppPushBindInfo info) {
        Map<String, String> parameterMap = new LinkedHashMap<String, String>();
        parameterMap.put("user_id", String.valueOf(info.getUserId()));
        parameterMap.put("user_role", USER_ROLE);
        parameterMap.put("app_type", String.valueOf(info.getAppType()));
        parameterMap.put("tid", info.getTid());
        parameterMap.put("develop_status", String.valueOf(info.getDevelopStatus()));
        parameterMap.put("deploy_status", String.valueOf(info.getDeployStatus()));
        parameterMap.put("baidu_uid", info.getBaiduUid());
        parameterMap.put("baidu_cid", info.getBaiduCid());
        parameterMap.put("app_id", Config.APP_ID);
        parameterMap.put("timestamp", String.valueOf(System.currentTimeMillis()));
        parameterMap.put("auth_token", getTokenFromCache());
        try {
            RestfulResult<String> result =
                    RestUtil.getInstance().rest(RestUtils.RestMethod.POST, "push", "bind", null, parameterMap, null);
            if (result.getCode() != 200) {
                throw new RuntimeException();
            }
        } catch (Exception e) {
            logger.error("[Push] UnBind parameterMap:{}", parameterMap);
            logger.error("[Push] Exception:", e);
            throw new RuntimeException();
        }
    }

    public static String getTokenFromCache() {
        String token = null;
        try {
            token = null;
            token = RestUtil.getInstance().getAuthToken();
            logger.info("Get token from cached,token=" + token);
        } catch (Exception e) {
            logger.error("NameChangeUtil.getTokenFromCache: rest-get-token error.", e);
        }
        return token;
    }

    static class MsgDetail {
        private String sendMT;
        private String chatType;

        public String getSendMT() {
            return sendMT;
        }

        public void setSendMT(String sendMT) {
            this.sendMT = sendMT;
        }

        public String getChatType() {
            return chatType;
        }

        public void setChatType(String chatType) {
            this.chatType = chatType;
        }

        public static MsgDetail getDetail() {
            MsgDetail detail = new MsgDetail();
            detail.setChatType("0");
            detail.setSendMT("7");
            return detail;
        }
    }

}