package com.baijia.tianxiao.sal.push.service;

import com.baijia.tianxiao.dal.push.dto.content.NoticeMsgContent;
import com.baijia.tianxiao.dal.push.po.ConsultMessage;
import com.baijia.tianxiao.dal.push.po.UserIdentify;
import com.baijia.tianxiao.sal.push.dto.MsgUser;
import com.baijia.tianxiao.sal.push.dto.PushDto;
import com.baijia.tianxiao.sal.push.dto.newpush.MsgResponse;
import com.baijia.tianxiao.sal.push.dto.newpush.UserResponse;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;

import java.util.List;

/**
 * Created by liuxp on 15/12/4.
 */
public interface ConsultMessageService {

    /**
     * 咨询信息发送(接收方为机构)
     *
     * @param sender
     * @param receiver
     * @param message
     * @return
     */
    public boolean sendConsultMessage(MsgUser sender, MsgUser receiver, ConsultMessage message);

    /**
     * 员工之间的消息发送
     *
     * @param message
     * @return
     */
    public boolean sendStaffMsg(long orgId, Integer cascadeId, ConsultMessage message);

    public void receiveWechatMsg(ConsultMessage message);

    @Deprecated
    public List<PushDto> getNewMessageList(long userId, Long msgId);

    public boolean addMessage(ConsultMessage message);

    /**
     * 拉取新消息
     *
     * @param orgId
     * @param cascadeId
     * @param msgId
     * @return
     */
    public List<MsgResponse> pullMessageList(long orgId, Integer cascadeId, String deviceId, Long msgId);


    /**
     * 两个用户之间对话
     *
     * @param user1
     * @param user2
     * @param lastMsgId
     * @param limit
     * @return
     */
    List<ConsultMessage> listDialogMessage(Long orgId, Integer cascadeId, UserIdentify user1, UserIdentify user2, Long lastMsgId, int limit);

    /**
     * 发送通知
     *
     * @param orgId
     * @param message
     * @return
     */
    public boolean sendNotice(Long orgId, Integer cascadeId, NoticeMsgContent message);

    /**
     * 同步历史数据
     *
     * @param pageDto
     */
    public int syncData(PageDto pageDto, int maxId, int minId);


    public UserResponse getUserInfo(long orgId, long userId, int userType);

    /**
     * 给指定人发送信息
     *
     * @param sender
     * @param receiver
     * @param message
     * @param givenReceiverId
     * @return
     */
    public boolean sendConsultMessage(MsgUser sender, MsgUser receiver, ConsultMessage message, Integer givenReceiverId);
}
