/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.push.service.impl;

import com.baijia.commons.lang.utils.collection.CollectionUtils;
import com.baijia.tianxiao.constants.UserRoleEnum;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.push.constant.ConsultType;
import com.baijia.tianxiao.dal.push.constant.MsgType;
import com.baijia.tianxiao.dal.push.dao.MessageDao;
import com.baijia.tianxiao.dal.push.dao.MsgPulledRecordDao;
import com.baijia.tianxiao.dal.push.po.ConsultMessage;
import com.baijia.tianxiao.dal.push.po.MsgPulledRecord;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.user.dao.UserDao;
import com.baijia.tianxiao.dal.user.po.User;
import com.baijia.tianxiao.sal.push.api.AppPushApi;
import com.baijia.tianxiao.sal.push.dto.ConsultUserCacheDto;
import com.baijia.tianxiao.sal.push.dto.MsgUser;
import com.baijia.tianxiao.sal.push.dto.OrgCacheDto;
import com.baijia.tianxiao.sal.push.dto.PushConfig;
import com.baijia.tianxiao.sal.push.dto.PushDto;
import com.baijia.tianxiao.sal.push.dto.UserDto;
import com.baijia.tianxiao.sal.push.service.ConsultMessageService;
import com.baijia.tianxiao.sal.push.service.UserCacheService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ConsultMessageServiceImpl
implements ConsultMessageService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MessageDao messageDao;
    @Autowired
    private MsgPulledRecordDao pulledRecordDao;
    @Autowired
    private TxConsultUserDao consultUserDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private UserCacheService cacheService;
    @Autowired
    private UserDao userDao;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean sendConsultMessage(MsgUser sender, MsgUser receiver, ConsultMessage message) {
        message.setSenderId(sender.getUserId().longValue());
        message.setSenderRole(sender.getRole().getCode());
        message.setSenderNumber(sender.getNumber() == null ? 0L : sender.getNumber());
        message.setReceiverId(receiver.getNumber().longValue());
        message.setReceiverRole(receiver.getRole().getCode());
        message.setCreateTime(new Date());
        this.messageDao.insertMessage(message);
        boolean result = false;
        try {
            OrgCacheDto dto = this.cacheService.getOrg(receiver.getNumber());
            Long studentId = null;
            if (sender.getUserId() != null && sender.getUserId() > 0L) {
                PushConfig pushConfig;
                ConsultUserCacheDto userCacheDto = this.cacheService.getConsultUser(sender.getUserId());
                if (userCacheDto != null && (studentId = userCacheDto.getStudentId()) == null) {
                    studentId = this.cacheService.getStudentIdFromDb(sender.getUserId(), dto.getOrgId());
                }
                if ((pushConfig = this.getConfig(message, studentId, sender.getMobile())) != null) {
                    AppPushApi.pushMsg(pushConfig, dto.getOrgId());
                }
            }
            AppPushApi.sendMsg(message, sender);
            result = true;
        }
        catch (Exception e) {
            this.logger.info("[ConsultMessage] message = " + ToStringBuilder.reflectionToString((Object)message, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE));
            this.logger.error("[ConsultMessage] Insert Exception.", (Throwable)e);
        }
        return result;
    }

    private PushConfig getConfig(ConsultMessage message, Long userId, String mobile) {
        PushConfig config = null;
        switch (ConsultType.getByType((Integer)message.getConsultType())) {
            case WECHAT: {
                config = PushConfig.getWechatConfig(message.getSenderId());
                break;
            }
            case APPOINTMENT: {
                config = PushConfig.getAppointmentConfig(message.getSenderId(), userId);
                break;
            }
            case TELEPHONE: {
                if (message.getMsgType() != MsgType.TEXT.getValue()) break;
                config = PushConfig.getTelConfig(message.getSenderId(), mobile, message.getCallId());
                break;
            }
            default: {
                this.logger.warn("[Push] Message = " + ToStringBuilder.reflectionToString((Object)message));
            }
        }
        return config;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean addMessage(ConsultMessage message) {
        try {
            this.messageDao.insertMessage(message);
            return true;
        }
        catch (Exception e) {
            this.logger.info("[ConsultMessage] message = " + ToStringBuilder.reflectionToString((Object)message, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE));
            this.logger.error("[ConsultMessage] Insert Exception.", (Throwable)e);
            return false;
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<PushDto> getNewMessageList(long userId, Long msgId) {
        this.logger.info("userId=" + userId + ";msgId=" + msgId);
        OrgAccount account = (OrgAccount)this.orgAccountDao.getById((Serializable)Long.valueOf(userId), new String[]{"number"});
        if (account == null || account.getNumber() == null) {
            this.logger.warn("[PullMsg] orgId is not exist.id = " + userId);
            return Collections.emptyList();
        }
        MsgPulledRecord pulledRecord = this.pulledRecordDao.selectPulledRecordByUserId(account.getNumber().longValue());
        if (msgId == null) {
            msgId = pulledRecord != null ? Long.valueOf(pulledRecord.getMsgId()) : Long.valueOf(0L);
        }
        List msgList = this.messageDao.selectNewRecordByUserId(account.getNumber().longValue(), msgId.longValue(), 1000);
        ArrayList<PushDto> retList = new ArrayList<PushDto>();
        if (msgList != null && msgList.size() > 0) {
            if (pulledRecord != null) {
                this.pulledRecordDao.updatePulledRecord(account.getNumber().longValue(), ((ConsultMessage)msgList.get(0)).getId());
            } else {
                pulledRecord = new MsgPulledRecord();
                pulledRecord.setMsgId(msgId.longValue());
                pulledRecord.setUserId(account.getNumber().longValue());
                pulledRecord.setUpdateTime(new Date());
                this.pulledRecordDao.insertPulledRecord(pulledRecord);
            }
            ArrayList<Long> userNumbers = new ArrayList<Long>();
            ArrayList<Long> consultUserIds = new ArrayList<Long>();
            for (ConsultMessage msg : msgList) {
                PushDto dto = PushDto.getInstance(msg);
                if (ConsultType.MARKING.getValue() == msg.getConsultType()) {
                    if (msg.getSenderNumber() != -1L) {
                        userNumbers.add(msg.getSenderNumber());
                        UserDto userDto = new UserDto();
                        userDto.setUserNumber(msg.getSenderNumber());
                        dto.setUser(userDto);
                    }
                } else {
                    long consultUserId = msg.getSenderRole() == UserRoleEnum.STUDENT.getCode() ? msg.getSenderId() : msg.getReceiverId();
                    consultUserIds.add(consultUserId);
                    UserDto userDto = new UserDto();
                    userDto.setConsultUserId(consultUserId);
                    dto.setUser(userDto);
                }
                retList.add(dto);
            }
            List users = this.userDao.getByNumbers(userNumbers, new String[0]);
            Map userMap = CollectionUtils.extractMap((Collection)users, (CollectionUtils.Extracter)new CollectionUtils.Extracter<Long, User>(){

                public Long extract(User user) {
                    return user.getNumber();
                }
            });
            List consultUsers = this.consultUserDao.getByIds(consultUserIds, new String[0]);
            Map consultUserMap = CollectionUtils.extractMap((Collection)consultUsers, (CollectionUtils.Extracter)new CollectionUtils.Extracter<Long, TxConsultUser>(){

                public Long extract(TxConsultUser consultUser) {
                    return consultUser.getId();
                }
            });
            for (PushDto dto : retList) {
                if (dto.getUser() == null) continue;
                if (dto.getType() == ConsultType.MARKING.getValue()) {
                    dto.setUser(UserDto.getInstance((User)userMap.get(dto.getUser().getUserNumber()), dto.getUser().getConsultUserId()));
                    continue;
                }
                dto.setUser(UserDto.getInstance((TxConsultUser)consultUserMap.get(dto.getUser().getConsultUserId())));
            }
        }
        return retList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void receiveWechatMsg(ConsultMessage message) {
        try {
            this.messageDao.insertMessage(message);
        }
        catch (Exception e) {
            this.logger.info("[ConsultMessage] message = " + ToStringBuilder.reflectionToString((Object)message, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE));
            this.logger.error("[ConsultMessage] Insert Exception.", (Throwable)e);
        }
    }
}

