/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.push.api;

import com.baijia.tianxiao.dal.push.po.ConsultMessage;
import com.baijia.tianxiao.dto.RestfulResult;
import com.baijia.tianxiao.sal.push.constant.Config;
import com.baijia.tianxiao.sal.push.dto.AppPushBindInfo;
import com.baijia.tianxiao.sal.push.dto.MsgUser;
import com.baijia.tianxiao.sal.push.dto.PushConfig;
import com.baijia.tianxiao.sal.push.dto.PushDto;
import com.baijia.tianxiao.sal.push.dto.UserDto;
import com.baijia.tianxiao.sal.push.utils.RestUtil;
import com.baijia.tianxiao.util.rest.RestUtils;
import com.google.gson.Gson;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppPushApi {
    private static final int CMD_MSG_TYPE = 1;
    private static final int REPEAT_COUNT = 3;
    private static final Logger logger = LoggerFactory.getLogger(AppPushApi.class);

    public static void sendMsg(ConsultMessage message, MsgUser msgUser) {
        LinkedHashMap<String, String> parameterMap = new LinkedHashMap<String, String>();
        Gson gson = new Gson();
        HashMap<String, Object> payloadMap = new HashMap<String, Object>();
        payloadMap.put("action", "tianxiao-crm-msgs");
        ArrayList<PushDto> list = new ArrayList<PushDto>();
        PushDto pushDto = PushDto.getInstance(message);
        pushDto.setUser(UserDto.getInstance(msgUser));
        list.add(pushDto);
        payloadMap.put("list", list);
        HashMap<String, Serializable> messageMap = new HashMap<String, Serializable>();
        messageMap.put("payload", payloadMap);
        messageMap.put("type", Integer.valueOf(1));
        parameterMap.put("message", gson.toJson(messageMap));
        parameterMap.put("sendWay", "7");
        parameterMap.put("from", "100000000_100");
        parameterMap.put("to", message.getReceiverId() + "_" + message.getReceiverRole());
        parameterMap.put("app_id", Config.APP_ID);
        parameterMap.put("pri", "8");
        parameterMap.put("timestamp", String.valueOf(System.currentTimeMillis()));
        parameterMap.put("auth_token", AppPushApi.getTokenFromCache());
        MsgDetail detail = MsgDetail.getDetail();
        parameterMap.put("detail", gson.toJson((Object)detail));
        logger.info("[Param] = " + parameterMap);
        RestfulResult result = null;
        try {
            result = RestUtil.getInstance().rest(RestUtils.RestMethod.POST, "message", "send", null, parameterMap, null);
        }
        catch (Exception e) {
            logger.info("[Push]parameterMap:{}", parameterMap);
            logger.error("[Push] Exception:", (Throwable)e);
        }
        logger.info("[Result]=" + ToStringBuilder.reflectionToString((Object)result));
        int i = 1;
        while ((result == null || result.getCode() != 0) && i < 3) {
            try {
                result = RestUtil.getInstance().rest(RestUtils.RestMethod.POST, "message", "send", null, parameterMap, null);
                ++i;
                logger.info("[Result]=" + ToStringBuilder.reflectionToString((Object)result));
            }
            catch (Exception e) {
                logger.info("[Push]parameterMap:{}", parameterMap);
                logger.error("[Push] Exception:", (Throwable)e);
            }
        }
        if (result.getCode() != 0) {
            logger.error("[Push] :{}", parameterMap);
            throw new RuntimeException("\u5916\u90e8\u63a5\u53e3\u8bbf\u95ee\u5931\u8d25");
        }
    }

    public static void pushMsg(PushConfig config, Long orgId) {
        LinkedHashMap<String, String> parameterMap = new LinkedHashMap<String, String>();
        parameterMap.put("user_id", String.valueOf(orgId));
        parameterMap.put("user_role", "6");
        parameterMap.put("app_type", "10");
        parameterMap.put("msg", AppPushApi.getJsonMsg(config));
        parameterMap.put("app_id", Config.APP_ID);
        parameterMap.put("timestamp", String.valueOf(System.currentTimeMillis()));
        parameterMap.put("auth_token", AppPushApi.getTokenFromCache());
        parameterMap.put("msg_type", "0");
        logger.info("[Param] = " + parameterMap);
        try {
            RestfulResult result = RestUtil.getInstance().rest(RestUtils.RestMethod.POST, "push", "single", null, parameterMap, null);
            if (result.getCode() != 0) {
                logger.error("[Result] = " + ToStringBuilder.reflectionToString((Object)result));
                throw new RuntimeException("\u8fd4\u56de\u7ed3\u679c\u6709\u8bef");
            }
            logger.info("[Result] Push=" + ToStringBuilder.reflectionToString((Object)result));
        }
        catch (Exception e) {
            logger.error("[Push]parameterMap:{}", parameterMap);
            logger.error("[Push] Exception:", (Throwable)e);
            throw new RuntimeException("\u5916\u90e8\u63a5\u53e3\u8bbf\u95ee\u5931\u8d25");
        }
    }

    private static String getJsonMsg(PushConfig config) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("description", config.getTip());
        map.put("s", config.getJumpUrl());
        Gson gson = new Gson();
        return gson.toJson(map);
    }

    public static void bind(AppPushBindInfo info) {
        LinkedHashMap<String, String> parameterMap = new LinkedHashMap<String, String>();
        parameterMap.put("user_id", String.valueOf(info.getUserId()));
        parameterMap.put("user_role", "6");
        parameterMap.put("app_type", String.valueOf(info.getAppType()));
        parameterMap.put("tid", info.getTid());
        parameterMap.put("develop_status", String.valueOf(info.getDevelopStatus()));
        parameterMap.put("deploy_status", String.valueOf(info.getDeployStatus()));
        parameterMap.put("baidu_uid", info.getBaiduUid());
        parameterMap.put("baidu_cid", info.getBaiduCid());
        parameterMap.put("app_id", Config.APP_ID);
        parameterMap.put("timestamp", String.valueOf(System.currentTimeMillis()));
        parameterMap.put("auth_token", AppPushApi.getTokenFromCache());
        try {
            RestfulResult result = RestUtil.getInstance().rest(RestUtils.RestMethod.POST, "push", "bind", null, parameterMap, null);
            if (result.getCode() != 0) {
                throw new RuntimeException();
            }
        }
        catch (Exception e) {
            logger.error("[Push] Bind parameterMap:{}", parameterMap);
            logger.error("[Push] Exception:", (Throwable)e);
            throw new RuntimeException();
        }
    }

    public static void unBind(AppPushBindInfo info) {
        LinkedHashMap<String, String> parameterMap = new LinkedHashMap<String, String>();
        parameterMap.put("user_id", String.valueOf(info.getUserId()));
        parameterMap.put("user_role", "6");
        parameterMap.put("app_type", String.valueOf(info.getAppType()));
        parameterMap.put("tid", info.getTid());
        parameterMap.put("develop_status", String.valueOf(info.getDevelopStatus()));
        parameterMap.put("deploy_status", String.valueOf(info.getDeployStatus()));
        parameterMap.put("baidu_uid", info.getBaiduUid());
        parameterMap.put("baidu_cid", info.getBaiduCid());
        parameterMap.put("app_id", Config.APP_ID);
        parameterMap.put("timestamp", String.valueOf(System.currentTimeMillis()));
        parameterMap.put("auth_token", AppPushApi.getTokenFromCache());
        try {
            RestfulResult result = RestUtil.getInstance().rest(RestUtils.RestMethod.POST, "push", "bind", null, parameterMap, null);
            if (result.getCode() != 200) {
                throw new RuntimeException();
            }
        }
        catch (Exception e) {
            logger.error("[Push] UnBind parameterMap:{}", parameterMap);
            logger.error("[Push] Exception:", (Throwable)e);
            throw new RuntimeException();
        }
    }

    public static String getTokenFromCache() {
        String token = null;
        try {
            token = null;
            token = RestUtil.getInstance().getAuthToken();
            logger.info("Get token from cached,token=" + token);
        }
        catch (Exception e) {
            logger.error("NameChangeUtil.getTokenFromCache: rest-get-token error.", (Throwable)e);
        }
        return token;
    }

    static class MsgDetail {
        private String sendMT;
        private String chatType;

        MsgDetail() {
        }

        public String getSendMT() {
            return this.sendMT;
        }

        public void setSendMT(String sendMT) {
            this.sendMT = sendMT;
        }

        public String getChatType() {
            return this.chatType;
        }

        public void setChatType(String chatType) {
            this.chatType = chatType;
        }

        public static MsgDetail getDetail() {
            MsgDetail detail = new MsgDetail();
            detail.setChatType("0");
            detail.setSendMT("7");
            return detail;
        }
    }
}

