/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.organization.org.service.impl;

import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.dal.org.constant.AuditStatus;
import com.baijia.tianxiao.dal.org.constant.CampusAccountType;
import com.baijia.tianxiao.dal.org.constant.OrgImgType;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgPhotoDao;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgPhoto;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeCredential;
import com.baijia.tianxiao.dal.org.po.TXCommonRule;
import com.baijia.tianxiao.dal.push.constant.MsgUserRole;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.exception.ParameterException;
import com.baijia.tianxiao.exception.PermissionException;
import com.baijia.tianxiao.sal.organization.constant.CascadeSearchSource;
import com.baijia.tianxiao.sal.organization.constant.TXCommonRuleValue;
import com.baijia.tianxiao.sal.organization.org.dto.AccountSelectionDto;
import com.baijia.tianxiao.sal.organization.org.dto.OrgInfoSimpleDto;
import com.baijia.tianxiao.sal.organization.org.dto.TxCascadeCredentialDto;
import com.baijia.tianxiao.sal.organization.org.dto.TxCascadeCredentialSelectionDto;
import com.baijia.tianxiao.sal.organization.org.service.OrgInfoService;
import com.baijia.tianxiao.sal.organization.org.service.TXCommonRuleService;
import com.baijia.tianxiao.sal.organization.org.service.TxCascadeCredentialService;
import com.baijia.tianxiao.sal.organization.todo.dto.HeadTeacherRespDto;
import com.baijia.tianxiao.util.BaseUtils;
import com.baijia.tianxiao.util.CollectorUtil;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.HanZiPinYinUtils;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TxCascadeCredentialServiceImpl
implements TxCascadeCredentialService {
    private static final Logger log = LoggerFactory.getLogger(TxCascadeCredentialServiceImpl.class);
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    @Autowired
    private TXCascadeCredentialDao orgTxCascadeCredentialDao;
    @Autowired
    private OrgSubAccountDao orgSubAccountDao;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private TXCommonRuleService txCommonRuleService;
    @Autowired
    private TxConsultUserDao consultUserDao;
    @Autowired
    private OrgPhotoDao orgPhotoDao;
    @Autowired
    private OrgInfoService orgInfoService;
    @Autowired
    private OrgCourseDao orgCourseDao;

    @Override
    public Map<Long, String> getByTxCasCadeIds(Long orgId) {
        HashMap cascadeMap = Maps.newHashMap();
        OrgInfo orginfo = this.orgInfoDao.getOrgInfo(Integer.valueOf(orgId.intValue()), new String[0]);
        cascadeMap.put(0L, orginfo.getContacts());
        List txCascadeAccounts = this.txCascadeAccountDao.getTXCascadeAccountListByOrgId(orgId);
        log.debug("getByTxCasCadeIds orgId = {},cascadeMap={}", (Object)orgId, (Object)cascadeMap);
        if (GenericsUtils.isNullOrEmpty((Object)txCascadeAccounts)) {
            return cascadeMap;
        }
        Map cascadeIdsMap = CollectorUtil.collectMap((Collection)txCascadeAccounts, (Function)new Function<TXCascadeAccount, Integer>(){

            public Integer apply(TXCascadeAccount txCascadeAccount) {
                return txCascadeAccount.getId();
            }
        });
        Map cascadeMapResult = this.orgTxCascadeCredentialDao.getTxCascadCredentialListByCascdeIds(cascadeIdsMap.keySet());
        cascadeMapResult.put(0L, orginfo.getContacts());
        log.debug("getByTxCasCadeIds orgId = {},cascadeMapResult={}", (Object)orgId, (Object)cascadeMapResult);
        return cascadeMapResult;
    }

    @Override
    public TxCascadeCredentialDto getByTxCasCade(Long orgId, Integer cascadeId) {
        TXCascadeAccount txCascadeAccount = this.txCascadeAccountDao.getByIdAndOrgId(cascadeId, Integer.valueOf(orgId.intValue()));
        if (txCascadeAccount == null) {
            return null;
        }
        TXCascadeCredential txCascadeCredential = (TXCascadeCredential)this.orgTxCascadeCredentialDao.getById((Serializable)txCascadeAccount.getCredentialId(), new String[0]);
        TxCascadeCredentialDto result = this.buildToTxCascadeCredentialDto(txCascadeCredential);
        result.setUserType(txCascadeAccount.getAccountType());
        return result;
    }

    @Override
    public boolean isShowMobile(Long orgId, Integer cascadeId) {
        TXCommonRule commonRule;
        if (cascadeId == null || cascadeId == 0) {
            return true;
        }
        TxCascadeCredentialDto txCascadeCredentialDto = this.getByTxCasCade(orgId, cascadeId);
        boolean result = false;
        if (txCascadeCredentialDto != null && (txCascadeCredentialDto.getUserType() == CampusAccountType.MASTER_PRINCIPAL.getCode().intValue() || txCascadeCredentialDto.getUserType() == CampusAccountType.SLAVE_PRINCIPAL.getCode().intValue())) {
            result = true;
        }
        if ((commonRule = this.txCommonRuleService.getByOrgId(orgId.intValue())).getStudentMobileRule().intValue() == TXCommonRuleValue.STUDENT_MOBILE_DISPLAY.getCode()) {
            result = true;
        }
        log.debug("isShowMobile==orgId={},cascadeId={},isShowMobile ={}", new Object[]{orgId, cascadeId, result});
        return result;
    }

    @Override
    public List<TxCascadeCredentialDto> getTxCascadeCredentialList(Long orgId) {
        ArrayList result = Lists.newArrayList();
        OrgInfo orginfo = this.orgInfoDao.getOrgInfo(Integer.valueOf(orgId.intValue()), new String[0]);
        if (orginfo != null) {
            TxCascadeCredentialDto dto = new TxCascadeCredentialDto();
            dto.setCascadeId(0);
            dto.setName(orginfo.getContacts());
            dto.setUserType(CampusAccountType.SLAVE_PRINCIPAL.getCode());
            dto.setCredentialId(0);
            result.add(dto);
        }
        List txCascadeAccounts = this.txCascadeAccountDao.getTXCascadeAccountListByOrgId(orgId);
        log.debug("getTxCascadeCredentialList orgId = {},accounts={}", (Object)orgId, (Object)txCascadeAccounts);
        if (GenericsUtils.isNullOrEmpty((Object)txCascadeAccounts)) {
            return result;
        }
        Map credentialIdsMap = CollectorUtil.collectMap((Collection)txCascadeAccounts, (Function)new Function<TXCascadeAccount, Integer>(){

            public Integer apply(TXCascadeAccount txCascadeAccount) {
                return txCascadeAccount.getCredentialId();
            }
        });
        log.debug("getTxCascadeCredentialList credentialIdsMap={}", credentialIdsMap.keySet());
        List txCascadeCredentials = this.orgTxCascadeCredentialDao.getTxCascadCredentialListByCredentialIds(credentialIdsMap.keySet());
        for (TXCascadeCredential txCascadeCredential : txCascadeCredentials) {
            TxCascadeCredentialDto dto = this.buildToTxCascadeCredentialDto(txCascadeCredential);
            TXCascadeAccount txCascadeAccount = (TXCascadeAccount)credentialIdsMap.get((int)txCascadeCredential.getId());
            if (txCascadeAccount != null) {
                dto.setCascadeId(txCascadeAccount.getId());
            } else {
                dto.setCascadeId(0);
            }
            dto.setUserType(txCascadeAccount.getAccountType());
            result.add(dto);
        }
        log.debug("getTxCascadeCredentialList result={}", (Object)result);
        return result;
    }

    @Override
    public List<TxCascadeCredentialDto> getTxCascadeCredentialList(Long orgId, Integer cascadeId) {
        List txCascadeAccounts = this.txCascadeAccountDao.getTXCascadeAccountListByOrgId(orgId);
        OrgAccount orgAccount = this.orgAccountDao.getAccountById(orgId.intValue(), new String[0]);
        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(Integer.valueOf(orgId.intValue()), new String[0]);
        Integer orgNumber = orgAccount.getNumber();
        ArrayList<TxCascadeCredentialDto> txCascadeCredentialDtos = new ArrayList<TxCascadeCredentialDto>();
        if (GenericsUtils.notNullAndEmpty((Object)txCascadeAccounts)) {
            ArrayList<Integer> credentialIds = new ArrayList<Integer>();
            HashMap<Integer, Object> txCascadeAccountMap = new HashMap<Integer, Object>();
            for (Object txCascadeAccount : txCascadeAccounts) {
                if (txCascadeAccount.getId().equals(cascadeId)) continue;
                credentialIds.add(txCascadeAccount.getCredentialId());
                txCascadeAccountMap.put(txCascadeAccount.getCredentialId(), txCascadeAccount);
            }
            if (GenericsUtils.notNullAndEmpty(credentialIds)) {
                List txCascadeCredentials = this.orgTxCascadeCredentialDao.getTxCascadCredentialListByCredentialIds(credentialIds);
                for (TXCascadeCredential txCascadCredential : txCascadeCredentials) {
                    String name = txCascadCredential.getName();
                    String mobile = txCascadCredential.getMobile();
                    String str = this.getInitial(name, mobile);
                    TXCascadeAccount txCascadeAccount = (TXCascadeAccount)txCascadeAccountMap.get(txCascadCredential.getId());
                    TxCascadeCredentialDto txCascadeCredentialDto = TxCascadeCredentialDto.getInstance(txCascadCredential, txCascadeAccount);
                    txCascadeCredentialDto.setInitial(str.toUpperCase());
                    txCascadeCredentialDtos.add(txCascadeCredentialDto);
                }
            }
        }
        if (GenericsUtils.notNullAndEmpty((Object)cascadeId)) {
            Integer orgType = null;
            OrgSubAccount orgSubAccount = this.orgSubAccountDao.getMasterByOrgId(Integer.valueOf(orgId.intValue()));
            orgType = GenericsUtils.notNullAndEmpty((Object)orgSubAccount) ? Integer.valueOf(MsgUserRole.HEADER.getValue()) : Integer.valueOf(MsgUserRole.BRANCH_HEADER.getValue());
            String name = orgInfo.getShowName();
            String mobile = orgAccount.getMobile();
            String str = this.getInitial(name, mobile);
            String logo = null;
            try {
                OrgInfoSimpleDto orgDto = this.orgInfoService.getOrgInfo(orgId);
                logo = orgDto.getLogo();
            }
            catch (Exception e) {
                log.error("[ConsultMessage] orgLogo error param:{}", (Throwable)e);
            }
            TxCascadeCredentialDto txCascadeCredentialDto = TxCascadeCredentialDto.getInstanceByOrgInfo(orgType, orgInfo, orgNumber, logo);
            txCascadeCredentialDto.setInitial(str.toUpperCase());
            txCascadeCredentialDtos.add(txCascadeCredentialDto);
        }
        Comparator<TxCascadeCredentialDto> sortOfExportDto = new Comparator<TxCascadeCredentialDto>(){

            @Override
            public int compare(TxCascadeCredentialDto o1, TxCascadeCredentialDto o2) {
                String initial1 = o1.getInitial().equals("#") ? "~" : o1.getInitial();
                String initial2 = o2.getInitial().equals("#") ? "~" : o2.getInitial();
                return initial1.compareTo(initial2) >= 0 ? 1 : -1;
            }
        };
        if (GenericsUtils.notNullAndEmpty(txCascadeCredentialDtos)) {
            Collections.sort(txCascadeCredentialDtos, sortOfExportDto);
        }
        return txCascadeCredentialDtos;
    }

    private String getInitial(String name, String mobile) {
        String pinyin = "";
        pinyin = StringUtils.isNotBlank((CharSequence)name) ? HanZiPinYinUtils.getLowerCasePinYin((String)name) : HanZiPinYinUtils.getLowerCasePinYin((String)mobile);
        String str = "#";
        if (StringUtils.isNotBlank((CharSequence)pinyin)) {
            char init = pinyin.charAt(0);
            str = init >= '0' && init <= '9' ? "#" : String.valueOf(init);
        }
        return str;
    }

    @Override
    public List<TxCascadeCredentialSelectionDto> getTxCascadeCredentialList(Integer orgId, Long cascadeId, CascadeSearchSource source, AccountSelectionDto dto) {
        Integer principalCascadeId = 0;
        ArrayList<TxCascadeCredentialSelectionDto> list = new ArrayList<TxCascadeCredentialSelectionDto>();
        TXCascadeAccount cascadeAccount = null;
        HashSet<Integer> cascadesIds = new HashSet<Integer>();
        List txCascadeAccounts = this.txCascadeAccountDao.getTXCascadeAccountListByOrgId(Long.valueOf(Long.parseLong(orgId + "")), Integer.valueOf(Flag.FALSE.getInt()));
        HashMap<Integer, TXCascadeAccount> txCascadeIdMap = new HashMap<Integer, TXCascadeAccount>();
        HashMap<Integer, TXCascadeAccount> txCredentialIdMap = new HashMap<Integer, TXCascadeAccount>();
        for (Object txCascadeAccount : txCascadeAccounts) {
            txCascadeIdMap.put(txCascadeAccount.getId(), (TXCascadeAccount)txCascadeAccount);
            txCredentialIdMap.put(txCascadeAccount.getCredentialId(), (TXCascadeAccount)txCascadeAccount);
            cascadesIds.add(txCascadeAccount.getId());
        }
        if (cascadeId != null && cascadeId > 0L) {
            cascadeAccount = (TXCascadeAccount)txCascadeIdMap.get(cascadeId.intValue());
            if (cascadeAccount == null) {
                throw new PermissionException("\u8d26\u53f7ID\u4e0d\u5b58\u5728");
            }
        } else {
            cascadeId = principalCascadeId.longValue();
        }
        switch (source) {
            case CONSULTER_PASSTO: {
                cascadesIds.add(principalCascadeId);
                cascadesIds.addAll(txCascadeIdMap.keySet());
                if (dto.getConsulterId() == null) break;
                TxConsultUser txConsultUser = (TxConsultUser)this.consultUserDao.getById((Serializable)dto.getConsulterId(), new String[0]);
                cascadesIds.remove(txConsultUser.getCascadeId().intValue());
                break;
            }
            case CONSULTER_SEARCH: {
                cascadesIds.add(principalCascadeId);
                cascadesIds.addAll(txCascadeIdMap.keySet());
                break;
            }
            case COMMENT_NOTUFY_COLLEAGUE: {
                cascadesIds.add(principalCascadeId);
                cascadesIds.addAll(txCascadeIdMap.keySet());
                cascadesIds.remove(cascadeId.intValue());
                break;
            }
        }
        if (!CollectionUtils.isEmpty(cascadesIds)) {
            TxCascadeCredentialSelectionDto sdto;
            HashSet<Integer> credentialIds = new HashSet<Integer>();
            for (Integer n : cascadesIds) {
                if (txCascadeIdMap.get((int)n) == null) continue;
                credentialIds.add(((TXCascadeAccount)txCascadeIdMap.get((int)n)).getCredentialId());
            }
            if (credentialIds.size() > 0) {
                List txCascadeCredentials = this.orgTxCascadeCredentialDao.getTxCascadCredentialListByCredentialIds(credentialIds);
                for (TXCascadeCredential txCascadCredential : txCascadeCredentials) {
                    String name = txCascadCredential.getName();
                    String mobile = txCascadCredential.getMobile();
                    String str = this.getInitial(name, mobile);
                    TXCascadeAccount txCascadeAccount = (TXCascadeAccount)txCredentialIdMap.get(txCascadCredential.getId());
                    if (txCascadeAccount == null) continue;
                    sdto = TxCascadeCredentialSelectionDto.getInstance(txCascadCredential, txCascadeAccount);
                    sdto.setInitial(str.toUpperCase());
                    list.add(sdto);
                }
            }
            if (cascadesIds.contains((int)principalCascadeId)) {
                OrgAccount orgAccount = this.orgAccountDao.getAccountById(orgId.intValue(), new String[0]);
                OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(Integer.valueOf(orgId), new String[0]);
                Integer orgType = null;
                OrgSubAccount orgSubAccount = this.orgSubAccountDao.getMasterByOrgId(Integer.valueOf(orgId));
                orgType = GenericsUtils.notNullAndEmpty((Object)orgSubAccount) ? CampusAccountType.MASTER_PRINCIPAL.getCode() : CampusAccountType.SLAVE_PRINCIPAL.getCode();
                String name = orgInfo.getShowName();
                String mobile = orgAccount.getMobile();
                String str = this.getInitial(name, mobile);
                sdto = TxCascadeCredentialSelectionDto.getInstanceByOrgInfo(orgType, orgInfo);
                String logo = this.orgInfoService.getLogo(orgId);
                if (StringUtils.isNotBlank((CharSequence)logo)) {
                    sdto.setAvatarUrl(logo);
                }
                sdto.setInitial(str.toUpperCase());
                list.add(sdto);
            }
        }
        Comparator<TxCascadeCredentialSelectionDto> sortOfExportDto = new Comparator<TxCascadeCredentialSelectionDto>(){

            @Override
            public int compare(TxCascadeCredentialSelectionDto o1, TxCascadeCredentialSelectionDto o2) {
                if (o1.getInitial().matches("[a-zA-Z]*") && o2.getInitial().equals("#")) {
                    return -1;
                }
                if (o2.getInitial().matches("[a-zA-Z]*") && o1.getInitial().equals("#")) {
                    return 1;
                }
                return o1.getInitial().charAt(0) - o2.getInitial().charAt(0) >= 0 ? 1 : -1;
            }
        };
        Collections.sort(list, sortOfExportDto);
        return list;
    }

    @Override
    public void setAvatar(Long orgId, Integer cascadeId, Long storageId, String avatar) {
        if (cascadeId != null && cascadeId > 0) {
            TXCascadeAccount cascadeAccount = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)cascadeId, new String[0]);
            if (cascadeAccount == null) {
                throw new ParameterException();
            }
            TXCascadeCredential credential = (TXCascadeCredential)this.orgTxCascadeCredentialDao.getById((Serializable)cascadeAccount.getCredentialId(), new String[0]);
            credential.setStorageId(storageId);
            credential.setAvatar(avatar);
            credential.setUpdateTime(new Date());
            this.orgTxCascadeCredentialDao.update((Object)credential, Boolean.valueOf(false), new String[0]);
        } else {
            List photos = this.orgPhotoDao.getByOrgIdAndCategory(orgId.intValue(), 1);
            if (photos != null && photos.size() > 0) {
                OrgPhoto photo = (OrgPhoto)photos.get(0);
                photo.setOrgStorageId(Integer.valueOf(storageId.intValue()));
                photo.setUpdateTime(new Date());
                this.orgPhotoDao.update((Object)photo, Boolean.valueOf(false), new String[0]);
            } else {
                OrgPhoto orgPhoto = new OrgPhoto();
                orgPhoto.setOrgId(Integer.valueOf(orgId.intValue()));
                orgPhoto.setOrgStorageId(Integer.valueOf(storageId.intValue()));
                orgPhoto.setAuditstatus(AuditStatus.PASS.getValue());
                orgPhoto.setCategory(OrgImgType.ORG_LOGO.getValue());
                orgPhoto.setGroupId(Integer.valueOf(OrgImgType.ORG_LOGO.getGroupId()));
                orgPhoto.setCreateTime(new Date());
                orgPhoto.setUpdateTime(new Date());
                orgPhoto.setIsdel(DataStatus.NORMAL.getValue());
                this.orgPhotoDao.save((Object)orgPhoto, new String[0]);
            }
        }
    }

    private TxCascadeCredentialDto buildToTxCascadeCredentialDto(TXCascadeCredential txCascadeCredential) {
        TxCascadeCredentialDto dto = new TxCascadeCredentialDto();
        dto.setName(txCascadeCredential.getName());
        dto.setCredentialId(txCascadeCredential.getId());
        dto.setAvatarUrl(txCascadeCredential.getAvatar());
        return dto;
    }

    @Override
    public List<HeadTeacherRespDto> listPcHeadTeacher(Long orgId, String key, Long courseId) {
        OrgCourse orgCourse;
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"\u673a\u6784id\u975e\u6cd5");
        ArrayList dtos = Lists.newArrayList();
        OrgInfo orginfo = this.orgInfoDao.queryOrgInfo(orgId.intValue(), key);
        if (orginfo != null) {
            OrgAccount orgAccount = (OrgAccount)this.orgAccountDao.getById((Serializable)orgId, new String[0]);
            HeadTeacherRespDto dto = new HeadTeacherRespDto();
            dto.setAvatarUrl("http://img.gsxservice.com/11868862_i0x2qxlp.png");
            dto.setId(0);
            if (orgAccount != null) {
                dto.setMobile(orgAccount.getMobile());
            }
            dto.setName(orginfo.getContacts());
            dtos.add(dto);
        }
        Integer cascadeId = null;
        if (courseId != null && (orgCourse = (OrgCourse)this.orgCourseDao.getById((Serializable)courseId, new String[0])) != null) {
            if (orgCourse.getIsDel() == 1) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bfe\u7a0b\u4e0d\u5b58\u5728");
            }
            cascadeId = orgCourse.getCascadeId();
        }
        List txCascadeAccount = this.txCascadeAccountDao.listIdByOrgId(orgId, cascadeId);
        Map map = CollectorUtil.collectMap((Collection)txCascadeAccount, (Function)new Function<TXCascadeAccount, Integer>(){

            public Integer apply(TXCascadeAccount account) {
                return account.getCredentialId();
            }
        }, (Function)new Function<TXCascadeAccount, Integer>(){

            public Integer apply(TXCascadeAccount account) {
                return account.getId();
            }
        });
        Set cascadeIds = BaseUtils.getPropertiesList((List)txCascadeAccount, (String)"credentialId");
        List txCascadeCredential = this.orgTxCascadeCredentialDao.gueryByKey(key, cascadeId, (Collection)cascadeIds, null);
        dtos.addAll(HeadTeacherRespDto.converToDto(txCascadeCredential, map));
        Collections.sort(dtos, new Comparator(){

            public int compare(Object object1, Object object2) {
                HeadTeacherRespDto info1 = (HeadTeacherRespDto)object1;
                HeadTeacherRespDto info2 = (HeadTeacherRespDto)object2;
                return Collator.getInstance(Locale.CHINESE).compare(info1.getName(), info2.getName());
            }
        });
        return dtos;
    }
}

