/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.organization.finance.service.impl;

import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constants.signup.PayResult;
import com.baijia.tianxiao.constants.signup.SplitCourseResult;
import com.baijia.tianxiao.dal.finance.dao.CwDrawcashPurchaseDao;
import com.baijia.tianxiao.dal.finance.po.CWDrawcashPurchase;
import com.baijia.tianxiao.dal.org.dao.OrgFinanceAccountRecordDao;
import com.baijia.tianxiao.dal.org.po.OrgFinanceAccount;
import com.baijia.tianxiao.dal.org.po.OrgFinanceAccountRecord;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.dal.statistic.dao.TxFinanceRecordDayDao;
import com.baijia.tianxiao.filter.TianxiaoMContext;
import com.baijia.tianxiao.sal.organization.finance.constant.FinanceOpType;
import com.baijia.tianxiao.sal.organization.finance.constant.FinanceStatus;
import com.baijia.tianxiao.sal.organization.finance.dto.OrgFinanceAccountDto;
import com.baijia.tianxiao.sal.organization.finance.dto.OrgFinanceAccountRecordDto;
import com.baijia.tianxiao.sal.organization.finance.dto.response.FinanceAccountDto;
import com.baijia.tianxiao.sal.organization.finance.dto.response.FinanceAccountIncomeDto;
import com.baijia.tianxiao.sal.organization.finance.dto.response.OrgFinanceAccountRecordFromPay;
import com.baijia.tianxiao.sal.organization.finance.dto.response.TxFreezeAccountListDto;
import com.baijia.tianxiao.sal.organization.finance.service.OrgFinanceAccountService;
import com.baijia.tianxiao.sal.organization.finance.service.TxBankCardService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.ArithUtil;
import com.baijia.tianxiao.util.NumberUtil;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.baijia.tianxiao.util.pay.PayHttpRestUtil;
import com.google.common.collect.Lists;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OrgFinanceAcountServiceImpl
implements OrgFinanceAccountService {
    private static final Logger log = LoggerFactory.getLogger(OrgFinanceAcountServiceImpl.class);
    private static List<Integer> SPLIT_CODES_NOT_SIGN = Lists.newArrayList((Object[])new Integer[]{SplitCourseResult.PENDING.getCode(), SplitCourseResult.NOT_COMMIT.getCode()});
    private static List<Integer> PURCHASE_CODES_NOT_SIGN = Lists.newArrayList((Object[])new Integer[]{PayResult.SUCCESS.getCode()});
    @Resource
    private OrgSignupInfoDao orgSignupInfoDao;
    @Resource
    private CwDrawcashPurchaseDao cwDrawcashPurchaseDao;
    @Resource
    private TxBankCardService txBankCardService;
    @Resource
    private OrgFinanceAccountRecordDao orgFinanceAccountRecordDao;
    @Resource
    private TxFinanceRecordDayDao txFinanceRecordDayDao;

    private static boolean isNotNullJsonNode(Object node) {
        return node != null && !node.equals("null") && !node.toString().equals("{}") && !node.toString().equals("[]");
    }

    @Override
    public FinanceAccountDto getInfo(Long orgId) throws Exception {
        OrgFinanceAccount account = this.getAccountInfo(orgId);
        if (account == null) {
            return new FinanceAccountDto();
        }
        Long signupMoney = this.orgSignupInfoDao.sumByPurchaseStatus(orgId, (Collection)Lists.newArrayList((Object[])new Integer[]{PayResult.SUCCESS.getCode()}), (Collection)Lists.newArrayList((Object[])new Integer[]{SplitCourseResult.PENDING.getCode(), SplitCourseResult.NOT_COMMIT.getCode()}), null, true);
        double withdrawMoney = this.orgFinanceAccountRecordDao.sumDrawcashMoney(orgId.longValue());
        double settleMoney = this.getSettleMoney(orgId);
        int drawCashTime = this.txBankCardService.drawCashCount(orgId, DateUtil.getStrByDate((Date)new Date()), DateUtil.getStrByDate((Date)new Date()));
        return this.buildDto(account, signupMoney, withdrawMoney, settleMoney, drawCashTime);
    }

    private FinanceAccountDto buildDto(OrgFinanceAccount account, Long signupMoney, double withdrawMondy, double settleMoney, int drawCashTime) {
        FinanceAccountDto dto = new FinanceAccountDto();
        dto.setBalance(NumberUtil.numberWithDelimiter((double)account.getBalance()).substring(1));
        dto.setWithdrawMoney(NumberUtil.numberWithDelimiter((double)withdrawMondy).substring(1));
        dto.setSettleMoney(NumberUtil.numberWithDelimiter((double)settleMoney).substring(1));
        dto.setSignupMoney(signupMoney == null ? "0" : NumberUtil.numberWithDelimiter((double)ArithUtil.div((double)signupMoney.longValue(), (double)100.0, (int)2)).substring(1));
        dto.setFreezeMoney(NumberUtil.numberWithDelimiter((double)(account.getFreezeMoney() + account.getExpectedEarning())).substring(1));
        dto.setAssureMoney(NumberUtil.numberWithDelimiter((double)(account.getFreezeMoney() + account.getExpectedEarning() - withdrawMondy - settleMoney - ArithUtil.div((double)(signupMoney == null ? 0.0 : (double)signupMoney.longValue()), (double)100.0, (int)2))).substring(1));
        dto.setWithdrawLeftTimes(1 - drawCashTime);
        return dto;
    }

    private Double getSettleMoney(Long orgId) {
        List<TxFreezeAccountListDto> txFreezeAccountListDtos = this.settleList(orgId, null);
        double result = 0.0;
        for (TxFreezeAccountListDto txFreezeAccountListDto : txFreezeAccountListDtos) {
            result += Double.parseDouble(txFreezeAccountListDto.getOpMoney());
        }
        return result;
    }

    @Override
    public List<TxFreezeAccountListDto> signupList(Long orgId, PageDto pageDto) {
        List signupInfos = this.orgSignupInfoDao.listByStatus(orgId, PURCHASE_CODES_NOT_SIGN, SPLIT_CODES_NOT_SIGN, TianxiaoMContext.getTXCascadeId(), true, pageDto, new String[0]);
        if (signupInfos.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList result = Lists.newArrayList();
        for (OrgSignupInfo orgSignupInfo : signupInfos) {
            TxFreezeAccountListDto txFreezeAccountListDto = new TxFreezeAccountListDto();
            double opMoney = orgSignupInfo.getTotalPrices().longValue();
            txFreezeAccountListDto.setOpMoney(NumberUtil.numberWithDelimiter((double)(opMoney / 100.0)));
            txFreezeAccountListDto.setPayTypeStr("\u652f\u4ed8");
            txFreezeAccountListDto.setPayTime(DateUtil.getPayTime((Date)orgSignupInfo.getPayTime()));
            txFreezeAccountListDto.setStatusStr("");
            txFreezeAccountListDto.setOpInfo("\u673a\u6784\u62a5\u540d\u6536\u6b3e");
            result.add(txFreezeAccountListDto);
        }
        return result;
    }

    @Override
    public List<TxFreezeAccountListDto> settleList(Long orgId, PageDto pageDto) {
        List dto = Lists.newArrayList();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("user_id", orgId + "");
        params.put("user_role", UserRole.ORGANIZATION.getRole() + "");
        if (pageDto != null) {
            params.put("page", String.valueOf(pageDto.getPageNum()));
            params.put("size", String.valueOf(pageDto.getPageSize()));
        }
        params.put("_time", System.currentTimeMillis() + "");
        Object data = PayHttpRestUtil.rest((String)(PayHttpRestUtil.PAY_SERVICE + "/wallet/noSettlementRecords"), params);
        if (OrgFinanceAcountServiceImpl.isNotNullJsonNode(data)) {
            JSONArray jsondata = JSONArray.fromObject((Object)data);
            try {
                dto = JacksonUtil.str2List((String)jsondata.toString(), OrgFinanceAccountRecordFromPay.class);
            }
            catch (Exception e) {
                log.warn("e", (Throwable)e);
            }
        }
        if (dto.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList result = Lists.newArrayList();
        for (OrgFinanceAccountRecordFromPay financeAccountRecord : dto) {
            TxFreezeAccountListDto listDto = new TxFreezeAccountListDto();
            listDto.setOpInfo(financeAccountRecord.getOp_info());
            listDto.setStatusStr(FinanceStatus.SETTLE.getValue());
            listDto.setStatus(FinanceStatus.SETTLE.getCode());
            listDto.setPayTime(DateUtil.getPayTime((Date)DateUtil.getStrToDate((String)"yyyy-MM-dd HH:mm:ss", (String)financeAccountRecord.getCreate_time())));
            listDto.setOpMoney(NumberUtil.get2FromDouble((double)financeAccountRecord.getOp_money()));
            listDto.setPayTypeStr(FinanceOpType.getByCode(financeAccountRecord.getOp_type()));
            listDto.setPurchase_id(financeAccountRecord.getPurchase_id());
            result.add(listDto);
        }
        return result;
    }

    @Override
    public List<TxFreezeAccountListDto> withdrawList(Long orgId, Integer status, PageDto pageDto) {
        List list = Lists.newArrayList();
        list = status != null && status == 0 ? this.cwDrawcashPurchaseDao.listDrawcashing(orgId, pageDto, new String[0]) : this.cwDrawcashPurchaseDao.listAll(orgId, pageDto, new String[0]);
        if (list.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList result = Lists.newArrayList();
        for (CWDrawcashPurchase dto : list) {
            TxFreezeAccountListDto listDto = new TxFreezeAccountListDto();
            listDto.setPayTime(DateUtil.getPayTime((Date)dto.getUpdateTime()));
            if (dto.getStatus() == 3 || dto.getStatus() == 5) {
                listDto.setOpMoney(NumberUtil.numberWithDelimiter((double)dto.getAmount()));
            } else {
                listDto.setOpMoney(NumberUtil.numberWithDelimiter((double)(-dto.getAmount().doubleValue())));
            }
            listDto.setPayTypeStr("\u63d0\u73b0");
            listDto.setStatusStr(dto.getStatus() == 2 ? "\u63d0\u73b0\u6210\u529f" : (dto.getStatus() == 3 || dto.getStatus() == 5 ? "\u63d0\u73b0\u9000\u56de" : "\u63d0\u73b0\u4e2d"));
            listDto.setOpInfo("\u63d0\u73b0\u81f3" + dto.getBankName() + (dto.getCardNum() != null && dto.getCardNum().length() > 4 ? "(" + dto.getCardNum().substring(dto.getCardNum().length() - 4) + ")" : ""));
            if (listDto.getStatusStr().equals("\u63d0\u73b0\u4e2d")) {
                listDto.setStatus(FinanceStatus.WITHDRAW.getCode());
            }
            result.add(listDto);
        }
        return result;
    }

    @Override
    public OrgFinanceAccount getAccountInfo(Long orgId) {
        OrgFinanceAccountDto dto = null;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("org_id", String.valueOf(orgId));
        Object data = PayHttpRestUtil.rest((String)(PayHttpRestUtil.PAY_SERVICE + "/org/orgAccountInfo"), params);
        if (OrgFinanceAcountServiceImpl.isNotNullJsonNode(data)) {
            JSONObject jsondata = JSONObject.fromObject((Object)data);
            try {
                dto = (OrgFinanceAccountDto)JacksonUtil.str2Obj((String)jsondata.toString(), OrgFinanceAccountDto.class);
            }
            catch (Exception e) {
                log.warn("e", (Throwable)e);
            }
        }
        return this.bulidAccount(dto);
    }

    @Override
    public List<OrgFinanceAccountDto> getAccountInfos(List<Long> orgIds) {
        List list = Lists.newArrayList();
        StringBuffer stringBuffer = new StringBuffer();
        for (Long id : orgIds) {
            stringBuffer.append(",").append(id);
        }
        String param = stringBuffer.toString().substring(1);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("orgIds", param);
        Object data = PayHttpRestUtil.rest((String)(PayHttpRestUtil.PAY_SERVICE + "/org/getBatchAccountInfo"), params);
        if (OrgFinanceAcountServiceImpl.isNotNullJsonNode(data)) {
            JSONArray jsondata = JSONArray.fromObject((Object)data);
            try {
                list = JacksonUtil.str2List((String)jsondata.toString(), OrgFinanceAccountDto.class);
            }
            catch (Exception e) {
                log.warn("e", (Throwable)e);
            }
        }
        return list;
    }

    @Override
    public OrgFinanceAccountRecord getAccountRecordInfo(Long orgId, Date date) {
        OrgFinanceAccountRecordDto dto = null;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("org_id", String.valueOf(orgId));
        params.put("create_time", String.valueOf(date));
        Object data = PayHttpRestUtil.rest((String)(PayHttpRestUtil.PAY_SERVICE + "/org/getRecordInfo"), params);
        if (OrgFinanceAcountServiceImpl.isNotNullJsonNode(data)) {
            JSONObject jsondata = JSONObject.fromObject((Object)data);
            try {
                dto = (OrgFinanceAccountRecordDto)JacksonUtil.str2Obj((String)jsondata.toString(), OrgFinanceAccountRecordDto.class);
            }
            catch (Exception e) {
                log.warn("e", (Throwable)e);
            }
        }
        if (dto == null || dto.getId() == null) {
            return null;
        }
        return this.buildRecord(dto);
    }

    @Override
    public List<OrgFinanceAccountRecord> getAccountRecordInfos(Long syncId) {
        List list = Lists.newArrayList();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", String.valueOf(syncId));
        params.put("maxSize", "100");
        Object data = PayHttpRestUtil.rest((String)(PayHttpRestUtil.PAY_SERVICE + "/org/orgAccountIncreasedRecord"), params);
        if (OrgFinanceAcountServiceImpl.isNotNullJsonNode(data)) {
            JSONArray records = JSONArray.fromObject((Object)data);
            try {
                list = JacksonUtil.str2List((String)records.toString(), OrgFinanceAccountRecordDto.class);
            }
            catch (Exception e) {
                log.warn("e", (Throwable)e);
            }
        }
        return this.buildAccounts(list);
    }

    private OrgFinanceAccount bulidAccount(OrgFinanceAccountDto dto) {
        OrgFinanceAccount account = new OrgFinanceAccount();
        account.setExpectedEarning(Double.valueOf(dto.getExpected_earning() != null ? Double.parseDouble(dto.getExpected_earning()) : 0.0));
        account.setBalance(Double.valueOf(dto.getBalance() != null ? Double.parseDouble(dto.getBalance()) : 0.0));
        account.setFreezeMoney(Double.valueOf(dto.getFreeze_money() != null ? Double.parseDouble(dto.getFreeze_money()) : 0.0));
        account.setCreatTime(dto.getCreate_time() == null ? null : DateUtil.getDateByStr((String)dto.getCreate_time()));
        account.setId(Integer.valueOf(dto.getId() == null ? 0 : Integer.parseInt(dto.getId())));
        account.setIncome(Double.valueOf(dto.getIncome() != null ? Double.parseDouble(dto.getIncome()) : 0.0));
        account.setOrgName(dto.getOrg_name());
        account.setUpdateTime(dto.getUpdate_time() == null ? null : DateUtil.getDateByStr((String)dto.getUpdate_time()));
        account.setOrgId(dto.getOrg_id() == null ? null : Long.valueOf(Long.parseLong(dto.getOrg_id())));
        return account;
    }

    private OrgFinanceAccountRecord buildRecord(OrgFinanceAccountRecordDto dto) {
        OrgFinanceAccountRecord record = new OrgFinanceAccountRecord();
        record.setCurrBalance(Double.valueOf(dto.getCurr_balance() == null ? 0.0 : Double.parseDouble(dto.getCurr_balance())));
        record.setCurrFreezeMoney(Double.valueOf(dto.getCurr_freeze_money() == null ? 0.0 : Double.parseDouble(dto.getCurr_freeze_money())));
        record.setCurrExpectedEarning(Double.valueOf(dto.getCurr_expected_earning() == null ? 0.0 : Double.parseDouble(dto.getCurr_expected_earning())));
        record.setActivitySourceUserRole(dto.getActivity_source_user_role() != null ? Integer.valueOf(Integer.parseInt(dto.getActivity_source_user_role())) : null);
        record.setCreateTime(dto.getCreate_time() == null ? new Timestamp(System.currentTimeMillis()) : Timestamp.valueOf(dto.getCreate_time()));
        record.setCurrIncome(Double.valueOf(dto.getCurr_income() == null ? 0.0 : Double.parseDouble(dto.getCurr_income())));
        record.setCurrPayType(dto.getCurr_pay_type());
        record.setDestId(dto.getDest_id() != null ? Long.valueOf(Long.parseLong(dto.getDest_id())) : null);
        record.setId(Integer.valueOf(Integer.parseInt(dto.getId())));
        record.setIsShow(Integer.valueOf(dto.getIs_show() == null ? 1 : Integer.parseInt(dto.getIs_show())));
        record.setNote(dto.getNote());
        record.setOpDesc(dto.getOp_desc());
        record.setOpInfo(dto.getOp_info());
        record.setOpMoney(Double.valueOf(dto.getOp_money() == null ? 0.0 : Double.parseDouble(dto.getOp_money())));
        record.setOpMoneyType(dto.getOp_money_type() != null ? Integer.valueOf(Integer.parseInt(dto.getOp_money_type())) : null);
        record.setOpStatus(dto.getOp_status() != null ? Integer.valueOf(Integer.parseInt(dto.getOp_status())) : null);
        record.setOpType(Integer.valueOf(dto.getOp_type() == null ? 1 : Integer.parseInt(dto.getOp_type())));
        record.setOrderLessonId(dto.getOrder_lesson_id() != null ? Long.valueOf(Long.parseLong(dto.getOrder_lesson_id())) : null);
        record.setOrgId(Long.valueOf(dto.getOrg_id() == null ? 0L : Long.parseLong(dto.getOrg_id())));
        record.setOrgName(dto.getOrg_name());
        record.setPayType(dto.getPay_type());
        record.setPreBalance(Double.valueOf(dto.getPre_balance() == null ? 0.0 : Double.parseDouble(dto.getPre_balance())));
        record.setPreExpectedEarning(Double.valueOf(dto.getPre_expected_earning() == null ? 0.0 : Double.parseDouble(dto.getPre_expected_earning())));
        record.setPreFreezeMoney(Double.valueOf(dto.getPre_freeze_money() == null ? 0.0 : Double.parseDouble(dto.getPre_freeze_money())));
        record.setPreIncome(Double.valueOf(dto.getPre_income() == null ? 0.0 : Double.parseDouble(dto.getPre_income())));
        record.setPurchaseId(dto.getPurchase_id() == null ? null : Long.valueOf(Long.parseLong(dto.getPurchase_id())));
        return record;
    }

    private List<OrgFinanceAccountRecord> buildAccounts(List<OrgFinanceAccountRecordDto> list) {
        ArrayList result = Lists.newArrayList();
        for (OrgFinanceAccountRecordDto dto : list) {
            OrgFinanceAccountRecord o = this.buildRecord(dto);
            result.add(o);
        }
        return result;
    }

    @Override
    public FinanceAccountIncomeDto getIncome(Long orgId) {
        FinanceAccountIncomeDto dto = new FinanceAccountIncomeDto();
        Double day = this.txFinanceRecordDayDao.getIncome(orgId, DateUtil.getCurrentDate(), DateUtil.getDayDiff((int)1));
        Double week = this.txFinanceRecordDayDao.getIncome(orgId, DateUtil.getStartOfWeek(), DateUtil.getEndOfWeek());
        Double month = this.txFinanceRecordDayDao.getIncome(orgId, DateUtil.getStartOfMonth(), DateUtil.getEndOfMonth());
        Double total = this.txFinanceRecordDayDao.getIncome(orgId, null, null);
        log.debug("---------------{},{},{},{}", new Object[]{day, week, month, total});
        String incomeToday = NumberUtil.numberWithDelimiter((double)day).substring(1);
        String incomeWeek = NumberUtil.numberWithDelimiter((double)week).substring(1);
        String incomeMonth = NumberUtil.numberWithDelimiter((double)month).substring(1);
        String income = NumberUtil.numberWithDelimiter((double)total).substring(1);
        dto.setIncome(income);
        dto.setIncomeToday(incomeToday);
        dto.setIncomeMonth(incomeMonth);
        dto.setIncomeWeek(incomeWeek);
        return dto;
    }
}

