/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.organization.org.service.impl;

import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.constant.TXAccountStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.sal.organization.org.service.TXAccountService;
import com.baijia.tianxiao.util.SmsSendUtil;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TXAccountServiceImpl
implements TXAccountService {
    private static final Logger log = LoggerFactory.getLogger(TXAccountServiceImpl.class);
    @Autowired
    private TXAccountDao txAccountDao;
    @Autowired
    private OrgSubAccountDao orgSubAccountDao;
    @Autowired
    private OrgAccountDao orgAccountDao;

    @Override
    public boolean orgAccessValid(Integer orgId) {
        Integer masterOrgId;
        TXAccount txAccount;
        OrgSubAccount orgSubAccount;
        OrgAccount orgAccount;
        return null != orgId && null != (orgAccount = this.orgAccountDao.getAccountById(orgId.intValue(), new String[0])) && orgAccount.getIsDel().intValue() == DeleteStatus.NORMAL.getValue() && null != (orgSubAccount = this.orgSubAccountDao.getByOrgId(orgId, new String[0])) && orgSubAccount.getIsdel().intValue() == DeleteStatus.NORMAL.getValue() && null != (txAccount = this.getByOrgId(masterOrgId = orgSubAccount.getPid() > 0 ? orgSubAccount.getPid() : orgSubAccount.getOrgId(), new String[0])) && txAccount.getIsdel().intValue() == DeleteStatus.NORMAL.getValue() && txAccount.getStatus() == TXAccountStatus.VALID.getCode();
    }

    @Override
    public TXAccount getByOrgId(Integer orgId, String ... props) {
        TXAccount account = this.txAccountDao.getByOrgId(orgId, TXAccountStatus.VALID.getCode(), props);
        return account;
    }

    @Override
    @Deprecated
    public TXAccount getByOrgIdIgnoreStatus(Integer orgId, String ... props) {
        TXAccount account = this.txAccountDao.getByOrgId(orgId, null, props);
        return account;
    }

    @Override
    public TXAccount getByIdAndOrgId(Integer id, Integer orgId) {
        TXAccount account = this.txAccountDao.getByIdAndOrgId(id, orgId);
        return account;
    }

    @Override
    public TXAccount getByOrgNumber(Integer orgNumber) {
        TXAccount txAccount = this.txAccountDao.getByOrgNumber(orgNumber);
        return txAccount;
    }

    @Override
    public TXAccount getTXAccountByOrgId(Integer orgId, String ... props) {
        OrgSubAccount subAcc = this.orgSubAccountDao.getByOrgIdIgnoreDelStatus(orgId);
        log.info("subAcc is:{} ", (Object)subAcc);
        TXAccount superAcc = null;
        superAcc = 0 == subAcc.getPid() ? this.getByOrgId(orgId, props) : this.getByOrgId(subAcc.getPid(), props);
        return superAcc;
    }

    @Override
    public Integer getTxAccountSmsGate(Integer orgId) {
        if (orgId == null) {
            return SmsSendUtil.DEFAULT_SMS_GATE;
        }
        TXAccount txAccount = this.getTXAccountByOrgId((int)orgId, new String[0]);
        if (txAccount == null) {
            return SmsSendUtil.DEFAULT_SMS_GATE;
        }
        return txAccount.getSmsGate();
    }

    @Override
    public void saveTXAccount(TXAccount txAccount) {
        this.txAccountDao.save((Object)txAccount, new String[0]);
    }

    @Override
    public TXAccount getByMobile(String mobile) {
        OrgAccount orgAccount = this.orgAccountDao.getAccountByMobile(mobile);
        TXAccount txAccount = null;
        if (orgAccount != null) {
            txAccount = this.txAccountDao.getByOrgId(orgAccount.getId(), TXAccountStatus.VALID.getCode(), new String[0]);
        }
        return txAccount;
    }

    @Override
    public TXAccount getById(Long id) {
        return (TXAccount)this.txAccountDao.getById((Serializable)id, new String[0]);
    }

    @Override
    public List<Long> getAllTxAccountOrgId() {
        return this.txAccountDao.getAllTxAccountOrgId();
    }
}

