/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.organization.org.service.impl;

import com.baijia.tianxiao.dal.addressbook.dao.TXAddressBookDao;
import com.baijia.tianxiao.dal.org.dao.OrgBranchsDao;
import com.baijia.tianxiao.dal.org.po.OrgBranchs;
import com.baijia.tianxiao.sal.organization.index.dto.OrgBranchsDto;
import com.baijia.tianxiao.sal.organization.org.service.OrgBranchsService;
import com.baijia.tianxiao.util.GenericsUtils;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class OrgBranchsServicesImpl
implements OrgBranchsService {
    private static final Logger log = LoggerFactory.getLogger(OrgBranchsServicesImpl.class);
    @Autowired
    private OrgBranchsDao orgBranchsDao;
    @Autowired
    private TXAddressBookDao txAddressBookDao;

    @Override
    public OrgBranchs getDefaultOrgBranchs(int orgId) {
        List branchsList = this.orgBranchsDao.listBranchsByOrgId(orgId);
        if (branchsList != null && branchsList.size() > 0) {
            return (OrgBranchs)branchsList.get(0);
        }
        return new OrgBranchs();
    }

    @Override
    public OrgBranchsDto getDefOrgBranchsDto(int orgId) {
        OrgBranchsDto dto = new OrgBranchsDto();
        List branchsList = this.orgBranchsDao.listBranchsByOrgId(orgId);
        if (branchsList != null && branchsList.size() > 0) {
            OrgBranchs orgBranchs = (OrgBranchs)branchsList.get(0);
            dto.setProvince(orgBranchs.getProvince());
            dto.setCounty(orgBranchs.getCounty());
            dto.setDistrict(orgBranchs.getDistrict());
            dto.setAddress(orgBranchs.getAddress());
            dto.setLongitude(orgBranchs.getLongitude());
            dto.setLatitude(orgBranchs.getLatitude());
        }
        return dto;
    }

    @Override
    public void saveOrUpdate(int orgId, String province, String county, String district, String address, String longitude, String latitude) {
        OrgBranchs orgBranchs = this.getDefaultOrgBranchs(orgId);
        Date now = new Date();
        if (orgBranchs == null) {
            orgBranchs = new OrgBranchs();
            orgBranchs.setCreateTime(now);
        }
        if (StringUtils.isEmpty((Object)orgBranchs.getBranchName())) {
            orgBranchs.setBranchName("\u4e3b\u6821\u533a");
        }
        orgBranchs.setOrgId(Integer.valueOf(orgId));
        orgBranchs.setProvince(province);
        orgBranchs.setCounty(county);
        orgBranchs.setDistrict(district);
        orgBranchs.setAddress(address);
        orgBranchs.setLongitude(longitude);
        orgBranchs.setLatitude(latitude);
        orgBranchs.setUpdateTime(now);
        log.debug("save or update orgBranch==={}", (Object)orgBranchs);
        this.orgBranchsDao.saveOrUpdate((Object)orgBranchs, new String[0]);
    }

    @Override
    public void saveAddressDetail(int orgId, String addressDetail) {
        OrgBranchs orgBranchs = this.getDefaultOrgBranchs(orgId);
        if (GenericsUtils.isNullOrEmpty((Object)orgBranchs.getId())) {
            OrgBranchs orgBranchsNew = new OrgBranchs();
            orgBranchsNew.setAddressDetail(addressDetail);
            orgBranchsNew.setOrgId(Integer.valueOf(orgId));
            orgBranchsNew.setCreateTime(new Date());
            orgBranchsNew.setUpdateTime(new Date());
            this.orgBranchsDao.save((Object)orgBranchsNew, new String[0]);
        } else {
            orgBranchs.setAddressDetail(addressDetail);
            orgBranchs.setUpdateTime(new Date());
            this.orgBranchsDao.update((Object)orgBranchs, new String[0]);
        }
    }
}

