/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.organization.finance.service.impl;

import com.baijia.commons.lang.utils.JacksonUtil;
import com.baijia.tianxiao.constants.signup.PayType;
import com.baijia.tianxiao.dal.finance.dao.TxFinanceInfoDao;
import com.baijia.tianxiao.dal.finance.po.TxxFinanceInfo;
import com.baijia.tianxiao.dal.org.dao.CoursePurchaseDao;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.po.CoursePurchase;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.excel.dto.ExportField;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.organization.finance.constant.FinanceOpType;
import com.baijia.tianxiao.sal.organization.finance.constant.FinanceStatus;
import com.baijia.tianxiao.sal.organization.finance.dto.request.TxFinanceInfoRequest;
import com.baijia.tianxiao.sal.organization.finance.dto.request.TxFinanceRecordRequest;
import com.baijia.tianxiao.sal.organization.finance.dto.response.TxFinanceInfoAppDto;
import com.baijia.tianxiao.sal.organization.finance.dto.response.TxFinanceInfoDto;
import com.baijia.tianxiao.sal.organization.finance.dto.response.TxFinanceRecordDto;
import com.baijia.tianxiao.sal.organization.finance.dto.response.TxFreezeAccountListDto;
import com.baijia.tianxiao.sal.organization.finance.service.ExcelFinanceExportService;
import com.baijia.tianxiao.sal.organization.finance.service.OrgFinanceAccountService;
import com.baijia.tianxiao.sal.organization.finance.service.TxFinanceInfoService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.ArithUtil;
import com.baijia.tianxiao.util.NumberUtil;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.baijia.tianxiao.util.date.DateUtil;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TxFinanceInfoServiceImpl
implements TxFinanceInfoService {
    private static final Logger log = LoggerFactory.getLogger(TxFinanceInfoServiceImpl.class);
    @Resource
    private TxFinanceInfoDao txFinanceinfoDao;
    @Resource
    private OrgInfoDao orgInfoDao;
    @Resource
    private OrgAccountDao orgAccountDao;
    @Resource
    private OrgFinanceAccountService orgFinanceAccountService;
    @Resource
    private CoursePurchaseDao coursePurchaseDao;

    @Override
    public List<TxFinanceInfoDto> list(Long orgId, TxFinanceInfoRequest request, PageDto page) {
        TxxFinanceInfo txFinanceInfo = new TxxFinanceInfo();
        if (request.getOpType() != null && request.getOpType().size() != 0) {
            txFinanceInfo.setOpTypes(FinanceOpType.getByOpType(request.getOpType()));
        }
        if (request.getOpTo() != null && request.getOpTo().size() != 0) {
            txFinanceInfo.setOpTos(request.getOpTo());
        }
        if (request.getPayType() != null && request.getPayType().size() != 0) {
            txFinanceInfo.setPayTypes(request.getPayType());
        }
        if (request.getStartPrice() != null && request.getEndPrice() != null) {
            txFinanceInfo.setStartBalance(request.getStartPrice());
            txFinanceInfo.setEndBalance(request.getEndPrice());
        }
        txFinanceInfo.setStartTime(request.getStartTime());
        txFinanceInfo.setEndTime(request.getEndTime());
        txFinanceInfo.setOrgId(orgId);
        List result = this.txFinanceinfoDao.list(txFinanceInfo, request.getSearchKey(), page, new String[0]);
        if (CollectionUtils.isEmpty((Collection)result)) {
            return Collections.EMPTY_LIST;
        }
        return this.buildDto(result);
    }

    @Override
    public List<TxFinanceInfoAppDto> appList(Long orgId, TxFinanceInfoRequest request, PageDto page) {
        TxxFinanceInfo txFinanceInfo = new TxxFinanceInfo();
        txFinanceInfo.setStartTime(request.getStartTime());
        txFinanceInfo.setEndTime(request.getEndTime());
        txFinanceInfo.setOrgId(orgId);
        List data = this.txFinanceinfoDao.list(txFinanceInfo, request.getSearchKey(), page, new String[0]);
        if (CollectionUtils.isEmpty((Collection)data)) {
            return Collections.EMPTY_LIST;
        }
        List<TxFreezeAccountListDto> txFreezeAccountListDtos = this.orgFinanceAccountService.settleList(orgId, null);
        final HashSet purchaseIds = Sets.newHashSet();
        Map purchaseMap = CollectorUtil.collectMap(txFreezeAccountListDtos, (Function)new Function<TxFreezeAccountListDto, String>(){

            public String apply(TxFreezeAccountListDto txFreezeAccountListDto) {
                purchaseIds.add(txFreezeAccountListDto.getPurchase_id());
                return txFreezeAccountListDto.getPurchase_id() + "";
            }
        });
        HashMap signPurchaseMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)purchaseIds)) {
            List coursePurchaseList = this.coursePurchaseDao.getByPurcahseIds((Set)purchaseIds);
            Map signPurchaseMap1 = CollectorUtil.collectMap((Collection)coursePurchaseList, (Function)new Function<CoursePurchase, String>(){

                public String apply(CoursePurchase coursePurchase) {
                    return coursePurchase.getParentPurchaseId() + "";
                }
            });
            signPurchaseMap.putAll(signPurchaseMap1);
        }
        ArrayList result = Lists.newArrayList();
        for (TxxFinanceInfo txxFinanceInfo : data) {
            TxFinanceInfoAppDto txFinanceInfoAppDto = new TxFinanceInfoAppDto();
            txFinanceInfoAppDto.setPayTime(DateUtil.getPayTime((Date)txxFinanceInfo.getCreateTime()));
            txFinanceInfoAppDto.setOpInfo(txxFinanceInfo.getOpInfo());
            if (txxFinanceInfo.getOpTo() == 2) {
                txFinanceInfoAppDto.setOpMoney(NumberUtil.numberWithDelimiter((double)(-txxFinanceInfo.getOpMoney().doubleValue())));
            } else {
                txFinanceInfoAppDto.setOpMoney(NumberUtil.numberWithDelimiter((double)txxFinanceInfo.getOpMoney()));
            }
            txFinanceInfoAppDto.setPayTypeStr(FinanceOpType.getByCode(txxFinanceInfo.getOpType()));
            TxFreezeAccountListDto txfreeAccount = (TxFreezeAccountListDto)((Object)purchaseMap.get(txxFinanceInfo.getPurchaseId()));
            CoursePurchase coursePurchase = null;
            if (txfreeAccount == null) {
                coursePurchase = (CoursePurchase)signPurchaseMap.get(txxFinanceInfo.getPurchaseId());
            }
            if (!(txfreeAccount == null && coursePurchase == null || txFinanceInfoAppDto.getOpMoney().startsWith("-"))) {
                txFinanceInfoAppDto.setStatusStr(FinanceStatus.SETTLE.getValue());
                txFinanceInfoAppDto.setStatus(FinanceStatus.SETTLE.getCode());
            } else {
                txFinanceInfoAppDto.setStatusStr("");
            }
            result.add(txFinanceInfoAppDto);
        }
        return result;
    }

    private List<TxFinanceInfoDto> buildDto(List<TxxFinanceInfo> list) {
        ArrayList result = Lists.newArrayList();
        for (TxxFinanceInfo txFinanceInfo : list) {
            TxFinanceInfoDto dto = new TxFinanceInfoDto();
            dto.setPurchaseId(txFinanceInfo.getPurchaseId());
            dto.setCourseId(txFinanceInfo.getCourseId());
            dto.setCreateTime(txFinanceInfo.getCreateTime());
            dto.setOpType(txFinanceInfo.getOpType());
            dto.setOpTypeStr(FinanceOpType.getByCode(dto.getOpType()));
            dto.setOpTo(txFinanceInfo.getOpTo());
            dto.setPayType(txFinanceInfo.getPayType());
            dto.setPayTypeStr(PayType.getByCode((int)dto.getPayType()));
            dto.setBalance(txFinanceInfo.getCurrBalance() + txFinanceInfo.getCurrFreezeMoney() + txFinanceInfo.getExpectedEarning());
            dto.setBalance(ArithUtil.round((double)dto.getBalance(), (int)2));
            dto.setOpInfo(txFinanceInfo.getOpInfo());
            dto.setOpMoney(txFinanceInfo.getOpTo() == 2 ? -txFinanceInfo.getOpMoney().doubleValue() : txFinanceInfo.getOpMoney());
            dto.setOpMoney(ArithUtil.round((double)dto.getOpMoney(), (int)2));
            result.add(dto);
        }
        return result;
    }

    @Override
    public void export(HttpServletResponse response, TxFinanceRecordRequest recordRequest, List<TxFinanceRecordDto> recordDtos, List<TxFinanceInfoDto> infoDtos) {
        Preconditions.checkArgument((recordDtos != null ? 1 : 0) != 0, (Object)"\u6c47\u603b\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((infoDtos != null ? 1 : 0) != 0, (Object)"\u660e\u7ec6\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(Integer.valueOf(recordRequest.getOrgId().intValue()), new String[0]);
        OrgAccount orgAccount = this.orgAccountDao.getAccountById(recordRequest.getOrgId().intValue(), new String[0]);
        Date startDate = null;
        Date endDate = null;
        if (recordRequest.getDate() != null) {
            startDate = endDate = DateUtil.getDateByDay((int)recordRequest.getYear(), (int)recordRequest.getMonth(), (int)recordRequest.getDate());
        } else {
            startDate = DateUtil.getDateByYearMonth((int)recordRequest.getYear(), (int)recordRequest.getMonth());
            endDate = DateUtil.endDateByYearMonth((int)recordRequest.getYear(), (int)recordRequest.getMonth());
        }
        startDate = DateUtil.getStartOfDay((Date)startDate);
        endDate = DateUtil.getEndOfDay((Date)endDate);
        SXSSFWorkbook workbook = null;
        try {
            workbook = new SXSSFWorkbook(1000);
            HashMap<String, CellStyle> cellStyleMap = new HashMap<String, CellStyle>();
            ArrayList recordFields = Lists.newArrayList();
            recordFields.add(new ExportField("\u7c7b\u578b", "@", 5120));
            recordFields.add(new ExportField("\u6536\u5165\u7b14\u6570", "@", 5120));
            recordFields.add(new ExportField("\u6536\u5165\u91d1\u989d\uff08+\u5143\uff09", "@", 5120));
            recordFields.add(new ExportField("\u652f\u51fa\u7b14\u6570", "@", 5120));
            recordFields.add(new ExportField("\u652f\u51fa\u91d1\u989d\uff08-\u5143\uff09\uff09", "@", 5120));
            recordFields.add(new ExportField("\u603b\u91d1\u989d\uff08\u5143\uff09", "@", 5120));
            ArrayList recordTitles = Lists.newArrayList();
            recordTitles.add("#\u5929\u6821\u8d44\u91d1\u6c47\u603b\u67e5\u8be2");
            recordTitles.add("#\u8d26\u53f7:" + orgInfo.getShortName() + "(" + orgAccount.getNumber() + ")");
            recordTitles.add("#\u8d77\u59cb\u65e5\u671f\uff1a[" + DateUtil.getAllDayStr((Date)startDate) + "]  \u7ec8\u6b62\u65e5\u671f\uff1a[" + DateUtil.getAllDayStr((Date)endDate) + "]");
            recordTitles.add(" #-----------------------------------------\u8d26\u52a1\u6c47\u603b\u5217\u8868----------------------------------------");
            ExcelFinanceExportService.createFinanceRecordSheet((Workbook)workbook, "\u6c47\u603b", recordTitles, cellStyleMap, recordFields, recordDtos);
            ArrayList infoFields = Lists.newArrayList();
            infoFields.add(new ExportField("\u4e1a\u52a1\u6d41\u6c34\u53f7", "@", 5120));
            infoFields.add(new ExportField("\u4e1a\u52a1\u7c7b\u578b", "@", 5120));
            infoFields.add(new ExportField("\u4e1a\u52a1\u6458\u8981", "@", 5120));
            infoFields.add(new ExportField("\u4e1a\u52a1\u65f6\u95f4", "@", 5120));
            infoFields.add(new ExportField("\u6536\u5165\u91d1\u989d\uff08+\u5143\uff09", "@", 5120));
            infoFields.add(new ExportField("\u652f\u51fa\u91d1\u989d\uff08-\u5143\uff09", "@", 5120));
            infoFields.add(new ExportField("\u8d44\u91d1\u7c7b\u578b", "@", 5120));
            infoFields.add(new ExportField("\u5929\u6821\u8d26\u6237\u4f59\u989d", "@", 5120));
            ArrayList infoTitles = Lists.newArrayList();
            infoTitles.add("#\u5929\u6821\u4e1a\u52a1\u660e\u7ec6\u67e5\u8be2");
            infoTitles.add("#\u8d26\u53f7:" + orgInfo.getShortName() + "(" + orgAccount.getNumber() + ")");
            infoTitles.add("#\u8d77\u59cb\u65e5\u671f\uff1a[" + DateUtil.getAllDayStr((Date)startDate) + "]  \u7ec8\u6b62\u65e5\u671f\uff1a[" + DateUtil.getAllDayStr((Date)endDate) + "]");
            infoTitles.add(" #-----------------------------------------\u4e1a\u52a1\u660e\u7ec6\u5217\u8868----------------------------------------");
            ExcelFinanceExportService.createFinanceInfoSheet((Workbook)workbook, "\u660e\u7ec6", infoTitles, cellStyleMap, infoFields, infoDtos);
            ExcelFinanceExportService.exportExcel(response, (Workbook)workbook, "\u5929\u6821\u6536\u652f\u8bb0\u5f55.xlsx");
        }
        catch (Exception var20) {
            log.warn("export catch exception:", (Throwable)var20);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5bfc\u51fa\u6570\u636e\u5904\u7406\u5f02\u5e38");
        }
        finally {
            try {
                workbook.close();
            }
            catch (IOException var19) {
                log.warn("close workbook catch error:", (Throwable)var19);
            }
        }
    }

    public static void main(String[] args) throws IOException {
        String json1 = FileUtils.readFileToString((File)new File("/Users/wengshengli/Downloads/response1.json"));
        List recordDtos = JacksonUtil.str2List((String)json1, TxFinanceRecordDto.class);
        String json2 = FileUtils.readFileToString((File)new File("/Users/wengshengli/Downloads/response2.json"));
        List infoDtos = JacksonUtil.str2List((String)json2, TxFinanceInfoDto.class);
        SXSSFWorkbook workbook = new SXSSFWorkbook(1000);
        workbook = new SXSSFWorkbook(1000);
        HashMap<String, CellStyle> cellStyleMap = new HashMap<String, CellStyle>();
        ArrayList recordFields = Lists.newArrayList();
        recordFields.add(new ExportField("\u7c7b\u578b", "@", 5120));
        recordFields.add(new ExportField("\u6536\u5165\u7b14\u6570", "@", 5120));
        recordFields.add(new ExportField("\u6536\u5165\u91d1\u989d\uff08+\u5143\uff09", "@", 5120));
        recordFields.add(new ExportField("\u652f\u51fa\u7b14\u6570", "@", 5120));
        recordFields.add(new ExportField("\u652f\u51fa\u91d1\u989d\uff08-\u5143\uff09\uff09", "@", 5120));
        recordFields.add(new ExportField("\u603b\u91d1\u989d\uff08\u5143\uff09", "@", 5120));
        ArrayList recordTitles = Lists.newArrayList();
        recordTitles.add("#\u5929\u6821\u8d44\u91d1\u6c47\u603b\u67e5\u8be2");
        recordTitles.add("#\u8d26\u53f7: ()");
        recordTitles.add("#\u8d77\u59cb\u65e5\u671f\uff1a[]  \u7ec8\u6b62\u65e5\u671f\uff1a[]");
        recordTitles.add(" #-----------------------------------------\u8d26\u52a1\u6c47\u603b\u5217\u8868----------------------------------------");
        ExcelFinanceExportService.createFinanceRecordSheet((Workbook)workbook, "\u6c47\u603b", recordTitles, cellStyleMap, recordFields, recordDtos);
        ArrayList infoFields = Lists.newArrayList();
        infoFields.add(new ExportField("\u4e1a\u52a1\u6d41\u6c34\u53f7", "@", 5120));
        infoFields.add(new ExportField("\u4e1a\u52a1\u7c7b\u578b", "@", 5120));
        infoFields.add(new ExportField("\u4e1a\u52a1\u6458\u8981", "@", 5120));
        infoFields.add(new ExportField("\u4e1a\u52a1\u65f6\u95f4", "@", 5120));
        infoFields.add(new ExportField("\u6536\u5165\u91d1\u989d\uff08+\u5143\uff09", "@", 5120));
        infoFields.add(new ExportField("\u652f\u51fa\u91d1\u989d\uff08-\u5143\uff09", "@", 5120));
        infoFields.add(new ExportField("\u8d44\u91d1\u7c7b\u578b", "@", 5120));
        infoFields.add(new ExportField("\u5929\u6821\u8d26\u6237\u4f59\u989d", "@", 5120));
        ArrayList infoTitles = Lists.newArrayList();
        infoTitles.add("#\u5929\u6821\u4e1a\u52a1\u660e\u7ec6\u67e5\u8be2");
        infoTitles.add("#\u8d26\u53f7: )");
        infoTitles.add("#\u8d77\u59cb\u65e5\u671f\uff1a[");
        infoTitles.add(" #-----------------------------------------\u4e1a\u52a1\u660e\u7ec6\u5217\u8868----------------------------------------");
        ExcelFinanceExportService.createFinanceInfoSheet((Workbook)workbook, "\u660e\u7ec6", infoTitles, cellStyleMap, infoFields, infoDtos);
        File excelFile = new File("/Users/wengshengli/Documents/test1.xlsx");
        workbook.write((OutputStream)new FileOutputStream(excelFile));
    }
}

