/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.organization.constant;

import com.baijia.tianxiao.util.BaseUtils;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public enum ClientType {
    HW(1, "\u4f5c\u4e1a\u7cfb\u7edf", "tx201703221528", "baijiahulian", 185L),
    EXAM(2, "\u8003\u8bd5\u7cfb\u7edf", "tx201703221528", "baijiahulian", 187L),
    GRADE(3, "\u6210\u7ee9\u7cfb\u7edf", "tx201704221528", "baijiahulian_grade", 189L),
    POINTS(4, "\u79ef\u5206\u7cfb\u7edf", "tx201708221528", "baijiahulian_points", 206L),
    CALL_SERVICE(5, "\u53cc\u547c", "", "", 0L),
    LIJIA_KEXIAO(6, "\u7acb\u52a0\u8bfe\u6d88\u62a5\u8868", "", "", 196L),
    TIMESCARD(7, "\u6b21\u5361\u7ba1\u7406", "", "", 0L),
    CUSTOM_COMMENT(8, "\u81ea\u5b9a\u4e49\u8bc4\u4ef7\u9879(\u89c4\u5219\u8bbe\u7f6e&\u5fae\u4fe1\u4e2a\u4eba\u4e2d\u5fc3)", "", "", 0L),
    CUSTOM_RECORD_TEMPLATE(9, "\u81ea\u5b9a\u4e49\u8bb0\u5f55\u6a21\u677f(\u89c4\u5219\u8bbe\u7f6e&\u5b66\u5458\u6210\u957f\u6863\u6848)", "", "", 0L);

    private int code;
    private String name;
    private String appId;
    private String secertKey;
    private Long permissionCode;
    private static final Map<Integer, ClientType> codeMap;

    private ClientType(int code, String name, String appId, String secertKey, Long permissionCode) {
        this.code = code;
        this.name = name;
        this.appId = appId;
        this.secertKey = secertKey;
        this.permissionCode = permissionCode;
    }

    public static ClientType getByCode(Integer code) {
        return codeMap.get(code);
    }

    public static Collection<ClientType> getByCodes(String codeStr) {
        List codes = BaseUtils.strToList((String)codeStr, (String)",");
        HashSet result = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty((Collection)codes)) {
            codes.stream().filter(code -> StringUtils.isNumeric((CharSequence)code)).forEach(s -> {
                ClientType clientType = codeMap.get(Integer.valueOf(s));
                if (null != clientType) {
                    result.add(clientType);
                }
            });
        }
        return result;
    }

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getSecertKey() {
        return this.secertKey;
    }

    public Long getPermissionCode() {
        return this.permissionCode;
    }

    static {
        codeMap = Maps.newHashMap();
        for (ClientType clientType : ClientType.values()) {
            codeMap.put(clientType.getCode(), clientType);
        }
    }
}

