/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.organization.org.service.impl;

import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.sal.organization.constant.ClientType;
import com.baijia.tianxiao.sal.organization.constant.DoorgodUserRole;
import com.baijia.tianxiao.sal.organization.dto.AuthToken;
import com.baijia.tianxiao.sal.organization.org.service.OrgInfoService;
import com.baijia.tianxiao.sal.organization.org.service.TXAccountService;
import com.baijia.tianxiao.sal.organization.org.service.TxAccountModuleAuthService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TxAccountModuleAuthServiceImpl
implements TxAccountModuleAuthService {
    @Autowired
    private OrgSubAccountDao orgSubAccountDao;
    @Autowired
    private TXAccountDao txAccountDao;
    @Autowired
    private TXAccountService txAccountService;
    @Autowired
    private OrgInfoService orgInfoService;

    @Override
    public Collection<ClientType> getAllClientTypes(@NonNull Long orgId) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        OrgSubAccount orgSubAccount = this.orgSubAccountDao.getByOrgIdIgnoreDelStatus(Integer.valueOf(orgId.intValue()));
        TXAccount txAccount = orgSubAccount.getPid() == 0 ? this.txAccountDao.getByOrgId(orgSubAccount.getOrgId(), null, new String[0]) : this.txAccountDao.getByOrgId(orgSubAccount.getPid(), null, new String[0]);
        return ClientType.getByCodes(txAccount.getModuleAuth());
    }

    @Override
    public boolean hasClientType(Long orgId, ClientType clientType) {
        return null == orgId ? false : this.getAllClientTypes(orgId).contains((Object)clientType);
    }

    @Override
    public String getModuleAuthValueStr(Long orgId, ClientType clientType) {
        OrgSubAccount orgSubAccount = this.orgSubAccountDao.getByOrgIdIgnoreDelStatus(Integer.valueOf(orgId.intValue()));
        TXAccount txAccount = orgSubAccount.getPid() == 0 ? this.txAccountDao.getByOrgId(orgSubAccount.getOrgId(), null, new String[0]) : this.txAccountDao.getByOrgId(orgSubAccount.getPid(), null, new String[0]);
        return null == txAccount ? null : (String)txAccount.getModuleAuthDataMap().get(String.valueOf(clientType.getCode()));
    }

    @Override
    public List<Map<String, Object>> getAuthLinkMap(Long orgId, Long studentId, String studentName) {
        Collection<ClientType> auths = this.getAllClientTypes(orgId);
        ArrayList result = Lists.newArrayList();
        OrgInfo orgInfo = this.orgInfoService.getOrgInfoByOrgId(orgId.intValue());
        for (ClientType clientType : auths) {
            HashMap innerMap;
            if (clientType == ClientType.HW) {
                innerMap = Maps.newHashMap();
                innerMap.put("type", ClientType.HW.getCode());
                innerMap.put("text", ClientType.HW.getName());
                innerMap.put("url", AuthToken.assignMentStudentToken(orgId, orgInfo.getShortName(), studentId, studentName, DoorgodUserRole.STUDENT.getRole(), ClientType.HW));
                result.add(innerMap);
                continue;
            }
            if (clientType == ClientType.EXAM) {
                innerMap = Maps.newHashMap();
                innerMap.put("type", ClientType.EXAM.getCode());
                innerMap.put("text", ClientType.EXAM.getName());
                innerMap.put("url", AuthToken.assignMentStudentToken(orgId, orgInfo.getShortName(), studentId, studentName, DoorgodUserRole.STUDENT.getRole(), ClientType.EXAM));
                result.add(innerMap);
                continue;
            }
            if (clientType == ClientType.GRADE) {
                innerMap = Maps.newHashMap();
                innerMap.put("type", ClientType.GRADE.getCode());
                innerMap.put("text", ClientType.GRADE.getName());
                innerMap.put("url", AuthToken.assignMentStudentToken(orgId, orgInfo.getShortName(), studentId, studentName, DoorgodUserRole.STUDENT.getRole(), ClientType.GRADE));
                result.add(innerMap);
                continue;
            }
            if (clientType != ClientType.POINTS) continue;
            innerMap = Maps.newHashMap();
            innerMap.put("type", ClientType.POINTS.getCode());
            innerMap.put("text", ClientType.POINTS.getName());
            innerMap.put("url", AuthToken.assignMentStudentToken(orgId, orgInfo.getShortName(), studentId, studentName, DoorgodUserRole.STUDENT.getRole(), ClientType.POINTS));
            result.add(innerMap);
        }
        return result;
    }
}

