/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.organization.org.service.impl;

import com.baijia.tianxiao.dal.org.constant.TXAccountType;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCommonRuleDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.dal.org.po.TXCommonRule;
import com.baijia.tianxiao.sal.organization.constant.TXCommonRuleValue;
import com.baijia.tianxiao.sal.organization.org.service.TXAccountService;
import com.baijia.tianxiao.sal.organization.org.service.TXCommonRuleService;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TXCommonServiceImpl
implements TXCommonRuleService {
    @Autowired
    private TXCommonRuleDao txCommonRuleDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private TXAccountService txAccountService;

    @Override
    public TXCommonRule getByOrgId(Integer orgId) {
        TXAccount txAccount;
        TXCommonRule txCommonRule = this.txCommonRuleDao.getByOrgId(orgId);
        if (txCommonRule == null) {
            txCommonRule = new TXCommonRule();
            txCommonRule.setCallMobileRule(Integer.valueOf(TXCommonRuleValue.NOT_USE_OWN_MOBILE_CALL.getCode()));
            txCommonRule.setCreateTime(new Date());
            txCommonRule.setOrgId(orgId);
            OrgAccount orgAccount = this.orgAccountDao.getAccountById(orgId.intValue(), new String[0]);
            txCommonRule.setOrgNumber(orgAccount.getNumber());
            txCommonRule.setStudentMobileRule(Integer.valueOf(TXCommonRuleValue.STUDENT_MOBILE_NOT_DISPLAY.getCode()));
            txCommonRule.setCallSendMsgRule(Integer.valueOf(TXCommonRuleValue.NOT_SEND_MSG_AFTER_CALL.getCode()));
            txCommonRule.setLeftKexiaoRule(Integer.valueOf(TXCommonRuleValue.STUDNET_CENTER_VALID_KEXIAO.getCode()));
            txCommonRule.setFullClassRule(Integer.valueOf(0));
        }
        if (txCommonRule.getConsumeRule() == null) {
            txCommonRule.setConsumeRule(Integer.valueOf(TXCommonRuleValue.DEFAULT_CONSUME_RULE.getCode()));
        }
        if (txCommonRule.getVipConsumeRule() == null) {
            txCommonRule.setVipConsumeRule(Integer.valueOf(TXCommonRuleValue.DEFAULT_VIP_CONSUME_RULE.getCode()));
        }
        if ((txAccount = this.txAccountService.getByOrgId(orgId, new String[0])) != null && txAccount.getVipLevel().intValue() == TXAccountType.DAZHONG.getCode().intValue()) {
            txCommonRule.setCallMobileRule(Integer.valueOf(TXCommonRuleValue.USE_OWN_MOBILE_CALL.getCode()));
            txCommonRule.setStudentMobileRule(Integer.valueOf(TXCommonRuleValue.STUDENT_MOBILE_DISPLAY.getCode()));
        }
        return txCommonRule;
    }

    @Override
    public void saveTXCommonRule(TXCommonRule txCommonRule) {
        this.txCommonRuleDao.saveOrUpdate((Object)txCommonRule, new String[0]);
    }
}

