/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.organization.org.service.impl;

import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.po.AccountRoleType;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.pcAuthority.constant.RoleType;
import com.baijia.tianxiao.sal.organization.org.service.TxAccountHelpService;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.ListUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TxAccountHelpServiceImpl
implements TxAccountHelpService {
    private static final Logger log = LoggerFactory.getLogger(TxAccountHelpServiceImpl.class);
    @Autowired
    private OrgStudentCourseDao orgStudentCourseDao;
    @Autowired
    private OrgSubAccountDao orgSubAccountDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private OrgStudentDao orgStudentDao;

    @Override
    public AccountRoleType findAccountRoleType(Long orgId, Integer cascadeId) {
        AccountRoleType ary = new AccountRoleType();
        OrgAccount accountById = this.orgAccountDao.getAccountById(orgId.intValue(), new String[0]);
        RoleType superRole = null;
        if (cascadeId != null && (long)cascadeId.intValue() != 0L) {
            TXCascadeAccount tca = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)cascadeId, new String[0]);
            if (tca == null) {
                log.info("can not find any cascade account with cadcadeId : {} ", (Object)cascadeId);
                return null;
            }
            Integer accountType = tca.getAccountType();
            superRole = RoleType.getRoleType((Integer)accountType);
        } else {
            OrgSubAccount osa = this.orgSubAccountDao.getByOrgId(Integer.valueOf(orgId.intValue()), new String[0]);
            if (osa == null) {
                if (accountById == null) {
                    log.info(" can not find any org account with orgId : {} ", (Object)orgId);
                    return null;
                }
                superRole = RoleType.PRESIDENT;
            } else {
                Integer pId = osa.getPid();
                superRole = 0 == pId ? RoleType.PRESIDENT : RoleType.BRANCH_SCH_PRESIDENT;
            }
            cascadeId = 0;
        }
        ary.setCascadeId(cascadeId);
        ary.setOrgId(orgId);
        ary.setRoleType(superRole);
        ary.setOrgNumber(accountById.getNumber());
        return ary;
    }

    @Override
    @Deprecated
    public List<OrgStudent> findMyStudents(Long orgId, Integer casCadeId) {
        OrgAccount accountById = this.orgAccountDao.getAccountById(orgId.intValue(), new String[0]);
        if (accountById == null) {
            return Collections.emptyList();
        }
        AccountRoleType ary = this.findAccountRoleType(orgId, casCadeId);
        if (ary == null) {
            return Collections.emptyList();
        }
        ArrayList<Integer> casCadeIds = new ArrayList<Integer>();
        if (ary.getRoleType() == RoleType.EMPLOYEE) {
            casCadeIds.add(casCadeId);
        } else {
            casCadeIds.add(Flag.NULL.getInt());
            casCadeIds.addAll(this.txCascadeAccountDao.listIdByAccountType(Integer.valueOf(orgId.intValue()), RoleType.CHARAGE.type));
            casCadeIds.addAll(this.txCascadeAccountDao.listIdByAccountType(Integer.valueOf(orgId.intValue()), RoleType.EMPLOYEE.type));
        }
        List courseByCasCadeIds = this.orgCourseDao.getCourseByCasCadeIds(accountById.getNumber(), casCadeIds, CourseTypeEnum.IS_COURSE_TRUE.getCode(), null, null, new String[]{"id", "cascadeId"});
        List courseIds = ListUtil.toKeyList((Collection)courseByCasCadeIds, (String)"id", OrgCourse.class);
        if (GenericsUtils.isNullOrEmpty((Object)courseByCasCadeIds)) {
            return Collections.emptyList();
        }
        Map studentIdMapBycourseIds = this.orgStudentCourseDao.getStudentIdMapBycourseIds((Collection)courseIds, orgId);
        HashSet studentIds = new HashSet();
        for (Map.Entry entry : studentIdMapBycourseIds.entrySet()) {
            List userIds = (List)entry.getValue();
            if (!GenericsUtils.notNullAndEmpty((Object)userIds)) continue;
            studentIds.addAll(userIds);
        }
        List byIds = this.orgStudentDao.getByIds(studentIds, new String[0]);
        return byIds;
    }
}

