/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.organization.org.service.impl;

import com.baijia.tianxiao.dal.org.constant.TXAccountStatus;
import com.baijia.tianxiao.dal.org.constant.TXAccountType;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXSaleClueRuleDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.dal.org.po.TXSaleClueRule;
import com.baijia.tianxiao.sal.organization.constant.TXSaleClueRuleValue;
import com.baijia.tianxiao.sal.organization.org.service.TXSaleClueRuleService;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TXSaleClueRuleServiceImpl
implements TXSaleClueRuleService {
    @Autowired
    private TXSaleClueRuleDao txSaleClueRuleDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private TXAccountDao txAccountDao;
    @Autowired
    private OrgSubAccountDao orgSubAccountDao;

    @Override
    public TXSaleClueRule getByOrgId(Integer orgId) {
        TXSaleClueRule txSaleClueRule = this.txSaleClueRuleDao.getByOrgId(orgId);
        if (txSaleClueRule == null) {
            txSaleClueRule = new TXSaleClueRule();
            txSaleClueRule.setClueAllot(Integer.valueOf(TXSaleClueRuleValue.CLUEALLOT_STAFF_CAN_HAVE.getCode()));
            txSaleClueRule.setClueTransValid(Integer.valueOf(TXSaleClueRuleValue.CLUETRANSVALID_PRIVATE.getCode()));
            txSaleClueRule.setCreateTime(new Date());
            txSaleClueRule.setMaxClueCount(Integer.valueOf(TXSaleClueRuleValue.MAXCLUECOUNT.getCode()));
            txSaleClueRule.setMaxClueDelay(Integer.valueOf(TXSaleClueRuleValue.MAXCLUEDELAY.getCode()));
            txSaleClueRule.setOrgId(orgId);
            txSaleClueRule.setAttendClassMsg(Integer.valueOf(TXSaleClueRuleValue.SEND_MSG.getCode()));
            txSaleClueRule.setSigninMsg(Integer.valueOf(TXSaleClueRuleValue.SEND_MSG.getCode()));
            txSaleClueRule.setEvaluateMsg(Integer.valueOf(TXSaleClueRuleValue.SEND_MSG.getCode()));
            txSaleClueRule.setSignupMsg(Integer.valueOf(TXSaleClueRuleValue.SEND_MSG.getCode()));
            OrgAccount orgAccount = this.orgAccountDao.getAccountById(orgId.intValue(), new String[0]);
            if (orgAccount != null) {
                txSaleClueRule.setOrgNumber(orgAccount.getNumber());
            }
            txSaleClueRule.setReturnClue(Integer.valueOf(TXSaleClueRuleValue.RETURNCLUE_CAN.getCode()));
        }
        TXAccount txAccount = this.txAccountDao.getByOrgId(orgId, TXAccountStatus.VALID.getCode(), new String[0]);
        boolean forbidSms = false;
        if (txAccount == null) {
            OrgSubAccount orgSubAccount = this.orgSubAccountDao.getByOrgId(orgId, new String[0]);
            if (orgSubAccount == null) {
                forbidSms = true;
            } else {
                txAccount = this.txAccountDao.getByOrgId(orgSubAccount.getPid(), TXAccountStatus.VALID.getCode(), new String[0]);
                if (txAccount == null || txAccount.getVipLevel().intValue() == TXAccountType.DAZHONG.getCode().intValue()) {
                    forbidSms = true;
                }
            }
        } else if (txAccount.getVipLevel().intValue() == TXAccountType.DAZHONG.getCode().intValue()) {
            forbidSms = true;
        }
        if (forbidSms) {
            txSaleClueRule.setAttendClassMsg(Integer.valueOf(TXSaleClueRuleValue.DONOT_SEND_MSG.getCode()));
            txSaleClueRule.setSigninMsg(Integer.valueOf(TXSaleClueRuleValue.DONOT_SEND_MSG.getCode()));
            txSaleClueRule.setEvaluateMsg(Integer.valueOf(TXSaleClueRuleValue.DONOT_SEND_MSG.getCode()));
            txSaleClueRule.setSignupMsg(Integer.valueOf(TXSaleClueRuleValue.DONOT_SEND_MSG.getCode()));
        }
        return txSaleClueRule;
    }

    @Override
    public void saveTXSaleClueRule(TXSaleClueRule txSaleClueRule) {
        this.txSaleClueRuleDao.saveOrUpdate((Object)txSaleClueRule, new String[0]);
    }

    @Override
    public Map<Integer, TXSaleClueRule> queryByIds(Collection<Integer> idList) {
        List list = this.txSaleClueRuleDao.queryByOrgIds(idList, new String[0]);
        HashMap<Integer, TXSaleClueRule> map = new HashMap<Integer, TXSaleClueRule>();
        for (TXSaleClueRule rule : list) {
            Integer orgId = rule.getOrgId();
            if (orgId == null) continue;
            map.put(orgId, rule);
        }
        return map;
    }
}

