package com.baijia.tianxiao.sal.organization.todo.constant;

/**
 * @title GroupType
 * @desc 待办事项分组类型
 * @author wangsixia
 * @date 2016年02月25日
 * @version 1.0
 */
public enum GroupType {
    TODAY(0,"今天"),NEXT_SEVEN_DAY(1,"未来7天"),FURTHER(2,"更远"),PAST(3,"过去");
    
    int value;
    String note;
    
    private GroupType(int value, String note){
        this.value = value;
        this.note = note;
    }
    
    public int getValue(){
        return this.value;
    }
    
    public String getNote(){
        return this.note;
    }
    
    public static GroupType getGroupType(int value){
        GroupType groupType = null;
        for(GroupType type : GroupType.values()){
            if(type.getValue() == value){
                groupType = type;
                break;
            }
        }
        return groupType;
    }

    public static String getNoteWithValue(int value){
        String note = "";
        for(GroupType type : GroupType.values()){
            if(type.value == value){
                note = type.getNote();
                break;
            }
        }
        return note;
    }
}

