package com.baijia.tianxiao.sal.organization.org.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.po.AccountRoleType;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.pcAuthority.constant.RoleType;
import com.baijia.tianxiao.sal.organization.org.service.TxAccountHelpService;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.ListUtil;

import lombok.extern.slf4j.Slf4j;

/**
 * @author Rezar
 * @createDate :Jun 13, 2016 2:06:13 PM
 * @desc :
 */

@Slf4j
@Service
public class TxAccountHelpServiceImpl implements TxAccountHelpService {

    @Autowired
    private OrgStudentCourseDao orgStudentCourseDao;
    @Autowired
    private OrgSubAccountDao orgSubAccountDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private OrgStudentDao orgStudentDao;

    @Override
    public AccountRoleType findAccountRoleType(Long orgId, Integer cascadeId) {
        AccountRoleType ary = new AccountRoleType();
        OrgAccount accountById = this.orgAccountDao.getAccountById(orgId.intValue());
        RoleType superRole = null;
        if (cascadeId != null && cascadeId != 0L) {
            TXCascadeAccount tca = this.txCascadeAccountDao.getById(cascadeId);
            if (tca == null) {
                log.info("can not find any cascade account with cadcadeId : {} ", cascadeId);
                return null;
            }
            Integer accountType = tca.getAccountType();
            superRole = RoleType.getRoleType(accountType);
        } else {
            OrgSubAccount osa = this.orgSubAccountDao.getByOrgId(orgId.intValue());
            if (osa == null) {
                if (accountById == null) {
                    log.info(" can not find any org account with orgId : {} ", orgId);
                    return null;
                }
                superRole = RoleType.PRESIDENT;
            } else {
                Integer pId = osa.getPid();
                if (0 == pId) {
                    superRole = RoleType.PRESIDENT;
                } else {
                    superRole = RoleType.BRANCH_SCH_PRESIDENT;
                }
            }
            cascadeId = 0;
        }
        ary.setCascadeId(cascadeId);
        ary.setOrgId(orgId);
        ary.setRoleType(superRole);
        ary.setOrgNumber(accountById.getNumber());
        return ary;
    }

    /**
     * 根据某个账号获取到该账号对应的所有学员（该账号可以为主账号或者子账号）</br>
     * 
     * 当前规则是:主管及以上可以查看所有学员，员工只能查看当前所属自己的学员
     * 
     * @return
     */
    @Deprecated
    @Override
    public List<OrgStudent> findMyStudents(Long orgId, Integer casCadeId) {
        OrgAccount accountById = orgAccountDao.getAccountById(orgId.intValue());
        if (accountById == null) {
            return Collections.emptyList();
        }
        AccountRoleType ary = this.findAccountRoleType(orgId, casCadeId);

        if (ary == null) {
            return Collections.emptyList();
        }

        List<Integer> casCadeIds = new ArrayList<>();
        if (ary.getRoleType() == RoleType.EMPLOYEE) {
            casCadeIds.add(casCadeId);
        } else {
            // 主管及以上可以看到当前机构的所有员工
            casCadeIds.add(Flag.NULL.getInt()); // 添加主账号
            casCadeIds.addAll(this.txCascadeAccountDao.listIdByAccountType(orgId.intValue(), RoleType.CHARAGE.type)); // 获取所有主管
            casCadeIds.addAll(this.txCascadeAccountDao.listIdByAccountType(orgId.intValue(), RoleType.EMPLOYEE.type)); // 获取所有员工
        }

        List<OrgCourse> courseByCasCadeIds =
            orgCourseDao.getCourseByCasCadeIds(accountById.getNumber(), casCadeIds, "id", "cascadeId");

        List<Long> courseIds = ListUtil.toKeyList(courseByCasCadeIds, "id", OrgCourse.class);

        if (GenericsUtils.isNullOrEmpty(courseByCasCadeIds)) {
            return Collections.emptyList();
        }

        Map<Long, List<Long>> studentIdMapBycourseIds =
            orgStudentCourseDao.getStudentIdMapBycourseIds(courseIds, orgId);

        Set<Long> studentIds = new HashSet<>();
        for (Map.Entry<Long, List<Long>> entry : studentIdMapBycourseIds.entrySet()) {
            List<Long> userIds = entry.getValue();
            if (GenericsUtils.notNullAndEmpty(userIds)) {
                studentIds.addAll(userIds);
            }
        }
        List<OrgStudent> byIds = this.orgStudentDao.getByIds(studentIds);
        return byIds;
    }

}
