package com.baijia.tianxiao.sal.organization.org.service.impl;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.dal.index.dao.TxVisitorDao;
import com.baijia.tianxiao.dal.index.po.TxVisitor;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeCredential;
import com.baijia.tianxiao.dal.pcAuthority.constant.PAccessType;
import com.baijia.tianxiao.dal.pcAuthority.constant.PMasterType;
import com.baijia.tianxiao.dal.pcAuthority.constant.PermissionOperationType;
import com.baijia.tianxiao.dal.pcAuthority.constant.RoleType;
import com.baijia.tianxiao.dal.pcAuthority.dao.ApplicationAuthConfigDao;
import com.baijia.tianxiao.dal.pcAuthority.dao.PermissionDao;
import com.baijia.tianxiao.dal.pcAuthority.po.ApplicationAuthConfig;
import com.baijia.tianxiao.dal.pcAuthority.po.Permission;
import com.baijia.tianxiao.sal.organization.org.dto.pcAuthority.AuthorityDto;
import com.baijia.tianxiao.sal.organization.org.dto.pcAuthority.PermissionDto;
import com.baijia.tianxiao.sal.organization.org.dto.pcAuthority.PermissionRequest;
import com.baijia.tianxiao.sal.organization.org.service.TXAuthPermissionService;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.ListUtil;
import com.google.common.base.Function;
import com.google.common.collect.Maps;

import lombok.extern.slf4j.Slf4j;

/**
 * @author Rezar
 * @createDate :May 29, 2016 11:28:25 PM
 * @desc :
 */
@Deprecated
@Service
@Slf4j
public class TXAuthPermissionServiceImpl implements TXAuthPermissionService {

    private static final Long ONE_DAY_TIME = 86400000L;

    @Autowired
    private PermissionDao permissionDao;
    @Autowired
    private ApplicationAuthConfigDao ApplicationAuthConfigDao;
    // @Autowired
    // private UserRoleDao userRoleDao;
    // @Autowired
    // private RoleDao roleDao;
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    @Autowired
    private OrgSubAccountDao orgSubAccountDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private TXCascadeCredentialDao txCascadeCredendtialDao;
    @Autowired
    private TxVisitorDao txVistorDao;

    @Override
    public void savePermissions(List<PermissionRequest> permissions) {
        if (GenericsUtils.isNullOrEmpty(permissions)) {
            return;
        }
        List<Permission> permissionPos = toPermissionPos(permissions);
        log.info("permissionPos'size is : {} ", permissionPos.size());
        this.permissionDao.saveAll(permissionPos);
    }

    private List<Permission> toPermissionPos(List<PermissionRequest> permissions) {
        List<Permission> permissionPos = new ArrayList<>();
        for (PermissionRequest dto : permissions) {
            permissionPos.add(dto.toPo());
        }
        return permissionPos;
    }

    @Override
    public List<PermissionDto> findPermissions(Integer applicationType, Integer pMasterType, Long pValue,
        String accessKey) {

        List<PermissionDto> ret = new ArrayList<>();
        List<Permission> permissions = null;

        if (pMasterType == PMasterType.USER.type) {
            // TODO ,两种类型的查找可以合并
        } else if (pMasterType == PMasterType.ROLE.type) {
            permissions = this.permissionDao.findPermissionWithRoleType(pValue, accessKey);
        }

        if (GenericsUtils.notNullAndEmpty(permissions)) {
            List<Long> pIds = ListUtil.toKeyList(permissions, "pAccessValue", Permission.class);
            List<ApplicationAuthConfig> menus =
                ApplicationAuthConfigDao.getByIdsAndApplicationType(pIds, applicationType);

            Map<Long, ApplicationAuthConfig> menuMap =
                Maps.uniqueIndex(menus, new Function<ApplicationAuthConfig, Long>() {
                    public Long apply(ApplicationAuthConfig from) {
                        return from.getId();
                    }
                });

            if (GenericsUtils.notNullAndEmpty(menus)) {
                for (Permission permission : permissions) {
                    ret.add(PermissionDto.toDto(permission, menuMap.get(permission.getPAccessValue())));
                }
            }
        }
        return ret;
    }

    /**
     * 初始化角色的权限
     */
    @Override
    public void initRolePermission(Long roleId, List<Long> ApplicationAuthConfigIds) {
        log.info("begin to init user permission ");

        List<PermissionRequest> permissionRequests = new ArrayList<>();
        if (GenericsUtils.notNullAndEmpty(ApplicationAuthConfigIds)) {
            for (Long ApplicationAuthConfigId : ApplicationAuthConfigIds) {
                PermissionRequest pr = new PermissionRequest();
                pr.setApplicationMenuId(ApplicationAuthConfigId);
                pr.setPMasterType(PMasterType.ROLE.type);
                pr.setType(PermissionOperationType.CAN_USE.type);
                pr.setPValue(roleId);
                permissionRequests.add(pr);
            }
        }
        log.info(" permissionRequest are : {} ", permissionRequests);
        this.savePermissions(permissionRequests);
    }

    @Override
    public AuthorityDto findAuths(Long orgId, Long casCadeId, Integer applicationType) {

        Set<PermissionDto> permissions = new HashSet<>();

        Set<Long> roleTypes = new HashSet<>();

        RoleType superRole = null;
        Long roleValue = null;
        String roleName = "";
        String mobile = "";
        if (casCadeId != null) {
            TXCascadeAccount tca = this.txCascadeAccountDao.getById(casCadeId);
            if (tca == null) {
                return null;
            }
            TXCascadeCredential cascadeCredential = txCascadeCredendtialDao.getById(tca.getCredentialId());
            if (cascadeCredential != null) {
                mobile = cascadeCredential.getMobile();
            }
            Integer accountType = tca.getAccountType();
            superRole = RoleType.getRoleType(accountType);
        } else {
            OrgSubAccount osa = this.orgSubAccountDao.getByOrgId(orgId.intValue());
            if (osa == null) {
                return null;
            }
            OrgAccount orgAccount = orgAccountDao.getAccountById(orgId.intValue());
            if (orgAccount != null) {
                mobile = orgAccount.getMobile();
            }
            Integer pId = osa.getPid();
            if (0 == pId) {
                superRole = RoleType.PRESIDENT;
            } else {
                superRole = RoleType.BRANCH_SCH_PRESIDENT;
            }
        }
        roleValue = superRole.type.longValue();
        roleName = superRole.desc;
        roleTypes.add(roleValue);
        List<RoleType> subRoleTypes = RoleType.getSubRoleTypes(superRole);
        for (RoleType subRoleType : subRoleTypes) {
            roleTypes.add(subRoleType.type.longValue());
        }

        AuthorityDto authorityDto = new AuthorityDto();
        // boolean isVistorAccount = (GenericsUtils.notNullAndEmpty(mobile)); //如果是主账号，是否确定就不是体验账号
        Integer userType = 0; // TODO 如何判断账户的类型是否是体验账户?tx_visitor mobile date

        List<TxVisitor> byMobile = this.txVistorDao.getByMobile(mobile);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date now = new Date();
        if (GenericsUtils.notNullAndEmpty(byMobile)) {
            for (TxVisitor txVistor : byMobile) {
                Date startTime = txVistor.getStartTime();
                Integer remaindDay = txVistor.getRemainDay();
                Integer isDel = txVistor.getIsdel();
                log.info("txVistor createTime is : {} ", dateFormat.format(startTime));
                if (isDel == 0 && (startTime.getTime() + remaindDay * ONE_DAY_TIME) > now.getTime()) {
                    userType = 1;
                    break;
                }
            }
            if (userType == 0) {
                log.info(
                    "find the mobile:{}  is a vistor's mobile and can not login again for orgId:{} and cascade_Id:{}",
                    mobile, orgId, casCadeId);
                return null;
            }
        }

        for (Long roleType : roleTypes) {
            List<PermissionDto> permissionDtos =
                this.findPermissions(applicationType, PMasterType.ROLE.type, roleType, PAccessType.PC_AUTH.desc);
            if (GenericsUtils.notNullAndEmpty(permissionDtos)) {
                permissions.addAll(permissionDtos);
            }
        }

        authorityDto.setRole(roleValue);
        authorityDto.setRoleName(roleName);
        authorityDto.setHasPermissions(new ArrayList<>(permissions));
        return authorityDto;
    }

}
