package com.baijia.tianxiao.sal.organization.org.service.impl;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.dal.pcAuthority.dao.ApplicationAuthConfigDao;
import com.baijia.tianxiao.dal.pcAuthority.po.ApplicationAuthConfig;
import com.baijia.tianxiao.sal.organization.org.dto.pcAuthority.ApplicationAuthConfigDto;
import com.baijia.tianxiao.sal.organization.org.service.TXAuthApplicationMenuService;

import lombok.extern.slf4j.Slf4j;

/**
 * @author Rezar
 * @createDate :May 30, 2016 1:19:08 AM
 * @desc :
 */
@Service
@Slf4j
public class TXAuthApplicationMenuServiceImpl implements TXAuthApplicationMenuService {

    @Autowired
    private ApplicationAuthConfigDao applicationMenuDao;

    @Override
    public void saveApplicationMenus(List<ApplicationAuthConfigDto> menus) {
        applicationMenuDao.saveAll(toApplicationMenus(menus));
    }

    private List<ApplicationAuthConfig> toApplicationMenus(List<ApplicationAuthConfigDto> menuDtos) {
        List<ApplicationAuthConfig> menus = new ArrayList<>();
        for (ApplicationAuthConfigDto amd : menuDtos) {
            menus.add(amd.toPo());
        }
        return menus;
    }

    @Override
    public List<ApplicationAuthConfig> findApplicationMenus(List<Long> menuIds) {
        return this.applicationMenuDao.getByIds(menuIds);
    }

}
