
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2015 All Rights Reserved.
 */
    
package com.baijia.tianxiao.sal.organization.org.service.impl;

import java.util.List;

import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.dal.org.dao.OrgMaterialBucketDao;
import com.baijia.tianxiao.dal.org.po.OrgMaterialBucket;
import com.baijia.tianxiao.sal.organization.org.dto.OrgMaterialBucketDto;
import com.baijia.tianxiao.sal.organization.org.service.OrgMaterialBucketService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.google.common.collect.Lists;


/**
 * @title OrgMaterialBucketServiceImpl
 * @desc TODO 
 * @author zhangbing
 * @date 2015年12月24日
 * @version 1.0
 */
@Service
public class OrgMaterialBucketServiceImpl implements OrgMaterialBucketService {

    @Autowired
    private OrgMaterialBucketDao orgMaterialBucketDao;
    
    @Override
    public List<OrgMaterialBucketDto> getMaterialBuckets(PageDto pageDto) {
        List<OrgMaterialBucket> photos = orgMaterialBucketDao.getMaterialBucketList(pageDto);
        
        List<OrgMaterialBucketDto> data = Lists.newArrayList();
        if (photos != null && !photos.isEmpty()) {
            OrgMaterialBucketDto item = null;
            for (OrgMaterialBucket photo : photos) {
                item = new OrgMaterialBucketDto();
                BeanUtils.copyProperties(photo, item);
                data.add(item);
            }
        }
        return data;
    }
}

    